/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.cache;

import java.util.Calendar;
import java.util.HashMap;
import org.wso2.carbon.bam.common.dataobjects.service.OperationDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServerDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServiceDO;
import org.wso2.carbon.bam.core.admin.BAMDataServiceAdmin;
import org.wso2.carbon.bam.core.cache.CacheData;
import org.wso2.carbon.bam.core.util.BAMUtil;
import org.wso2.carbon.bam.util.BAMException;

public class CacheImpl {
    private HashMap<String, CacheData> cacheDataHashMap = BAMUtil.getBAMCache();

    public ServerDO getServer(BAMDataServiceAdmin dsAdmin, String serverName, int tenantID, String serverTypeEventing, int serviceStatType) throws BAMException {
        ServerDO monitoringServer = null;
        String cacheKey = serverName + "_" + tenantID + "_" + serverTypeEventing + "_" + serviceStatType;
        CacheData cacheData = this.cacheDataHashMap.get(cacheKey);
        if (cacheData != null) {
            monitoringServer = cacheData.getMonitoringServer();
            cacheData.setTimestamp(Calendar.getInstance());
        } else {
            monitoringServer = dsAdmin.getServer(serverName, tenantID, serverTypeEventing, serviceStatType);
            if (monitoringServer != null) {
                cacheData = new CacheData();
                cacheData.setMonitoringServer(monitoringServer);
                cacheData.setTimestamp(Calendar.getInstance());
                this.cacheDataHashMap.put(cacheKey, cacheData);
            }
        }
        return monitoringServer;
    }

    public ServiceDO getService(BAMDataServiceAdmin dsAdmin, String serverName, int tenantID, int serverID, String serviceName) throws BAMException {
        ServiceDO service = null;
        String cacheKey = serverName + "_" + tenantID + "_" + serverID + "_" + serviceName;
        CacheData cacheData = this.cacheDataHashMap.get(cacheKey);
        if (cacheData != null) {
            service = cacheData.getService();
            cacheData.setTimestamp(Calendar.getInstance());
        } else {
            service = dsAdmin.getService(serverID, serviceName);
            if (service != null) {
                cacheData = new CacheData();
                cacheData.setService(service);
                cacheData.setTimestamp(Calendar.getInstance());
                this.cacheDataHashMap.put(cacheKey, cacheData);
            }
        }
        return service;
    }

    public OperationDO getOperation(BAMDataServiceAdmin dsAdmin, String serverName, int tenantId, int serviceID, String operationName) throws BAMException {
        OperationDO operation = null;
        String cacheKey = serverName + "_" + tenantId + "_" + serviceID + "_" + operationName;
        CacheData cacheData = this.cacheDataHashMap.get(cacheKey);
        if (cacheData != null) {
            operation = cacheData.getOperation();
            cacheData.setTimestamp(Calendar.getInstance());
        } else {
            operation = dsAdmin.getOperation(serviceID, operationName);
            if (operation != null) {
                cacheData = new CacheData();
                cacheData.setOperation(operation);
                cacheData.setTimestamp(Calendar.getInstance());
                this.cacheDataHashMap.put(cacheKey, cacheData);
            }
        }
        return operation;
    }
}

