/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.core.admin;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.bam.util.TimeRange;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class BAMGlobalConfigAdmin {
    private static Log log = LogFactory.getLog(BAMGlobalConfigAdmin.class);
    protected Registry registry;

    public BAMGlobalConfigAdmin(Registry registry) {
        this.registry = registry;
    }

    public void updateDataRetentionPeriod(TimeRange timeRange) throws BAMException {
        try {
            Collection configCollection = this.registry.resourceExists("/carbon/bam/global.config") ? (Collection)this.registry.get("/carbon/bam/global.config") : this.registry.newCollection();
            configCollection.setProperty("dataRetention", timeRange.toString());
            this.registry.put("/carbon/bam/global.config", (Resource)configCollection);
        }
        catch (RegistryException e) {
            String msg = "Could not save the data retention policy in registry";
            log.error((Object)msg);
            throw new BAMException(msg, (Throwable)e);
        }
    }

    public void updateDataArchivalPeriod(TimeRange timeRange) throws BAMException {
        try {
            Collection configCollection = this.registry.resourceExists("/carbon/bam/global.config") ? (Collection)this.registry.get("/carbon/bam/global.config") : this.registry.newCollection();
            configCollection.setProperty("dataRetention", timeRange.toString());
            configCollection.setProperty("dataArchival", timeRange.toString());
            this.registry.put("/carbon/bam/global.config", (Resource)configCollection);
        }
        catch (RegistryException e) {
            String msg = "Could not save the data retention policy in registry";
            log.error((Object)msg, (Throwable)e);
            throw new BAMException(msg, (Throwable)e);
        }
    }

    public TimeRange getDataRetentionPeriod() throws BAMException {
        try {
            if (this.registry.resourceExists("/carbon/bam/global.config")) {
                Collection configCollection = (Collection)this.registry.get("/carbon/bam/global.config");
                String period = configCollection.getProperty("dataRetention");
                return TimeRange.parseTimeRange((String)period);
            }
        }
        catch (RegistryException e) {
            String msg = "Could not retrieve the data retention policy in registry";
            throw new BAMException(msg, (Throwable)e);
        }
        return null;
    }

    public TimeRange getDataArchivalPeriod() throws BAMException {
        try {
            if (this.registry.resourceExists("/carbon/bam/global.config")) {
                Collection configCollection = (Collection)this.registry.get("/carbon/bam/global.config");
                String period = configCollection.getProperty("dataArchival");
                return TimeRange.parseTimeRange((String)period);
            }
        }
        catch (RegistryException e) {
            String msg = "Could not retrieve the data archival policy in registry";
            throw new BAMException(msg, (Throwable)e);
        }
        return null;
    }
}

