/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.common.clients;

import java.util.Calendar;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.common.ClientUtil;
import org.wso2.carbon.bam.common.dataobjects.dimensions.DayDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.HourDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.MonthDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.QuarterDimension;
import org.wso2.carbon.bam.common.dataobjects.dimensions.YearDimension;
import org.wso2.carbon.bam.services.stub.bamsummarygenerationds.BAMSummaryGenerationDSStub;
import org.wso2.carbon.bam.services.stub.bamsummarygenerationds.types.DayDim;
import org.wso2.carbon.bam.services.stub.bamsummarygenerationds.types.HourDim;
import org.wso2.carbon.bam.services.stub.bamsummarygenerationds.types.MonthDim;
import org.wso2.carbon.bam.services.stub.bamsummarygenerationds.types.QuarterDim;
import org.wso2.carbon.bam.services.stub.bamsummarygenerationds.types.YearDim;
import org.wso2.carbon.bam.util.BAMCalendar;
import org.wso2.carbon.bam.util.BAMException;

public class SummaryDimensionDSClient {
    private static final String BAM_SUMMARY_GENERATION_DS = "BAMSummaryGenerationDS";
    private static final Log log = LogFactory.getLog(SummaryDimensionDSClient.class);
    private BAMSummaryGenerationDSStub summaryGenerationDSStub;

    public SummaryDimensionDSClient(String backendServerURL, ConfigurationContext configCtx) throws BAMException {
        try {
            String serviceURL = ClientUtil.getBackendEPR(backendServerURL, BAM_SUMMARY_GENERATION_DS);
            this.summaryGenerationDSStub = new BAMSummaryGenerationDSStub(configCtx, serviceURL);
        }
        catch (Exception e) {
            throw new BAMException(e.getMessage(), (Throwable)e);
        }
    }

    public SummaryDimensionDSClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws BAMException {
        try {
            String serviceURL = ClientUtil.getBackendEPR(backendServerURL, BAM_SUMMARY_GENERATION_DS);
            this.summaryGenerationDSStub = new BAMSummaryGenerationDSStub(configCtx, serviceURL);
        }
        catch (Exception e) {
            throw new BAMException(e.getMessage(), (Throwable)e);
        }
        ServiceClient client = this.summaryGenerationDSStub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public void cleanup() {
        block2: {
            try {
                this.summaryGenerationDSStub._getServiceClient().cleanupTransport();
            }
            catch (AxisFault axisFault) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("Stub cleanup failed: " + this.getClass().getName()), (Throwable)axisFault);
            }
        }
    }

    private void populateHourDimension(HourDimension hd, HourDim thd) {
        hd.setId(Integer.parseInt(thd.getBamId()));
        hd.setDayDim(Integer.parseInt(thd.getDayId()));
        hd.setHour(Integer.parseInt(thd.getHourNo()));
        hd.setStartTimestamp(thd.getStartTime());
    }

    public HourDimension getHourDimension(int hourId) throws BAMException {
        HourDimension hd = null;
        try {
            HourDim[] hdArr = this.summaryGenerationDSStub.getHourDimFromId(hourId);
            if (hdArr != null && hdArr[0] != null) {
                hd = new HourDimension();
                this.populateHourDimension(hd, hdArr[0]);
            }
        }
        catch (Exception e) {
            throw new BAMException("getHourDimension failed", (Throwable)e);
        }
        return hd;
    }

    public HourDimension getHourDimension(int hour, int dayId) throws BAMException {
        HourDimension hd = null;
        try {
            HourDim[] hdArr = this.summaryGenerationDSStub.getHourDim(hour, dayId);
            if (hdArr != null && hdArr[0] != null) {
                hd = new HourDimension();
                this.populateHourDimension(hd, hdArr[0]);
            }
        }
        catch (Exception e) {
            throw new BAMException("getHourDimension failed", (Throwable)e);
        }
        return hd;
    }

    private void pupulateDayDimension(DayDimension dayDimension, DayDim dayDim) {
        dayDimension.setId(Integer.parseInt(dayDim.getBamId()));
        dayDimension.setName(dayDim.getName());
        dayDimension.setMonthDim(Integer.parseInt(dayDim.getMonthId()));
        dayDimension.setDayOfMonth(Integer.parseInt(dayDim.getDayOfMonth()));
        dayDimension.setDayOfWeek(Integer.parseInt(dayDim.getDayOfWeek()));
        dayDimension.setDayOfYear(Integer.parseInt(dayDim.getDayOfYear()));
        dayDimension.setStartTimestamp(dayDim.getStartTime());
    }

    public DayDimension getDayDimension(int day, int monthId) throws BAMException {
        DayDimension dd = null;
        try {
            DayDim[] ddArr = this.summaryGenerationDSStub.getDayDim(day, monthId);
            if (ddArr != null && ddArr[0] != null) {
                dd = new DayDimension();
                this.pupulateDayDimension(dd, ddArr[0]);
            }
        }
        catch (Exception e) {
            throw new BAMException("getDayDim failed", (Throwable)e);
        }
        return dd;
    }

    public DayDimension getDayDimension(int dayId) throws BAMException {
        DayDimension dd = null;
        try {
            DayDim[] ddArr = this.summaryGenerationDSStub.getDayDimFromId(dayId);
            if (ddArr != null && ddArr[0] != null) {
                dd = new DayDimension();
                this.pupulateDayDimension(dd, ddArr[0]);
            }
        }
        catch (Exception e) {
            throw new BAMException("getDayDimFromId failed", (Throwable)e);
        }
        return dd;
    }

    private void populateMonthDimension(MonthDimension md, MonthDim tmd) {
        md.setId(Integer.parseInt(tmd.getBamId()));
        md.setMonth(Integer.parseInt(tmd.getMonthNo()));
        md.setName(tmd.getName());
        md.setQuarterDim(Integer.parseInt(tmd.getQuarterId()));
        md.setStartTimestamp(tmd.getStartTime());
    }

    public MonthDimension getMonthDimension(int month, int quarterId) throws BAMException {
        MonthDimension md = null;
        try {
            MonthDim[] mdArr = this.summaryGenerationDSStub.getMonthDim(month, quarterId);
            if (mdArr != null && mdArr[0] != null) {
                md = new MonthDimension();
                this.populateMonthDimension(md, mdArr[0]);
            }
        }
        catch (Exception e) {
            throw new BAMException("getMonthDim failed", (Throwable)e);
        }
        return md;
    }

    public MonthDimension getMonthDimension(int monthId) throws BAMException {
        MonthDimension md = null;
        try {
            MonthDim[] mdArr = this.summaryGenerationDSStub.getMonthDimFormId(monthId);
            if (mdArr != null && mdArr[0] != null) {
                md = new MonthDimension();
                this.populateMonthDimension(md, mdArr[0]);
            }
        }
        catch (Exception e) {
            throw new BAMException("getMonthDimFormId failed", (Throwable)e);
        }
        return md;
    }

    private void populateQuarterDimension(QuarterDimension qd, QuarterDim tqd) {
        qd.setId(Integer.parseInt(tqd.getBamId()));
        qd.setName(tqd.getName());
        qd.setQuarter(Integer.parseInt(tqd.getQuarterNo()));
        qd.setYearDim(Integer.parseInt(tqd.getYearId()));
        qd.setStartTimestamp(tqd.getStartTime());
    }

    public QuarterDimension getQuarterDimension(int quarter, int yearId) throws BAMException {
        QuarterDimension qd = null;
        try {
            QuarterDim[] qdArr = this.summaryGenerationDSStub.getQuarterDim(quarter, yearId);
            if (qdArr != null && qdArr[0] != null) {
                qd = new QuarterDimension();
                this.populateQuarterDimension(qd, qdArr[0]);
            }
        }
        catch (Exception e) {
            throw new BAMException("getQuarterDim failed", (Throwable)e);
        }
        return qd;
    }

    public QuarterDimension getQuarterDimension(int quarterId) throws BAMException {
        QuarterDimension qd = null;
        try {
            QuarterDim[] qdArr = this.summaryGenerationDSStub.getQuarterDimFromId(quarterId);
            if (qdArr != null && qdArr[0] != null) {
                qd = new QuarterDimension();
                this.populateQuarterDimension(qd, qdArr[0]);
            }
        }
        catch (Exception e) {
            throw new BAMException("getQuarterDimFromId failed", (Throwable)e);
        }
        return qd;
    }

    private void populateYearDimension(YearDimension yd, YearDim tyd) {
        yd.setId(Integer.parseInt(tyd.getBamId()));
        yd.setYear(Integer.parseInt(tyd.getYearNo()));
        yd.setStartTimestamp(tyd.getStartTime());
    }

    public YearDimension getYearDimension(int year) throws BAMException {
        YearDimension yd = null;
        try {
            YearDim[] ydArr = this.summaryGenerationDSStub.getYearDim(year);
            if (ydArr != null && ydArr[0] != null) {
                yd = new YearDimension();
                this.populateYearDimension(yd, ydArr[0]);
            }
        }
        catch (Exception e) {
            throw new BAMException("getYearDim failed", (Throwable)e);
        }
        return yd;
    }

    public YearDimension getYearDimensionFromId(int yearId) throws BAMException {
        YearDimension yd = null;
        try {
            YearDim[] ydArr = this.summaryGenerationDSStub.getYearDimFromId(yearId);
            if (ydArr != null && ydArr[0] != null) {
                yd = new YearDimension();
                this.populateYearDimension(yd, ydArr[0]);
            }
        }
        catch (Exception e) {
            throw new BAMException("getYearDimFromId failed", (Throwable)e);
        }
        return yd;
    }

    public void addHourDimension(BAMCalendar startTime, int dayId) throws BAMException {
        try {
            this.summaryGenerationDSStub.addHourDim((Calendar)startTime, startTime.get(11), dayId);
        }
        catch (Exception e) {
            throw new BAMException("addHourDim failed", (Throwable)e);
        }
    }

    public void addDayDimension(BAMCalendar startTime, String name, int monthId) throws BAMException {
        try {
            this.summaryGenerationDSStub.addDayDim((Calendar)startTime, name, startTime.get(8), startTime.get(5), startTime.get(6), monthId);
        }
        catch (Exception e) {
            throw new BAMException("addDayDim failed", (Throwable)e);
        }
    }

    public void addMonthDimension(BAMCalendar startTime, String name, int quarterId) throws BAMException {
        try {
            this.summaryGenerationDSStub.addMonthDim((Calendar)startTime, name, startTime.get(2), quarterId);
        }
        catch (Exception e) {
            throw new BAMException("addMonthDim failed", (Throwable)e);
        }
    }

    public void addQuarterDimension(BAMCalendar startTime, String name, int yearId) throws BAMException {
        try {
            this.summaryGenerationDSStub.addQuarterDim((Calendar)startTime, name, startTime.get(50), yearId);
        }
        catch (Exception e) {
            throw new BAMException("addQuarterDim failed", (Throwable)e);
        }
    }

    public void addYearDimension(BAMCalendar startTime) throws BAMException {
        try {
            this.summaryGenerationDSStub.addYearDim((Calendar)startTime, startTime.get(1));
        }
        catch (Exception e) {
            throw new BAMException("addYearDim failed", (Throwable)e);
        }
    }
}

