/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.common.clients;

import java.util.Calendar;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.common.ClientUtil;
import org.wso2.carbon.bam.common.dataobjects.mediation.MediationDataDO;
import org.wso2.carbon.bam.common.dataobjects.mediation.MediationSummaryStatistic;
import org.wso2.carbon.bam.services.stub.bamsummarygenerationds.BAMSummaryGenerationDSStub;
import org.wso2.carbon.bam.services.stub.bamsummarygenerationds.types.MedStatValue;
import org.wso2.carbon.bam.services.stub.bamsummarygenerationds.types.MedSummaryStat;
import org.wso2.carbon.bam.services.stub.bamsummarygenerationds.types.SummaryTime;
import org.wso2.carbon.bam.services.stub.bamsummarygenerationds.types.TimeStamp;
import org.wso2.carbon.bam.util.BAMCalendar;
import org.wso2.carbon.bam.util.BAMException;

public class BAMSummaryGenerationDSClient {
    private static final String BAM_SUMMARY_GENERATION_DS = "BAMSummaryGenerationDS";
    private static final Log log = LogFactory.getLog(BAMSummaryGenerationDSClient.class);
    private BAMSummaryGenerationDSStub summaryGenerationDSStub;

    public BAMSummaryGenerationDSClient(String backendServerURL, ConfigurationContext configCtx) throws BAMException {
        try {
            String serviceURL = ClientUtil.getBackendEPR(backendServerURL, BAM_SUMMARY_GENERATION_DS);
            this.summaryGenerationDSStub = new BAMSummaryGenerationDSStub(configCtx, serviceURL);
        }
        catch (Exception e) {
            throw new BAMException(e.getMessage(), (Throwable)e);
        }
    }

    public BAMSummaryGenerationDSClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws BAMException {
        try {
            String serviceURL = ClientUtil.getBackendEPR(backendServerURL, BAM_SUMMARY_GENERATION_DS);
            this.summaryGenerationDSStub = new BAMSummaryGenerationDSStub(configCtx, serviceURL);
        }
        catch (Exception e) {
            throw new BAMException(e.getMessage(), (Throwable)e);
        }
        ServiceClient client = this.summaryGenerationDSStub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public void cleanup() {
        block2: {
            try {
                this.summaryGenerationDSStub._getServiceClient().cleanupTransport();
            }
            catch (AxisFault axisFault) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("Stub cleanup failed: " + this.getClass().getName()), (Throwable)axisFault);
            }
        }
    }

    public void cleanupTransports() {
        block2: {
            try {
                this.summaryGenerationDSStub._getServiceClient().cleanupTransport();
            }
            catch (AxisFault axisFault) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("Stub cleanup failed: " + this.getClass().getName()), (Throwable)axisFault);
            }
        }
    }

    public double[] getMediationStatHourlySummaryDouble(int serverId, String endpointString, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        double[] valArr = new double[]{};
        try {
            MedStatValue[] stats = this.summaryGenerationDSStub.getDataForMediationHourlySummary(serverId, endpointString, (Calendar)startTime, (Calendar)endTime);
            if (stats != null) {
                valArr = new double[stats.length];
                for (int i = 0; i < stats.length; ++i) {
                    if (stats[i] == null) continue;
                    try {
                        valArr[i] = Double.parseDouble(stats[i].getMedStatValue());
                        continue;
                    }
                    catch (NumberFormatException e) {
                        valArr[i] = 0.0;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new BAMException("getMediationStatHourlySummaryDouble failed", (Throwable)e);
        }
        return valArr;
    }

    public int[] getDataForMediationMaxCount(int severId, String mediationString, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        int[] valArr = new int[]{};
        try {
            MedStatValue[] stats = this.summaryGenerationDSStub.getDataForMediationMaxCount(severId, mediationString, (Calendar)startTime, (Calendar)endTime);
            if (stats != null) {
                valArr = new int[stats.length];
                for (int i = 0; i < stats.length; ++i) {
                    if (stats[i] == null) continue;
                    try {
                        valArr[i] = Integer.parseInt(stats[i].getMedStatValue());
                        continue;
                    }
                    catch (NumberFormatException e) {
                        valArr[i] = 0;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new BAMException("getDataForMediation failed", (Throwable)e);
        }
        return valArr;
    }

    public int[] getMediationStatHourlySummaryInt(int serverId, String endpointString, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        int[] valArr = new int[]{};
        try {
            MedStatValue[] stats = this.summaryGenerationDSStub.getDataForMediationHourlySummary(serverId, endpointString, (Calendar)startTime, (Calendar)endTime);
            if (stats != null) {
                valArr = new int[stats.length];
                for (int i = 0; i < stats.length; ++i) {
                    if (stats[i] == null) continue;
                    try {
                        valArr[i] = Integer.parseInt(stats[i].getMedStatValue());
                        continue;
                    }
                    catch (NumberFormatException e) {
                        valArr[i] = 0;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new BAMException("getMediationStatHourlySummaryInt failed", (Throwable)e);
        }
        return valArr;
    }

    public MediationSummaryStatistic getEndpointStatDailySummary(int serverId, String endpoint, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        MediationSummaryStatistic msst = new MediationSummaryStatistic();
        try {
            MedSummaryStat mst;
            MedSummaryStat[] stat = this.summaryGenerationDSStub.getEndpointStatDailySummary(serverId, endpoint, direction, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (mst = stat[0]) != null) {
                BAMSummaryGenerationDSClient.populateMedSummaryStatistic(mst, msst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getEndpointStatDailySummary failed", (Throwable)e);
        }
        return msst;
    }

    public MediationSummaryStatistic getEndpointStatMonthlySummary(int serverId, String endpoint, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        MediationSummaryStatistic msst = new MediationSummaryStatistic();
        try {
            MedSummaryStat mst;
            MedSummaryStat[] stat = this.summaryGenerationDSStub.getEndpointStatMonthlySummary(serverId, endpoint, direction, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (mst = stat[0]) != null) {
                BAMSummaryGenerationDSClient.populateMedSummaryStatistic(mst, msst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getEndpointStatMonthlySummary failed", (Throwable)e);
        }
        return msst;
    }

    public MediationSummaryStatistic getEndpointStatQuarterlySummary(int serverId, String endpoint, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        MediationSummaryStatistic msst = new MediationSummaryStatistic();
        try {
            MedSummaryStat mst;
            MedSummaryStat[] stat = this.summaryGenerationDSStub.getEndpointStatQuarterlySummary(serverId, endpoint, direction, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (mst = stat[0]) != null) {
                BAMSummaryGenerationDSClient.populateMedSummaryStatistic(mst, msst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getEndpointStatQuarterlySummary failed", (Throwable)e);
        }
        return msst;
    }

    public MediationSummaryStatistic getEndpointStatYearlySummary(int serverId, String endpoint, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        MediationSummaryStatistic msst = new MediationSummaryStatistic();
        try {
            MedSummaryStat mst;
            MedSummaryStat[] stat = this.summaryGenerationDSStub.getEndpointStatYearlySummary(serverId, endpoint, direction, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (mst = stat[0]) != null) {
                BAMSummaryGenerationDSClient.populateMedSummaryStatistic(mst, msst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getEndpointStatYearlySummary failed", (Throwable)e);
        }
        return msst;
    }

    public void addEndpointStatHourlySummary(MediationSummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addEndpointStatHourlySummary(stat.getServerId(), stat.getTimeDimensionId(), stat.getName(), stat.getDirection(), stat.getAvgProcessingTime(), stat.getMaxProcessingTime(), stat.getMinProcessingTime(), stat.getCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addEndpointStatHourlySummary failed", (Throwable)e);
        }
    }

    public void addEndpointStatDailySummary(MediationSummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addEndpointStatDailySummary(stat.getServerId(), stat.getTimeDimensionId(), stat.getName(), stat.getDirection(), stat.getAvgProcessingTime(), stat.getMaxProcessingTime(), stat.getMinProcessingTime(), stat.getCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addEndpointStatDailySummary failed", (Throwable)e);
        }
    }

    public void addEndpointStatMonthlySummary(MediationSummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addEndpointStatMonthlySummary(stat.getServerId(), stat.getTimeDimensionId(), stat.getName(), stat.getDirection(), stat.getAvgProcessingTime(), stat.getMaxProcessingTime(), stat.getMinProcessingTime(), stat.getCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addEndpointStatMonthlySummary failed", (Throwable)e);
        }
    }

    public void addEndpointStatQuarterlySummary(MediationSummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addEndpointStatQuarterlySummary(stat.getServerId(), stat.getTimeDimensionId(), stat.getName(), stat.getDirection(), stat.getAvgProcessingTime(), stat.getMaxProcessingTime(), stat.getMinProcessingTime(), stat.getCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addEndpointStatQuarterlySummary failed", (Throwable)e);
        }
    }

    public void addEndpointStatYearlySummary(MediationSummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addEndpointStatYearlySummary(stat.getServerId(), stat.getTimeDimensionId(), stat.getName(), stat.getDirection(), stat.getAvgProcessingTime(), stat.getMaxProcessingTime(), stat.getMinProcessingTime(), stat.getCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addEndpointStatYearlySummary failed", (Throwable)e);
        }
    }

    public Calendar getLatestEndpointStatSummaryPeriod(int summaryPeriod, MediationDataDO endpoint) throws BAMException {
        Calendar cal;
        try {
            SummaryTime[] time;
            switch (summaryPeriod) {
                case 11: {
                    time = this.summaryGenerationDSStub.getLatestEndpointStatHourlySummaryHourId(endpoint.getServerId(), endpoint.getName(), endpoint.getDirection());
                    break;
                }
                case 5: {
                    time = this.summaryGenerationDSStub.getLatestEndpointStatDailySummaryDayId(endpoint.getServerId(), endpoint.getName(), endpoint.getDirection());
                    break;
                }
                case 2: {
                    time = this.summaryGenerationDSStub.getLatestEndpointStatMonthlySummaryMonthId(endpoint.getServerId(), endpoint.getName(), endpoint.getDirection());
                    break;
                }
                case 50: {
                    time = this.summaryGenerationDSStub.getLatestEndpointStatQuarterlySummaryQuarterId(endpoint.getServerId(), endpoint.getName(), endpoint.getDirection());
                    break;
                }
                case 1: {
                    time = this.summaryGenerationDSStub.getLatestEndpointStatYearlySummaryYearId(endpoint.getServerId(), endpoint.getName(), endpoint.getDirection());
                    break;
                }
                default: {
                    throw new BAMException("Unexpected timeInterval");
                }
            }
            cal = this.getTimeStampForId(summaryPeriod, time);
            if (cal == null) {
                TimeStamp[] timeStamps = this.summaryGenerationDSStub.getServerUserDataMinimumPeriodId(endpoint.getServerId());
                cal = timeStamps != null && timeStamps[0] != null ? BAMCalendar.getInstance((Calendar)timeStamps[0].getTimeStamp()) : BAMCalendar.getInstance();
                cal.add(summaryPeriod, -2);
            }
        }
        catch (Exception e) {
            String msg = "Unable to get LatestSummaryTime for endpoint";
            log.error((Object)msg);
            throw new BAMException(msg, (Throwable)e);
        }
        return cal;
    }

    public MediationSummaryStatistic getProxyServiceStatDailySummary(int serverId, String proxyService, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        MediationSummaryStatistic msst = new MediationSummaryStatistic();
        try {
            MedSummaryStat mst;
            MedSummaryStat[] stat = this.summaryGenerationDSStub.getProxyStatDailySummary(serverId, proxyService, direction, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (mst = stat[0]) != null) {
                BAMSummaryGenerationDSClient.populateMedSummaryStatistic(mst, msst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getProxyStatDailySummary failed", (Throwable)e);
        }
        return msst;
    }

    public MediationSummaryStatistic getProxyServiceStatMonthlySummary(int serverId, String proxyService, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        MediationSummaryStatistic msst = new MediationSummaryStatistic();
        try {
            MedSummaryStat mst;
            MedSummaryStat[] stat = this.summaryGenerationDSStub.getProxyStatMonthlySummary(serverId, proxyService, direction, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (mst = stat[0]) != null) {
                BAMSummaryGenerationDSClient.populateMedSummaryStatistic(mst, msst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getProxyStatMonthlySummary failed", (Throwable)e);
        }
        return msst;
    }

    public MediationSummaryStatistic getProxyServiceStatQuarterlySummary(int serverId, String proxyService, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        MediationSummaryStatistic msst = new MediationSummaryStatistic();
        try {
            MedSummaryStat mst;
            MedSummaryStat[] stat = this.summaryGenerationDSStub.getProxyStatQuarterlySummary(serverId, proxyService, direction, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (mst = stat[0]) != null) {
                BAMSummaryGenerationDSClient.populateMedSummaryStatistic(mst, msst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getProxyStatQuarterlySummary failed", (Throwable)e);
        }
        return msst;
    }

    public MediationSummaryStatistic getProxyServiceStatYearlySummary(int serverId, String proxyService, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        MediationSummaryStatistic msst = new MediationSummaryStatistic();
        try {
            MedSummaryStat mst;
            MedSummaryStat[] stat = this.summaryGenerationDSStub.getProxyStatYearlySummary(serverId, proxyService, direction, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (mst = stat[0]) != null) {
                BAMSummaryGenerationDSClient.populateMedSummaryStatistic(mst, msst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getProxyStatYearlySummary failed", (Throwable)e);
        }
        return msst;
    }

    public void addProxyServiceStatHourlySummary(MediationSummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addProxyStatHourlySummary(stat.getServerId(), stat.getTimeDimensionId(), stat.getName(), stat.getDirection(), stat.getAvgProcessingTime(), stat.getMaxProcessingTime(), stat.getMinProcessingTime(), stat.getCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addProxyStatHourlySummary failed", (Throwable)e);
        }
    }

    public void addProxyServiceStatDailySummary(MediationSummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addProxyStatDailySummary(stat.getServerId(), stat.getTimeDimensionId(), stat.getName(), stat.getDirection(), stat.getAvgProcessingTime(), stat.getMaxProcessingTime(), stat.getMinProcessingTime(), stat.getCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addProxyStatDailySummary failed", (Throwable)e);
        }
    }

    public void addProxyServiceStatMonthlySummary(MediationSummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addProxyStatMonthlySummary(stat.getServerId(), stat.getTimeDimensionId(), stat.getName(), stat.getDirection(), stat.getAvgProcessingTime(), stat.getMaxProcessingTime(), stat.getMinProcessingTime(), stat.getCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addProxyStatMonthlySummary failed", (Throwable)e);
        }
    }

    public void addProxyServiceStatQuarterlySummary(MediationSummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addProxyStatQuarterlySummary(stat.getServerId(), stat.getTimeDimensionId(), stat.getName(), stat.getDirection(), stat.getAvgProcessingTime(), stat.getMaxProcessingTime(), stat.getMinProcessingTime(), stat.getCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addProxyStatQuarterlySummary failed", (Throwable)e);
        }
    }

    public void addProxyServiceStatYearlySummary(MediationSummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addProxyStatYearlySummary(stat.getServerId(), stat.getTimeDimensionId(), stat.getName(), stat.getDirection(), stat.getAvgProcessingTime(), stat.getMaxProcessingTime(), stat.getMinProcessingTime(), stat.getCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addProxyStatYearlySummary failed", (Throwable)e);
        }
    }

    public Calendar getLatestProxyServiceStatSummaryPeriod(int summaryPeriod, MediationDataDO proxyService) throws BAMException {
        Calendar cal;
        try {
            SummaryTime[] time;
            switch (summaryPeriod) {
                case 11: {
                    time = this.summaryGenerationDSStub.getLatestProxyStatHourlySummaryHourId(proxyService.getServerId(), proxyService.getName(), proxyService.getDirection());
                    break;
                }
                case 5: {
                    time = this.summaryGenerationDSStub.getLatestProxyStatDailySummaryDayId(proxyService.getServerId(), proxyService.getName(), proxyService.getDirection());
                    break;
                }
                case 2: {
                    time = this.summaryGenerationDSStub.getLatestProxyStatMonthlySummaryMonthId(proxyService.getServerId(), proxyService.getName(), proxyService.getDirection());
                    break;
                }
                case 50: {
                    time = this.summaryGenerationDSStub.getLatestProxyStatQuarterlySummaryQuarterId(proxyService.getServerId(), proxyService.getName(), proxyService.getDirection());
                    break;
                }
                case 1: {
                    time = this.summaryGenerationDSStub.getLatestProxyStatYearlySummaryYearId(proxyService.getServerId(), proxyService.getName(), proxyService.getDirection());
                    break;
                }
                default: {
                    throw new BAMException("Unexpected timeInterval");
                }
            }
            cal = this.getTimeStampForId(summaryPeriod, time);
            if (cal == null) {
                TimeStamp[] timeStamps = this.summaryGenerationDSStub.getServerUserDataMinimumPeriodId(proxyService.getServerId());
                cal = timeStamps != null && timeStamps[0] != null ? BAMCalendar.getInstance((Calendar)timeStamps[0].getTimeStamp()) : BAMCalendar.getInstance();
                cal.add(summaryPeriod, -2);
            }
        }
        catch (Exception e) {
            String msg = "Unable to get LatestSummaryTime for proxy service";
            log.error((Object)msg);
            throw new BAMException(msg, (Throwable)e);
        }
        return cal;
    }

    public MediationSummaryStatistic getSequenceStatDailySummary(int serverId, String sequence, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        MediationSummaryStatistic msst = new MediationSummaryStatistic();
        try {
            MedSummaryStat mst;
            MedSummaryStat[] stat = this.summaryGenerationDSStub.getSequenceStatDailySummary(serverId, sequence, direction, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (mst = stat[0]) != null) {
                BAMSummaryGenerationDSClient.populateMedSummaryStatistic(mst, msst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getSequenceStatDailySummary failed", (Throwable)e);
        }
        return msst;
    }

    public MediationSummaryStatistic getSequenceStatMonthlySummary(int serverId, String sequence, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        MediationSummaryStatistic msst = new MediationSummaryStatistic();
        try {
            MedSummaryStat mst;
            MedSummaryStat[] stat = this.summaryGenerationDSStub.getSequenceStatMonthlySummary(serverId, sequence, direction, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (mst = stat[0]) != null) {
                BAMSummaryGenerationDSClient.populateMedSummaryStatistic(mst, msst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getSequenceStatMonthlySummary failed", (Throwable)e);
        }
        return msst;
    }

    public MediationSummaryStatistic getSequenceStatQuarterlySummary(int serverId, String sequence, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        MediationSummaryStatistic msst = new MediationSummaryStatistic();
        try {
            MedSummaryStat mst;
            MedSummaryStat[] stat = this.summaryGenerationDSStub.getSequenceStatQuarterlySummary(serverId, sequence, direction, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (mst = stat[0]) != null) {
                BAMSummaryGenerationDSClient.populateMedSummaryStatistic(mst, msst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getSequenceStatQuarterlySummary failed", (Throwable)e);
        }
        return msst;
    }

    public MediationSummaryStatistic getSequenceStatYearlySummary(int serverId, String sequence, String direction, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        MediationSummaryStatistic msst = new MediationSummaryStatistic();
        try {
            MedSummaryStat mst;
            MedSummaryStat[] stat = this.summaryGenerationDSStub.getSequenceStatYearlySummary(serverId, sequence, direction, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (mst = stat[0]) != null) {
                BAMSummaryGenerationDSClient.populateMedSummaryStatistic(mst, msst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getSequenceStatYearlySummary failed", (Throwable)e);
        }
        return msst;
    }

    public void addSequenceStatHourlySummary(MediationSummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addSequenceStatHourlySummary(stat.getServerId(), stat.getTimeDimensionId(), stat.getName(), stat.getDirection(), stat.getAvgProcessingTime(), stat.getMaxProcessingTime(), stat.getMinProcessingTime(), stat.getCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addSequenceStatHourlySummary failed", (Throwable)e);
        }
    }

    public void addSequenceStatDailySummary(MediationSummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addSequenceStatDailySummary(stat.getServerId(), stat.getTimeDimensionId(), stat.getName(), stat.getDirection(), stat.getAvgProcessingTime(), stat.getMaxProcessingTime(), stat.getMinProcessingTime(), stat.getCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addSequenceStatDailySummary failed", (Throwable)e);
        }
    }

    public void addSequenceStatMonthlySummary(MediationSummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addSequenceStatMonthlySummary(stat.getServerId(), stat.getTimeDimensionId(), stat.getName(), stat.getDirection(), stat.getAvgProcessingTime(), stat.getMaxProcessingTime(), stat.getMinProcessingTime(), stat.getCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addSequenceStatMonthlySummary failed", (Throwable)e);
        }
    }

    public void addSequenceStatQuarterlySummary(MediationSummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addSequenceStatQuarterlySummary(stat.getServerId(), stat.getTimeDimensionId(), stat.getName(), stat.getDirection(), stat.getAvgProcessingTime(), stat.getMaxProcessingTime(), stat.getMinProcessingTime(), stat.getCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addSequenceStatQuarterlySummary failed", (Throwable)e);
        }
    }

    public void addSequenceStatYearlySummary(MediationSummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addSequenceStatYearlySummary(stat.getServerId(), stat.getTimeDimensionId(), stat.getName(), stat.getDirection(), stat.getAvgProcessingTime(), stat.getMaxProcessingTime(), stat.getMinProcessingTime(), stat.getCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addSequenceStatYearlySummary failed", (Throwable)e);
        }
    }

    public Calendar getLatestSequenceStatSummaryPeriod(int summaryPeriod, MediationDataDO sequence) throws BAMException {
        Calendar cal;
        try {
            SummaryTime[] time;
            switch (summaryPeriod) {
                case 11: {
                    time = this.summaryGenerationDSStub.getLatestSequenceStatHourlySummaryHourId(sequence.getServerId(), sequence.getName(), sequence.getDirection());
                    break;
                }
                case 5: {
                    time = this.summaryGenerationDSStub.getLatestSequenceStatDailySummaryDayId(sequence.getServerId(), sequence.getName(), sequence.getDirection());
                    break;
                }
                case 2: {
                    time = this.summaryGenerationDSStub.getLatestSequenceStatMonthlySummaryMonthId(sequence.getServerId(), sequence.getName(), sequence.getDirection());
                    break;
                }
                case 50: {
                    time = this.summaryGenerationDSStub.getLatestSequenceStatQuarterlySummaryQuarterId(sequence.getServerId(), sequence.getName(), sequence.getDirection());
                    break;
                }
                case 1: {
                    time = this.summaryGenerationDSStub.getLatestSequenceStatYearlySummaryYearId(sequence.getServerId(), sequence.getName(), sequence.getDirection());
                    break;
                }
                default: {
                    throw new BAMException("Unexpected timeInterval");
                }
            }
            cal = this.getTimeStampForId(summaryPeriod, time);
            if (cal == null) {
                TimeStamp[] timeStamps = this.summaryGenerationDSStub.getServerUserDataMinimumPeriodId(sequence.getServerId());
                cal = timeStamps != null && timeStamps[0] != null ? BAMCalendar.getInstance((Calendar)timeStamps[0].getTimeStamp()) : BAMCalendar.getInstance();
                cal.add(summaryPeriod, -2);
            }
        }
        catch (Exception e) {
            String msg = "Unable to get LatestSummaryTime for sequence";
            log.error((Object)msg);
            throw new BAMException(msg, (Throwable)e);
        }
        return cal;
    }

    private static void populateMedSummaryStatistic(MedSummaryStat mst, MediationSummaryStatistic msst) {
        if (mst.getAvgResTime() != null && mst.getAvgResTime().length() > 0) {
            msst.setAvgProcessingTime(Double.parseDouble(mst.getAvgResTime()));
        }
        if (mst.getMaxResTime() != null && mst.getMaxResTime().length() > 0) {
            msst.setMaxProcessingTime(Double.parseDouble(mst.getMaxResTime()));
        }
        if (mst.getMinResTime() != null && mst.getMinResTime().length() > 0) {
            msst.setMinProcessingTime(Double.parseDouble(mst.getMinResTime()));
        }
        if (mst.getReqCount() != null && mst.getReqCount().length() > 0) {
            msst.setCount(Integer.parseInt(mst.getReqCount()));
        }
        if (mst.getFaultCount() != null && mst.getFaultCount().length() > 0) {
            msst.setFaultCount(Integer.parseInt(mst.getFaultCount()));
        }
    }

    public void deleteServerData(int serverId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        try {
            this.summaryGenerationDSStub.deleteServerData(serverId, (Calendar)startTime, (Calendar)endTime);
        }
        catch (Exception e) {
            throw new BAMException("deleteServerData failed", (Throwable)e);
        }
    }

    public void deleteServiceData(int serviceId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        try {
            this.summaryGenerationDSStub.deleteServiceData(serviceId, (Calendar)startTime, (Calendar)endTime);
        }
        catch (Exception e) {
            throw new BAMException("deleteServiceData failed", (Throwable)e);
        }
    }

    public void deleteOperationData(int operationId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        try {
            this.summaryGenerationDSStub.deleteOperationData(operationId, (Calendar)startTime, (Calendar)endTime);
        }
        catch (Exception e) {
            throw new BAMException("deleteOperationData failed", (Throwable)e);
        }
    }

    public void deleteServerUserData(int serverId, String mediationName, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        try {
            this.summaryGenerationDSStub.deleteServerUserData(serverId, mediationName, (Calendar)startTime, (Calendar)endTime);
        }
        catch (Exception e) {
            throw new BAMException("deleteServerUserData failed", (Throwable)e);
        }
    }

    private Calendar getTimeStampForId(int summaryPeriod, SummaryTime[] time) throws Exception {
        Calendar cal = null;
        if (time != null && time[0] != null) {
            String idStr = time[0].getSummaryTime();
            int id = 0;
            try {
                id = Integer.parseInt(idStr);
            }
            catch (Exception e) {
                return null;
            }
            switch (summaryPeriod) {
                case 11: {
                    cal = this.summaryGenerationDSStub.getHourDimFromId(id)[0].getStartTime();
                    break;
                }
                case 5: {
                    cal = this.summaryGenerationDSStub.getDayDimFromId(id)[0].getStartTime();
                    break;
                }
                case 2: {
                    cal = this.summaryGenerationDSStub.getMonthDimFormId(id)[0].getStartTime();
                    break;
                }
                case 50: {
                    cal = this.summaryGenerationDSStub.getQuarterDimFromId(id)[0].getStartTime();
                    break;
                }
                case 1: {
                    cal = this.summaryGenerationDSStub.getYearDimFromId(id)[0].getStartTime();
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        if (cal != null) {
            return BAMCalendar.getInstance(cal);
        }
        return null;
    }
}

