/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.common.clients;

import java.util.Calendar;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.common.ClientUtil;
import org.wso2.carbon.bam.common.dataobjects.stats.SummaryStatistic;
import org.wso2.carbon.bam.services.stub.bamsummarygenerationds.BAMSummaryGenerationDSStub;
import org.wso2.carbon.bam.services.stub.bamsummarygenerationds.types.MaxCount;
import org.wso2.carbon.bam.services.stub.bamsummarygenerationds.types.SummaryStat;
import org.wso2.carbon.bam.services.stub.bamsummarygenerationds.types.SummaryTime;
import org.wso2.carbon.bam.services.stub.bamsummarygenerationds.types.TimeStamp;
import org.wso2.carbon.bam.util.BAMCalendar;
import org.wso2.carbon.bam.util.BAMException;

public class BAMServiceSummaryDSClient {
    private BAMSummaryGenerationDSStub summaryGenerationDSStub;
    private static final String BAM_SUMMARY_GENERATION_DS = "BAMSummaryGenerationDS";
    private static final Log log = LogFactory.getLog(BAMServiceSummaryDSClient.class);

    public BAMServiceSummaryDSClient(String backendServerURL, ConfigurationContext configCtx) throws BAMException {
        try {
            String serviceURL = ClientUtil.getBackendEPR(backendServerURL, BAM_SUMMARY_GENERATION_DS);
            this.summaryGenerationDSStub = new BAMSummaryGenerationDSStub(configCtx, serviceURL);
        }
        catch (Exception e) {
            throw new BAMException(e.getMessage(), (Throwable)e);
        }
    }

    public BAMServiceSummaryDSClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws BAMException {
        try {
            String serviceURL = ClientUtil.getBackendEPR(backendServerURL, BAM_SUMMARY_GENERATION_DS);
            this.summaryGenerationDSStub = new BAMSummaryGenerationDSStub(configCtx, serviceURL);
        }
        catch (Exception e) {
            throw new BAMException(e.getMessage(), (Throwable)e);
        }
        ServiceClient client = this.summaryGenerationDSStub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public void cleanup() {
        block2: {
            try {
                this.summaryGenerationDSStub._getServiceClient().cleanupTransport();
            }
            catch (AxisFault axisFault) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("Stub cleanup failed: " + this.getClass().getName()), (Throwable)axisFault);
            }
        }
    }

    public Calendar getLatestServerStatSummaryPeriod(int summaryPeriod, int serverId) throws BAMException {
        Calendar cal;
        try {
            SummaryTime[] time;
            switch (summaryPeriod) {
                case 11: {
                    time = this.summaryGenerationDSStub.getLatestServerStatHourlySummaryHourId(serverId);
                    break;
                }
                case 5: {
                    time = this.summaryGenerationDSStub.getLatestServerStatDailySummaryDayId(serverId);
                    break;
                }
                case 2: {
                    time = this.summaryGenerationDSStub.getLatestServerStatMonthlySummaryMonthId(serverId);
                    break;
                }
                case 50: {
                    time = this.summaryGenerationDSStub.getLatestServerStatQuarterlySummaryQuarterId(serverId);
                    break;
                }
                case 1: {
                    time = this.summaryGenerationDSStub.getLatestServerStatYearlySummaryYearId(serverId);
                    break;
                }
                default: {
                    throw new BAMException("Unexpected timeInterval");
                }
            }
            cal = this.getTimeStampForId(summaryPeriod, time);
            if (cal == null) {
                TimeStamp[] timeStamps = this.summaryGenerationDSStub.getServerStatMinimumPeriodId(serverId);
                cal = timeStamps != null && timeStamps[0] != null ? BAMCalendar.getInstance((Calendar)timeStamps[0].getTimeStamp()) : BAMCalendar.getInstance();
                cal.add(summaryPeriod, -2);
            }
        }
        catch (Exception e) {
            String msg = "Unable to get LatestSummaryTime for server";
            log.error((Object)msg);
            throw new BAMException(msg, (Throwable)e);
        }
        return cal;
    }

    public Calendar getLatestServiceStatSummaryPeriod(int summaryPeriod, int serviceId) throws BAMException {
        Calendar cal;
        try {
            SummaryTime[] time;
            switch (summaryPeriod) {
                case 11: {
                    time = this.summaryGenerationDSStub.getLatestServiceStatHourlySummaryHourId(serviceId);
                    break;
                }
                case 5: {
                    time = this.summaryGenerationDSStub.getLatestServiceStatDailySummaryDayId(serviceId);
                    break;
                }
                case 2: {
                    time = this.summaryGenerationDSStub.getLatestServiceStatMonthlySummaryMonthId(serviceId);
                    break;
                }
                case 50: {
                    time = this.summaryGenerationDSStub.getLatestServiceStatQuarterlySummaryQuarterId(serviceId);
                    break;
                }
                case 1: {
                    time = this.summaryGenerationDSStub.getLatestServiceStatYearlySummaryYearId(serviceId);
                    break;
                }
                default: {
                    throw new BAMException("Unexpected timeInterval");
                }
            }
            cal = this.getTimeStampForId(summaryPeriod, time);
            if (cal == null) {
                TimeStamp[] timeStamps = this.summaryGenerationDSStub.getServiceStatMinimumPeriodId(serviceId);
                cal = timeStamps != null && timeStamps[0] != null ? BAMCalendar.getInstance((Calendar)timeStamps[0].getTimeStamp()) : BAMCalendar.getInstance();
                cal.add(summaryPeriod, -2);
            }
        }
        catch (Exception e) {
            String msg = "Unable to get LatestSummaryTime for service";
            log.error((Object)msg);
            throw new BAMException(msg, (Throwable)e);
        }
        return cal;
    }

    public Calendar getLatestOperationStatSummaryPeriod(int summaryPeriod, int operationId) throws BAMException {
        Calendar cal;
        try {
            SummaryTime[] time;
            switch (summaryPeriod) {
                case 11: {
                    time = this.summaryGenerationDSStub.getLatestOperationStatHourlySummaryHourId(operationId);
                    break;
                }
                case 5: {
                    time = this.summaryGenerationDSStub.getLatestOperationStatDailySummaryDayId(operationId);
                    break;
                }
                case 2: {
                    time = this.summaryGenerationDSStub.getLatestOperationStatMonthlySummaryMonthId(operationId);
                    break;
                }
                case 50: {
                    time = this.summaryGenerationDSStub.getLatestOperationStatQuarterlySummaryQuarterId(operationId);
                    break;
                }
                case 1: {
                    time = this.summaryGenerationDSStub.getLatestOperationStatYearlySummaryYearId(operationId);
                    break;
                }
                default: {
                    throw new BAMException("Unexpected timeInterval");
                }
            }
            cal = this.getTimeStampForId(summaryPeriod, time);
            if (cal == null) {
                TimeStamp[] timeStamps = this.summaryGenerationDSStub.getOperationStatMinimumPeriodId(operationId);
                cal = timeStamps != null && timeStamps[0] != null ? BAMCalendar.getInstance((Calendar)timeStamps[0].getTimeStamp()) : BAMCalendar.getInstance();
                cal.add(summaryPeriod, -2);
            }
        }
        catch (Exception e) {
            String msg = "Unable to get LatestSummaryTime for operation";
            log.error((Object)msg);
            throw new BAMException(msg, (Throwable)e);
        }
        return cal;
    }

    public void addServerStatHourlySummary(SummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addServerStatHourlySummary(stat.getTypeId(), stat.getTimeDimensionId(), stat.getAvgResTime(), stat.getMaxResTime(), stat.getMinResTime(), stat.getReqCount(), stat.getResCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addServerStatHourlySummary failed", (Throwable)e);
        }
    }

    public void addServerStatDailySummary(SummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addServerStatDailySummary(stat.getTypeId(), stat.getTimeDimensionId(), stat.getAvgResTime(), stat.getMaxResTime(), stat.getMinResTime(), stat.getReqCount(), stat.getResCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addServerStatDailySummary failed", (Throwable)e);
        }
    }

    public void addServerStatMonthlySummary(SummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addServerStatMonthlySummary(stat.getTypeId(), stat.getTimeDimensionId(), stat.getAvgResTime(), stat.getMaxResTime(), stat.getMinResTime(), stat.getReqCount(), stat.getResCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addServerStatMonthlySummary failed", (Throwable)e);
        }
    }

    public void addServerStatQuarterlySummary(SummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addServerStatQuarterlySummary(stat.getTypeId(), stat.getTimeDimensionId(), stat.getAvgResTime(), stat.getMaxResTime(), stat.getMinResTime(), stat.getReqCount(), stat.getResCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addServerStatQuarterlySummary failed", (Throwable)e);
        }
    }

    public void addServerStatYearlySummary(SummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addServerStatYearlySummary(stat.getTypeId(), stat.getTimeDimensionId(), stat.getAvgResTime(), stat.getMaxResTime(), stat.getMinResTime(), stat.getReqCount(), stat.getResCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addServerStatYearlySummary failed", (Throwable)e);
        }
    }

    public SummaryStatistic getServerStatHourlySummary(int serverId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        SummaryStatistic sst = new SummaryStatistic();
        try {
            SummaryStat st;
            SummaryStat[] stat = this.summaryGenerationDSStub.getServerHourlySummary(serverId, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (st = stat[0]) != null) {
                this.populateSummaryStatistic(st, sst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getServerHourlySummary failed", (Throwable)e);
        }
        return sst;
    }

    public SummaryStatistic getServerMaxCounts(int serverId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        try {
            SummaryStatistic stat = new SummaryStatistic();
            MaxCount[] maxCounts = this.summaryGenerationDSStub.getServerDataMaxCounts(serverId, (Calendar)startTime, (Calendar)endTime);
            if (maxCounts != null && maxCounts[0] != null) {
                this.populateSummaryStatisticFromMaxCounts(maxCounts[0], stat);
            }
            return stat;
        }
        catch (Exception e) {
            throw new BAMException("getServerMaxCounts failed", (Throwable)e);
        }
    }

    public SummaryStatistic getServiceMaxCounts(int serverId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        try {
            SummaryStatistic stat = new SummaryStatistic();
            MaxCount[] maxCounts = this.summaryGenerationDSStub.getServiceDataMaxCounts(serverId, (Calendar)startTime, (Calendar)endTime);
            if (maxCounts != null && maxCounts[0] != null) {
                this.populateSummaryStatisticFromMaxCounts(maxCounts[0], stat);
            }
            return stat;
        }
        catch (Exception e) {
            throw new BAMException("getServiceMaxCounts failed", (Throwable)e);
        }
    }

    public SummaryStatistic getOperationMaxCounts(int serverId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        try {
            SummaryStatistic stat = new SummaryStatistic();
            MaxCount[] maxCounts = this.summaryGenerationDSStub.getOperationDataMaxCounts(serverId, (Calendar)startTime, (Calendar)endTime);
            if (maxCounts != null && maxCounts[0] != null) {
                this.populateSummaryStatisticFromMaxCounts(maxCounts[0], stat);
            }
            return stat;
        }
        catch (Exception e) {
            throw new BAMException("getOperationMaxCounts failed", (Throwable)e);
        }
    }

    private void populateSummaryStatisticFromMaxCounts(MaxCount maxCount, SummaryStatistic stat) {
        if (maxCount.getReqCount() != null && maxCount.getReqCount().length() > 0) {
            stat.setReqCount(Integer.parseInt(maxCount.getReqCount()));
        }
        if (maxCount.getResCount() != null && maxCount.getResCount().length() > 0) {
            stat.setResCount(Integer.parseInt(maxCount.getResCount()));
        }
        if (maxCount.getFaultCount() != null && maxCount.getFaultCount().length() > 0) {
            stat.setFaultCount(Integer.parseInt(maxCount.getFaultCount()));
        }
    }

    public SummaryStatistic getServerStatDailySummary(int serverId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        SummaryStatistic sst = new SummaryStatistic();
        try {
            SummaryStat st;
            SummaryStat[] stat = this.summaryGenerationDSStub.getServerDailySummary(serverId, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (st = stat[0]) != null) {
                this.populateSummaryStatistic(st, sst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getServerDailySummary failed", (Throwable)e);
        }
        return sst;
    }

    public SummaryStatistic getServerStatMonthlySummary(int serverId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        SummaryStatistic sst = new SummaryStatistic();
        try {
            SummaryStat st;
            SummaryStat[] stat = this.summaryGenerationDSStub.getServerMonthlySummary(serverId, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (st = stat[0]) != null) {
                this.populateSummaryStatistic(st, sst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getServerMonthlySummary failed", (Throwable)e);
        }
        return sst;
    }

    public SummaryStatistic getServerStatQuarterlySummary(int serverId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        SummaryStatistic sst = new SummaryStatistic();
        try {
            SummaryStat st;
            SummaryStat[] stat = this.summaryGenerationDSStub.getServerQuarterlySummary(serverId, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (st = stat[0]) != null) {
                this.populateSummaryStatistic(st, sst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getServerQuarterlySummary failed", (Throwable)e);
        }
        return sst;
    }

    public SummaryStatistic getServerStatYearlySummary(int serverId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        SummaryStatistic sst = new SummaryStatistic();
        try {
            SummaryStat st;
            SummaryStat[] stat = this.summaryGenerationDSStub.getServerYearlySummary(serverId, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (st = stat[0]) != null) {
                this.populateSummaryStatistic(st, sst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getServerYearlySummary failed", (Throwable)e);
        }
        return sst;
    }

    public SummaryStatistic getServiceStatHourlySummary(int serviceId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        SummaryStatistic sst = new SummaryStatistic();
        try {
            SummaryStat st;
            SummaryStat[] stat = this.summaryGenerationDSStub.getServiceHourlySummary(serviceId, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (st = stat[0]) != null) {
                this.populateSummaryStatistic(st, sst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getServiceHourlySummary failed", (Throwable)e);
        }
        return sst;
    }

    public SummaryStatistic getServiceStatDailySummary(int serviceId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        SummaryStatistic sst = new SummaryStatistic();
        try {
            SummaryStat st;
            SummaryStat[] stat = this.summaryGenerationDSStub.getServiceDailySummary(serviceId, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (st = stat[0]) != null) {
                this.populateSummaryStatistic(st, sst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getServiceHourlySummary failed", (Throwable)e);
        }
        return sst;
    }

    public SummaryStatistic getServiceStatMonthlySummary(int serviceId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        SummaryStatistic sst = new SummaryStatistic();
        try {
            SummaryStat st;
            SummaryStat[] stat = this.summaryGenerationDSStub.getServiceMonthlySummary(serviceId, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (st = stat[0]) != null) {
                this.populateSummaryStatistic(st, sst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getServiceMonthlySummary failed", (Throwable)e);
        }
        return sst;
    }

    public SummaryStatistic getServiceStatQuarterlySummary(int serviceId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        SummaryStatistic sst = new SummaryStatistic();
        try {
            SummaryStat st;
            SummaryStat[] stat = this.summaryGenerationDSStub.getServiceQuarterlySummary(serviceId, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (st = stat[0]) != null) {
                this.populateSummaryStatistic(st, sst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getServiceQuarterlySummary failed", (Throwable)e);
        }
        return sst;
    }

    public SummaryStatistic getServiceStatYearlySummary(int serviceId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        SummaryStatistic sst = new SummaryStatistic();
        try {
            SummaryStat st;
            SummaryStat[] stat = this.summaryGenerationDSStub.getServiceYearlySummary(serviceId, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (st = stat[0]) != null) {
                this.populateSummaryStatistic(st, sst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getServiceYearlySummary failed", (Throwable)e);
        }
        return sst;
    }

    public void addServiceStatHourlySummary(SummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addServiceStatHourlySummary(stat.getTypeId(), stat.getTimeDimensionId(), stat.getAvgResTime(), stat.getMaxResTime(), stat.getMinResTime(), stat.getReqCount(), stat.getResCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addServiceStatHourlySummary failed", (Throwable)e);
        }
    }

    public void addServiceStatDailySummary(SummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addServiceStatDailySummary(stat.getTypeId(), stat.getTimeDimensionId(), stat.getAvgResTime(), stat.getMaxResTime(), stat.getMinResTime(), stat.getReqCount(), stat.getResCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addServiceStatDailySummary failed", (Throwable)e);
        }
    }

    public void addServiceStatMonthlySummary(SummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addServiceStatMonthlySummary(stat.getTypeId(), stat.getTimeDimensionId(), stat.getAvgResTime(), stat.getMaxResTime(), stat.getMinResTime(), stat.getReqCount(), stat.getResCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addServiceStatMonthlySummary failed", (Throwable)e);
        }
    }

    public void addServiceStatQuarterlySummary(SummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addServiceStatQuarterlySummary(stat.getTypeId(), stat.getTimeDimensionId(), stat.getAvgResTime(), stat.getMaxResTime(), stat.getMinResTime(), stat.getReqCount(), stat.getResCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addServiceStatQuarterlySummary failed", (Throwable)e);
        }
    }

    public void addServiceStatYearlySummary(SummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addServiceStatYearlySummary(stat.getTypeId(), stat.getTimeDimensionId(), stat.getAvgResTime(), stat.getMaxResTime(), stat.getMinResTime(), stat.getReqCount(), stat.getResCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addServiceStatYearlySummary failed", (Throwable)e);
        }
    }

    public SummaryStatistic getOperationStatHourlySummary(int opId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        SummaryStatistic sst = new SummaryStatistic();
        try {
            SummaryStat st;
            SummaryStat[] stat = this.summaryGenerationDSStub.getOperationHourlySummary(opId, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (st = stat[0]) != null) {
                this.populateSummaryStatistic(st, sst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getOperationHourlySummary failed", (Throwable)e);
        }
        return sst;
    }

    public SummaryStatistic getOperationStatDailySummary(int opId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        SummaryStatistic sst = new SummaryStatistic();
        try {
            SummaryStat st;
            SummaryStat[] stat = this.summaryGenerationDSStub.getOperationDailySummary(opId, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (st = stat[0]) != null) {
                this.populateSummaryStatistic(st, sst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getOperationDailySummary failed", (Throwable)e);
        }
        return sst;
    }

    public SummaryStatistic getOperationStatMonthlySummary(int opId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        SummaryStatistic sst = new SummaryStatistic();
        try {
            SummaryStat st;
            SummaryStat[] stat = this.summaryGenerationDSStub.getOperationMonthlySummary(opId, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (st = stat[0]) != null) {
                this.populateSummaryStatistic(st, sst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getOperationMonthlySummary failed", (Throwable)e);
        }
        return sst;
    }

    public SummaryStatistic getOperationStatQuarterlySummary(int opId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        SummaryStatistic sst = new SummaryStatistic();
        try {
            SummaryStat st;
            SummaryStat[] stat = this.summaryGenerationDSStub.getOperationQuarterlySummary(opId, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (st = stat[0]) != null) {
                this.populateSummaryStatistic(st, sst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getOperationQuarterlySummary failed", (Throwable)e);
        }
        return sst;
    }

    public SummaryStatistic getOperationStatYearlySummary(int opId, BAMCalendar startTime, BAMCalendar endTime) throws BAMException {
        SummaryStatistic sst = new SummaryStatistic();
        try {
            SummaryStat st;
            SummaryStat[] stat = this.summaryGenerationDSStub.getOperationYearlySummary(opId, (Calendar)startTime, (Calendar)endTime);
            if (stat != null && (st = stat[0]) != null) {
                this.populateSummaryStatistic(st, sst);
            }
        }
        catch (Exception e) {
            throw new BAMException("getOperationYearlySummary failed", (Throwable)e);
        }
        return sst;
    }

    public void addOperationStatHourlySummary(SummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addOperationStatHourlySummary(stat.getTypeId(), stat.getTimeDimensionId(), stat.getAvgResTime(), stat.getMaxResTime(), stat.getMinResTime(), stat.getReqCount(), stat.getResCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addOperationStatHourlySummary failed", (Throwable)e);
        }
    }

    public void addOperationStatDailySummary(SummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addOperationStatDailySummary(stat.getTypeId(), stat.getTimeDimensionId(), stat.getAvgResTime(), stat.getMaxResTime(), stat.getMinResTime(), stat.getReqCount(), stat.getResCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addOperationStatDailySummary failed", (Throwable)e);
        }
    }

    public void addOperationStatMonthlySummary(SummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addOperaionStatMonthlySummary(stat.getTypeId(), stat.getTimeDimensionId(), stat.getAvgResTime(), stat.getMaxResTime(), stat.getMinResTime(), stat.getReqCount(), stat.getResCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addOperaionStatMonthlySummary failed", (Throwable)e);
        }
    }

    public void addOperationStatQuarterlySummary(SummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addOperationStatQuarterlySummary(stat.getTypeId(), stat.getTimeDimensionId(), stat.getAvgResTime(), stat.getMaxResTime(), stat.getMinResTime(), stat.getReqCount(), stat.getResCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addOperationStatQuarterlySummary failed", (Throwable)e);
        }
    }

    public void addOperationStatYearlySummary(SummaryStatistic stat) throws BAMException {
        try {
            this.summaryGenerationDSStub.addOperationStatYearlySummary(stat.getTypeId(), stat.getTimeDimensionId(), stat.getAvgResTime(), stat.getMaxResTime(), stat.getMinResTime(), stat.getReqCount(), stat.getResCount(), stat.getFaultCount());
        }
        catch (Exception e) {
            throw new BAMException("addOperationStatYearlySummary failed", (Throwable)e);
        }
    }

    private void populateSummaryStatistic(SummaryStat st, SummaryStatistic sst) {
        if (st.getAvgResTime() != null && st.getAvgResTime().length() > 0) {
            sst.setAvgResTime(Double.parseDouble(st.getAvgResTime()));
        }
        if (st.getMaxResTime() != null && st.getMaxResTime().length() > 0) {
            sst.setMaxResTime(Double.parseDouble(st.getMaxResTime()));
        }
        if (st.getMinResTime() != null && st.getMinResTime().length() > 0) {
            sst.setMinResTime(Double.parseDouble(st.getMinResTime()));
        }
        if (st.getReqCount() != null && st.getReqCount().length() > 0) {
            sst.setReqCount(Integer.parseInt(st.getReqCount()));
        }
        if (st.getResCount() != null && st.getResCount().length() > 0) {
            sst.setResCount(Integer.parseInt(st.getResCount()));
        }
        if (st.getFaultCount() != null && st.getFaultCount().length() > 0) {
            sst.setFaultCount(Integer.parseInt(st.getFaultCount()));
        }
    }

    private Calendar getTimeStampForId(int summaryPeriod, SummaryTime[] time) throws Exception {
        if (time != null && time[0] != null) {
            Calendar cal;
            int id;
            String idStr = time[0].getSummaryTime();
            try {
                id = Integer.parseInt(idStr);
            }
            catch (Exception e) {
                return null;
            }
            switch (summaryPeriod) {
                case 11: {
                    cal = this.summaryGenerationDSStub.getHourDimFromId(id)[0].getStartTime();
                    break;
                }
                case 5: {
                    cal = this.summaryGenerationDSStub.getDayDimFromId(id)[0].getStartTime();
                    break;
                }
                case 2: {
                    cal = this.summaryGenerationDSStub.getMonthDimFormId(id)[0].getStartTime();
                    break;
                }
                case 50: {
                    cal = this.summaryGenerationDSStub.getQuarterDimFromId(id)[0].getStartTime();
                    break;
                }
                case 1: {
                    cal = this.summaryGenerationDSStub.getYearDimFromId(id)[0].getStartTime();
                    break;
                }
                default: {
                    return null;
                }
            }
            return BAMCalendar.getInstance((Calendar)cal);
        }
        return null;
    }
}

