/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.common.clients;

import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.common.ClientUtil;
import org.wso2.carbon.bam.common.dataobjects.activity.ActivityDO;
import org.wso2.carbon.bam.common.dataobjects.activity.MessageDO;
import org.wso2.carbon.bam.common.dataobjects.activity.MessageDataDO;
import org.wso2.carbon.bam.common.dataobjects.activity.MessagePropertyDO;
import org.wso2.carbon.bam.common.dataobjects.activity.NamespaceDO;
import org.wso2.carbon.bam.common.dataobjects.activity.PropertyFilterDO;
import org.wso2.carbon.bam.common.dataobjects.common.ClientDO;
import org.wso2.carbon.bam.common.dataobjects.mediation.MediationDataDO;
import org.wso2.carbon.bam.common.dataobjects.service.OperationDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServerDO;
import org.wso2.carbon.bam.common.dataobjects.service.ServiceDO;
import org.wso2.carbon.bam.services.stub.bamconfigurationds.BAMConfigurationDSStub;
import org.wso2.carbon.bam.services.stub.bamconfigurationds.BamSeverIDval;
import org.wso2.carbon.bam.services.stub.bamconfigurationds.DataServiceFaultException;
import org.wso2.carbon.bam.services.stub.bamconfigurationds.types.ActivateServer;
import org.wso2.carbon.bam.services.stub.bamconfigurationds.types.Activity;
import org.wso2.carbon.bam.services.stub.bamconfigurationds.types.Client;
import org.wso2.carbon.bam.services.stub.bamconfigurationds.types.Endpoint;
import org.wso2.carbon.bam.services.stub.bamconfigurationds.types.Message;
import org.wso2.carbon.bam.services.stub.bamconfigurationds.types.Messagedata;
import org.wso2.carbon.bam.services.stub.bamconfigurationds.types.Messageproperty;
import org.wso2.carbon.bam.services.stub.bamconfigurationds.types.NamespaceData;
import org.wso2.carbon.bam.services.stub.bamconfigurationds.types.Operation;
import org.wso2.carbon.bam.services.stub.bamconfigurationds.types.ProxyService;
import org.wso2.carbon.bam.services.stub.bamconfigurationds.types.Sequence;
import org.wso2.carbon.bam.services.stub.bamconfigurationds.types.Server;
import org.wso2.carbon.bam.services.stub.bamconfigurationds.types.ServerWithCategory;
import org.wso2.carbon.bam.services.stub.bamconfigurationds.types.Service;
import org.wso2.carbon.bam.services.stub.bamconfigurationds.types.XpathConfig;
import org.wso2.carbon.bam.services.stub.bamconfigurationds.types.XpathData;
import org.wso2.carbon.bam.util.BAMException;

public class BAMConfigurationDSClient {
    private static final String BAM_CONFIGURATION_DS = "BAMConfigurationDS";
    private BAMConfigurationDSStub stub;
    private static final Log log = LogFactory.getLog(BAMConfigurationDSClient.class);

    public BAMConfigurationDSClient(String backendServerURL, ConfigurationContext configCtx) throws BAMException {
        try {
            String serviceURL = ClientUtil.getBackendEPR(backendServerURL, BAM_CONFIGURATION_DS);
            this.stub = new BAMConfigurationDSStub(configCtx, serviceURL);
        }
        catch (RemoteException e) {
            throw new BAMException(e.getMessage(), (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new BAMException(e.getMessage(), (Throwable)e);
        }
    }

    public void cleanup() {
        block2: {
            try {
                this.stub._getServiceClient().cleanupTransport();
                this.stub._getServiceClient().cleanup();
                this.stub.cleanup();
            }
            catch (AxisFault axisFault) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)("Stub cleanup failed: " + this.getClass().getName()), (Throwable)axisFault);
            }
        }
    }

    public ServerDO getServer(String serverURL, int tenantID) throws BAMException {
        Server[] monitoringServers;
        ServerDO server = null;
        try {
            monitoringServers = this.stub.getServerFromURLAndTenantID(serverURL, String.valueOf(tenantID));
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred getting server details for " + serverURL, (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("Error occurred getting server details for " + serverURL, (Throwable)e);
        }
        if (monitoringServers != null && monitoringServers.length > 0) {
            server = ClientUtil.convertServerToServerDO(monitoringServers[0]);
        }
        return server;
    }

    public ServerDO getServer(String serverUrl, int tenantId, String serverType, int category) throws BAMException {
        Server[] monitoringServers;
        ServerDO server = null;
        try {
            monitoringServers = this.stub.getServerFromBAMDB(serverUrl, tenantId, serverType, category);
        }
        catch (Exception e) {
            throw new BAMException("Error occurred getting server details for " + serverUrl + " with server type: " + serverType, (Throwable)e);
        }
        if (monitoringServers != null && monitoringServers.length > 0) {
            server = ClientUtil.convertServerToServerDO(monitoringServers[0]);
        }
        return server;
    }

    public ServerDO getServer(String serverURL) throws BAMException {
        ServerDO server = null;
        Server[] monitoringServers = new Server[]{};
        try {
            monitoringServers = this.stub.getServerFromURL(serverURL);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred getting server details for " + serverURL, (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("Error occurred getting server details for " + serverURL, (Throwable)e);
        }
        if (monitoringServers != null && monitoringServers.length > 0) {
            server = ClientUtil.convertServerToServerDO(monitoringServers[0]);
        }
        return server;
    }

    public ServerDO getServer(int serverId) throws BAMException {
        ServerDO server = null;
        Server[] monitoringServers = new Server[]{};
        try {
            monitoringServers = this.stub.getServer(serverId);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred getting server details for server id " + serverId, (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("Error occurred getting server details for server id " + serverId, (Throwable)e);
        }
        if (monitoringServers != null && monitoringServers.length > 0) {
            server = ClientUtil.convertServerToServerDO(monitoringServers[0]);
        }
        return server;
    }

    public ServerDO[] getServersforServerType(String serverType) throws BAMException {
        ArrayList<ServerDO> servers = new ArrayList<ServerDO>();
        try {
            Server[] monitoredServers = this.stub.getServersForServerType(serverType);
            if (monitoredServers != null) {
                for (Server server : monitoredServers) {
                    servers.add(ClientUtil.convertServerToServerDO(server));
                }
            }
        }
        catch (RemoteException e) {
            throw new BAMException("Failed to get server details", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("Failed to get server details", (Throwable)e);
        }
        return servers.toArray(new ServerDO[servers.size()]);
    }

    public ServerDO[] getServersForTenant(int tenantID) throws BAMException {
        Server[] monitoringServers;
        ArrayList<ServerDO> servers = new ArrayList<ServerDO>();
        try {
            monitoringServers = this.stub.getServersForTenant(tenantID);
        }
        catch (RemoteException e) {
            throw new BAMException("Failed to get server details", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("Failed to get server details", (Throwable)e);
        }
        if (monitoringServers != null && monitoringServers.length > 0) {
            for (Server monitorServer : monitoringServers) {
                ServerDO server = ClientUtil.convertServerToServerDO(monitorServer);
                servers.add(server);
            }
        } else {
            return null;
        }
        return servers.toArray(new ServerDO[servers.size()]);
    }

    public ServerDO[] getServersWithCategoryNameForTenant(int tenantID) throws BAMException {
        ServerWithCategory[] monitoringServers;
        ArrayList<ServerDO> servers = new ArrayList<ServerDO>();
        try {
            monitoringServers = this.stub.getAllServersWithCategoryForTenent(tenantID);
        }
        catch (RemoteException e) {
            throw new BAMException("Failed to get server details", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("Failed to get server details", (Throwable)e);
        }
        if (monitoringServers != null && monitoringServers.length > 0) {
            for (ServerWithCategory monitorServer : monitoringServers) {
                ServerDO server = ClientUtil.convertToServerDOWithCategoryName(monitorServer);
                servers.add(server);
            }
        } else {
            return null;
        }
        return servers.toArray(new ServerDO[servers.size()]);
    }

    public ServerDO[] getAllServers() throws BAMException {
        ArrayList<ServerDO> servers = new ArrayList<ServerDO>();
        Server[] monitorServers = new Server[]{};
        try {
            monitorServers = this.stub.getAllServers();
        }
        catch (RemoteException e) {
            throw new BAMException("Failed to get all monitoring servers", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("Failed to get all monitoring servers", (Throwable)e);
        }
        if (monitorServers != null && monitorServers.length > 0) {
            for (Server monitorServer : monitorServers) {
                ServerDO server = ClientUtil.convertServerToServerDO(monitorServer);
                servers.add(server);
            }
        } else {
            return null;
        }
        return servers.toArray(new ServerDO[servers.size()]);
    }

    public ServerDO[] getAllServersWithCategoryName() throws BAMException {
        ArrayList<ServerDO> servers = new ArrayList<ServerDO>();
        ServerWithCategory[] monitorServers = new ServerWithCategory[]{};
        try {
            monitorServers = this.stub.getAllServersWithCategory();
        }
        catch (RemoteException e) {
            throw new BAMException("Failed to get all monitoring servers", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("Failed to get all monitoring servers", (Throwable)e);
        }
        if (monitorServers != null && monitorServers.length > 0) {
            for (ServerWithCategory monitorServer : monitorServers) {
                ServerDO server = ClientUtil.convertToServerDOWithCategoryName(monitorServer);
                servers.add(server);
            }
        } else {
            return null;
        }
        return servers.toArray(new ServerDO[servers.size()]);
    }

    public synchronized int addServer(ServerDO server) throws BAMException {
        int serverID = -1;
        String serverType = server.getServerType();
        int tenantId = server.getTenantID();
        String serverUrl = server.getServerURL();
        String serverDescription = server.getDescription();
        int serverCategory = server.getCategory();
        String subscriptionEPR = server.getSubscriptionEPR();
        String subscriptionId = server.getSubscriptionID();
        try {
            BamSeverIDval[] serverIDs = this.stub.addServer(tenantId, serverType, serverUrl, serverDescription, serverCategory, subscriptionEPR, subscriptionId, server.getUserName(), server.getPassword());
            serverID = serverIDs[0].getBamServerIDValue();
        }
        catch (RemoteException e) {
            throw new BAMException("Server " + serverUrl + " adding failed ", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("Server " + serverUrl + " adding failed ", (Throwable)e);
        }
        return serverID;
    }

    public void updateServer(ServerDO server) throws BAMException {
        int serverId = server.getId();
        String serverURL = server.getServerURL();
        String serverDescription = server.getDescription();
        String username = server.getUserName();
        String password = server.getPassword();
        if (server.getSubscriptionEPR() != null) {
            String subscriptionEPR = server.getSubscriptionEPR();
            String subscriptionID = server.getSubscriptionID();
            try {
                this.stub.updateServerWithSubscription(serverURL, serverDescription, subscriptionEPR, subscriptionID, username, password, serverId);
            }
            catch (RemoteException e) {
                throw new BAMException("Updating server " + serverURL + "failed", (Throwable)e);
            }
            catch (DataServiceFaultException e) {
                throw new BAMException("Updating server " + serverURL + "failed", (Throwable)e);
            }
        }
        try {
            this.stub.updateServer(serverURL, serverDescription, username, password, serverId);
        }
        catch (RemoteException e) {
            throw new BAMException("Updating server " + serverURL + "failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("Updating server " + serverURL + "failed", (Throwable)e);
        }
    }

    public void deactivateServer(int serverId) throws BAMException {
        try {
            this.stub.deactivateServer(serverId);
        }
        catch (RemoteException e) {
            throw new BAMException("deactivateServer failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("deactivateServer failed", (Throwable)e);
        }
    }

    public void removeServer(int serverId) throws BAMException {
        try {
            this.stub.deleteServer(serverId);
        }
        catch (RemoteException e) {
            throw new BAMException("Removing server failed..", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("Removing server failed..", (Throwable)e);
        }
    }

    public void activateServer(int serverId, String subscriptionId) throws BAMException {
        ActivateServer activateServer = new ActivateServer();
        activateServer.setServerID(serverId);
        activateServer.setSubscriptionID(subscriptionId);
        try {
            this.stub.activateServer(subscriptionId, serverId);
        }
        catch (RemoteException e) {
            throw new BAMException("activateServer failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("activateServer failed", (Throwable)e);
        }
    }

    public ServiceDO getService(int serviceId) throws BAMException {
        ServiceDO service = null;
        Service[] services = new Service[]{};
        try {
            services = this.stub.getService(serviceId);
        }
        catch (RemoteException e) {
            throw new BAMException("getService failed for serviceId: " + serviceId, (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("getService failed for serviceId: " + serviceId, (Throwable)e);
        }
        if (services != null && services.length > 0) {
            service = ClientUtil.convertServiceToServiceDO(services[0]);
        }
        return service;
    }

    public ServiceDO getService(int serverId, String serviceName) throws BAMException {
        ServiceDO service = null;
        Service[] services = new Service[]{};
        try {
            services = this.stub.getServiceForServer(serverId, serviceName);
        }
        catch (RemoteException e) {
            throw new BAMException("getService failed for serviceId: " + serverId + " serverName: " + serviceName, (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("getService failed for serviceId: " + serverId + " serverName: " + serviceName, (Throwable)e);
        }
        if (services != null && services.length > 0) {
            service = ClientUtil.convertServiceToServiceDO(services[0]);
        }
        return service;
    }

    public ServiceDO[] getAllServices(int serverId) throws BAMException {
        ArrayList<ServiceDO> serviceDOList = new ArrayList<ServiceDO>();
        Service[] services = new Service[]{};
        try {
            services = this.stub.getAllServices(serverId);
        }
        catch (RemoteException e) {
            throw new BAMException("getAllServices failed for serviceId: " + serverId, (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("getAllServices failed for serviceId: " + serverId, (Throwable)e);
        }
        if (services != null && services.length > 0) {
            for (Service adbService : services) {
                ServiceDO service = ClientUtil.convertServiceToServiceDO(adbService);
                serviceDOList.add(service);
            }
        }
        return serviceDOList.toArray(new ServiceDO[serviceDOList.size()]);
    }

    public synchronized void addService(ServiceDO service) throws BAMException {
        try {
            int serviceId = service.getServerID();
            String serviceName = service.getName();
            String serviceDescription = service.getDescription();
            if (this.stub.getServiceForServer(serviceId, serviceName) != null) {
                return;
            }
            this.stub.addService(serviceId, serviceName, serviceDescription);
        }
        catch (RemoteException e) {
            throw new BAMException("addService failed for service serverId: " + service.getServerID() + " serviceName: " + service.getName(), (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("addService failed for service serverId: " + service.getServerID() + " serviceName: " + service.getName(), (Throwable)e);
        }
    }

    public synchronized void addOperation(OperationDO operation) throws BAMException {
        int serviceId = operation.getServiceID();
        String operationName = operation.getName();
        try {
            if (this.stub.getOperationFromName(serviceId, operationName) != null) {
                return;
            }
            this.stub.addOperation(serviceId, operationName, operation.getDescription());
        }
        catch (RemoteException e) {
            throw new BAMException("addOperation failed for operation with serviceId: " + operation.getServiceID() + " operationName: " + operation.getName(), (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("addOperation failed for operation with serviceId: " + operation.getServiceID() + " operationName: " + operation.getName(), (Throwable)e);
        }
    }

    public OperationDO getOperation(int serviceId, String operationName) throws BAMException {
        OperationDO operationDO = null;
        Operation[] operations = new Operation[]{};
        try {
            operations = this.stub.getOperationFromName(serviceId, operationName);
        }
        catch (RemoteException e) {
            throw new BAMException("Unable to getOperation", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("Unable to getOperation", (Throwable)e);
        }
        if (operations != null && operations.length > 0) {
            Operation operation = operations[0];
            operationDO = ClientUtil.convertOperationToOperationDO(operation);
        }
        return operationDO;
    }

    public OperationDO getOperation(int operationId) throws BAMException {
        OperationDO operationDO = null;
        Operation[] adbOperationArray = new Operation[]{};
        try {
            adbOperationArray = this.stub.getOperation(operationId);
        }
        catch (RemoteException e) {
            throw new BAMException("Unable to getOperation", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("Unable to getOperation", (Throwable)e);
        }
        if (adbOperationArray != null && adbOperationArray.length > 0) {
            Operation adbOperation = adbOperationArray[0];
            operationDO = ClientUtil.convertOperationToOperationDO(adbOperation);
        }
        return operationDO;
    }

    public OperationDO[] getAllOperations(int serviceId) throws BAMException {
        ArrayList<OperationDO> operationDOList = new ArrayList<OperationDO>();
        Operation[] operations = new Operation[]{};
        try {
            operations = this.stub.getAllOperationsForService(serviceId);
        }
        catch (RemoteException e) {
            throw new BAMException("Unable to get operations", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("Unable to get operations", (Throwable)e);
        }
        if (operations != null && operations.length > 0) {
            for (Operation operation : operations) {
                OperationDO operationDO = ClientUtil.convertOperationToOperationDO(operation);
                operationDOList.add(operationDO);
            }
        }
        return operationDOList.toArray(new OperationDO[operationDOList.size()]);
    }

    public MediationDataDO[] getEndpoints(int serverId) throws BAMException {
        ArrayList<MediationDataDO> endpointsList = new ArrayList<MediationDataDO>();
        Endpoint[] endpoints = new Endpoint[]{};
        try {
            endpoints = this.stub.getEndpoints(serverId);
        }
        catch (RemoteException e) {
            throw new BAMException("getEndpoints failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("getEndpoints failed", (Throwable)e);
        }
        if (endpoints != null && endpoints.length > 0) {
            for (Endpoint endpoint : endpoints) {
                MediationDataDO endpointDO = new MediationDataDO();
                endpointDO.setName(endpoint.getEndpoint());
                endpointDO.setDirection("In");
                endpointDO.setServerId(serverId);
                endpointsList.add(endpointDO);
                endpointDO = new MediationDataDO();
                endpointDO.setName(endpoint.getEndpoint());
                endpointDO.setDirection("Out");
                endpointDO.setServerId(serverId);
                endpointsList.add(endpointDO);
            }
        }
        return endpointsList.toArray(new MediationDataDO[endpointsList.size()]);
    }

    public MediationDataDO[] getProxyServices(int serverId) throws BAMException {
        ArrayList<MediationDataDO> proxyServicesList = new ArrayList<MediationDataDO>();
        ProxyService[] proxyServices = new ProxyService[]{};
        try {
            proxyServices = this.stub.getProxyServices(serverId);
        }
        catch (RemoteException e) {
            throw new BAMException("getProxyServices failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("getProxyServices failed", (Throwable)e);
        }
        if (proxyServices != null && proxyServices.length > 0) {
            for (ProxyService proxyService : proxyServices) {
                MediationDataDO proxyDO = new MediationDataDO();
                proxyDO.setName(proxyService.getProxyService());
                proxyDO.setDirection("In");
                proxyDO.setServerId(serverId);
                proxyServicesList.add(proxyDO);
                proxyDO = new MediationDataDO();
                proxyDO.setName(proxyService.getProxyService());
                proxyDO.setDirection("Out");
                proxyDO.setServerId(serverId);
                proxyServicesList.add(proxyDO);
            }
        }
        return proxyServicesList.toArray(new MediationDataDO[proxyServicesList.size()]);
    }

    public MediationDataDO[] getSequences(int serverId) throws BAMException {
        ArrayList<MediationDataDO> sequencesList = new ArrayList<MediationDataDO>();
        Sequence[] sequences = new Sequence[]{};
        try {
            sequences = this.stub.getSequences(serverId);
        }
        catch (RemoteException e) {
            throw new BAMException("Sequences getting  failed for serverId : " + serverId, (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("Sequences getting  failed for serverId : " + serverId, (Throwable)e);
        }
        if (sequences != null && sequences.length > 0) {
            for (Sequence seq : sequences) {
                MediationDataDO sequenceDO = new MediationDataDO();
                sequenceDO.setName(seq.getSequence());
                sequenceDO.setDirection("In");
                sequenceDO.setServerId(serverId);
                sequencesList.add(sequenceDO);
                sequenceDO = new MediationDataDO();
                sequenceDO.setName(seq.getSequence());
                sequenceDO.setDirection("Out");
                sequenceDO.setServerId(serverId);
                sequencesList.add(sequenceDO);
            }
        }
        return sequencesList.toArray(new MediationDataDO[sequencesList.size()]);
    }

    public synchronized void addActivity(ActivityDO activity) throws BAMException {
        try {
            this.stub.addActivityData(activity.getName(), activity.getDescription(), activity.getActivityId());
        }
        catch (RemoteException e) {
            throw new BAMException("Adding Activity to the datbase failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("Adding Activity to the datbase failed", (Throwable)e);
        }
    }

    public void updateActivity(String name, String description, int activityKeyId) throws BAMException {
        try {
            this.stub.updateActivity(name, description, activityKeyId);
        }
        catch (RemoteException e) {
            throw new BAMException("updateActivity failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("updateActivity failed", (Throwable)e);
        }
    }

    public ActivityDO getActivityForActivityID(String activityId) throws BAMException {
        ActivityDO activity = null;
        try {
            Activity[] adbActivityArray = this.stub.getActivityForActivityID(activityId);
            if (adbActivityArray != null && adbActivityArray.length > 0) {
                Activity adbActivity = adbActivityArray[0];
                activity = new ActivityDO();
                activity.setActivityKeyId(Integer.parseInt(adbActivity.getActivityKeyId()));
                activity.setDescription(adbActivity.getDescription());
                activity.setName(adbActivity.getName());
                activity.setActivityId(adbActivity.getActivityId());
            }
        }
        catch (RemoteException e) {
            throw new BAMException("getActivityForActivityID failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("getActivityForActivityID failed", (Throwable)e);
        }
        return activity;
    }

    public ActivityDO getActivity(int activityKeyId) throws BAMException {
        ActivityDO activity = null;
        try {
            Activity[] adbActivityArray = this.stub.getActivity(activityKeyId);
            if (adbActivityArray != null && adbActivityArray.length > 0) {
                Activity adbActivity = adbActivityArray[0];
                activity = new ActivityDO();
                activity.setActivityKeyId(Integer.parseInt(adbActivity.getActivityKeyId()));
                activity.setDescription(adbActivity.getDescription());
                activity.setName(adbActivity.getName());
                activity.setActivityId(adbActivity.getActivityId());
            }
        }
        catch (RemoteException e) {
            throw new BAMException("getActivity failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("getActivity failed", (Throwable)e);
        }
        return activity;
    }

    public ActivityDO[] getAllActivities() throws BAMException {
        ArrayList<ActivityDO> activities = new ArrayList<ActivityDO>();
        Activity[] adbActivityIdArray = new Activity[]{};
        try {
            adbActivityIdArray = this.stub.getAllActivities();
        }
        catch (RemoteException e) {
            throw new BAMException("getAllActivities failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("getAllActivities failed", (Throwable)e);
        }
        if (adbActivityIdArray != null && adbActivityIdArray.length > 0) {
            for (Activity act : adbActivityIdArray) {
                ActivityDO activity = new ActivityDO();
                activity.setDescription(act.getDescription());
                activity.setActivityKeyId(Integer.parseInt(act.getActivityKeyId()));
                activity.setName(act.getName());
                activity.setActivityId(act.getActivityId());
                activities.add(activity);
            }
        }
        return activities.toArray(new ActivityDO[activities.size()]);
    }

    public synchronized void addMessage(MessageDO message) throws BAMException {
        try {
            this.stub.addMessage(message.getOperationId(), message.getMessageId(), message.getActivityKeyId(), message.getTimestamp(), message.getIPAddress(), message.getUserAgent());
        }
        catch (RemoteException e) {
            throw new BAMException("Add Message failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("Add Message failed", (Throwable)e);
        }
    }

    public MessageDO getMessage(int messageKeyId) throws BAMException {
        MessageDO message = null;
        Message[] adbMessageArray = new Message[]{};
        try {
            adbMessageArray = this.stub.getMessage(messageKeyId);
        }
        catch (RemoteException e) {
            throw new BAMException("getMessage failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("getMessage failed", (Throwable)e);
        }
        if (adbMessageArray != null && adbMessageArray.length > 0) {
            Message adbMessage = adbMessageArray[0];
            message = new MessageDO();
            message.setMessageKeyId(Integer.parseInt(adbMessage.getMessageKeyId()));
            message.setActivityKeyId(Integer.parseInt(adbMessage.getActivityKeyId()));
            message.setIPAddress(adbMessage.getIpAddress());
            message.setMessageId(adbMessage.getMessageId());
            message.setOperationId(Integer.parseInt(adbMessage.getOperationId()));
            message.setUserAgent(adbMessage.getUserAgent());
            message.setTimestamp(adbMessage.getTimestamp());
        }
        return message;
    }

    public MessageDO getMessage(String messageId, int operationId, int actiivtyKeyId) throws BAMException {
        MessageDO message = null;
        try {
            Message[] adbMessageArray = this.stub.getMessageForMessageandOperationandActivity(messageId, operationId, actiivtyKeyId);
            if (adbMessageArray != null && adbMessageArray.length > 0) {
                Message adbMessage = adbMessageArray[0];
                message = new MessageDO();
                message.setMessageKeyId(Integer.parseInt(adbMessage.getMessageKeyId()));
                message.setActivityKeyId(Integer.parseInt(adbMessage.getActivityKeyId()));
                message.setIPAddress(adbMessage.getIpAddress());
                message.setMessageId(adbMessage.getMessageId());
                message.setOperationId(Integer.parseInt(adbMessage.getOperationId()));
                message.setUserAgent(adbMessage.getUserAgent());
                message.setTimestamp(adbMessage.getTimestamp());
            }
        }
        catch (RemoteException e) {
            throw new BAMException("getMessage failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("getMessage failed", (Throwable)e);
        }
        return message;
    }

    public MessageDataDO getMessageDataForActivityKeyIDandMessageKeyID(int messageKeyID, int activityKeyID) throws BAMException {
        MessageDataDO message = null;
        try {
            Messagedata[] adbMessageDataArray = this.stub.getMessageDataForActivityKeyIDandMessageKeyID(messageKeyID, activityKeyID);
            if (adbMessageDataArray != null && adbMessageDataArray.length > 0) {
                Messagedata adbMessageData = adbMessageDataArray[0];
                message = new MessageDataDO();
                message.setMessageKeyId(Integer.parseInt(adbMessageData.getMessageKeyId()));
                message.setActivityKeyId(Integer.parseInt(adbMessageData.getActivityKeyId()));
                message.setIpAddress(adbMessageData.getIpAddress());
                message.setMessageBody(adbMessageData.getMessage());
                message.setMessageDirection(adbMessageData.getDirection());
                message.setMessageDataKeyId(Integer.parseInt(adbMessageData.getMessageDataKeyId()));
            }
        }
        catch (RemoteException e) {
            throw new BAMException("getMessage failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("getMessage failed", (Throwable)e);
        }
        return message;
    }

    public ClientDO[] getAllClients(int serverId) throws BAMException {
        ArrayList<ClientDO> clients = new ArrayList<ClientDO>();
        try {
            Client[] adbClientsArray = this.stub.getAllClients(serverId);
            if (adbClientsArray != null && adbClientsArray.length > 0) {
                for (Client adbClient : adbClientsArray) {
                    ClientDO client = new ClientDO();
                    client.setName(adbClient.getClientname());
                    client.setId(Integer.parseInt(adbClient.getClientbamid()));
                    client.setServerID(Integer.parseInt(adbClient.getClientserverid()));
                    client.setUUID(adbClient.getClientuuid());
                    client.setValue(adbClient.getClientvalue());
                    clients.add(client);
                }
            }
        }
        catch (RemoteException e) {
            throw new BAMException("getAllClients failed for serverId: " + serverId, (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("getAllClients failed for serverId: " + serverId, (Throwable)e);
        }
        return clients.toArray(new ClientDO[clients.size()]);
    }

    public PropertyFilterDO[] getAllXpathData(int serverID) throws BAMException {
        ArrayList<PropertyFilterDO> dataList = new ArrayList<PropertyFilterDO>();
        try {
            XpathConfig[] datas = this.stub.getAllXpathData(serverID);
            if (datas != null && datas.length > 0) {
                for (XpathConfig data : datas) {
                    PropertyFilterDO propertyFilterDO = new PropertyFilterDO();
                    propertyFilterDO.setId(data.getBamId().intValue());
                    propertyFilterDO.setAlias(data.getBamAlias());
                    propertyFilterDO.setExpressionKey(data.getBamName());
                    propertyFilterDO.setExpression(data.getBamXpath());
                    dataList.add(propertyFilterDO);
                }
            }
        }
        catch (RemoteException e) {
            throw new BAMException("Fetching xpath configurations failed..", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("Fetching xpath configurations failed..", (Throwable)e);
        }
        return dataList.toArray(new PropertyFilterDO[dataList.size()]);
    }

    public NamespaceDO[] getAllNamespaceData(int xpathID) throws BAMException {
        ArrayList<NamespaceDO> nsList = new ArrayList<NamespaceDO>();
        try {
            NamespaceData[] datas = this.stub.selectNamespaceData(xpathID);
            if (datas != null && datas.length > 0) {
                for (NamespaceData data : datas) {
                    NamespaceDO namespaceDO = new NamespaceDO();
                    namespaceDO.setId(data.getBamId().intValue());
                    namespaceDO.setPrefix(data.getBamPrefix());
                    namespaceDO.setUri(data.getBamURI());
                    nsList.add(namespaceDO);
                }
            }
        }
        catch (RemoteException e) {
            throw new BAMException("Fetching namespaces for xpath id " + xpathID + " failed..", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("Fetching namespaces for xpath id " + xpathID + " failed..", (Throwable)e);
        }
        return nsList.toArray(new NamespaceDO[nsList.size()]);
    }

    public MessageDO[] getAllMessagesForOperationID(int operationID) throws BAMException {
        throw new RuntimeException("TODO");
    }

    public MessageDO[] getAllMessages() throws BAMException {
        throw new RuntimeException("TODO");
    }

    public void updateXpathData(String alias, String name, String xpath, int serverId, int bamId) throws BAMException {
        try {
            this.stub.updateXpathData(alias, name, xpath, serverId, bamId);
        }
        catch (RemoteException e) {
            throw new BAMException("updateXpathData failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("updateXpathData failed", (Throwable)e);
        }
    }

    public void addXpathData(String alias, String name, String xpath, int serverId) throws BAMException {
        try {
            this.stub.addXpathData(alias, name, xpath, serverId);
        }
        catch (RemoteException e) {
            throw new BAMException("addXpathData failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("addXpathData failed", (Throwable)e);
        }
    }

    public void addNamespaceData(int bamXpathId, String prefix, String uri) throws BAMException {
        try {
            this.stub.addNamespaceData(bamXpathId, prefix, uri);
        }
        catch (RemoteException e) {
            throw new BAMException("addNamespaceData failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("addNamespaceData failed", (Throwable)e);
        }
    }

    public void deleteNamespaceData(int bamXpathId) throws BAMException {
        try {
            this.stub.deleteNamespaceData(bamXpathId);
        }
        catch (RemoteException e) {
            throw new BAMException("Deleting namespace data failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("Deleting namespace data failed", (Throwable)e);
        }
    }

    public void updateNamespaceData(int bamXpathId, String prefix, String uri, int bamId) throws BAMException {
        try {
            this.stub.updateNamespaceData(bamXpathId, prefix, uri, bamId);
        }
        catch (RemoteException e) {
            throw new BAMException("updateNamespaceData failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("updateNamespaceData failed", (Throwable)e);
        }
    }

    public void updateMessageProperty(String value, int messagePropertyKeyId) throws BAMException {
        try {
            this.stub.updateMessageProperty(value, messagePropertyKeyId);
        }
        catch (RemoteException e) {
            throw new BAMException("updateMessageProperty failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("updateMessageProperty failed", (Throwable)e);
        }
    }

    public PropertyFilterDO getXpathData(String xpathKey, int serverId) throws BAMException {
        PropertyFilterDO propertyFilterDO = null;
        try {
            XpathData[] datas = this.stub.selectXpathData(xpathKey, serverId);
            XpathData data = null;
            if (datas != null && datas.length > 0) {
                data = datas[0];
                propertyFilterDO = new PropertyFilterDO();
                propertyFilterDO.setExpressionKey(xpathKey);
                propertyFilterDO.setAlias(data.getBamAlias());
                propertyFilterDO.setId(data.getBamId().intValue());
                propertyFilterDO.setExpression(data.getBamXpath());
            }
        }
        catch (RemoteException e) {
            throw new BAMException("getXpathData failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("getXpathData failed", (Throwable)e);
        }
        return propertyFilterDO;
    }

    public MessagePropertyDO getPropertyofMessage(int messageKeyId, int activityKeyId, String key) throws BAMException {
        MessagePropertyDO messagePropertyDO = null;
        try {
            Messageproperty[] adbMessageArray = this.stub.getMessageProperty(messageKeyId, activityKeyId, key);
            if (adbMessageArray != null && adbMessageArray.length > 0) {
                Messageproperty adbMessage = adbMessageArray[0];
                messagePropertyDO = new MessagePropertyDO();
                messagePropertyDO.setMessagePropertyKeyId(Integer.parseInt(adbMessage.getMessagePropertyKeyId()));
                messagePropertyDO.setActivityKeyId(Integer.parseInt(adbMessage.getActivityKeyId()));
                messagePropertyDO.setMessageKeyId(Integer.parseInt(adbMessage.getMessageKeyId()));
                messagePropertyDO.setKey(adbMessage.getKey());
                messagePropertyDO.setValue(adbMessage.getValue());
            }
        }
        catch (RemoteException e) {
            throw new BAMException("getMessage failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("getMessage failed", (Throwable)e);
        }
        return messagePropertyDO;
    }

    public void updateMessageDump(String messageBody, String messageDir, String ipAddress, int messageDataKeyId) throws BAMException {
        try {
            this.stub.updateMessageDump(messageBody, messageDir, ipAddress, messageDataKeyId);
        }
        catch (RemoteException e) {
            throw new BAMException("updateMessageStatus failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("updateMessageStatus failed", (Throwable)e);
        }
    }

    public void updateMessageStatus(String messageStatus, int messageDataKeyId) throws BAMException {
        try {
            this.stub.updateMessageStatus(messageStatus, messageDataKeyId);
        }
        catch (RemoteException e) {
            throw new BAMException("updateMessageStatus failed", (Throwable)e);
        }
        catch (DataServiceFaultException e) {
            throw new BAMException("updateMessageStatus failed", (Throwable)e);
        }
    }
}

