/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.cep;

import java.net.SocketException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.receivers.AbstractMessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.cep.BAMCepConfigure;
import org.wso2.carbon.bam.cep.BAMCepUtils;
import org.wso2.carbon.bam.util.BAMException;

public class BAMMessageReceiver
extends AbstractMessageReceiver {
    Log log = LogFactory.getLog(BAMMessageReceiver.class);

    protected void invokeBusinessLogic(MessageContext messageContext) throws AxisFault {
        String msgProcessType;
        BAMCepUtils bamCepUtils = new BAMCepUtils();
        String nameSpaceURI = messageContext.getEnvelope().getBody().getFirstElementNS().getNamespaceURI().trim();
        OMElement soapBodyElement = messageContext.getEnvelope().getBody().getFirstElement();
        try {
            msgProcessType = BAMCepConfigure.getBAMConfigValue();
        }
        catch (BAMException e) {
            this.log.error((Object)"Error occurred get BAMMessageProcessing type", (Throwable)e);
            return;
        }
        if (msgProcessType.equals("bam")) {
            BAMCepConfigure bamCepConfigure = new BAMCepConfigure();
            if (nameSpaceURI.equals("http://wso2.org/ns/2009/09/bam/service/statistics/data")) {
                String backEndServerURL;
                try {
                    backEndServerURL = bamCepConfigure.getReceiverURL("BAMServiceStatisticsSubscriberService");
                }
                catch (SocketException e) {
                    this.log.error((Object)"Error getting back end server url for the service stat message receiver", (Throwable)e);
                    return;
                }
                catch (BAMException e) {
                    this.log.error((Object)"BAM exception occurred getting back end server url for the service stat message receiver", (Throwable)e);
                    return;
                }
                EndpointReference reference = new EndpointReference(backEndServerURL);
                bamCepUtils.invokeSoapClient(soapBodyElement, reference);
            } else if (nameSpaceURI.equals("http://wso2.org/ns/2009/09/bam/server/user-defined/data")) {
                String backEndServerURL;
                try {
                    backEndServerURL = bamCepConfigure.getReceiverURL("BAMServerUserDefinedDataSubscriberService");
                }
                catch (SocketException e) {
                    this.log.error((Object)"Error getting back end server url for the mediation stat message receiver", (Throwable)e);
                    return;
                }
                catch (BAMException e) {
                    this.log.error((Object)"BAM exception occurred getting back end server url for the service stat message receiver", (Throwable)e);
                    return;
                }
                EndpointReference reference = new EndpointReference(backEndServerURL);
                bamCepUtils.invokeSoapClient(soapBodyElement, reference);
            } else if (nameSpaceURI.equals("http://wso2.org/ns/2009/09/bam/service/activity/data")) {
                String backEndServerURL;
                try {
                    backEndServerURL = bamCepConfigure.getReceiverURL("BAMActivityDataStatisticsSubscriberService");
                }
                catch (SocketException e) {
                    this.log.error((Object)"Error getting back end server url for the activity stat message receiver", (Throwable)e);
                    return;
                }
                catch (BAMException e) {
                    this.log.error((Object)"BAM exception occurred getting back end server url for the service stat message receiver", (Throwable)e);
                    return;
                }
                EndpointReference reference = new EndpointReference(backEndServerURL);
                bamCepUtils.invokeSoapClient(soapBodyElement, reference);
            }
        } else if (msgProcessType.equals("cep")) {
            soapBodyElement.detach();
            if (nameSpaceURI.equals("http://wso2.org/ns/2009/09/bam/service/statistics/data")) {
                String eprForReceivers;
                try {
                    eprForReceivers = BAMCepConfigure.getServerEprValue();
                }
                catch (BAMException e) {
                    this.log.error((Object)"Error occurred getting ServerDataEPR ", (Throwable)e);
                    return;
                }
                EndpointReference reference = new EndpointReference(eprForReceivers);
                bamCepUtils.invokeSoapClient(soapBodyElement, reference);
            } else if (nameSpaceURI.equals("http://wso2.org/ns/2009/09/bam/server/user-defined/data")) {
                String eprForReceivers;
                try {
                    eprForReceivers = BAMCepConfigure.getMediationEprValue();
                }
                catch (BAMException e) {
                    this.log.error((Object)"Error occurred getting MediationDataEPR ", (Throwable)e);
                    return;
                }
                EndpointReference reference = new EndpointReference(eprForReceivers);
                bamCepUtils.invokeSoapClient(soapBodyElement, reference);
            }
        } else {
            this.log.error((Object)("bam config type should be CEP or BAM , found wrong type " + msgProcessType));
            return;
        }
    }
}

