/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.util.stats;

import java.util.Calendar;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.data.publisher.util.stats.AtomicIntSingleton;

public class StatsPrinterTimerTask
implements Runnable {
    private static Log log = LogFactory.getLog(StatsPrinterTimerTask.class);
    public static final int INITIAL_DELAY = 60000;
    public static final int TIME_GAP_FOR_PRINTING_STATS = 2000;
    int previousValue;
    long previousTime;
    double previousNoOfEventsPerSec;
    double maxTPS;

    @Override
    public void run() {
        if (log.isDebugEnabled()) {
            this.printResult();
        }
    }

    private void printResult() {
        while (true) {
            if (AtomicIntSingleton.getAtomicInteger().get() == 0) {
                try {
                    Thread.sleep(60000L);
                    this.printResults();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            try {
                Thread.sleep(2000L);
                this.printResults();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void printResults() {
        long currentTime = Calendar.getInstance().getTimeInMillis();
        int totalNoOfEvents = AtomicIntSingleton.getAtomicInteger().get();
        int difference = totalNoOfEvents - this.previousValue;
        long timeDifference = currentTime - this.previousTime;
        double noOfEventsPerSec = (double)(difference * 1000) / (double)timeDifference;
        log.debug((Object)("Total no of events:" + totalNoOfEvents));
        log.debug((Object)("No of events per sec: " + noOfEventsPerSec));
        if (noOfEventsPerSec > this.maxTPS) {
            this.maxTPS = noOfEventsPerSec;
        }
        this.previousNoOfEventsPerSec = noOfEventsPerSec;
        log.debug((Object)("Max no of events per sec: " + this.maxTPS));
        this.previousValue = totalNoOfEvents;
        this.previousTime = currentTime;
    }
}

