/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.data.publisher.util.PublisherConfiguration;
import org.wso2.carbon.utils.CarbonUtils;

public class PublisherUtil {
    private static Log log = LogFactory.getLog(PublisherUtil.class);

    public static PublisherConfiguration readConfigurationFromAgentConfig() {
        PublisherConfiguration publisherConfiguration = new PublisherConfiguration();
        String publisherConfigPath = CarbonUtils.getCarbonConfigDirPath() + "/" + "agent.xml";
        try {
            OMElement publisherOMElement = new StAXOMBuilder((InputStream)new FileInputStream(publisherConfigPath)).getDocumentElement();
            OMElement threadPoolElement = publisherOMElement.getFirstChildWithName(new QName("ThreadPool"));
            OMElement taskQueueSize = threadPoolElement.getFirstChildWithName(new QName("TaskQueue"));
            OMElement corePoolSize = threadPoolElement.getFirstChildWithName(new QName("CorePool"));
            OMElement maxPoolSize = threadPoolElement.getFirstChildWithName(new QName("MaxPool"));
            OMElement eventQueueSize = publisherOMElement.getFirstChildWithName(new QName("EventQueue"));
            OMElement connectionPoolElement = publisherOMElement.getFirstChildWithName(new QName("ConnectionPool"));
            OMElement maxIdleConnections = connectionPoolElement.getFirstChildWithName(new QName("MaxIdle"));
            OMElement evictionTimePeriod = connectionPoolElement.getFirstChildWithName(new QName("TimeBetweenEvictionRunsMillis"));
            OMElement minIdleTimeInPool = connectionPoolElement.getFirstChildWithName(new QName("MinEvictableIdleTimeMillis"));
            publisherConfiguration.setEventQueueSize(Integer.parseInt(eventQueueSize.getText()));
            publisherConfiguration.setTaskQueueSize(Integer.parseInt(taskQueueSize.getText()));
            publisherConfiguration.setCorePoolSize(Integer.parseInt(corePoolSize.getText()));
            publisherConfiguration.setMaxPoolSize(Integer.parseInt(maxPoolSize.getText()));
            publisherConfiguration.setMaxIdleConnections(Integer.parseInt(maxIdleConnections.getText()));
            publisherConfiguration.setEvictionTimePeriod(Long.parseLong(evictionTimePeriod.getText()));
            publisherConfiguration.setMinIdleTimeInPool(Long.parseLong(minIdleTimeInPool.getText()));
        }
        catch (XMLStreamException e) {
            log.error((Object)"Invalid configuration in publisher.xml", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            log.error((Object)(publisherConfigPath + " file not found. Using default configurations"));
        }
        return publisherConfiguration;
    }
}

