/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.mediationstats.data.publisher.util;

import java.net.SocketException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.synapse.aspects.statistics.ErrorLog;
import org.wso2.carbon.bam.mediationstats.data.publisher.conf.EventPublisherConfig;
import org.wso2.carbon.bam.mediationstats.data.publisher.services.BAMMediationStatsPublisherAdmin;
import org.wso2.carbon.bam.mediationstats.data.publisher.util.MediationPublisherException;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.mediation.statistics.MediationStatisticsSnapshot;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.NetworkUtils;

public class PublisherUtils {
    private static ConfigurationContext axisConfigurationContext;
    private static ConfigurationContextService configurationContextService;
    private static BAMMediationStatsPublisherAdmin bamMediationStatsPublisherAdmin;
    private static SynapseEnvironmentService synapseEnvironmentService;
    private static String serverName;
    private static final String TRANSPORT = "https";
    private static Map<String, EventPublisherConfig> eventPublisherConfigMap;

    public static EventPublisherConfig getEventPublisherConfig(String key) {
        return eventPublisherConfigMap.get(key);
    }

    public static Map<String, EventPublisherConfig> getEventPublisherConfigMap() {
        return eventPublisherConfigMap;
    }

    public static void setConfigurationContext(ConfigurationContext axisConfigContext) {
        axisConfigurationContext = axisConfigContext;
    }

    public static ConfigurationContext getConfigurationContext() {
        return axisConfigurationContext;
    }

    public static void setConfigurationContextService(ConfigurationContextService contextService) {
        configurationContextService = contextService;
    }

    public static ConfigurationContextService getConfigurationContextService() {
        return configurationContextService;
    }

    public static BAMMediationStatsPublisherAdmin getMediationStatPublisherAdmin() {
        return bamMediationStatsPublisherAdmin;
    }

    public static void setMediationStatPublisherAdmin(BAMMediationStatsPublisherAdmin mediationStatsPublisherAdmin) {
        bamMediationStatsPublisherAdmin = mediationStatsPublisherAdmin;
    }

    public static void setSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        PublisherUtils.synapseEnvironmentService = synapseEnvironmentService;
    }

    public static SynapseEnvironmentService getSynapseEnvironmentService() {
        return synapseEnvironmentService;
    }

    public static Map<String, Object> calculateErrorCounts(MediationStatisticsSnapshot mediationStatisticsSnapshot) {
        List errorLogs = mediationStatisticsSnapshot.getErrorLogs();
        HashMap<String, Object> errorMap = new HashMap<String, Object>();
        MediationSnapshotWrapper mediationSnapshotWrapper = new MediationSnapshotWrapper(mediationStatisticsSnapshot);
        if (errorLogs != null) {
            for (ErrorLog errorLog : errorLogs) {
                String key = mediationSnapshotWrapper.getStatTypePrefix() + mediationSnapshotWrapper.getDirection() + "ErrorCount-Category-" + errorLog.getErrorCode() + "-ResourceID-" + mediationSnapshotWrapper.getResId();
                Integer count = (Integer)errorMap.get(errorLog.getErrorCode());
                if (count == null) {
                    errorMap.put(key, 1);
                    continue;
                }
                errorMap.put(key, count + 1);
            }
        }
        return errorMap;
    }

    public static void addErrorCategories(MediationStatisticsSnapshot mediationStatisticsSnapshot, Map<String, Object> errorMap) {
        List errorLogs = mediationStatisticsSnapshot.getErrorLogs();
        MediationSnapshotWrapper mediationSnapshotWrapper = new MediationSnapshotWrapper(mediationStatisticsSnapshot);
        if (errorLogs != null) {
            for (ErrorLog errorLog : errorLogs) {
                String idKey = mediationSnapshotWrapper.getStatTypePrefix() + mediationSnapshotWrapper.getDirection() + mediationSnapshotWrapper.getResId();
                errorMap.put(idKey, errorLog.getErrorCode());
            }
        }
    }

    public static String updateServerName(AxisConfiguration axisConfiguration) throws MediationPublisherException {
        String hostName;
        if (axisConfiguration == null) {
            return serverName;
        }
        String serverName = null;
        try {
            hostName = NetworkUtils.getLocalHostname();
        }
        catch (SocketException e) {
            throw new MediationPublisherException("Error getting host name for the BAM event payload", e);
        }
        ConfigurationContextService confContextService = PublisherUtils.getConfigurationContextService();
        int port = CarbonUtils.getTransportPort((ConfigurationContext)confContextService.getServerConfigContext(), (String)TRANSPORT);
        String baseServerUrl = "https://" + hostName + ":" + port;
        ConfigurationContext configurationContext = confContextService.getServerConfigContext();
        String context = configurationContext.getContextRoot();
        SuperTenantCarbonContext tenantCarbonContext = SuperTenantCarbonContext.getCurrentContext((AxisConfiguration)axisConfiguration);
        String tenantDomain = null;
        if (tenantCarbonContext != null) {
            tenantDomain = tenantCarbonContext.getTenantDomain();
        }
        if (tenantDomain != null) {
            serverName = baseServerUrl + context + "t/" + tenantDomain;
        } else if (tenantDomain == null && context.equals("/")) {
            serverName = baseServerUrl + "";
        } else if (tenantDomain == null && !context.equals("/")) {
            serverName = baseServerUrl + context;
        }
        return serverName;
    }

    public static void setServerName(String serverName) {
        PublisherUtils.serverName = serverName;
    }

    public static String getServerName() {
        return serverName;
    }

    static {
        eventPublisherConfigMap = new HashMap<String, EventPublisherConfig>();
    }

    private static class MediationSnapshotWrapper {
        private MediationStatisticsSnapshot mediationStatisticsSnapshot;
        private String statTypePrefix = "Any";
        private String direction;
        private String resId;

        public MediationSnapshotWrapper(MediationStatisticsSnapshot mediationStatisticsSnapshot) {
            this.mediationStatisticsSnapshot = mediationStatisticsSnapshot;
            this.updateFields();
        }

        public String getStatTypePrefix() {
            return this.statTypePrefix;
        }

        public String getDirection() {
            return this.direction;
        }

        public String getResId() {
            return this.resId;
        }

        private MediationSnapshotWrapper updateFields() {
            switch (this.mediationStatisticsSnapshot.getUpdate().getType()) {
                case PROXYSERVICE: {
                    this.statTypePrefix = "Proxy";
                    break;
                }
                case SEQUENCE: {
                    this.statTypePrefix = "Sequence";
                    break;
                }
                case ENDPOINT: {
                    this.statTypePrefix = "Endpoint";
                    break;
                }
                default: {
                    this.statTypePrefix = "Any";
                }
            }
            this.direction = this.mediationStatisticsSnapshot.getUpdate().isInStatistic() ? "In" : "Out";
            this.resId = this.mediationStatisticsSnapshot.getUpdate().getResourceId();
            return this;
        }

        public static ConfigurationContext getConfigurationContext() {
            return axisConfigurationContext;
        }

        public static void setConfigurationContext(ConfigurationContext axisConfigurationContext) {
            axisConfigurationContext = axisConfigurationContext;
        }
    }
}

