/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.mediationstats.data.publisher.publish;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.mediationstats.data.publisher.conf.EventPublisherConfig;
import org.wso2.carbon.bam.mediationstats.data.publisher.conf.MediationStatConfig;
import org.wso2.carbon.bam.mediationstats.data.publisher.conf.Property;
import org.wso2.carbon.bam.mediationstats.data.publisher.data.MediationData;
import org.wso2.carbon.bam.mediationstats.data.publisher.util.PublisherUtils;
import org.wso2.carbon.bam.mediationstats.data.publisher.util.TenantMediationStatConfigData;
import org.wso2.carbon.databridge.agent.thrift.DataPublisher;
import org.wso2.carbon.databridge.agent.thrift.conf.AgentConfiguration;
import org.wso2.carbon.databridge.agent.thrift.exception.AgentException;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.AuthenticationException;
import org.wso2.carbon.databridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.NoStreamDefinitionExistException;
import org.wso2.carbon.databridge.commons.exception.StreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.TransportException;
import org.wso2.carbon.mediation.statistics.StatisticsRecord;

public class Publisher {
    private static Log log = LogFactory.getLog(Publisher.class);
    private static boolean isStreamDefinitionAlreadyExist = false;
    private static DataPublisher dataPublisher = null;
    private static String streamId = null;

    public static void process(MediationData mediationData, int tenantID) {
        ArrayList<String> metaDataKeyList = new ArrayList<String>();
        ArrayList<String> metaDataValueList = new ArrayList<String>();
        ArrayList<Object> eventData = new ArrayList<Object>();
        Map<Integer, MediationStatConfig> mediationStatConfigMap = TenantMediationStatConfigData.getTenantSpecificEventingConfigData();
        MediationStatConfig mediationStatConfig = mediationStatConfigMap.get(tenantID);
        Publisher.addEventData(eventData, mediationData);
        Publisher.addMetaData(metaDataKeyList, metaDataValueList, mediationStatConfig);
        Publisher.publishToAgent(eventData, metaDataKeyList, metaDataValueList, mediationStatConfig);
    }

    private static void addMetaData(List<String> metaDataKeyList, List<String> metaDataValueList, MediationStatConfig mediationStatConfig) {
        Property[] properties = mediationStatConfig.getProperties();
        if (properties != null) {
            for (int i = 0; i < properties.length; ++i) {
                Property property = properties[i];
                if (property.getKey() == null || property.getKey().isEmpty()) continue;
                metaDataKeyList.add(property.getKey());
                metaDataValueList.add(property.getValue());
            }
        }
    }

    private static void addEventData(List<Object> eventData, MediationData mediationData) {
        eventData.add(mediationData.getDirection());
        eventData.add(mediationData.getTimestamp().getTime());
        eventData.add(mediationData.getResourceId());
        eventData.add(mediationData.getStatsType());
        StatisticsRecord record = mediationData.getStatisticsRecord();
        eventData.add(record.getMaxTime());
        eventData.add(record.getAvgTime());
        eventData.add(record.getMinTime());
        eventData.add(record.getFaultCount());
        eventData.add(record.getTotalCount());
    }

    private static void publishToAgent(List<Object> eventData, List<String> metaDataKeyList, List<String> metaDataValueList, MediationStatConfig mediationStatConfig) {
        try {
            String serverUrl = mediationStatConfig.getUrl();
            String userName = mediationStatConfig.getUserName();
            String passWord = mediationStatConfig.getPassword();
            Object[] metaData = metaDataKeyList.toArray();
            String key = serverUrl + "_" + userName + "_" + passWord;
            EventPublisherConfig eventPublisherConfig = PublisherUtils.getEventPublisherConfig(key);
            StreamDefinition streamDef = Publisher.getEventStreamDefinition(mediationStatConfig, metaData);
            try {
                if (eventPublisherConfig == null) {
                    eventPublisherConfig = new EventPublisherConfig();
                    AgentConfiguration agentConfiguration = new AgentConfiguration();
                    dataPublisher = new DataPublisher(serverUrl, userName, passWord);
                    eventPublisherConfig.setAgentConfiguration(agentConfiguration);
                    eventPublisherConfig.setDataPublisher(dataPublisher);
                    PublisherUtils.getEventPublisherConfigMap().put(key, eventPublisherConfig);
                }
                try {
                    streamId = dataPublisher.findStream(mediationStatConfig.getStreamName(), mediationStatConfig.getVersion());
                }
                catch (NoStreamDefinitionExistException e) {
                    streamId = dataPublisher.defineStream(streamDef);
                }
                catch (StreamDefinitionException e) {
                    e.printStackTrace();
                }
                dataPublisher.publish(streamId, metaDataValueList.toArray(), null, eventData.toArray());
            }
            catch (StreamDefinitionException e1) {
                e1.printStackTrace();
            }
            catch (DifferentStreamDefinitionAlreadyDefinedException e1) {
                e1.printStackTrace();
            }
        }
        catch (MalformedURLException e) {
            log.error((Object)"Unable to publish event to BAM", (Throwable)e);
        }
        catch (AuthenticationException e) {
            log.error((Object)"Unable to publish event to BAM", (Throwable)e);
        }
        catch (TransportException e) {
            log.error((Object)"Unable to publish event to BAM", (Throwable)e);
        }
        catch (AgentException e) {
            log.error((Object)"Unable to publish event to BAM", (Throwable)e);
        }
        catch (MalformedStreamDefinitionException e) {
            log.error((Object)"Unable to publish event to BAM", (Throwable)e);
        }
    }

    public static StreamDefinition getEventStreamDefinition(MediationStatConfig mediationStatConfig, Object[] metaData) throws MalformedStreamDefinitionException {
        StreamDefinition eventStreamDefinition = new StreamDefinition(mediationStatConfig.getStreamName(), mediationStatConfig.getVersion());
        eventStreamDefinition.setNickName(mediationStatConfig.getNickName());
        eventStreamDefinition.setDescription(mediationStatConfig.getDescription());
        for (int i = 0; i < metaData.length; ++i) {
            eventStreamDefinition.addMetaData(metaData[i].toString(), AttributeType.STRING);
        }
        eventStreamDefinition.addPayloadData("direction", AttributeType.STRING);
        eventStreamDefinition.addPayloadData("timestamp", AttributeType.LONG);
        eventStreamDefinition.addPayloadData("resource_id", AttributeType.STRING);
        eventStreamDefinition.addPayloadData("stats_type", AttributeType.STRING);
        eventStreamDefinition.addPayloadData("max_processing_time", AttributeType.LONG);
        eventStreamDefinition.addPayloadData("avg_processing_time", AttributeType.DOUBLE);
        eventStreamDefinition.addPayloadData("min_processing_time", AttributeType.LONG);
        eventStreamDefinition.addPayloadData("fault_count", AttributeType.INT);
        eventStreamDefinition.addPayloadData("count", AttributeType.INT);
        return eventStreamDefinition;
    }
}

