/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.mediationstats.data.publisher.observer;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.mediationstats.data.publisher.conf.MediationStatConfig;
import org.wso2.carbon.bam.mediationstats.data.publisher.data.MediationData;
import org.wso2.carbon.bam.mediationstats.data.publisher.publish.Publisher;
import org.wso2.carbon.bam.mediationstats.data.publisher.util.PublisherUtils;
import org.wso2.carbon.bam.mediationstats.data.publisher.util.TenantMediationStatConfigData;
import org.wso2.carbon.mediation.statistics.MediationStatisticsObserver;
import org.wso2.carbon.mediation.statistics.MediationStatisticsSnapshot;
import org.wso2.carbon.mediation.statistics.MessageTraceLog;
import org.wso2.carbon.mediation.statistics.StatisticsRecord;
import org.wso2.carbon.mediation.statistics.TenantInformation;

public class BAMMediationStatisticsObserver
implements MediationStatisticsObserver,
TenantInformation {
    private static final Log log = LogFactory.getLog(BAMMediationStatisticsObserver.class);
    private AxisConfiguration axisConfiguration;
    private int tenantId = 0;

    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Shutting down the mediation statistics observer of BAM");
        }
    }

    public void updateStatistics(MediationStatisticsSnapshot mediationStatisticsSnapshot) {
        StatisticsRecord update = mediationStatisticsSnapshot.getUpdate();
        Map<String, Object> errorMap = PublisherUtils.calculateErrorCounts(mediationStatisticsSnapshot);
        PublisherUtils.addErrorCategories(mediationStatisticsSnapshot, errorMap);
        try {
            this.updateStatisticsInternal(update, errorMap);
        }
        catch (Exception e) {
            log.error((Object)"failed to update statics from BAM publisher", (Throwable)e);
        }
    }

    private void updateStatisticsInternal(StatisticsRecord update, Map<String, Object> errorMap) throws Exception {
        int tenantID = this.getTenantId();
        Map<Integer, MediationStatConfig> tenantSpecificMediationStatConfig = TenantMediationStatConfigData.getTenantSpecificEventingConfigData();
        MediationStatConfig mediationStatConfig = tenantSpecificMediationStatConfig.get(tenantID);
        if (mediationStatConfig == null || !mediationStatConfig.isEnableMediationStats()) {
            return;
        }
        switch (update.getType()) {
            case SEQUENCE: {
                this.processSequenceData(update, tenantID, errorMap);
                break;
            }
            case PROXYSERVICE: {
                this.processProxyData(update, tenantID, errorMap);
                break;
            }
            case ENDPOINT: {
                this.processEndpointData(update, tenantID, errorMap);
            }
        }
    }

    private void processEndpointData(StatisticsRecord latestEntityRecord, int tenantID, Map<String, Object> errorMap) {
        if (latestEntityRecord == null) {
            return;
        }
        this.process(latestEntityRecord, errorMap, tenantID);
    }

    private void processProxyData(StatisticsRecord update, int tenantID, Map<String, Object> errorMap) {
        if (update == null) {
            return;
        }
        this.process(update, errorMap, tenantID);
    }

    private void processSequenceData(StatisticsRecord entitySnapshot, int tenantID, Map<String, Object> errorMap) throws Exception {
        if (entitySnapshot == null) {
            return;
        }
        this.process(entitySnapshot, errorMap, tenantID);
    }

    private void process(StatisticsRecord entitySnapshot, Map<String, Object> errorMap, int tenantID) {
        String statTypePrefix;
        MediationData mediationData = new MediationData();
        Date currentDate = new Date();
        Timestamp timestamp = new Timestamp(currentDate.getTime());
        switch (entitySnapshot.getType()) {
            case PROXYSERVICE: {
                statTypePrefix = "Proxy";
                break;
            }
            case SEQUENCE: {
                statTypePrefix = "Sequence";
                break;
            }
            case ENDPOINT: {
                statTypePrefix = "Endpoint";
                break;
            }
            default: {
                statTypePrefix = "Any";
            }
        }
        String direction = entitySnapshot.isInStatistic() ? "In" : "Out";
        mediationData.setStatsType(statTypePrefix);
        mediationData.setDirection(direction);
        mediationData.setResourceId(entitySnapshot.getResourceId());
        mediationData.setStatisticsRecord(entitySnapshot);
        mediationData.setTimestamp(timestamp);
        if (errorMap != null && !errorMap.isEmpty()) {
            mediationData.setErrorMap(errorMap);
        }
        Publisher.process(mediationData, tenantID);
    }

    public void notifyTraceLogs(MessageTraceLog[] messageTraceLogs) {
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int i) {
        this.tenantId = i;
    }

    public AxisConfiguration getTenantAxisConfiguration() {
        return this.axisConfiguration;
    }

    public void setTenantAxisConfiguration(AxisConfiguration axisConfiguration) {
        this.axisConfiguration = axisConfiguration;
    }
}

