/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.mediationstats.data.publisher.internal;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.bam.mediationstats.data.publisher.conf.RegistryPersistenceManager;
import org.wso2.carbon.bam.mediationstats.data.publisher.observer.BAMMediationStatisticsObserver;
import org.wso2.carbon.bam.mediationstats.data.publisher.services.BAMMediationStatsPublisherAdmin;
import org.wso2.carbon.bam.mediationstats.data.publisher.util.PublisherUtils;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.mediation.statistics.MediationStatisticsObserver;
import org.wso2.carbon.mediation.statistics.MediationStatisticsStore;
import org.wso2.carbon.mediation.statistics.services.MediationStatisticsService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class MediationStatisticsComponent {
    private static final Log log = LogFactory.getLog(MediationStatisticsComponent.class);
    private boolean activated = false;
    private ServiceRegistration statAdminServiceRegistration;
    private MediationStatisticsService mediationStatisticsService;
    private ConfigurationContext configContext;
    private ServerConfigurationService serverConfigurationService;

    protected void activate(ComponentContext ctxt) {
        BAMMediationStatsPublisherAdmin bamMediationStatsPublisherAdmin = new BAMMediationStatsPublisherAdmin();
        PublisherUtils.setMediationStatPublisherAdmin(bamMediationStatsPublisherAdmin);
        MediationStatisticsStore mediationStatisticsStore = this.mediationStatisticsService.getStatisticsStore();
        BAMMediationStatisticsObserver observer = new BAMMediationStatisticsObserver();
        mediationStatisticsStore.registerObserver((MediationStatisticsObserver)observer);
        observer.setTenantId(this.mediationStatisticsService.getTenantId());
        new RegistryPersistenceManager().load();
        observer.setTenantAxisConfiguration(this.mediationStatisticsService.getConfigurationContext().getAxisConfiguration());
        log.info((Object)("Registering  Observer for tenant: " + this.mediationStatisticsService.getTenantId()));
        this.activated = true;
        log.info((Object)"BAM MediationStatisticsComponent activate");
        if (log.isDebugEnabled()) {
            log.debug((Object)"BAM Mediation statistics data publisher bundle is activated");
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        this.statAdminServiceRegistration.unregister();
        if (log.isDebugEnabled()) {
            log.debug((Object)"BAM service statistics data publisher bundle is deactivated");
        }
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        this.configContext = contextService.getServerConfigContext();
        PublisherUtils.setConfigurationContextService(contextService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        PublisherUtils.setConfigurationContextService(null);
        this.configContext = null;
    }

    protected void setRegistryService(RegistryService registryService) {
        try {
            RegistryPersistenceManager.setRegistryService(registryService);
        }
        catch (Exception e) {
            log.error((Object)"Cannot retrieve System Registry", (Throwable)e);
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        RegistryPersistenceManager.setRegistryService(null);
    }

    protected void setSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        PublisherUtils.setSynapseEnvironmentService(synapseEnvironmentService);
    }

    protected void unsetSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        PublisherUtils.setSynapseEnvironmentService(null);
    }

    protected void setServerConfiguration(ServerConfigurationService serverConfigService) {
        this.serverConfigurationService = serverConfigService;
    }

    protected void unsetServerConfiguration(ServerConfigurationService serverConfigService) {
        this.serverConfigurationService = null;
    }

    protected void setMediationStatisticsService(MediationStatisticsService mediationStatisticsService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Mediation statistics service bound to the BAM mediation statistics component");
        }
        if (this.activated && mediationStatisticsService != null) {
            MediationStatisticsStore mediationStatisticsStore = mediationStatisticsService.getStatisticsStore();
            BAMMediationStatisticsObserver observer = new BAMMediationStatisticsObserver();
            mediationStatisticsStore.registerObserver((MediationStatisticsObserver)observer);
            observer.setTenantId(mediationStatisticsService.getTenantId());
            observer.setTenantAxisConfiguration(mediationStatisticsService.getConfigurationContext().getAxisConfiguration());
            log.info((Object)("Registering BamMediationStatistics Observer for tenant: " + mediationStatisticsService.getTenantId()));
        } else {
            this.mediationStatisticsService = mediationStatisticsService;
        }
    }

    protected void unsetMediationStatisticsService(MediationStatisticsService statService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Mediation statistics service unbound from the BAM mediation statistics component");
        }
    }
}

