/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.mediationstats.data.publisher.conf;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.mediationstats.data.publisher.conf.MediationStatConfig;
import org.wso2.carbon.bam.mediationstats.data.publisher.conf.Property;
import org.wso2.carbon.bam.mediationstats.data.publisher.util.MediationPublisherException;
import org.wso2.carbon.bam.mediationstats.data.publisher.util.TenantMediationStatConfigData;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class RegistryPersistenceManager {
    private static Log log = LogFactory.getLog(RegistryPersistenceManager.class);
    private static RegistryService registryService;
    private static MediationStatConfig eventConfiguration;
    public static final String EMPTY_STRING = "";

    public static void setRegistryService(RegistryService registryServiceParam) {
        registryService = registryServiceParam;
    }

    public MediationStatConfig load() {
        MediationStatConfig mediationStatConfig = new MediationStatConfig();
        mediationStatConfig.setEnableMediationStats(false);
        mediationStatConfig.setUrl(EMPTY_STRING);
        mediationStatConfig.setUserName(EMPTY_STRING);
        mediationStatConfig.setPassword(EMPTY_STRING);
        mediationStatConfig.setProperties(new Property[0]);
        try {
            String mediationStatsEnable = this.getConfigurationProperty("EnableMediationStats");
            String url = this.getConfigurationProperty("BAMUrl");
            String userName = this.getConfigurationProperty("BAMUserName");
            String password = this.getConfigurationProperty("BAMPassword");
            String streamName = this.getConfigurationProperty("streamName");
            String version = this.getConfigurationProperty("version");
            String description = this.getConfigurationProperty("description");
            String nickName = this.getConfigurationProperty("nickName");
            Properties properties = this.getAllConfigProperties("/repository/components/org.wso2.carbon.bam.mediationstats.data.publisher/properties");
            if (mediationStatsEnable != null && url != null && userName != null && password != null) {
                int tenantId = CarbonContext.getCurrentContext().getTenantId();
                Map<Integer, MediationStatConfig> tenantEventConfigData = TenantMediationStatConfigData.getTenantSpecificEventingConfigData();
                tenantEventConfigData.put(tenantId, mediationStatConfig);
                mediationStatConfig.setEnableMediationStats(Boolean.parseBoolean(mediationStatsEnable));
                mediationStatConfig.setUrl(url);
                mediationStatConfig.setUserName(userName);
                mediationStatConfig.setPassword(password);
                mediationStatConfig.setStreamName(streamName);
                mediationStatConfig.setVersion(version);
                mediationStatConfig.setDescription(description);
                mediationStatConfig.setNickName(nickName);
                if (properties != null) {
                    ArrayList<Property> propertyDTOList = new ArrayList<Property>();
                    String[] keys = properties.keySet().toArray(new String[properties.size()]);
                    for (int i = keys.length - 1; i >= 0; --i) {
                        String key = keys[i];
                        Property propertyDTO = new Property();
                        propertyDTO.setKey(key);
                        propertyDTO.setValue((String)((List)properties.get(key)).get(0));
                        propertyDTOList.add(propertyDTO);
                    }
                    mediationStatConfig.setProperties(propertyDTOList.toArray(new Property[propertyDTOList.size()]));
                }
            } else {
                this.update(mediationStatConfig);
            }
        }
        catch (Exception e) {
            log.error((Object)"Coul not load values from registry", (Throwable)e);
        }
        return mediationStatConfig;
    }

    private Properties getAllConfigProperties(String mediationStatisticsPropertiesRegPath) throws RegistryException {
        Resource resource;
        UserRegistry registry = registryService.getConfigSystemRegistry(CarbonContext.getCurrentContext().getTenantId());
        Properties properties = null;
        Properties filterProperties = null;
        if (registry.resourceExists(mediationStatisticsPropertiesRegPath) && (properties = (resource = registry.get(mediationStatisticsPropertiesRegPath)).getProperties()) != null) {
            filterProperties = new Properties();
            for (Map.Entry<Object, Object> keyValuePair : properties.entrySet()) {
                if (keyValuePair.getKey().toString().startsWith("registry.")) continue;
                filterProperties.put(keyValuePair.getKey(), keyValuePair.getValue());
            }
        }
        return filterProperties;
    }

    public void updateAllProperties(Properties properties, String registryPath) throws RegistryException {
        UserRegistry registry = registryService.getConfigSystemRegistry(CarbonContext.getCurrentContext().getTenantId());
        Resource resource = registry.newResource();
        resource.setProperties(properties);
        registry.put(registryPath, resource);
    }

    public String getConfigurationProperty(String propertyName) throws RegistryException, MediationPublisherException {
        String resourcePath = "/repository/components/org.wso2.carbon.bam.mediationstats.data.publisher/mediationstats" + propertyName;
        UserRegistry registry = registryService.getConfigSystemRegistry(CarbonContext.getCurrentContext().getTenantId());
        String value = null;
        if (registry != null) {
            try {
                if (registry.resourceExists(resourcePath)) {
                    Resource resource = registry.get(resourcePath);
                    value = resource.getProperty(propertyName);
                }
            }
            catch (Exception e) {
                throw new MediationPublisherException("Error while accessing registry", e);
            }
        }
        return value;
    }

    public void update(MediationStatConfig eventConfig) {
        try {
            int tenantId = CarbonContext.getCurrentContext().getTenantId();
            Map<Integer, MediationStatConfig> tenantEventConfigData = TenantMediationStatConfigData.getTenantSpecificEventingConfigData();
            tenantEventConfigData.put(tenantId, eventConfig);
            this.updateConfigProperty("EnableMediationStats", eventConfig.isEnableMediationStats());
            this.updateConfigProperty("BAMUrl", eventConfig.getUrl());
            this.updateConfigProperty("BAMUserName", eventConfig.getUserName());
            this.updateConfigProperty("BAMPassword", eventConfig.getPassword());
            this.updateConfigProperty("streamName", eventConfig.getStreamName());
            this.updateConfigProperty("version", eventConfig.getVersion());
            this.updateConfigProperty("nickName", eventConfig.getNickName());
            this.updateConfigProperty("description", eventConfig.getDescription());
            Property[] propertiesDTO = eventConfig.getProperties();
            if (propertiesDTO != null) {
                Properties properties = new Properties();
                for (int i = 0; i < propertiesDTO.length; ++i) {
                    Property property = propertiesDTO[i];
                    ArrayList<String> valueList = new ArrayList<String>();
                    valueList.add(property.getValue());
                    properties.put(property.getKey(), valueList);
                }
                this.updateAllProperties(properties, "/repository/components/org.wso2.carbon.bam.mediationstats.data.publisher/properties");
            } else {
                this.updateAllProperties(null, "/repository/components/org.wso2.carbon.bam.mediationstats.data.publisher/properties");
            }
        }
        catch (Exception e) {
            log.error((Object)"Could not update the registry", (Throwable)e);
        }
    }

    public void updateConfigProperty(String propertyName, Object value) throws RegistryException, MediationPublisherException {
        String resourcePath = "/repository/components/org.wso2.carbon.bam.mediationstats.data.publisher/mediationstats" + propertyName;
        UserRegistry registry = registryService.getConfigSystemRegistry(CarbonContext.getCurrentContext().getTenantId());
        if (registry != null) {
            try {
                if (!registry.resourceExists(resourcePath)) {
                    Resource resource = registry.newResource();
                    resource.addProperty(propertyName, value.toString());
                    registry.put(resourcePath, resource);
                } else {
                    Resource resource = registry.get(resourcePath);
                    resource.setProperty(propertyName, value.toString());
                    registry.put(resourcePath, resource);
                }
            }
            catch (Exception e) {
                throw new MediationPublisherException("Error while accessing registry", e);
            }
        }
    }

    public MediationStatConfig getEventingConfigData() {
        return this.load();
    }

    static {
        eventConfiguration = new MediationStatConfig();
    }
}

