/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.lwevent.core.notify;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.core.Message;
import org.wso2.carbon.event.core.subscription.EventDispatcher;
import org.wso2.carbon.event.core.subscription.Subscription;

public class WSEventDispatcher
implements EventDispatcher {
    private static Log log = LogFactory.getLog(WSEventDispatcher.class);

    public void notify(Message message, Subscription subscription) {
        String endpoint = subscription.getEventSinkURL();
        String topic = subscription.getTopicName();
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace topicNs = factory.createOMNamespace("http://wso2.org/ns/2009/09/eventing/notify", "ns");
        OMElement topicEle = factory.createOMElement("topic", topicNs);
        topicEle.setText(topic);
        OMElement domainElement = null;
        String tenantDomain = message.getProperty("TenantDomain");
        if (tenantDomain != null) {
            OMNamespace domainNs = factory.createOMNamespace("http://cloud.wso2.com/", null);
            domainElement = factory.createOMElement("TenantDomain", domainNs);
            domainElement.setText(tenantDomain);
        }
        OMElement payload = message.getMessage().cloneOMElement();
        try {
            this.sendNotification(topicEle, domainElement, payload, endpoint);
        }
        catch (Exception e) {
            log.error((Object)"Unable to send message", (Throwable)e);
        }
    }

    protected void sendNotification(OMElement topicHeader, OMElement tenantDomainHeader, OMElement payload, String endpoint) throws AxisFault {
        ServiceClient serviceClient = new ServiceClient();
        Options options = new Options();
        options.setTo(new EndpointReference(endpoint));
        options.setAction("http://ws.apache.org/ws/2007/05/eventing-extended/Publish");
        serviceClient.setOptions(options);
        serviceClient.addHeader(topicHeader);
        if (tenantDomainHeader != null) {
            serviceClient.addHeader(tenantDomainHeader);
        }
        serviceClient.fireAndForget(payload);
    }

    protected void sendNotification(OMElement topicHeader, OMElement payload, String endpoint) throws AxisFault {
        ServiceClient serviceClient = new ServiceClient();
        Options options = new Options();
        options.setTo(new EndpointReference(endpoint));
        options.setAction("http://ws.apache.org/ws/2007/05/eventing-extended/Publish");
        serviceClient.setOptions(options);
        serviceClient.addHeader(topicHeader);
        serviceClient.fireAndForget(payload);
    }
}

