/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.lwevent.core.builders;

import java.util.Calendar;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.EndpointReferenceHelper;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.databinding.types.Duration;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.lwevent.core.builders.CommandBuilderConstants;
import org.wso2.carbon.bam.lwevent.core.builders.exceptions.BuilderException;
import org.wso2.carbon.bam.lwevent.core.builders.exceptions.InvalidExpirationTimeException;
import org.wso2.carbon.bam.lwevent.core.builders.exceptions.InvalidMessageException;
import org.wso2.carbon.bam.lwevent.core.builders.utils.BuilderUtils;
import org.wso2.carbon.event.core.subscription.EventFilter;
import org.wso2.carbon.event.core.subscription.Subscription;

public class SubscribeCommandBuilder
extends CommandBuilderConstants {
    private static final Log log = LogFactory.getLog(SubscribeCommandBuilder.class);
    private SOAPFactory factory;

    public SubscribeCommandBuilder(MessageContext messageCtx) {
        this.factory = (SOAPFactory)messageCtx.getEnvelope().getOMFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Subscription toSubscription(SOAPEnvelope envelope) throws InvalidMessageException, InvalidExpirationTimeException {
        OMElement scriptElement;
        OMElement expiryElem;
        OMElement elem;
        Subscription subscription;
        block16: {
            subscription = null;
            if (envelope == null) {
                log.error((Object)"No SOAP envelope was provided.");
                throw new BuilderException("No SOAP envelope was provided.");
            }
            elem = null;
            if (envelope.getBody() != null) {
                elem = envelope.getBody().getFirstChildWithName(SUBSCRIBE_QNAME);
            }
            if (elem == null) {
                log.error((Object)"Subscribe element is required as the payload of the subscription message.");
                throw new InvalidMessageException("Subscribe element is required as the payload of the subscription message.");
            }
            OMElement deliveryElem = elem.getFirstChildWithName(DELIVERY_QNAME);
            if (deliveryElem == null) {
                log.error((Object)"Delivery element is not found in the subscription message.");
                throw new InvalidMessageException("Delivery element is not found in the subscription message.");
            }
            OMElement notifyToElem = deliveryElem.getFirstChildWithName(NOTIFY_TO_QNAME);
            if (notifyToElem == null) {
                log.error((Object)"NotifyTo element not found in the subscription message.");
                throw new InvalidMessageException("NotifyTo element not found in the subscription message.");
            }
            String ep = BuilderUtils.getEndpointFromWSAAddress(notifyToElem.getFirstElement());
            if (ep != null) {
                subscription = new Subscription();
                subscription.setEventSinkURL(ep);
            }
            OMElement filterElem = elem.getFirstChildWithName(FILTER_QNAME);
            if (subscription != null && filterElem != null) {
                OMAttribute dialectAttribute = filterElem.getAttribute(ATT_DIALECT);
                if (dialectAttribute != null && dialectAttribute.getAttributeValue() != null) {
                    subscription.setEventFilter(new EventFilter(dialectAttribute.getAttributeValue(), filterElem.getText().trim()));
                    break block16;
                } else {
                    log.error((Object)"Error in creating subscription. Filter dialect not defined.");
                    throw new BuilderException("Error in creating subscription. Filter dialect not defined.");
                }
            }
            if (subscription == null) {
                log.error((Object)"Error in creating subscription.");
                throw new BuilderException("Error in creating subscription.");
            }
        }
        if ((expiryElem = elem.getFirstChildWithName(EXPIRES)) != null) {
            Calendar calendarExpires;
            try {
                String expiryText = expiryElem.getText().trim();
                if (expiryText.startsWith("P")) {
                    calendarExpires = Calendar.getInstance();
                    Duration duration = ConverterUtil.convertToDuration((String)expiryText);
                    calendarExpires.add(1, duration.getYears());
                    calendarExpires.add(2, duration.getMonths());
                    calendarExpires.add(5, duration.getDays());
                    calendarExpires.add(11, duration.getHours());
                    calendarExpires.add(12, duration.getMinutes());
                    calendarExpires.add(13, (int)duration.getSeconds());
                } else {
                    calendarExpires = ConverterUtil.convertToDateTime((String)expiryText);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error converting the expiration date.", (Throwable)e);
                throw new InvalidExpirationTimeException("Error converting the expiration date.", e);
            }
            Calendar calendarNow = Calendar.getInstance();
            if (!calendarNow.before(calendarExpires)) {
                log.error((Object)"The expiration time has passed.");
                throw new InvalidExpirationTimeException("The expiration time has passed.");
            }
            subscription.setExpires(calendarExpires);
        }
        if ((scriptElement = elem.getFirstChildWithName(new QName("http://ws.apache.org/ws/2007/05/eventing-extended", "ExecuatableScript"))) == null) return subscription;
        subscription.getProperties().put("ExecuatableScript", scriptElement.getText());
        return subscription;
    }

    public SOAPEnvelope fromSubscription(Subscription subscription) {
        SOAPEnvelope message = this.factory.getDefaultEnvelope();
        EndpointReference subscriptionManagerEPR = new EndpointReference(subscription.getEventSinkURL());
        subscriptionManagerEPR.addReferenceParameter(new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", "Identifier", "wse"), subscription.getId());
        OMNamespace eventingNamespace = this.factory.createOMNamespace("http://schemas.xmlsoap.org/ws/2004/08/eventing", "wse");
        OMElement subscribeResponseElement = this.factory.createOMElement("SubscribeResponse", eventingNamespace);
        try {
            OMElement subscriptionManagerElement = EndpointReferenceHelper.toOM((OMFactory)subscribeResponseElement.getOMFactory(), (EndpointReference)subscriptionManagerEPR, (QName)new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", "SubscriptionManager", "wse"), (String)"http://schemas.xmlsoap.org/ws/2004/08/addressing");
            subscribeResponseElement.addChild((OMNode)subscriptionManagerElement);
            OMElement expiresElement = this.factory.createOMElement("Expires", eventingNamespace);
            if (subscription.getExpires() != null) {
                this.factory.createOMText((OMContainer)expiresElement, ConverterUtil.convertToString((Calendar)subscription.getExpires()));
            } else {
                this.factory.createOMText((OMContainer)expiresElement, "*");
            }
            subscribeResponseElement.addChild((OMNode)expiresElement);
            message.getBody().addChild((OMNode)subscribeResponseElement);
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Unable to create subscription response", (Throwable)axisFault);
            throw new BuilderException("Unable to create subscription response", axisFault);
        }
        return message;
    }
}

