/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.lwevent.core.util;

import java.util.regex.Matcher;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.llom.soap12.SOAP12Factory;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.jaxen.JaxenException;
import org.wso2.carbon.bam.lwevent.core.exception.EventBrokerException;
import org.wso2.carbon.bam.lwevent.core.exception.WSEventException;
import org.wso2.carbon.bam.lwevent.core.util.EventingConstants;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;

public class EventBrokerUtils {
    public static MessageContext createMessageContext(OMElement payload, OMElement topic, int tenantId) throws EventBrokerException {
        MessageContext mc = new MessageContext();
        mc.setConfigurationContext(new ConfigurationContext(new AxisConfiguration()));
        SuperTenantCarbonContext.getCurrentContext((MessageContext)mc).setTenantId(tenantId);
        SOAP12Factory soapFactory = new SOAP12Factory();
        SOAPEnvelope envelope = soapFactory.getDefaultEnvelope();
        envelope.getBody().addChild((OMNode)payload);
        if (topic != null) {
            envelope.getHeader().addChild((OMNode)topic);
        }
        try {
            mc.setEnvelope(envelope);
        }
        catch (Exception e) {
            throw new EventBrokerException("Unable to generate event.", e);
        }
        return mc;
    }

    public static String getSecureTopicRegistryPath(String topicName) {
        if (!topicName.startsWith("/")) {
            topicName = "/" + topicName;
        }
        topicName = topicName.replaceAll("/", "_").replaceAll("_+", "_");
        return new StringBuffer().append("eventing/SecureTopic").append("/").append(topicName).toString();
    }

    public static String getLoggedInUserName() {
        String userName = "";
        userName = CarbonContext.getCurrentContext().getTenantId() != 0 ? CarbonContext.getCurrentContext().getUsername() + "@" + CarbonContext.getCurrentContext().getTenantDomain() : CarbonContext.getCurrentContext().getUsername();
        return userName.trim();
    }

    public static boolean isSystemDefinedUser(String user) {
        return user.equals("admin");
    }

    public static boolean isSystemAllowedRole(String role) {
        return role.equals("admin");
    }

    public static String extractTopicFromMessage(MessageContext mc) throws WSEventException {
        Matcher matcher;
        String toaddress;
        String topic = null;
        if (mc.getTo() != null && mc.getTo().getAddress() != null && (toaddress = mc.getTo().getAddress()).contains("/publish/") && (matcher = EventingConstants.TO_ADDRESS_PATTERN.matcher(toaddress)).matches()) {
            topic = matcher.group(1);
        }
        if (topic == null || topic.trim().length() == 0) {
            try {
                AXIOMXPath topicXPath = new AXIOMXPath("s11:Header/ns:topic | s12:Header/ns:topic");
                topicXPath.addNamespace("s11", "http://schemas.xmlsoap.org/soap/envelope/");
                topicXPath.addNamespace("s12", "http://www.w3.org/2003/05/soap-envelope");
                topicXPath.addNamespace("ns", "http://wso2.org/ns/2009/09/eventing/notify");
                OMElement topicNode = (OMElement)topicXPath.selectSingleNode((Object)mc.getEnvelope());
                if (topicNode != null) {
                    topic = topicNode.getText();
                }
            }
            catch (JaxenException e) {
                throw new WSEventException("can not process the xpath ", e);
            }
        }
        return topic;
    }
}

