/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.lwevent.core;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.lwevent.core.BackOffCounter;
import org.wso2.carbon.bam.lwevent.core.LightWeightEventBrokerInterface;
import org.wso2.carbon.bam.lwevent.core.internal.LightWeightEventBrokerComponent;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.event.core.subscription.Subscription;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class LightWeightEventBroker
implements LightWeightEventBrokerInterface {
    private static LightWeightEventBroker instance = null;
    private final String registryPath;
    private static final String packageName = LightWeightEventBroker.class.getPackage().getName();
    private static final Log log = LogFactory.getLog(LightWeightEventBroker.class);
    private ThreadLocal<ServiceClient> serviceClientThreadLocal = new ThreadLocal<ServiceClient>(){

        @Override
        protected ServiceClient initialValue() {
            try {
                return new ServiceClient();
            }
            catch (AxisFault axisFault) {
                log.error((Object)"Unable to create service client", (Throwable)axisFault);
                return null;
            }
        }
    };
    private Map<String, BackOffCounter> backOffCounterMap;

    protected LightWeightEventBroker(String packageName) throws AxisFault {
        this.registryPath = "repository/components/" + packageName + "/subscriptions/";
        this.backOffCounterMap = new ConcurrentHashMap<String, BackOffCounter>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LightWeightEventBroker getInstance() throws AxisFault {
        if (instance != null) return instance;
        Class<LightWeightEventBroker> clazz = LightWeightEventBroker.class;
        synchronized (LightWeightEventBroker.class) {
            if (instance != null) return instance;
            instance = new LightWeightEventBroker(packageName);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public String subscribe(Subscription subscription) throws RegistryException {
        Registry registry = this.getRegistry();
        int topicHash = subscription.getTopicName().hashCode();
        String subscriptionPath = this.registryPath + topicHash;
        if (registry.resourceExists(subscriptionPath)) {
            String[] subscriptonPaths;
            Collection subscriptionCollection = (Collection)registry.get(subscriptionPath);
            for (String registrySubscriptionPath : subscriptonPaths = subscriptionCollection.getChildren()) {
                Resource regSubscription = registry.get(registrySubscriptionPath);
                String eventSinkURL = regSubscription.getProperty("eventSinkURL");
                if (!subscription.getEventSinkURL().equals(eventSinkURL)) continue;
                return regSubscription.getProperty("uuid");
            }
        }
        Resource resource = registry.newResource();
        resource.setProperty("topicName", subscription.getTopicName());
        resource.setProperty("eventSinkURL", subscription.getEventSinkURL());
        String uuid = UUID.randomUUID().toString();
        resource.setProperty("uuid", uuid);
        registry.put(this.constructRegistryPath(subscription.getTopicName(), uuid), resource);
        log.info((Object)("Subscription added for topic : " + subscription.getTopicName() + " for subscriber URL : " + subscription.getEventSinkURL()));
        return uuid;
    }

    private String constructRegistryPath(String topicName, String uuid) {
        return this.registryPath + topicName.hashCode() + "/" + uuid;
    }

    private String constructRegistryPathWithoutUUID(String topicName, String uuid) {
        return this.registryPath + topicName + "/" + uuid;
    }

    @Override
    public void unsubscribe(Subscription subscription) throws RegistryException {
        try {
            String[] subscriptionTopics;
            Registry registry = this.getRegistry();
            String subcriptionPath = this.registryPath;
            Collection subscriptionCollection = (Collection)registry.get(subcriptionPath);
            for (String topic : subscriptionTopics = subscriptionCollection.getChildren()) {
                Resource subscriptionResource;
                String uuid;
                String subscriptionResourcePath = topic + "/" + subscription.getId();
                if (!registry.resourceExists(subscriptionResourcePath) || !(uuid = (subscriptionResource = registry.get(subscriptionResourcePath)).getProperty("uuid")).equals(subscription.getId())) continue;
                String topicName = subscriptionResource.getProperty("topicName");
                String eventSinkURL = subscriptionResource.getProperty("eventSinkURL");
                registry.delete(subscriptionResourcePath);
                log.info((Object)("Subscription removed for topic : " + topicName + " for subscriber URL : " + eventSinkURL));
                return;
            }
        }
        catch (RegistryException e) {
            log.error((Object)("Subscription cannot be found to remove for subscription Id : " + subscription.getId()));
            throw new RegistryException("Error removing subscription", (Throwable)e);
        }
    }

    private Registry getRegistry() throws RegistryException {
        RegistryService registryService = LightWeightEventBrokerComponent.getRegistryService();
        UserRegistry registry = registryService.getConfigSystemRegistry(CarbonContext.getCurrentContext().getTenantId());
        return registry;
    }

    @Override
    public void publish(String topicName, OMElement event) throws AxisFault, RegistryException {
        String[] subEndpointsUUIDPaths;
        Registry registry = this.getRegistry();
        Collection collection = (Collection)registry.get(this.registryPath + topicName.hashCode());
        for (String endpointUUIDPath : subEndpointsUUIDPaths = collection.getChildren()) {
            BackOffCounter backOffCounter = this.backOffCounterMap.get(endpointUUIDPath);
            if (backOffCounter == null) {
                backOffCounter = new BackOffCounter();
                this.backOffCounterMap.put(endpointUUIDPath, backOffCounter);
            }
            if (backOffCounter.isFailed()) {
                if (backOffCounter.getTotalBackOffCount().get() > backOffCounter.getCurrentBackOffCount().get()) {
                    backOffCounter.getCurrentBackOffCount().incrementAndGet();
                    continue;
                }
                String endpoint = registry.get(endpointUUIDPath).getProperty("eventSinkURL");
                try {
                    String ipAddr = endpoint.substring(endpoint.indexOf("://"), endpoint.lastIndexOf(":"));
                    boolean reachable = InetAddress.getByName(ipAddr).isReachable(250);
                    if (!reachable) {
                        this.exponentiateBackOfftime(backOffCounter, new Exception("Cannot reach IP address : " + ipAddr));
                    }
                }
                catch (UnknownHostException e) {
                }
                catch (IOException e) {
                    // empty catch block
                }
                backOffCounter.getCurrentBackOffCount().set(0);
                backOffCounter.setFailed(false);
            }
            Resource subscription = registry.get(endpointUUIDPath);
            Options options = new Options();
            options.setAction("http://ws.apache.org/ws/2007/05/eventing-extended/Publish");
            options.setTo(new EndpointReference(subscription.getProperty("eventSinkURL")));
            options.setTimeOutInMilliSeconds(120000L);
            ServiceClient serviceClient = this.serviceClientThreadLocal.get();
            try {
                serviceClient.setOptions(options);
                serviceClient.fireAndForget(event);
                serviceClient.cleanupTransport();
                backOffCounter.getTotalBackOffCount().set(0);
            }
            catch (AxisFault axisFault) {
                this.exponentiateBackOfftime(backOffCounter, (Exception)((Object)axisFault));
            }
        }
    }

    private void exponentiateBackOfftime(BackOffCounter backOffCounter, Exception axisFault) {
        backOffCounter.setFailed(true);
        int totalBackOffCount = backOffCounter.getTotalBackOffCount().get();
        int backOffDelta = totalBackOffCount == 0 ? 2 : Math.min(totalBackOffCount * 2, 100);
        backOffCounter.getTotalBackOffCount().set(backOffDelta);
        log.error((Object)("Cannot send request due to client failing. Exponentially backing off - Total back off count " + backOffCounter.getTotalBackOffCount().get()));
        if (log.isDebugEnabled()) {
            log.error((Object)axisFault.getMessage(), (Throwable)axisFault);
        }
    }
}

