/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.gauges.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.gauges.ui.BAMListAdminServiceClient;
import org.wso2.carbon.bam.gauges.ui.BAMMediationDataProcessor;
import org.wso2.carbon.bam.gauges.ui.BAMStatQueryDSClient;
import org.wso2.carbon.bam.gauges.ui.BAMSummaryQueryDSClient;
import org.wso2.carbon.bam.gauges.ui.GaugesUtils;
import org.wso2.carbon.bam.gauges.ui.ServiceInfo;
import org.wso2.carbon.bam.stub.listadmin.types.carbon.ActivityDTO;
import org.wso2.carbon.bam.stub.listadmin.types.carbon.ClientDTO;
import org.wso2.carbon.bam.stub.listadmin.types.carbon.MonitoredServerDTO;
import org.wso2.carbon.bam.stub.listadmin.types.carbon.NamespaceDTO;
import org.wso2.carbon.bam.stub.listadmin.types.carbon.OperationDO;
import org.wso2.carbon.bam.stub.listadmin.types.carbon.PropertyFilterDTO;
import org.wso2.carbon.bam.stub.listadmin.types.carbon.ServiceDO;
import org.wso2.carbon.bam.stub.statquery.Activity;
import org.wso2.carbon.bam.stub.statquery.ActivityForServer;
import org.wso2.carbon.bam.stub.statquery.ActivityForTime;
import org.wso2.carbon.bam.stub.statquery.ActivityGroupForTime;
import org.wso2.carbon.bam.stub.statquery.ActivityInfo;
import org.wso2.carbon.bam.stub.statquery.ActivityOperation;
import org.wso2.carbon.bam.stub.statquery.AllMessagesForActivity;
import org.wso2.carbon.bam.stub.statquery.ClientServiceOperationInfo;
import org.wso2.carbon.bam.stub.statquery.Data;
import org.wso2.carbon.bam.stub.statquery.DirectionForOperation;
import org.wso2.carbon.bam.stub.statquery.Endpoint;
import org.wso2.carbon.bam.stub.statquery.FullActivityData;
import org.wso2.carbon.bam.stub.statquery.JmxMetricsInfo;
import org.wso2.carbon.bam.stub.statquery.Message;
import org.wso2.carbon.bam.stub.statquery.MessageCount;
import org.wso2.carbon.bam.stub.statquery.MessageForMessageID;
import org.wso2.carbon.bam.stub.statquery.MessageForOperation;
import org.wso2.carbon.bam.stub.statquery.MessageId;
import org.wso2.carbon.bam.stub.statquery.Operation;
import org.wso2.carbon.bam.stub.statquery.OperationForService;
import org.wso2.carbon.bam.stub.statquery.OperationInfo;
import org.wso2.carbon.bam.stub.statquery.OperationList;
import org.wso2.carbon.bam.stub.statquery.Property;
import org.wso2.carbon.bam.stub.statquery.PropertyBag;
import org.wso2.carbon.bam.stub.statquery.PropertyChildForActivity;
import org.wso2.carbon.bam.stub.statquery.PropertyKeyForActivity;
import org.wso2.carbon.bam.stub.statquery.ProxyService;
import org.wso2.carbon.bam.stub.statquery.SAPaleaudit;
import org.wso2.carbon.bam.stub.statquery.SAPchild;
import org.wso2.carbon.bam.stub.statquery.SAPcount;
import org.wso2.carbon.bam.stub.statquery.Sequence;
import org.wso2.carbon.bam.stub.statquery.ServerForActivity;
import org.wso2.carbon.bam.stub.statquery.Service;
import org.wso2.carbon.bam.stub.statquery.ServiceForServer;
import org.wso2.carbon.bam.stub.statquery.Status;
import org.wso2.carbon.bam.stub.statquery.TimeStampForOperation;
import org.wso2.carbon.bam.stub.summaryquery.SummaryStat;
import org.wso2.carbon.bam.util.BAMCalendar;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class BAMDataServiceDataProcessor {
    private static final Log log = LogFactory.getLog(BAMDataServiceDataProcessor.class);
    private BAMStatQueryDSClient bamDSClient;
    private BAMListAdminServiceClient bamListAdminClient;
    private BAMSummaryQueryDSClient bamSummaryQueryClient;
    private BAMStatQueryDSClient bamStatQueryDSClient;
    private ServiceInfo serviceInfo;
    String lastArcKey = "";
    StringBuilder activityResult = new StringBuilder();
    StringBuilder activityParentIdArr = new StringBuilder();
    StringBuilder activityChildIdArr = new StringBuilder();
    String lastArcKeyC = "";
    StringBuilder activityResultC = new StringBuilder();
    StringBuilder activityParentIdArrC = new StringBuilder();
    StringBuilder activityChildIdArrC = new StringBuilder();
    String lastArcKeyA = "";
    StringBuilder activityResultA = new StringBuilder();
    StringBuilder activityParentIdArrA = new StringBuilder();
    StringBuilder activityChildIdArrA = new StringBuilder();

    public BAMDataServiceDataProcessor(ServletConfig config, HttpSession session, HttpServletRequest request) throws Exception {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        this.bamDSClient = new BAMStatQueryDSClient(cookie, backendServerURL, configContext, request.getLocale());
        this.bamListAdminClient = new BAMListAdminServiceClient(cookie, backendServerURL, configContext, request.getLocale());
        this.bamSummaryQueryClient = new BAMSummaryQueryDSClient(cookie, backendServerURL, configContext);
        this.bamStatQueryDSClient = new BAMStatQueryDSClient(cookie, backendServerURL, configContext, request.getLocale());
        this.serviceInfo = new ServiceInfo(config, session, request);
    }

    public String getAdminConsoleUrl(HttpServletRequest request) {
        String data = CarbonUIUtil.getAdminConsoleURL((HttpServletRequest)request);
        data = data.split("/carbon/")[0];
        return data;
    }

    public String getServerList() throws BAMException {
        try {
            MonitoredServerDTO[] serverList = this.bamListAdminClient.getServerList();
            if (serverList != null) {
                return GaugesUtils.serverArrayToString(serverList, ",", "|");
            }
        }
        catch (Exception e) {
            throw new BAMException("failed to get server list", (Throwable)e);
        }
        return "No Servers Configured";
    }

    public String getServicesList(int serverID) {
        try {
            ServiceDO[] servicesList = this.bamListAdminClient.getServicesList(serverID);
            if (servicesList != null) {
                return GaugesUtils.serviceArrayToString(servicesList, ",", "|");
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
        return "No Services Found";
    }

    public String getActivityList() {
        try {
            ActivityDTO[] activityList = this.bamListAdminClient.getActivityList();
            if (activityList != null) {
                return BAMDataServiceDataProcessor.activityArrayToString(activityList, ",", "|");
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
        return "No Activities Configured";
    }

    private static String activityArrayToString(ActivityDTO[] activityList, String separator1, String separator2) {
        StringBuffer result = new StringBuffer();
        if (activityList != null && activityList.length > 0) {
            result.append(activityList[0].getActivityKeyId());
            result.append(separator1);
            result.append(activityList[0].getName());
            for (int i = 1; i < activityList.length; ++i) {
                result.append(separator2);
                result.append(activityList[i].getActivityKeyId());
                result.append(separator1);
                result.append(activityList[i].getName());
            }
        }
        return result.toString();
    }

    public String getServiceResponseTimesOfServer(int serverID, int responseType, boolean demo) {
        try {
            ServiceDO[] servicesList = this.bamListAdminClient.getServicesList(serverID);
            if (servicesList != null) {
                String header = "";
                StringBuffer values = new StringBuffer();
                if (servicesList.length > 0) {
                    for (ServiceDO service : servicesList) {
                        header = header + service.getName() + ",";
                        if (responseType == 0) {
                            values.append(this.bamDSClient.getAvgResponseTime(service.getId()));
                            values.append(",");
                            continue;
                        }
                        if (responseType == 1) {
                            values.append(this.bamDSClient.getMinResponseTime(service.getId()));
                            values.append(",");
                            continue;
                        }
                        if (responseType != 2) continue;
                        values.append(this.bamDSClient.getMaxResponseTime(service.getId()));
                        values.append(",");
                    }
                }
                if (header.equals("") || values.toString().equals("") || values.length() < 2 || header.length() < 2) {
                    return "";
                }
                return header.substring(0, header.length() - 1) + "\n" + values.substring(0, values.length() - 1);
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
        return "";
    }

    public String getServerWithData(String functionName, BAMMediationDataProcessor processor) throws BAMException {
        try {
            MonitoredServerDTO[] serverList = this.bamListAdminClient.getServerList();
            if (serverList != null && serverList.length > 0) {
                String result = "";
                for (MonitoredServerDTO server : serverList) {
                    if (functionName.indexOf("getServiceAvgResponseTimesOfServer") > -1) {
                        result = this.getServiceResponseTimesOfServer(server.getServerId(), 0, false);
                    } else if (functionName.indexOf("getServiceMaxResponseTimesOfServer") > -1) {
                        result = this.getServiceResponseTimesOfServer(server.getServerId(), 1, false);
                    } else if (functionName.indexOf("getServiceMinResponseTimesOfServer") > -1) {
                        result = this.getServiceResponseTimesOfServer(server.getServerId(), 2, false);
                    } else if (functionName.indexOf("getServerInfo") > -1) {
                        result = this.serviceInfo.getServerInfo(server.getServerId(), false);
                    } else if (functionName.indexOf("getServiceReqResFaultCountsOfServer") > -1) {
                        result = this.getServiceReqResFaultCountsOfServer(server.getServerId(), false);
                    } else if (functionName.indexOf("getSequenceInAvgProcessingTimesOfServer") > -1) {
                        result = processor.getSequenceInAvgProcessingTimesOfServer(server.getServerId(), false);
                    } else if (functionName.indexOf("getEndpointInAvgProcessingTimesOfServer") > -1) {
                        result = processor.getEndpointInAvgProcessingTimesOfServer(server.getServerId(), false);
                    } else if (functionName.indexOf("getProxyServiceInAvgProcessingTimesOfServer") > -1) {
                        result = processor.getProxyServiceInAvgProcessingTimesOfServer(server.getServerId(), false);
                    } else if (functionName.indexOf("getServerMediationInfo") > -1) {
                        result = processor.getServerMediationInfo(server.getServerId(), false);
                    } else if (functionName.indexOf("getSequenceReqResFaultCountsOfServer") > -1) {
                        result = this.getSequenceReqResFaultCountsOfServer(server.getServerId(), false);
                    } else if (functionName.indexOf("getProxyServiceReqResFaultCountsOfServer") > -1) {
                        result = this.getProxyServiceReqResFaultCountsOfServer(server.getServerId(), false);
                    } else if (functionName.indexOf("getEndpointReqResFaultCountsOfServer") > -1) {
                        result = this.getEndpointReqResFaultCountsOfServer(server.getServerId(), false);
                    }
                    if (result.equals("")) continue;
                    return server.getServerId() + "," + server.getServerURL();
                }
            }
        }
        catch (BAMException e) {
            throw new BAMException("error occurred getting server with data for the  " + functionName, (Throwable)e);
        }
        catch (RemoteException e) {
            throw new BAMException("failed to get server list", (Throwable)e);
        }
        return "-1,http://xxx.xxx.xxx.xxx:xxxx";
    }

    public String getServiceReqResFaultCountsOfServer(int serverID, boolean demo) throws BAMException, RemoteException {
        StringBuilder result = new StringBuilder();
        String formatString1 = "<level%d name=\"%s\">\n";
        String formatString2 = "<level%d name=\"%s\" count=\"%s\"/>\n";
        String formatString3 = "</level%d>\n";
        String serverURL = "";
        MonitoredServerDTO[] serverList = this.bamListAdminClient.getServerList();
        if (serverList != null) {
            for (MonitoredServerDTO monitoredServerDTO : serverList) {
                if (monitoredServerDTO.getServerId() != serverID) continue;
                serverURL = monitoredServerDTO.getServerURL();
            }
        }
        result.append(String.format(formatString1, 0, serverURL));
        ServiceDO[] servicesList = this.bamListAdminClient.getServicesList(serverID);
        if (servicesList != null) {
            for (ServiceDO service : servicesList) {
                result.append(String.format(formatString1, 1, service.getName()));
                Data data = this.bamDSClient.getLatestDataForService(service.getId());
                if (data == null) continue;
                result.append(String.format(formatString2, 2, "Requests", data.getReqCount()));
                result.append(String.format(formatString2, 2, "Responses", data.getResCount()));
                result.append(String.format(formatString2, 2, "Faults", data.getFaultCount()));
                result.append(String.format(formatString3, 1));
            }
        }
        result.append(String.format(formatString3, 0));
        return result.toString();
    }

    public String getSequenceReqResFaultCountsOfServer(int serverID, boolean demo) throws BAMException, RemoteException {
        MonitoredServerDTO[] serverList;
        StringBuilder result = new StringBuilder();
        String formatString1 = "<level%d name=\"%s\">\n";
        String formatString2 = "<level%d name=\"%s\" count=\"%s\"/>\n";
        String formatString3 = "</level%d>\n";
        String serverURL = "";
        for (MonitoredServerDTO monitoredServerDTO : serverList = this.bamListAdminClient.getServerList()) {
            if (monitoredServerDTO.getServerId() != serverID) continue;
            serverURL = monitoredServerDTO.getServerURL();
            break;
        }
        result.append(String.format(formatString1, 0, serverURL));
        Sequence[] sequenceList = this.bamDSClient.getSequences(serverID);
        if (sequenceList != null) {
            for (Sequence sequence : sequenceList) {
                result.append(String.format(formatString1, 1, sequence.getSequence()));
                result.append(String.format(formatString2, 2, "Requests", this.bamDSClient.getLatestInCumulativeCountForSequence(serverID, "SequenceInCumulativeCount-" + sequence.getSequence())));
                result.append(String.format(formatString2, 2, "Faults", this.bamDSClient.getLatestInFaultCountForSequence(serverID, "SequenceInFaultCount-" + sequence.getSequence())));
                result.append(String.format(formatString3, 1));
            }
        }
        result.append(String.format(formatString3, 0));
        return result.toString();
    }

    public String getProxyServiceReqResFaultCountsOfServer(int serverID, boolean demo) throws BAMException, RemoteException {
        MonitoredServerDTO[] serverList;
        StringBuilder result = new StringBuilder();
        String formatString1 = "<level%d name=\"%s\">\n";
        String formatString2 = "<level%d name=\"%s\" count=\"%s\"/>\n";
        String formatString3 = "</level%d>\n";
        String serverURL = "";
        for (MonitoredServerDTO monitoredServerDTO : serverList = this.bamListAdminClient.getServerList()) {
            if (monitoredServerDTO.getServerId() != serverID) continue;
            serverURL = monitoredServerDTO.getServerURL();
        }
        result.append(String.format(formatString1, 0, serverURL));
        ProxyService[] proxies = this.bamDSClient.getProxyServices(serverID);
        if (proxies != null) {
            for (ProxyService proxy : proxies) {
                result.append(String.format(formatString1, 1, proxy.getProxyService()));
                result.append(String.format(formatString2, 2, "Requests", this.bamDSClient.getLatestInCumulativeCountForProxy(serverID, "ProxyInCumulativeCount-" + proxy.getProxyService())));
                result.append(String.format(formatString2, 2, "Faults", this.bamDSClient.getLatestInFaultCountForProxy(serverID, "ProxyInFaultCount-" + proxy.getProxyService())));
                result.append(String.format(formatString3, 1));
            }
        }
        result.append(String.format(formatString3, 0));
        return result.toString();
    }

    public String getEndpointReqResFaultCountsForAllServers() throws BAMException, RemoteException {
        StringBuilder result = new StringBuilder();
        String formatString1 = "<level%d name=\"%s\">\n";
        String formatString2 = "<level%d id=\"%d\" name=\"%s\" requests=\"%s\" faults=\"%s\"/>\n";
        String formatString3 = "</level%d>\n";
        result.append(String.format(formatString1, 0, "Servers"));
        MonitoredServerDTO[] serverList = this.bamListAdminClient.getServerList();
        if (serverList != null) {
            for (MonitoredServerDTO monitoredServerDTO : serverList) {
                int serverID = monitoredServerDTO.getServerId();
                String serverURL = monitoredServerDTO.getServerURL();
                Endpoint[] endpointList = this.bamDSClient.getEndpoints(serverID);
                int requests = 0;
                int faults = 0;
                if (endpointList == null) continue;
                for (Endpoint endpoint : endpointList) {
                    requests += Integer.parseInt(this.bamDSClient.getLatestInCumulativeCountForEndpoint(serverID, "EndpointInCumulativeCount-" + endpoint.getEndpoint()));
                    faults += Integer.parseInt(this.bamDSClient.getLatestInFaultCountForEndpoint(serverID, "EndpointInFaultCount-" + endpoint.getEndpoint()));
                }
                result.append(String.format(formatString2, 1, serverID, serverURL, requests, faults));
            }
        }
        result.append(String.format(formatString3, 0));
        return result.toString();
    }

    public String getEndpointReqResFaultCountsOfServer(int serverID, boolean demo) throws BAMException, RemoteException {
        MonitoredServerDTO[] serverList;
        StringBuilder result = new StringBuilder();
        String formatString1 = "<level%d name=\"%s\">\n";
        String formatString2 = "<level%d name=\"%s\" count=\"%s\"/>\n";
        String formatString3 = "</level%d>\n";
        String serverURL = "";
        for (MonitoredServerDTO monitoredServerDTO : serverList = this.bamListAdminClient.getServerList()) {
            if (monitoredServerDTO.getServerId() != serverID) continue;
            serverURL = monitoredServerDTO.getServerURL();
        }
        result.append(String.format(formatString1, 0, serverURL));
        Endpoint[] endpointList = this.bamDSClient.getEndpoints(serverID);
        if (endpointList != null) {
            for (Endpoint endpoint : endpointList) {
                result.append(String.format(formatString1, 1, endpoint.getEndpoint()));
                result.append(String.format(formatString2, 2, "Requests", this.bamDSClient.getLatestInCumulativeCountForEndpoint(serverID, "EndpointInCumulativeCount-" + endpoint.getEndpoint())));
                result.append(String.format(formatString2, 2, "Faults", this.bamDSClient.getLatestInFaultCountForEndpoint(serverID, "EndpointInFaultCount-" + endpoint.getEndpoint())));
                result.append(String.format(formatString3, 1));
            }
        }
        result.append(String.format(formatString3, 0));
        return result.toString();
    }

    public String getActivityInfo(int activityKeyId, boolean demo) throws BAMException, RemoteException {
        ActivityOperation[] operationList;
        ActivityDTO[] activityList;
        StringBuilder result = new StringBuilder();
        String activityName = "";
        for (ActivityDTO activityDTO : activityList = this.bamListAdminClient.getActivityList()) {
            if (activityDTO.getActivityKeyId() != activityKeyId) continue;
            activityName = activityDTO.getName();
        }
        if (activityName.length() > 0) {
            result.append("<level0 name=\"").append(activityName).append("\"");
            result.append(">\n");
        }
        for (ActivityOperation operation : operationList = this.bamDSClient.getOperationsForActivityID(activityKeyId)) {
            Message[] messageList;
            result.append("<level1 name=\"").append(operation.getActivityOperationName()).append("\"");
            Data operationData = this.bamDSClient.getLatestDataForOperation(Integer.parseInt(operation.getActivityOperationID()));
            if (operationData != null) {
                result.append(" meta1=\"").append(operationData.getReqCount()).append("\"");
                result.append(" meta2=\"").append(operationData.getResCount()).append("\"");
                result.append(" meta3=\"").append(operationData.getFaultCount()).append("\"");
                result.append(" meta4=\"").append(operationData.getAvgTime()).append("\"");
                result.append(" meta5=\"").append(operationData.getMinTime()).append("\"");
                result.append(" meta6=\"").append(operationData.getMaxTime()).append("\"");
            } else {
                result.append(" meta1=\"").append("0").append("\"");
                result.append(" meta2=\"").append("0").append("\"");
                result.append(" meta3=\"").append("0").append("\"");
                result.append(" meta4=\"").append("0").append("\"");
                result.append(" meta5=\"").append("0").append("\"");
                result.append(" meta6=\"").append("0").append("\"");
            }
            result.append(">\n");
            for (Message message : messageList = this.bamDSClient.getMessagesForOperationIDAndActivityID(Integer.parseInt(operation.getActivityOperationID()), activityKeyId)) {
                result.append(" <level2 name=\"").append(message.getId()).append("\" count=\"1\"");
                result.append(" meta1=\"").append("Not defined for messages").append("\"");
                result.append(" meta2=\"").append("Not defined for messages").append("\"");
                result.append(" meta3=\"").append("Not defined for messages").append("\"");
                result.append(" meta4=\"").append("Not defined for messages").append("\"");
                result.append(" meta5=\"").append("Not defined for messages").append("\"");
                result.append(" meta6=\"").append("Not defined for messages").append("\"");
                result.append("/>\n");
            }
            result.append("</level1>\n");
        }
        result.append("</level0>\n");
        return result.toString();
    }

    public String getActivityInfoForActivityID(int activityKeyId) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            ActivityInfo[] activityInfo = this.bamDSClient.getActivityInfoForActivityID(activityKeyId);
            if (activityInfo != null) {
                String activityName = activityInfo[0].getActivityName();
                result.append("<level0 name=\"").append(activityName).append("\"");
                result.append(">\n");
                for (int index = 0; index < activityInfo.length; ++index) {
                    result.append("<dataSet").append(index).append(">\n");
                    result.append("<ServiceName>");
                    result.append(activityInfo[index].getServiceName());
                    result.append("</ServiceName>\n");
                    result.append("<OperationName>");
                    result.append(activityInfo[index].getOperationName());
                    result.append("</OperationName>\n");
                    result.append("<MessageCount>");
                    result.append(activityInfo[index].getMessageCount());
                    result.append("</MessageCount>\n");
                    result.append("</dataSet").append(index).append(">\n");
                }
                result.append("</level0>\n");
                return result.toString();
            }
        }
        catch (Exception e) {
            throw new BAMException("failed to getActivityInfoForActivityID ", (Throwable)e);
        }
        return "";
    }

    public String getOperationInfoForActivityID(int activityKeyId) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            OperationInfo[] operationInfo = this.bamDSClient.getOperationInfoForActivityID(activityKeyId);
            if (operationInfo != null) {
                String activityName = operationInfo[0].getActivityName();
                result.append("<level0 name=\"").append(activityName).append("\"");
                result.append(" meta1=\"").append("1").append("\"");
                result.append(" meta2=\"").append("0").append("\"");
                result.append(" meta3=\"").append("0").append("\"");
                result.append(" meta4=\"").append("0").append("\"");
                result.append(" meta5=\"").append("0").append("\"");
                result.append(" meta6=\"").append("0").append("\"");
                result.append(">\n");
                String currentOperation = "";
                boolean level1Found = false;
                for (int index = 0; index < operationInfo.length; ++index) {
                    if (currentOperation.equals(operationInfo[index].getOperationName())) continue;
                    if (index != 0) {
                        result.append("</level1>\n");
                    }
                    result.append("<level1 name=\"").append(operationInfo[index].getOperationName()).append("\"");
                    result.append(" meta1=\"").append("1").append("\"");
                    result.append(" meta2=\"").append("0").append("\"");
                    result.append(" meta3=\"").append("0").append("\"");
                    result.append(" meta4=\"").append("0").append("\"");
                    result.append(" meta5=\"").append("0").append("\"");
                    result.append(" meta6=\"").append("0").append("\"");
                    result.append(">\n");
                    level1Found = true;
                }
                if (level1Found) {
                    result.append("</level1>\n");
                }
                result.append("</level0>\n");
                return result.toString();
            }
        }
        catch (Exception e) {
            throw new BAMException("failed to getActivityInfoForActivityID ", (Throwable)e);
        }
        return "";
    }

    public String getDetailsForActivity(String activity) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            Activity[] activityInfo = this.bamDSClient.getDetailsForActivity(activity);
            if (activityInfo != null) {
                result.append("<level0 name=\"").append(activity).append("\"");
                result.append(">\n");
                for (int index = 0; index < activityInfo.length; ++index) {
                    result.append("<dataSet").append(index).append(">\n");
                    result.append("<ServerUrl>");
                    result.append(activityInfo[index].getServerUrl());
                    result.append("</ServerUrl>\n");
                    result.append("<ServiceName>");
                    result.append(activityInfo[index].getServiceName());
                    result.append("</ServiceName>\n");
                    result.append("<OperationName>");
                    result.append(activityInfo[index].getName());
                    result.append("</OperationName>\n");
                    result.append("<MessageID>");
                    result.append(activityInfo[index].getMessage_name());
                    result.append("</MessageID>\n");
                    result.append("<TimeStamp>");
                    result.append(activityInfo[index].getTimestamp());
                    result.append("</TimeStamp>\n");
                    result.append("<Direction>");
                    result.append(activityInfo[index].getDirection());
                    result.append("</Direction>\n");
                    result.append("<Status>");
                    result.append(activityInfo[index].getStatus());
                    result.append("</Status>\n");
                    result.append("</dataSet").append(index).append(">\n");
                }
                result.append("</level0>\n");
                return result.toString();
            }
        }
        catch (Exception e) {
            throw new BAMException("failed to getActivityInfoForActivityID ", (Throwable)e);
        }
        return "";
    }

    public String getActivityDetailsForTimeRange(String startTime, String endTime, String propertyKey1, String propertyValue1, String propertyKey2, String propertyValue2, String propertyKey3, String propertyValue3) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            ActivityForTime[] activityInfo = this.bamDSClient.getActivityDetailsForTimeRange(startTime, endTime, propertyKey1, propertyValue1, propertyKey2, propertyValue2, propertyKey3, propertyValue3);
            result.append("<level0>");
            if (activityInfo != null) {
                for (int index = 0; index < activityInfo.length; ++index) {
                    result.append("<dataSet").append(index).append(">\n");
                    result.append("<ServerUrl>");
                    result.append(activityInfo[index].getServerUrl());
                    result.append("</ServerUrl>\n");
                    result.append("<ServiceName>");
                    result.append(activityInfo[index].getServiceName());
                    result.append("</ServiceName>\n");
                    result.append("<OperationName>");
                    result.append(activityInfo[index].getName());
                    result.append("</OperationName>\n");
                    result.append("<MessageID>");
                    result.append(activityInfo[index].getMessage_name());
                    result.append("</MessageID>\n");
                    result.append("<TimeStamp>");
                    result.append(activityInfo[index].getTimestamp());
                    result.append("</TimeStamp>\n");
                    result.append("<Direction>");
                    result.append(activityInfo[index].getDirection());
                    result.append("</Direction>\n");
                    result.append("</dataSet").append(index).append(">\n");
                }
            }
            result.append("</level0>\n");
            return result.toString();
        }
        catch (Exception e) {
            throw new BAMException("failed to getActivityInfoForActivityID ", (Throwable)e);
        }
    }

    public String getXpathKeys() throws BAMException {
        StringBuilder result = new StringBuilder();
        ArrayList<PropertyFilterDTO> xpaths = new ArrayList<PropertyFilterDTO>();
        try {
            result.append("<level0>");
            MonitoredServerDTO[] servers = this.bamListAdminClient.getServerList();
            if (servers != null && servers.length > 0) {
                for (MonitoredServerDTO server : servers) {
                    PropertyFilterDTO[] xpathsForServer = this.bamListAdminClient.getXpathConfigurations(server.getServerId());
                    if (xpathsForServer == null || xpathsForServer.length <= 0) continue;
                    for (PropertyFilterDTO xpathForServer : xpathsForServer) {
                        xpaths.add(xpathForServer);
                        result.append("<xpathKey>");
                        result.append(xpathForServer.getExpressionKey());
                        result.append("</xpathKey>\n");
                    }
                }
            }
            result.append("</level0>\n");
        }
        catch (Exception e) {
            throw new BAMException("failed to getXpathKeys", (Throwable)e);
        }
        return result.toString();
    }

    public String getActivityDetailsForActivity(String startTime, String endTime) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            ActivityGroupForTime[] activityInfo = this.bamDSClient.getActivityDetailsForActivity(startTime, endTime);
            if (activityInfo != null) {
                result.append("<level0>");
                for (int index = 0; index < activityInfo.length; ++index) {
                    result.append("<dataSet").append(index).append(">\n");
                    result.append("<ServerUrl>");
                    result.append(activityInfo[index].getServerUrl());
                    result.append("</ServerUrl>\n");
                    result.append("<ServiceName>");
                    result.append(activityInfo[index].getServiceName());
                    result.append("</ServiceName>\n");
                    result.append("<OperationName>");
                    result.append(activityInfo[index].getName());
                    result.append("</OperationName>\n");
                    result.append("<MessageID>");
                    result.append(activityInfo[index].getMessage_name());
                    result.append("</MessageID>\n");
                    result.append("<TimeStamp>");
                    result.append(activityInfo[index].getTimestamp());
                    result.append("</TimeStamp>\n");
                    result.append("<Direction>");
                    result.append(activityInfo[index].getDirection());
                    result.append("</Direction>\n");
                    result.append("<Status>");
                    result.append(activityInfo[index].getStatus());
                    result.append("</Status>\n");
                    result.append("<Activity>");
                    result.append(activityInfo[index].getActivity());
                    result.append("</Activity>\n");
                    result.append("</dataSet").append(index).append(">\n");
                }
                result.append("</level0>\n");
                return result.toString();
            }
        }
        catch (Exception e) {
            throw new BAMException("failed to getActivityInfoForActivityID ", (Throwable)e);
        }
        return "";
    }

    public String getActivityDetailsForServer(String serverURL) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            ActivityForServer[] activityInfoForServer = this.bamDSClient.getActivityDetailsForServer(serverURL);
            if (activityInfoForServer != null) {
                result.append("<level0 name=\"").append(serverURL).append("\"");
                result.append(">\n");
                for (int index = 0; index < activityInfoForServer.length; ++index) {
                    result.append("<dataSet").append(index).append(">\n");
                    result.append("<TimeStamp>");
                    result.append(activityInfoForServer[index].getTimestamp_activityForServer());
                    result.append("</TimeStamp>\n");
                    result.append("<OperationName>");
                    result.append(activityInfoForServer[index].getOperationName_activityForServer());
                    result.append("</OperationName>\n");
                    result.append("</dataSet").append(index).append(">\n");
                }
                result.append("</level0>\n");
                return result.toString();
            }
        }
        catch (Exception e) {
            throw new BAMException("failed to getActivityInfoForActivityID ", (Throwable)e);
        }
        return "";
    }

    public String getpropertyBagForActivity(String activity) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            PropertyBag[] activityInfo = this.bamDSClient.getpropertyBagForActivity(activity);
            if (activityInfo != null) {
                result.append("<level0 name=\"").append(activity).append("\"");
                result.append(">\n");
                result.append("<Property>");
                result.append(activityInfo[0].getProperties());
                result.append("</Property>\n");
                for (int index = 0; index < activityInfo.length; ++index) {
                    result.append("<dataSet").append(index).append(">\n");
                    result.append("<Message>");
                    result.append(activityInfo[index].getMessageId());
                    result.append("</Message>\n");
                    result.append("</dataSet").append(index).append(">\n");
                }
                result.append("</level0>\n");
                return result.toString();
            }
        }
        catch (Exception e) {
            throw new BAMException("failed to getActivityInfoForActivityID ", (Throwable)e);
        }
        return "";
    }

    public String getPropertyKeyForActivity(String startTime, String endTime) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            PropertyKeyForActivity[] propertyKey = this.bamDSClient.getPropertyKeyForActivity(startTime, endTime);
            if (propertyKey != null) {
                result.append("<Parent>\n");
                for (int index = 0; index < propertyKey.length; ++index) {
                    result.append("<dataSet").append(index).append(">\n");
                    result.append("<Property>");
                    result.append(propertyKey[index].getPropertyKey());
                    result.append("</Property>\n");
                    result.append("</dataSet").append(index).append(">\n");
                }
                result.append("</Parent>\n");
                return result.toString();
            }
        }
        catch (Exception e) {
            throw new BAMException("failed to getActivityInfoForActivityID ", (Throwable)e);
        }
        return "";
    }

    public String getPropertyChildrenForActivity(String childParam, int activityId) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            PropertyChildForActivity[] propertyChild = this.bamDSClient.getPropertyChildrenForActivity(childParam, activityId);
            if (propertyChild != null) {
                result.append("<Child>\n");
                for (int index = 0; index < propertyChild.length; ++index) {
                    result.append("<dataSet").append(index).append(">\n");
                    result.append("<Property>");
                    result.append(propertyChild[index].getPropertyKeyForChild());
                    result.append("</Property>\n");
                    result.append("<MessageId>");
                    result.append(propertyChild[index].getMessageIdForChild());
                    result.append("</MessageId>\n");
                    result.append("<TimeStamp>");
                    result.append(propertyChild[index].getTimestampForChild());
                    result.append("</TimeStamp>\n");
                    result.append("</dataSet").append(index).append(">\n");
                }
                result.append("</Child>\n");
                return result.toString();
            }
        }
        catch (Exception e) {
            throw new BAMException("failed to getActivityInfoForActivityID ", (Throwable)e);
        }
        return "";
    }

    public String getServerListForActivity() throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            ServerForActivity[] serverDetails = this.bamDSClient.getServerListForActivity();
            if (serverDetails != null) {
                for (int index = 0; index < serverDetails.length; ++index) {
                    result.append("<dataSet").append(index).append(">\n");
                    result.append("<serverUrl>");
                    result.append(serverDetails[index].getServerUrl());
                    result.append("</serverUrl>\n");
                    result.append("<serverId>");
                    result.append(serverDetails[index].getServerId());
                    result.append("</serverId>\n");
                    result.append("</dataSet").append(index).append(">\n");
                }
                return result.toString();
            }
        }
        catch (Exception e) {
            throw new BAMException("failed to getActivityInfoForActivityID ", (Throwable)e);
        }
        return "";
    }

    public String getServiceListForActivity(int serverID) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            ServiceForServer[] serviceDetails = this.bamDSClient.getServiceListForActivity(serverID);
            if (serviceDetails != null) {
                result.append("<ActivityServices>");
                for (int index = 0; index < serviceDetails.length; ++index) {
                    result.append("<dataSet").append(index).append(">\n");
                    result.append("<serviceUrl>");
                    result.append(serviceDetails[index].getServiceName());
                    result.append("</serviceUrl>\n");
                    result.append("<serviceId>");
                    result.append(serviceDetails[index].getServiceId());
                    result.append("</serviceId>\n");
                    result.append("</dataSet").append(index).append(">\n");
                }
                result.append("</ActivityServices>");
                return result.toString();
            }
        }
        catch (Exception e) {
            throw new BAMException("failed to getActivityInfoForActivityID ", (Throwable)e);
        }
        return "";
    }

    public String getPropertyList(String key) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            Property[] properties = this.bamDSClient.getPropertyList(key);
            if (properties != null) {
                result.append("<Properties>");
                for (int index = 0; index < properties.length; ++index) {
                    result.append("<dataSet").append(index).append(">\n");
                    result.append("<value>");
                    result.append(properties[index].getValue());
                    result.append("</value>\n");
                    result.append("</dataSet").append(index).append(">\n");
                }
                result.append("</Properties>");
                return result.toString();
            }
        }
        catch (Exception e) {
            throw new BAMException("failed to getActivityInfoForActivityID ", (Throwable)e);
        }
        return "";
    }

    public String getOperationNameList(int serviceID) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            OperationList[] operationList = this.bamDSClient.getOperationNameList(serviceID);
            if (operationList != null) {
                result.append("<Operations>");
                for (int index = 0; index < operationList.length; ++index) {
                    result.append("<dataSet").append(index).append(">\n");
                    result.append("<operationName>");
                    result.append(operationList[index].getOperationName());
                    result.append("</operationName>\n");
                    result.append("</dataSet").append(index).append(">\n");
                }
                result.append("</Operations>");
                return result.toString();
            }
        }
        catch (Exception e) {
            throw new BAMException("failed to getActivityInfoForActivityID ", (Throwable)e);
        }
        return "";
    }

    public String getPropertyValueForStatus(String statusKey, String startTime, String endTime) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            Status[] status = this.bamDSClient.getPropertyValueForStatus(statusKey, startTime, endTime);
            if (status != null) {
                result.append("<Status>");
                for (int index = 0; index < status.length; ++index) {
                    result.append("<dataSet").append(index).append(">\n");
                    result.append("<serviceUrl>");
                    result.append(status[index].getStatusValue());
                    result.append("</serviceUrl>\n");
                    result.append("</dataSet").append(index).append(">\n");
                }
                result.append("</Status>");
                return result.toString();
            }
        }
        catch (Exception e) {
            throw new BAMException("failed to getPropertyValueForStatus ", (Throwable)e);
        }
        return "";
    }

    public String getMessageCount() throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            MessageCount[] messageId = this.bamDSClient.getMessageCount();
            if (messageId != null) {
                result.append("<MessageId>");
                for (int index = 0; index < messageId.length; ++index) {
                    result.append("<dataSet").append(index).append(">\n");
                    result.append("<Id>");
                    result.append(messageId[index].getCount());
                    result.append("</Id>\n");
                    result.append("</dataSet").append(index).append(">\n");
                }
                result.append("</MessageId>");
                return result.toString();
            }
        }
        catch (Exception e) {
            throw new BAMException("failed to getPropertyValueForStatus ", (Throwable)e);
        }
        return "";
    }

    private static Map<String, String> processNamespaces(String namepsaces) {
        String[] nsDefinitions;
        HashMap<String, String> nsMap = new HashMap<String, String>();
        if (namepsaces != null && (nsDefinitions = namepsaces.split(",")) != null) {
            for (String nsDefinition : nsDefinitions) {
                String[] tokens = nsDefinition.split("@");
                if (tokens == null || tokens.length != 2) continue;
                nsMap.put(tokens[0].trim(), tokens[1].trim());
            }
        }
        return nsMap;
    }

    private static String encodeNamespaces(NamespaceDTO[] nsArray) {
        if (nsArray != null) {
            StringBuffer namespaces = new StringBuffer();
            for (NamespaceDTO ns : nsArray) {
                namespaces.append(ns.getPrefix() + "@" + ns.getUri());
                namespaces.append(",");
            }
            namespaces.deleteCharAt(namespaces.length() - 1);
            return namespaces.toString();
        }
        return null;
    }

    public String getOperationListForActivity(int serviceId) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            OperationForService[] operationDetails = this.bamDSClient.getOperationListForActivity(serviceId);
            if (operationDetails != null) {
                result.append("<ActivityOperations>");
                for (int index = 0; index < operationDetails.length; ++index) {
                    result.append("<dataSet").append(index).append(">\n");
                    result.append("<operationName>");
                    result.append(operationDetails[index].getOperationName());
                    result.append("</operationName>\n");
                    result.append("<operationId>");
                    result.append(operationDetails[index].getOperationId());
                    result.append("</operationId>\n");
                    result.append("</dataSet").append(index).append(">\n");
                }
                result.append("</ActivityOperations>");
                return result.toString();
            }
        }
        catch (Exception e) {
            throw new BAMException("failed to getActivityInfoForActivityID ", (Throwable)e);
        }
        return "";
    }

    public String gettimestampForOperation(int operationId) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            TimeStampForOperation[] timestampDetails = this.bamDSClient.gettimestampForOperation(operationId);
            if (timestampDetails != null) {
                result.append("<MessageTimeStamp>");
                for (int index = 0; index < timestampDetails.length; ++index) {
                    result.append("<dataSet").append(index).append(">\n");
                    result.append("<timeStamp>");
                    result.append(timestampDetails[index].getTimestamp());
                    result.append("</timeStamp>\n");
                    result.append("<messageId>");
                    result.append(timestampDetails[index].getMessageId());
                    result.append("</messageId>\n");
                    result.append("</dataSet").append(index).append(">\n");
                }
                result.append("</MessageTimeStamp>");
                return result.toString();
            }
        }
        catch (Exception e) {
            throw new BAMException("failed to getActivityInfoForActivityID ", (Throwable)e);
        }
        return "";
    }

    public String getDirectionForOperation(int operationId) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            DirectionForOperation[] directionDetails = this.bamDSClient.getDirectionForOperation(operationId);
            if (directionDetails != null) {
                result.append("<MessageDirection>");
                for (int index = 0; index < directionDetails.length; ++index) {
                    result.append("<dataSet").append(index).append(">\n");
                    result.append("<direction>");
                    result.append(directionDetails[index].getDirection());
                    result.append("</direction>\n");
                    result.append("<messageId>");
                    result.append(directionDetails[index].getMessageId());
                    result.append("</messageId>\n");
                    result.append("</dataSet").append(index).append(">\n");
                }
                result.append("</MessageDirection>");
                return result.toString();
            }
        }
        catch (Exception e) {
            throw new BAMException("failed to getActivityInfoForActivityID ", (Throwable)e);
        }
        return "";
    }

    public String getMessagesForOperation(int operationId, String direction, String startTime, String endTime) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            MessageForOperation[] messagesForOperation = this.bamDSClient.getMessagesForOperation(operationId, direction, startTime, endTime);
            if (messagesForOperation != null) {
                result.append("<Messages>");
                for (int index = 0; index < messagesForOperation.length; ++index) {
                    result.append("<dataSet").append(index).append(">\n");
                    result.append("<messageId>");
                    result.append(messagesForOperation[index].getMessageId());
                    result.append("</messageId>\n");
                    result.append("</dataSet").append(index).append(">\n");
                }
                result.append("</Messages>");
                return result.toString();
            }
        }
        catch (Exception e) {
            throw new BAMException("failed to getActivityInfoForActivityID ", (Throwable)e);
        }
        return "";
    }

    public String getMessageForMessageID(int messageId) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            MessageForMessageID[] messages = this.bamDSClient.getMessageForMessageID(messageId);
            if (messages != null) {
                result.append("<Message>");
                for (int index = 0; index < messages.length; ++index) {
                    result.append("<dataSet").append(index).append(">\n");
                    result.append("<message>");
                    result.append(messages[index].getMessage());
                    result.append("</message>\n");
                    result.append("<timestamp>");
                    result.append(messages[index].getTimestamp());
                    result.append("</timestamp>\n");
                    result.append("</dataSet").append(index).append(">\n");
                }
                result.append("</Message>");
                return result.toString();
            }
        }
        catch (Exception e) {
            throw new BAMException("failed to getActivityInfoForActivityID ", (Throwable)e);
        }
        return "";
    }

    public String getOperationsOfService(int serverID, int serviceID, boolean demo) throws RemoteException, BAMException {
        ServiceDO[] servicesList;
        MonitoredServerDTO[] serverList;
        StringBuilder result = new StringBuilder();
        String serverURL = "";
        for (MonitoredServerDTO monitoredServerDTO : serverList = this.bamListAdminClient.getServerList()) {
            if (monitoredServerDTO.getServerId() != serverID) continue;
            serverURL = monitoredServerDTO.getServerURL();
        }
        Data serverData = this.bamDSClient.getLatestDataForServer(serverID);
        if (serverData != null) {
            result.append("<level0 name=\"").append(serverURL).append("\"");
            result.append(" meta1=\"").append(serverData.getReqCount()).append("\"");
            result.append(" meta2=\"").append(serverData.getResCount()).append("\"");
            result.append(" meta3=\"").append(serverData.getFaultCount()).append("\"");
            result.append(" meta4=\"").append(serverData.getAvgTime()).append("\"");
            result.append(" meta5=\"").append(serverData.getMinTime()).append("\"");
            result.append(" meta6=\"").append(serverData.getMaxTime()).append("\"");
            result.append(">\n");
        }
        for (ServiceDO service : servicesList = this.bamListAdminClient.getServicesList(serverID)) {
            Operation[] operationsList;
            if (service.getId() != serviceID) continue;
            result.append("<level1 name=\"").append(service.getName()).append("\"");
            Data serviceData = this.bamDSClient.getLatestDataForService(service.getId());
            if (serviceData != null) {
                result.append(" meta1=\"").append(serviceData.getReqCount()).append("\"");
                result.append(" meta2=\"").append(serviceData.getResCount()).append("\"");
                result.append(" meta3=\"").append(serviceData.getFaultCount()).append("\"");
                result.append(" meta4=\"").append(serviceData.getAvgTime()).append("\"");
                result.append(" meta5=\"").append(serviceData.getMinTime()).append("\"");
                result.append(" meta6=\"").append(serviceData.getMaxTime()).append("\"");
            }
            result.append(">\n");
            for (Operation operation : operationsList = this.bamDSClient.getOperations(service.getId())) {
                result.append(" <level2 name=\"").append(operation.getName()).append("\"");
                Data operationData = this.bamDSClient.getLatestDataForOperation(Integer.parseInt(operation.getId()));
                if (operationData != null) {
                    result.append(" count=\"").append(operationData.getReqCount()).append("\"");
                    result.append(" meta1=\"").append(operationData.getReqCount()).append("\"");
                    result.append(" meta2=\"").append(operationData.getResCount()).append("\"");
                    result.append(" meta3=\"").append(operationData.getFaultCount()).append("\"");
                    result.append(" meta4=\"").append(operationData.getAvgTime()).append("\"");
                    result.append(" meta5=\"").append(operationData.getMinTime()).append("\"");
                    result.append(" meta6=\"").append(operationData.getMaxTime()).append("\"");
                }
                result.append("/>\n");
            }
            result.append("</level1>\n");
        }
        result.append("</level0>\n");
        return result.toString();
    }

    public String getJMXMetricsWindow(int serverID) {
        StringBuilder result = new StringBuilder();
        String formatString1 = "<level%d name=\"%s\">\n";
        String formatString2 = "<level%d name=\"%s\" count=\"%s\" key=\"%s\" value=\"%s\">\n";
        String formatString3 = "</level%d>\n";
        try {
            MonitoredServerDTO[] serverList;
            String serverURL = "";
            for (MonitoredServerDTO monitoredServerDTO : serverList = this.bamListAdminClient.getServerList()) {
                if (monitoredServerDTO.getServerId() != serverID) continue;
                serverURL = monitoredServerDTO.getServerURL();
            }
            result.append(String.format(formatString1, 0, serverURL));
            JmxMetricsInfo[] response = this.bamDSClient.getJMXMetricsWindow(serverID);
            for (int i = 0; i < response.length; ++i) {
                result.append(String.format(formatString2, 1, "Attributes", i, response[i].getMxMetricsKey(), response[i].getJmxMetricsValue()));
                result.append(String.format(formatString3, 1));
            }
            result.append(String.format(formatString3, 0));
            return result.toString();
        }
        catch (Exception e) {
            log.debug((Object)e);
            return "";
        }
    }

    public String getClientList(int serverID) {
        try {
            ClientDTO[] clientList = this.bamListAdminClient.getClientList(serverID);
            if (clientList != null) {
                return BAMDataServiceDataProcessor.clientArrayToString(clientList, ",", "|");
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
        return "No Servers Configured";
    }

    private static String clientArrayToString(ClientDTO[] a, String separator1, String separator2) {
        StringBuffer result = new StringBuffer();
        if (a != null && a.length > 0) {
            result.append(a[0].getUUID());
            result.append(separator1);
            result.append(a[0].getName());
            for (int i = 1; i < a.length; ++i) {
                result.append(a[0].getUUID());
                result.append(separator1);
                result.append(a[0].getName());
            }
        }
        return result.toString();
    }

    public String getClientServiceOperation(int serverID) throws BAMException, RemoteException {
        ClientServiceOperationInfo[] clientServiceOperationInfoList;
        MonitoredServerDTO[] serverList;
        StringBuilder result = new StringBuilder();
        String serverURL = "";
        for (MonitoredServerDTO monitoredServerDTO : serverList = this.bamListAdminClient.getServerList()) {
            if (monitoredServerDTO.getServerId() != serverID) continue;
            serverURL = monitoredServerDTO.getServerURL();
        }
        Data serverData = this.bamDSClient.getLatestDataForServer(serverID);
        if (serverData != null) {
            result.append("<level0 name=\"").append(serverURL).append("\"");
            result.append(" meta1=\"").append(serverData.getReqCount()).append("\"");
            result.append(" meta2=\"").append(serverData.getResCount()).append("\"");
            result.append(" meta3=\"").append(serverData.getFaultCount()).append("\"");
            result.append(" meta4=\"").append(serverData.getAvgTime()).append("\"");
            result.append(" meta5=\"").append(serverData.getMinTime()).append("\"");
            result.append(" meta6=\"").append(serverData.getMaxTime()).append("\"");
            result.append(">\n");
        }
        for (ClientServiceOperationInfo clientServiceOperationInfo : clientServiceOperationInfoList = this.bamDSClient.getClientServiceOperation(serverID)) {
            Service[] serviceList;
            result.append(" <level1 name=\"").append(clientServiceOperationInfo.getClientService()).append("\"");
            for (Service service : serviceList = this.bamDSClient.getServiceForServer(serverID, clientServiceOperationInfo.getClientService())) {
                Operation[] operationsList;
                Data serviceData = this.bamDSClient.getLatestDataForService(Integer.parseInt(service.getServiceID()));
                if (serviceData != null) {
                    result.append(" meta1=\"").append(serviceData.getReqCount()).append("\"");
                    result.append(" meta2=\"").append(serviceData.getResCount()).append("\"");
                    result.append(" meta3=\"").append(serviceData.getFaultCount()).append("\"");
                    result.append(" meta4=\"").append(serviceData.getAvgTime()).append("\"");
                    result.append(" meta5=\"").append(serviceData.getMinTime()).append("\"");
                    result.append(" meta6=\"").append(serviceData.getMaxTime()).append("\"");
                    result.append(">\n");
                }
                for (Operation operation : operationsList = this.bamDSClient.getOperations(Integer.parseInt(service.getServiceID()))) {
                    result.append(" <level2 name=\"").append(clientServiceOperationInfo.getClientOperation()).append("\"");
                    Data operationData = this.bamDSClient.getLatestDataForOperation(Integer.parseInt(operation.getId()));
                    if (operationData != null) {
                        result.append(" count=\"").append(operationData.getReqCount()).append("\"");
                        result.append(" meta1=\"").append(operationData.getReqCount()).append("\"");
                        result.append(" meta2=\"").append(operationData.getResCount()).append("\"");
                        result.append(" meta3=\"").append(operationData.getFaultCount()).append("\"");
                        result.append(" meta4=\"").append(operationData.getAvgTime()).append("\"");
                        result.append(" meta5=\"").append(operationData.getMinTime()).append("\"");
                        result.append(" meta6=\"").append(operationData.getMaxTime()).append("\"");
                    }
                    result.append("/>\n");
                }
            }
            result.append("</level1>\n");
        }
        result.append("</level0>\n");
        return result.toString();
    }

    public String getServersHeirarchy(String type) throws BAMException, RemoteException {
        String nodeOpenFormatString = "<node>";
        String nodeCloseFormatString = "</node>";
        String labelFormatString = "<label>%s</label>";
        String valueFormatString = "<value>%d</value>";
        String childrenOpenFormatString = "<children>";
        String childrenCloseFormatString = "</children>";
        StringBuilder result = new StringBuilder();
        result.append(nodeOpenFormatString);
        result.append(String.format(labelFormatString, "Servers"));
        result.append(String.format(valueFormatString, 0));
        result.append(childrenOpenFormatString);
        MonitoredServerDTO[] serverList = this.bamListAdminClient.getServerList();
        if (serverList != null && serverList.length > 0) {
            for (MonitoredServerDTO monitoredServerDTO : serverList) {
                ServiceDO[] servicesList;
                result.append(nodeOpenFormatString);
                result.append(String.format(labelFormatString, monitoredServerDTO.getServerURL()));
                result.append(String.format(valueFormatString, monitoredServerDTO.getServerId()));
                int serverID = monitoredServerDTO.getServerId();
                result.append(childrenOpenFormatString);
                if (type.equalsIgnoreCase("all") || type.equalsIgnoreCase("mediation")) {
                    Endpoint[] endpointList = this.bamDSClient.getEndpoints(serverID);
                    result.append(nodeOpenFormatString);
                    result.append(String.format(labelFormatString, "Endpoints"));
                    result.append(String.format(valueFormatString, -2));
                    if (endpointList != null && endpointList.length > 0) {
                        result.append(childrenOpenFormatString);
                        int artifialIDtillThisSupported = -2;
                        for (Endpoint endpoint : endpointList) {
                            result.append(nodeOpenFormatString);
                            result.append(String.format(labelFormatString, endpoint.getEndpoint()));
                            result.append(String.format(valueFormatString, artifialIDtillThisSupported));
                            result.append(nodeCloseFormatString);
                            --artifialIDtillThisSupported;
                        }
                        result.append(childrenCloseFormatString);
                    }
                    result.append(nodeCloseFormatString);
                    ProxyService[] proxyList = this.bamDSClient.getProxyServices(serverID);
                    result.append(nodeOpenFormatString);
                    result.append(String.format(labelFormatString, "Proxy Services"));
                    result.append(String.format(valueFormatString, -3));
                    if (proxyList != null && proxyList.length > 0) {
                        result.append(childrenOpenFormatString);
                        int artifialIDtillThisSupported = -2;
                        for (ProxyService proxy : proxyList) {
                            result.append(nodeOpenFormatString);
                            result.append(String.format(labelFormatString, proxy.getProxyService()));
                            result.append(String.format(valueFormatString, artifialIDtillThisSupported));
                            result.append(nodeCloseFormatString);
                            --artifialIDtillThisSupported;
                        }
                        result.append(childrenCloseFormatString);
                    }
                    result.append(nodeCloseFormatString);
                    Sequence[] sequenceList = this.bamDSClient.getSequences(serverID);
                    result.append(nodeOpenFormatString);
                    result.append(String.format(labelFormatString, "Sequences"));
                    result.append(String.format(valueFormatString, -4));
                    if (sequenceList != null && sequenceList.length > 0) {
                        result.append(childrenOpenFormatString);
                        int artifialIDtillThisSupported = -2;
                        for (Sequence sequence : sequenceList) {
                            result.append(nodeOpenFormatString);
                            result.append(String.format(labelFormatString, sequence.getSequence()));
                            result.append(String.format(valueFormatString, artifialIDtillThisSupported));
                            result.append(nodeCloseFormatString);
                            --artifialIDtillThisSupported;
                        }
                        result.append(childrenCloseFormatString);
                    }
                    result.append(nodeCloseFormatString);
                }
                if ((type.equalsIgnoreCase("all") || type.equalsIgnoreCase("service")) && (servicesList = this.bamListAdminClient.getServicesList(serverID)) != null && servicesList.length > 0) {
                    for (ServiceDO serviceDTO : servicesList) {
                        result.append(nodeOpenFormatString);
                        result.append(String.format(labelFormatString, serviceDTO.getName()));
                        result.append(String.format(valueFormatString, serviceDTO.getId()));
                        int serviceID = serviceDTO.getId();
                        if (serviceID > -1) {
                            OperationDO[] operationsList;
                            result.append(childrenOpenFormatString);
                            for (OperationDO operationDTO : operationsList = this.bamListAdminClient.getOperationList(serviceID)) {
                                result.append(nodeOpenFormatString);
                                result.append(String.format(labelFormatString, operationDTO.getName()));
                                result.append(String.format(valueFormatString, operationDTO.getOperationID()));
                                result.append(nodeCloseFormatString);
                            }
                            result.append(childrenCloseFormatString);
                        }
                        result.append(nodeCloseFormatString);
                    }
                }
                result.append(childrenCloseFormatString);
                result.append(nodeCloseFormatString);
            }
        }
        result.append(childrenCloseFormatString);
        result.append(nodeCloseFormatString);
        return result.toString();
    }

    public String getMediationSummaries(String categoryType, String summaryType, int categoryID, String timeStart, String timeEnd) throws Exception {
        String rootOpenFormatString = "<level0>";
        String rootCloseFormatString = "</level0>";
        String xFormatString = "<x count=\"%s\" name=\"%s\"/>";
        String yFormatString = "<y count=\"%s\" />";
        String setOpenFormatString = "<set>";
        String setCloseFormatString = "</set>";
        String dataOpenFormatString = "<data name=\"%s\">";
        String dataCloseFormatString = "</data>";
        StringBuilder result = new StringBuilder();
        if (!categoryType.equalsIgnoreCase("AllServers")) {
            if (categoryType.equalsIgnoreCase("Server")) {
                MonitoredServerDTO[] serverList = this.bamListAdminClient.getServerList();
                if (serverList != null) {
                    for (MonitoredServerDTO server : serverList) {
                        if (server == null || server.getServerId() != categoryID) continue;
                        SummaryStat[] summaryStats = null;
                        if (summaryType.equalsIgnoreCase("hour")) {
                            summaryStats = this.bamSummaryQueryClient.getServerStatHourlySummaries(server.getServerId(), BAMCalendar.parseTimestamp((String)timeStart), BAMCalendar.parseTimestamp((String)timeEnd));
                        } else if (summaryType.equalsIgnoreCase("day")) {
                            summaryStats = this.bamSummaryQueryClient.getServerStatDailySummaries(server.getServerId(), BAMCalendar.parseTimestamp((String)timeStart), BAMCalendar.parseTimestamp((String)timeEnd));
                        } else if (summaryType.equalsIgnoreCase("month")) {
                            summaryStats = this.bamSummaryQueryClient.getServerStatMonthlySummaries(server.getServerId(), BAMCalendar.parseTimestamp((String)timeStart), BAMCalendar.parseTimestamp((String)timeEnd));
                        } else if (summaryType.equalsIgnoreCase("quater")) {
                            summaryStats = this.bamSummaryQueryClient.getServerStatQuarterlySummaries(server.getServerId(), BAMCalendar.parseTimestamp((String)timeStart), BAMCalendar.parseTimestamp((String)timeEnd));
                        } else if (summaryType.equalsIgnoreCase("year")) {
                            summaryStats = this.bamSummaryQueryClient.getServerStatYearlySummaries(server.getServerId(), BAMCalendar.parseTimestamp((String)timeStart), BAMCalendar.parseTimestamp((String)timeEnd));
                        }
                        result.append(rootOpenFormatString);
                        if (summaryStats != null) {
                            String summaryStatsTimeStamp;
                            result.append(String.format(dataOpenFormatString, "Requests"));
                            int i = 0;
                            for (SummaryStat summaryStat : summaryStats) {
                                if (summaryStat == null) continue;
                                result.append(setOpenFormatString);
                                summaryStatsTimeStamp = summaryStat.getTimestamp();
                                String summaryStatReqCount = summaryStat.getReqCount();
                                result.append(String.format(xFormatString, Integer.toString(i), summaryStatsTimeStamp));
                                result.append(String.format(yFormatString, summaryStatReqCount));
                                result.append(setCloseFormatString);
                                ++i;
                            }
                            result.append(dataCloseFormatString);
                            result.append(String.format(dataOpenFormatString, "Responses"));
                            i = 0;
                            for (SummaryStat summaryStat : summaryStats) {
                                if (summaryStat == null) continue;
                                result.append(setOpenFormatString);
                                summaryStatsTimeStamp = summaryStat.getTimestamp();
                                String summaryStatResTime = summaryStat.getReqCount();
                                result.append(String.format(xFormatString, Integer.toString(i), summaryStatsTimeStamp));
                                result.append(String.format(yFormatString, summaryStatResTime));
                                result.append(setCloseFormatString);
                                ++i;
                            }
                            result.append(dataCloseFormatString);
                            result.append(String.format(dataOpenFormatString, "Faults"));
                            i = 0;
                            for (SummaryStat summaryStat : summaryStats) {
                                if (summaryStat == null) continue;
                                result.append(setOpenFormatString);
                                summaryStatsTimeStamp = summaryStat.getTimestamp();
                                String summaryStatFault = summaryStat.getFaultCount();
                                result.append(String.format(xFormatString, Integer.toString(i), summaryStatsTimeStamp));
                                result.append(String.format(yFormatString, summaryStatFault));
                                result.append(setCloseFormatString);
                                ++i;
                            }
                            result.append(dataCloseFormatString);
                            result.append(String.format(dataOpenFormatString, "Average Processing Time"));
                            i = 0;
                            for (SummaryStat summaryStat : summaryStats) {
                                if (summaryStat == null) continue;
                                result.append(setOpenFormatString);
                                summaryStatsTimeStamp = summaryStat.getTimestamp();
                                String summaryStatAvgTime = summaryStat.getAvgResTime();
                                result.append(String.format(xFormatString, Integer.toString(i), summaryStatsTimeStamp));
                                result.append(String.format(yFormatString, summaryStatAvgTime));
                                result.append(setCloseFormatString);
                                ++i;
                            }
                            result.append(dataCloseFormatString);
                            result.append(String.format(dataOpenFormatString, "Minimum Processing Time"));
                            i = 0;
                            for (SummaryStat summaryStat : summaryStats) {
                                if (summaryStat == null) continue;
                                result.append(setOpenFormatString);
                                summaryStatsTimeStamp = summaryStat.getTimestamp();
                                String summaryStatMinTime = summaryStat.getMinResTime();
                                result.append(String.format(xFormatString, Integer.toString(i), summaryStatsTimeStamp));
                                result.append(String.format(yFormatString, summaryStatMinTime));
                                result.append(setCloseFormatString);
                                ++i;
                            }
                            result.append(dataCloseFormatString);
                            result.append(String.format(dataOpenFormatString, "Maximum Processing Time"));
                            i = 0;
                            for (SummaryStat summaryStat : summaryStats) {
                                if (summaryStat == null) continue;
                                result.append(setOpenFormatString);
                                summaryStatsTimeStamp = summaryStat.getTimestamp();
                                String summaryStatMaxTime = summaryStat.getMaxResTime();
                                result.append(String.format(xFormatString, Integer.toString(i), summaryStatsTimeStamp));
                                result.append(String.format(yFormatString, summaryStatMaxTime));
                                result.append(setCloseFormatString);
                                ++i;
                            }
                            result.append(dataCloseFormatString);
                        }
                        result.append(rootCloseFormatString);
                        return result.toString();
                    }
                }
            } else if (!categoryType.equalsIgnoreCase("AllEndpoints") || summaryType.equalsIgnoreCase("hour") || summaryType.equalsIgnoreCase("day") || summaryType.equalsIgnoreCase("month") || summaryType.equalsIgnoreCase("quoter") || summaryType.equalsIgnoreCase("year")) {
                // empty if block
            }
        }
        return "";
    }

    public String getMediationRealTimeFaultStat_temp(String categoryType, int serverId, String mediationName, String cacheId) throws BAMException {
        return "";
    }

    public String getAllActivityDataForTimeRange(String startTime, String endTime) throws BAMException {
        FullActivityData[] fullActivityDatas = this.bamDSClient.getAllActivityDataForTimeRange(startTime, endTime);
        StringBuffer result = new StringBuffer();
        if (fullActivityDatas != null) {
            for (FullActivityData activityData : fullActivityDatas) {
                result.append(activityData.getActivityDataId());
                result.append(",");
                result.append(activityData.getActivityDataName());
                result.append("|");
            }
        }
        return result.toString();
    }

    public String getAllMessagesForTimeRangeAndActivity(String startTime, String endTime, int activityID) throws BAMException {
        AllMessagesForActivity[] messagesForActivities = this.bamDSClient.getAllMessagesForTimeRangeAndActivity(startTime, endTime, activityID);
        StringBuffer result = new StringBuffer();
        if (messagesForActivities != null) {
            for (AllMessagesForActivity messagesForActivity : messagesForActivities) {
                result.append(messagesForActivity.getActivityMessage());
                result.append("|");
            }
        }
        return result.toString();
    }

    public String getMessagesForStatus(String startTimeSelection, String endTimeSelection, String server, String service, String operation, String direction, String status, String activityTypeSelection, String messageTypeSelection, String messageFormatSelection, String applicationStatusSelection, String technicalStatusSelection, String messageGUID, String expression, String value, String namespaces, int startDataset, int endDataset) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            MessageId[] messageIds = this.bamDSClient.getMessagesForStatus(startTimeSelection, endTimeSelection, server, service, operation, direction, status, activityTypeSelection, messageTypeSelection, messageFormatSelection, applicationStatusSelection, technicalStatusSelection, messageGUID, startDataset, endDataset);
            ArrayList<MessageId> idsForXPathList = new ArrayList<MessageId>();
            if (expression != null && !expression.equals("")) {
                AXIOMXPath xpath = new AXIOMXPath(expression);
                Map<String, String> nsMap = BAMDataServiceDataProcessor.processNamespaces(namespaces);
                for (String prefix : nsMap.keySet()) {
                    xpath.addNamespace(prefix, nsMap.get(prefix));
                }
                block3: for (int index = 0; index < messageIds.length; ++index) {
                    List nodes;
                    StAXOMBuilder builder;
                    OMElement root;
                    MessageForMessageID[] messages = this.bamDSClient.getMessageForMessageID(Integer.parseInt(messageIds[index].getMessageId()));
                    if (messages == null || messages.length <= 0 || messages[0].getMessage() == "" || (root = (builder = new StAXOMBuilder((InputStream)new ByteArrayInputStream(messages[0].getMessage().getBytes()))).getDocumentElement()) == null || (nodes = xpath.selectNodes((Object)root)) == null || nodes.size() <= 0) continue;
                    for (Object node : nodes) {
                        OMElement element = null;
                        OMAttribute attribute = null;
                        if (node instanceof OMDocument) {
                            element = ((OMDocument)node).getOMDocumentElement();
                        } else if (node instanceof OMElement) {
                            element = (OMElement)node;
                        } else if (node instanceof OMAttribute) {
                            attribute = (OMAttribute)node;
                        }
                        if (value != null && !value.equals("")) {
                            String evaluation = null;
                            String lineBreak = System.getProperty("line.separator");
                            if (element != null) {
                                evaluation = element.getChildElements().hasNext() ? element.toString().replace(lineBreak, "") : element.getText().replace(lineBreak, "");
                            } else if (attribute != null) {
                                evaluation = attribute.getLocalName().replace(lineBreak, "");
                            }
                            if (!(evaluation = evaluation.trim()).equals((value = value.replace(lineBreak, "")).trim())) continue;
                            idsForXPathList.add(messageIds[index]);
                            continue block3;
                        }
                        idsForXPathList.add(messageIds[index]);
                        continue block3;
                    }
                }
                MessageId[] idsForXPath = idsForXPathList.toArray(new MessageId[idsForXPathList.size()]);
                messageIds = idsForXPath;
            }
            if (messageIds != null && messageIds.length > 0) {
                result.append("<Messages>");
                String messageId = "";
                String messageDirection = "";
                String messageUUID = "";
                String messageStatus = "";
                String messageTimestamp = "";
                String activityType = "";
                String applicationFailure = "";
                String technicalFailure = "";
                String messageFormat = "";
                String messageType = "";
                String serviceName = "";
                String arcKey = "";
                String activityId = "";
                boolean parentRecord = false;
                MessageId message = null;
                for (int index = 0; index < messageIds.length; ++index) {
                    message = messageIds[index];
                    if (!messageId.equals(message.getMessageId())) {
                        if (!"".equals(messageId)) {
                            this.dumpXML(result, messageDirection, messageUUID, messageStatus, messageTimestamp, activityType, applicationFailure, technicalFailure, messageFormat, messageType, serviceName, arcKey, parentRecord, index, messageIds[index - 1]);
                        }
                        activityType = "";
                        applicationFailure = "";
                        technicalFailure = "";
                        messageFormat = "";
                        messageType = "";
                        arcKey = "";
                        parentRecord = false;
                        messageId = message.getMessageId();
                        messageDirection = message.getMessageDirection();
                        messageUUID = message.getMessageUUID();
                        messageStatus = message.getStatus();
                        messageTimestamp = message.getTimestamp();
                        serviceName = message.getServiceName();
                        activityId = message.getActivityId();
                    }
                    if ("activity_type".equals(message.getKey())) {
                        activityType = message.getValue();
                        continue;
                    }
                    if ("application_failure".equals(message.getKey())) {
                        applicationFailure = message.getValue();
                        continue;
                    }
                    if ("technical_failure".equals(message.getKey())) {
                        technicalFailure = message.getValue();
                        continue;
                    }
                    if ("message_format".equals(message.getKey())) {
                        messageFormat = message.getValue();
                        continue;
                    }
                    if ("message_type".equals(message.getKey())) {
                        messageType = message.getValue();
                        continue;
                    }
                    if ("arc_key".equals(message.getKey())) {
                        arcKey = message.getValue();
                        continue;
                    }
                    if (!message.getKey().contains("parent")) continue;
                    parentRecord = true;
                }
                this.dumpXML(result, messageDirection, messageUUID, messageStatus, messageTimestamp, activityType, applicationFailure, technicalFailure, messageFormat, messageType, serviceName, arcKey, parentRecord, messageIds.length - 1, message);
                if (this.activityResult != null) {
                    result.append((CharSequence)this.activityResult);
                }
                result.append("</Messages>");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("List of filtered messages are :" + result.toString()));
            }
            return result.toString();
        }
        catch (Exception e) {
            throw new BAMException("failed to getPropertyValueForStatus ", (Throwable)e);
        }
    }

    private void dumpXML(StringBuilder result, String messageDirection, String messageUUID, String messageStatus, String messageTimestamp, String activityType, String applicationFailure, String technicalFailure, String messageFormat, String messageType, String serviceName, String arcKey, boolean parentRecord, int index, MessageId message) throws BAMException {
        String msgStatus = "";
        int activityID = Integer.parseInt(message.getActivityId());
        try {
            int aleauditFailed;
            int replayedRequestFailed;
            int replayedResponseFailed;
            int originalFail;
            int error;
            int failMessageCount = this.getCountofChildrenFailedMessages(activityID);
            if (failMessageCount > 0 && (error = (originalFail = this.bamDSClient.getOriginalFailCount(activityID)) + (replayedResponseFailed = this.bamDSClient.getReplayedFailReponseCount(activityID)) - (replayedRequestFailed = this.bamDSClient.getReplayedFailRequestCount(activityID))) != 0 && (aleauditFailed = this.bamDSClient.getAleauditFailCount(activityID)) != 0) {
                this.bamDSClient.setParentStatus(activityID);
                messageStatus = "Fail";
            }
        }
        catch (Exception e) {
            throw new BAMException("failed to getCountofChildrenFailedMessages ", (Throwable)e);
        }
        if (!arcKey.equals(this.lastArcKey)) {
            result.append((CharSequence)this.activityResult);
            this.activityResult = new StringBuilder();
        }
        if (parentRecord) {
            result.append("<dataSet" + index + ">\n");
            result.append("<MessageId>");
            result.append(message.getMessageId());
            result.append("</MessageId>\n");
            result.append("<ActivityId>");
            result.append(message.getActivityId());
            result.append("</ActivityId>\n");
            result.append("<ActivityType>");
            result.append(activityType);
            result.append("</ActivityType>\n");
            result.append("<ApplicationFailure>");
            result.append(applicationFailure);
            result.append("</ApplicationFailure>\n");
            result.append("<TechnicalFailure>");
            result.append(technicalFailure);
            result.append("</TechnicalFailure>\n");
            result.append("<MessageFormat>");
            result.append(messageFormat);
            result.append("</MessageFormat>\n");
            result.append("<MessageType>");
            result.append(messageType);
            result.append("</MessageType>\n");
            result.append("<MessageDirection>");
            result.append(messageDirection);
            result.append("</MessageDirection>\n");
            result.append("<MessageUUID>");
            result.append(messageUUID);
            result.append("</MessageUUID>\n");
            result.append("<Status>");
            result.append(messageStatus);
            result.append("</Status>\n");
            result.append("<TimeStamp>");
            result.append(messageTimestamp);
            result.append("</TimeStamp>\n");
            result.append("<ServiceName>");
            result.append(serviceName);
            result.append("</ServiceName>\n");
            result.append("<ARCKey>");
            result.append(arcKey);
            result.append("</ARCKey>\n");
            result.append("<ParentRecord>");
            result.append(parentRecord);
            result.append("</ParentRecord>\n");
            result.append("<IpAddress>");
            result.append(message.getIpAddress());
            result.append("</IpAddress>\n");
            result.append("<UserAgent>");
            result.append(message.getUserAgent());
            result.append("</UserAgent>\n");
            result.append("</dataSet").append(index).append(">\n");
        } else {
            this.activityResult.append("<dataSet" + index + ">\n");
            this.activityResult.append("<MessageId>");
            this.activityResult.append(message.getMessageId());
            this.activityResult.append("</MessageId>\n");
            this.activityResult.append("<ActivityId>");
            this.activityResult.append(message.getActivityId());
            this.activityResult.append("</ActivityId>\n");
            this.activityResult.append("<ActivityType>");
            this.activityResult.append(activityType);
            this.activityResult.append("</ActivityType>\n");
            this.activityResult.append("<ApplicationFailure>");
            this.activityResult.append(applicationFailure);
            this.activityResult.append("</ApplicationFailure>\n");
            this.activityResult.append("<TechnicalFailure>");
            this.activityResult.append(technicalFailure);
            this.activityResult.append("</TechnicalFailure>\n");
            this.activityResult.append("<MessageFormat>");
            this.activityResult.append(messageFormat);
            this.activityResult.append("</MessageFormat>\n");
            this.activityResult.append("<MessageType>");
            this.activityResult.append(messageType);
            this.activityResult.append("</MessageType>\n");
            this.activityResult.append("<MessageDirection>");
            this.activityResult.append(messageDirection);
            this.activityResult.append("</MessageDirection>\n");
            this.activityResult.append("<MessageUUID>");
            this.activityResult.append(messageUUID);
            this.activityResult.append("</MessageUUID>\n");
            this.activityResult.append("<Status>");
            this.activityResult.append(messageStatus);
            this.activityResult.append("</Status>\n");
            this.activityResult.append("<TimeStamp>");
            this.activityResult.append(messageTimestamp);
            this.activityResult.append("</TimeStamp>\n");
            this.activityResult.append("<ServiceName>");
            this.activityResult.append(serviceName);
            this.activityResult.append("</ServiceName>\n");
            this.activityResult.append("<ARCKey>");
            this.activityResult.append(arcKey);
            this.activityResult.append("</ARCKey>\n");
            this.activityResult.append("<ParentRecord>");
            this.activityResult.append(parentRecord);
            this.activityResult.append("</ParentRecord>\n");
            this.activityResult.append("<IpAddress>");
            this.activityResult.append(message.getIpAddress());
            this.activityResult.append("</IpAddress>\n");
            this.activityResult.append("<UserAgent>");
            this.activityResult.append(message.getUserAgent());
            this.activityResult.append("</UserAgent>\n");
            this.activityResult.append("</dataSet").append(index).append(">\n");
        }
        this.lastArcKey = arcKey;
    }

    public String getMessagesForStatus(String startTimeSelection, String endTimeSelection, String server, String service, String operation, String direction, String status, String activityTypeSelection, String messageTypeSelection, String messageFormatSelection, String applicationStatusSelection, String technicalStatusSelection, String messageGUID, String xpathKey, String value, int startDataset, int endDataset) throws BAMException {
        String xpathExpression = null;
        String namespaces = null;
        if (xpathKey != null) {
            int serverId;
            try {
                serverId = this.bamStatQueryDSClient.getServerIdForServer(server);
            }
            catch (BAMException e) {
                log.error((Object)("Error fetching server data for server " + server));
                throw new BAMException("Filter processing failed at xpath filters..", (Throwable)e);
            }
            try {
                PropertyFilterDTO[] xpathConfigs;
                for (PropertyFilterDTO xpathConfig : xpathConfigs = this.bamListAdminClient.getXpathConfigurations(serverId)) {
                    if (xpathConfig.getExpressionKey().equals(xpathKey)) {
                        xpathExpression = xpathConfig.getExpression();
                    }
                    try {
                        NamespaceDTO[] nsArray = this.bamListAdminClient.getNamespaces(xpathConfig.getId());
                        namespaces = BAMDataServiceDataProcessor.encodeNamespaces(nsArray);
                    }
                    catch (BAMException e) {
                        log.error((Object)("Error fetching namespace for xpath id " + xpathConfig.getId() + ". No namespaces will be available.."), (Throwable)e);
                    }
                }
            }
            catch (BAMException e) {
                log.error((Object)("Error fetching xpath configurations for server id " + serverId));
                throw new BAMException("Filter processing failed at xpath filters..", (Throwable)e);
            }
        }
        return this.getMessagesForStatus(startTimeSelection, endTimeSelection, server, service, operation, direction, status, activityTypeSelection, messageTypeSelection, messageFormatSelection, applicationStatusSelection, technicalStatusSelection, messageGUID, xpathExpression, value, namespaces, startDataset, endDataset);
    }

    public String getMessagesCountForSAP(String startTimeSelection, String endTimeSelection, String server, String service, String operation, String direction, String status, String activityTypeSelection, String messageTypeSelection, String messageFormatSelection, String applicationStatusSelection, String technicalStatusSelection, String messageGUID, String expression, String value, String namespaces) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            SAPcount[] messageIds = this.bamDSClient.getMessagesCountForSAP(startTimeSelection, endTimeSelection, server, service, operation, direction, status, activityTypeSelection, messageTypeSelection, messageFormatSelection, applicationStatusSelection, technicalStatusSelection, messageGUID);
            if (messageIds != null && messageIds.length > 0) {
                result.append("<MessageCount>");
                for (int index = 0; index < messageIds.length; ++index) {
                    result.append(messageIds[index].getSAPmessageCount());
                }
                result.append("</MessageCount>");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Filtered messages count :" + result.toString()));
            }
            return result.toString();
        }
        catch (Exception e) {
            throw new BAMException("failed to getPropertyValueForStatus ", (Throwable)e);
        }
    }

    public String getChildrenMessagesForSAP(String startTimeSelection, String endTimeSelection, String server, String service, String operation, String direction, String status, String activityTypeSelection, String messageTypeSelection, String messageFormatSelection, String applicationStatusSelection, String technicalStatusSelection, String messageGUID, String expression, String value, String namespaces, int activityId, int startDataset, int endDataset) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            SAPchild[] messageIds = this.bamDSClient.getChildrenMessagesForSAP(startTimeSelection, endTimeSelection, server, service, operation, direction, status, activityTypeSelection, messageTypeSelection, messageFormatSelection, applicationStatusSelection, technicalStatusSelection, messageGUID, activityId, startDataset, endDataset);
            ArrayList<SAPchild> idsForXPathList = new ArrayList<SAPchild>();
            if (expression != null && !expression.equals("")) {
                AXIOMXPath xpath = new AXIOMXPath(expression);
                Map<String, String> nsMap = BAMDataServiceDataProcessor.processNamespaces(namespaces);
                for (String prefix : nsMap.keySet()) {
                    xpath.addNamespace(prefix, nsMap.get(prefix));
                }
                block3: for (int index = 0; index < messageIds.length; ++index) {
                    List nodes;
                    StAXOMBuilder builder;
                    OMElement root;
                    MessageForMessageID[] messages = this.bamDSClient.getMessageForMessageID(Integer.parseInt(messageIds[index].getMessageId()));
                    if (messages == null || messages.length <= 0 || messages[0].getMessage() == "" || (root = (builder = new StAXOMBuilder((InputStream)new ByteArrayInputStream(messages[0].getMessage().getBytes()))).getDocumentElement()) == null || (nodes = xpath.selectNodes((Object)root)) == null || nodes.size() <= 0) continue;
                    for (Object node : nodes) {
                        OMElement element = null;
                        OMAttribute attribute = null;
                        if (node instanceof OMDocument) {
                            element = ((OMDocument)node).getOMDocumentElement();
                        } else if (node instanceof OMElement) {
                            element = (OMElement)node;
                        } else if (node instanceof OMAttribute) {
                            attribute = (OMAttribute)node;
                        }
                        if (value != null && !value.equals("")) {
                            String evaluation = null;
                            String lineBreak = System.getProperty("line.separator");
                            if (element != null) {
                                evaluation = element.getChildElements().hasNext() ? element.toString().replace(lineBreak, "") : element.getText().replace(lineBreak, "");
                            } else if (attribute != null) {
                                evaluation = attribute.getLocalName().replace(lineBreak, "");
                            }
                            if (!(evaluation = evaluation.trim()).equals((value = value.replace(lineBreak, "")).trim())) continue;
                            idsForXPathList.add(messageIds[index]);
                            continue block3;
                        }
                        idsForXPathList.add(messageIds[index]);
                        continue block3;
                    }
                }
                SAPchild[] idsForXPath = idsForXPathList.toArray(new SAPchild[idsForXPathList.size()]);
                messageIds = idsForXPath;
            }
            if (messageIds != null && messageIds.length > 0) {
                result.append("<ChildMessages>");
                String messageId = "";
                String messageDirection = "";
                String messageUUID = "";
                String messageStatus = "";
                String messageTimestamp = "";
                String activityType = "";
                String applicationFailure = "";
                String technicalFailure = "";
                String messageFormat = "";
                String messageType = "";
                String serviceName = "";
                String arcKey = "";
                boolean parentRecord = false;
                SAPchild message = null;
                for (int index = 0; index < messageIds.length; ++index) {
                    message = messageIds[index];
                    if (!messageId.equals(message.getMessageId())) {
                        if (!"".equals(messageId)) {
                            this.dumpXML(result, messageDirection, messageUUID, messageStatus, messageTimestamp, activityType, applicationFailure, technicalFailure, messageFormat, messageType, serviceName, arcKey, parentRecord, index, messageIds[index - 1]);
                        }
                        activityType = "";
                        applicationFailure = "";
                        technicalFailure = "";
                        messageFormat = "";
                        messageType = "";
                        arcKey = "";
                        parentRecord = false;
                        messageId = message.getMessageId();
                        messageDirection = message.getMessageDirection();
                        messageUUID = message.getMessageUUID();
                        messageStatus = message.getStatus();
                        messageTimestamp = message.getTimestamp();
                        serviceName = message.getServiceName();
                    }
                    if ("activity_type".equals(message.getKey())) {
                        activityType = message.getValue();
                        continue;
                    }
                    if ("application_failure".equals(message.getKey())) {
                        applicationFailure = message.getValue();
                        continue;
                    }
                    if ("technical_failure".equals(message.getKey())) {
                        technicalFailure = message.getValue();
                        continue;
                    }
                    if ("message_format".equals(message.getKey())) {
                        messageFormat = message.getValue();
                        continue;
                    }
                    if ("message_type".equals(message.getKey())) {
                        messageType = message.getValue();
                        continue;
                    }
                    if ("arc_key".equals(message.getKey())) {
                        arcKey = message.getValue();
                        continue;
                    }
                    if (!message.getKey().contains("parent")) continue;
                    parentRecord = true;
                }
                this.dumpXML(result, messageDirection, messageUUID, messageStatus, messageTimestamp, activityType, applicationFailure, technicalFailure, messageFormat, messageType, serviceName, arcKey, parentRecord, messageIds.length - 1, message);
                if (this.activityResult != null) {
                    result.append((CharSequence)this.activityResult);
                }
                result.append("</ChildMessages>");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("List of filtered messages are :" + result.toString()));
            }
            return result.toString();
        }
        catch (Exception e) {
            throw new BAMException("failed to getPropertyValueForStatus ", (Throwable)e);
        }
    }

    private void dumpXML(StringBuilder result, String messageDirection, String messageUUID, String messageStatus, String messageTimestamp, String activityType, String applicationFailure, String technicalFailure, String messageFormat, String messageType, String serviceName, String arcKey, boolean parentRecord, int index, SAPchild message) {
        if (!parentRecord) {
            result.append("<dataSet" + index + ">\n");
            result.append("<MessageId>");
            result.append(message.getMessageId());
            result.append("</MessageId>\n");
            result.append("<ActivityId>");
            result.append(message.getActivityId());
            result.append("</ActivityId>\n");
            result.append("<ActivityType>");
            result.append(activityType);
            result.append("</ActivityType>\n");
            result.append("<ApplicationFailure>");
            result.append(applicationFailure);
            result.append("</ApplicationFailure>\n");
            result.append("<TechnicalFailure>");
            result.append(technicalFailure);
            result.append("</TechnicalFailure>\n");
            result.append("<MessageFormat>");
            result.append(messageFormat);
            result.append("</MessageFormat>\n");
            result.append("<MessageType>");
            result.append(messageType);
            result.append("</MessageType>\n");
            result.append("<MessageDirection>");
            result.append(messageDirection);
            result.append("</MessageDirection>\n");
            result.append("<MessageUUID>");
            result.append(messageUUID);
            result.append("</MessageUUID>\n");
            result.append("<Status>");
            result.append(messageStatus);
            result.append("</Status>\n");
            result.append("<TimeStamp>");
            result.append(messageTimestamp);
            result.append("</TimeStamp>\n");
            result.append("<ServiceName>");
            result.append(serviceName);
            result.append("</ServiceName>\n");
            result.append("<ARCKey>");
            result.append(arcKey);
            result.append("</ARCKey>\n");
            result.append("<ParentRecord>");
            result.append(parentRecord);
            result.append("</ParentRecord>\n");
            result.append("<IpAddress>");
            result.append(message.getIpAddress());
            result.append("</IpAddress>\n");
            result.append("<UserAgent>");
            result.append(message.getUserAgent());
            result.append("</UserAgent>\n");
            result.append("</dataSet").append(index).append(">\n");
        }
    }

    public String getChildrenMessagesForSAP(String startTimeSelection, String endTimeSelection, String server, String service, String operation, String direction, String status, String activityTypeSelection, String messageTypeSelection, String messageFormatSelection, String applicationStatusSelection, String technicalStatusSelection, String messageGUID, String xpathKey, String value, int activityId, int startDataset, int endDataset) throws BAMException {
        String xpathExpression = null;
        String namespaces = null;
        if (xpathKey != null) {
            int serverId;
            try {
                serverId = this.bamStatQueryDSClient.getServerIdForServer(server);
            }
            catch (BAMException e) {
                log.error((Object)("Error fetching server data for server " + server));
                throw new BAMException("Filter processing failed at xpath filters..", (Throwable)e);
            }
            try {
                PropertyFilterDTO[] xpathConfigs;
                for (PropertyFilterDTO xpathConfig : xpathConfigs = this.bamListAdminClient.getXpathConfigurations(serverId)) {
                    if (xpathConfig.getExpressionKey().equals(xpathKey)) {
                        xpathExpression = xpathConfig.getExpression();
                    }
                    try {
                        NamespaceDTO[] nsArray = this.bamListAdminClient.getNamespaces(xpathConfig.getId());
                        namespaces = BAMDataServiceDataProcessor.encodeNamespaces(nsArray);
                    }
                    catch (BAMException e) {
                        log.error((Object)("Error fetching namespace for xpath id " + xpathConfig.getId() + ". No namespaces will be available.."), (Throwable)e);
                    }
                }
            }
            catch (BAMException e) {
                log.error((Object)("Error fetching xpath configurations for server id " + serverId));
                throw new BAMException("Filter processing failed at xpath filters..", (Throwable)e);
            }
        }
        return this.getChildrenMessagesForSAP(startTimeSelection, endTimeSelection, server, service, operation, direction, status, activityTypeSelection, messageTypeSelection, messageFormatSelection, applicationStatusSelection, technicalStatusSelection, messageGUID, xpathExpression, value, namespaces, activityId, startDataset, endDataset);
    }

    public String getAleauditMessagesForSAP(String startTimeSelection, String endTimeSelection, String server, String service, String operation, String direction, String status, String messageTypeSelection, String messageFormatSelection, String applicationStatusSelection, String technicalStatusSelection, String messageGUID, String expression, String value, String namespaces, int startDataset, int endDataset) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            SAPaleaudit[] messageIds = this.bamDSClient.getAleauditMessagesForSAP(startTimeSelection, endTimeSelection, server, service, operation, direction, status, messageTypeSelection, messageFormatSelection, applicationStatusSelection, technicalStatusSelection, messageGUID, startDataset, endDataset);
            ArrayList<SAPaleaudit> idsForXPathList = new ArrayList<SAPaleaudit>();
            if (expression != null && !expression.equals("")) {
                AXIOMXPath xpath = new AXIOMXPath(expression);
                Map<String, String> nsMap = BAMDataServiceDataProcessor.processNamespaces(namespaces);
                for (String prefix : nsMap.keySet()) {
                    xpath.addNamespace(prefix, nsMap.get(prefix));
                }
                block3: for (int index = 0; index < messageIds.length; ++index) {
                    List nodes;
                    StAXOMBuilder builder;
                    OMElement root;
                    MessageForMessageID[] messages = this.bamDSClient.getMessageForMessageID(Integer.parseInt(messageIds[index].getMessageId()));
                    if (messages == null || messages.length <= 0 || messages[0].getMessage() == "" || (root = (builder = new StAXOMBuilder((InputStream)new ByteArrayInputStream(messages[0].getMessage().getBytes()))).getDocumentElement()) == null || (nodes = xpath.selectNodes((Object)root)) == null || nodes.size() <= 0) continue;
                    for (Object node : nodes) {
                        OMElement element = null;
                        OMAttribute attribute = null;
                        if (node instanceof OMDocument) {
                            element = ((OMDocument)node).getOMDocumentElement();
                        } else if (node instanceof OMElement) {
                            element = (OMElement)node;
                        } else if (node instanceof OMAttribute) {
                            attribute = (OMAttribute)node;
                        }
                        if (value != null && !value.equals("")) {
                            String evaluation = null;
                            String lineBreak = System.getProperty("line.separator");
                            if (element != null) {
                                evaluation = element.getChildElements().hasNext() ? element.toString().replace(lineBreak, "") : element.getText().replace(lineBreak, "");
                            } else if (attribute != null) {
                                evaluation = attribute.getLocalName().replace(lineBreak, "");
                            }
                            if (!(evaluation = evaluation.trim()).equals((value = value.replace(lineBreak, "")).trim())) continue;
                            idsForXPathList.add(messageIds[index]);
                            continue block3;
                        }
                        idsForXPathList.add(messageIds[index]);
                        continue block3;
                    }
                }
                SAPaleaudit[] idsForXPath = idsForXPathList.toArray(new SAPaleaudit[idsForXPathList.size()]);
                messageIds = idsForXPath;
            }
            if (messageIds != null && messageIds.length > 0) {
                result.append("<AleauditMessages>");
                String messageId = "";
                String messageDirection = "";
                String messageUUID = "";
                String messageStatus = "";
                String messageTimestamp = "";
                String activityType = "";
                String applicationFailure = "";
                String technicalFailure = "";
                String messageFormat = "";
                String messageType = "";
                String serviceName = "";
                String arcKey = "";
                boolean parentRecord = false;
                SAPaleaudit message = null;
                for (int index = 0; index < messageIds.length; ++index) {
                    message = messageIds[index];
                    if (!messageId.equals(message.getMessageId())) {
                        if (!"".equals(messageId)) {
                            this.dumpXML(result, messageDirection, messageUUID, messageStatus, messageTimestamp, activityType, applicationFailure, technicalFailure, messageFormat, messageType, serviceName, arcKey, parentRecord, index, messageIds[index - 1]);
                        }
                        activityType = "";
                        applicationFailure = "";
                        technicalFailure = "";
                        messageFormat = "";
                        messageType = "";
                        arcKey = "";
                        parentRecord = false;
                        messageId = message.getMessageId();
                        messageDirection = message.getMessageDirection();
                        messageUUID = message.getMessageUUID();
                        messageStatus = message.getStatus();
                        messageTimestamp = message.getTimestamp();
                        serviceName = message.getServiceName();
                    }
                    if ("activity_type".equals(message.getKey())) {
                        activityType = message.getValue();
                        continue;
                    }
                    if ("application_failure".equals(message.getKey())) {
                        applicationFailure = message.getValue();
                        continue;
                    }
                    if ("technical_failure".equals(message.getKey())) {
                        technicalFailure = message.getValue();
                        continue;
                    }
                    if ("message_format".equals(message.getKey())) {
                        messageFormat = message.getValue();
                        continue;
                    }
                    if ("message_type".equals(message.getKey())) {
                        messageType = message.getValue();
                        continue;
                    }
                    if ("arc_key".equals(message.getKey())) {
                        arcKey = message.getValue();
                        continue;
                    }
                    if (!message.getKey().contains("parent")) continue;
                    parentRecord = true;
                }
                this.dumpXML(result, messageDirection, messageUUID, messageStatus, messageTimestamp, activityType, applicationFailure, technicalFailure, messageFormat, messageType, serviceName, arcKey, parentRecord, messageIds.length - 1, message);
                if (this.activityResult != null) {
                    result.append((CharSequence)this.activityResult);
                }
                result.append("</AleauditMessages>");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("List of filtered messages are :" + result.toString()));
            }
            return result.toString();
        }
        catch (Exception e) {
            throw new BAMException("failed to getPropertyValueForStatus ", (Throwable)e);
        }
    }

    private void dumpXML(StringBuilder result, String messageDirection, String messageUUID, String messageStatus, String messageTimestamp, String activityType, String applicationFailure, String technicalFailure, String messageFormat, String messageType, String serviceName, String arcKey, boolean parentRecord, int index, SAPaleaudit message) {
        result.append("<AleauditMessage_dataSet" + index + ">\n");
        result.append("<MessageId>");
        result.append(message.getMessageId());
        result.append("</MessageId>\n");
        result.append("<ActivityId>");
        result.append(message.getActivityId());
        result.append("</ActivityId>\n");
        result.append("<ActivityType>");
        result.append(activityType);
        result.append("</ActivityType>\n");
        result.append("<ApplicationFailure>");
        result.append(applicationFailure);
        result.append("</ApplicationFailure>\n");
        result.append("<TechnicalFailure>");
        result.append(technicalFailure);
        result.append("</TechnicalFailure>\n");
        result.append("<MessageFormat>");
        result.append(messageFormat);
        result.append("</MessageFormat>\n");
        result.append("<MessageType>");
        result.append(messageType);
        result.append("</MessageType>\n");
        result.append("<MessageDirection>");
        result.append(messageDirection);
        result.append("</MessageDirection>\n");
        result.append("<MessageUUID>");
        result.append(messageUUID);
        result.append("</MessageUUID>\n");
        result.append("<Status>");
        result.append(messageStatus);
        result.append("</Status>\n");
        result.append("<TimeStamp>");
        result.append(messageTimestamp);
        result.append("</TimeStamp>\n");
        result.append("<ServiceName>");
        result.append(serviceName);
        result.append("</ServiceName>\n");
        result.append("<ARCKey>");
        result.append(arcKey);
        result.append("</ARCKey>\n");
        result.append("<ParentRecord>");
        result.append(parentRecord);
        result.append("</ParentRecord>\n");
        result.append("<IpAddress>");
        result.append(message.getIpAddress());
        result.append("</IpAddress>\n");
        result.append("<UserAgent>");
        result.append(message.getUserAgent());
        result.append("</UserAgent>\n");
        result.append("</AleauditMessage_dataSet").append(index).append(">\n");
    }

    public String getAleauditMessagesForSAP(String startTimeSelection, String endTimeSelection, String server, String service, String operation, String direction, String status, String messageTypeSelection, String messageFormatSelection, String applicationStatusSelection, String technicalStatusSelection, String messageGUID, String xpathKey, String value, int startDataset, int endDataset) throws BAMException {
        String xpathExpression = null;
        String namespaces = null;
        if (xpathKey != null) {
            int serverId;
            try {
                serverId = this.bamStatQueryDSClient.getServerIdForServer(server);
            }
            catch (BAMException e) {
                log.error((Object)("Error fetching server data for server " + server));
                throw new BAMException("Filter processing failed at xpath filters..", (Throwable)e);
            }
            try {
                PropertyFilterDTO[] xpathConfigs;
                for (PropertyFilterDTO xpathConfig : xpathConfigs = this.bamListAdminClient.getXpathConfigurations(serverId)) {
                    if (xpathConfig.getExpressionKey().equals(xpathKey)) {
                        xpathExpression = xpathConfig.getExpression();
                    }
                    try {
                        NamespaceDTO[] nsArray = this.bamListAdminClient.getNamespaces(xpathConfig.getId());
                        namespaces = BAMDataServiceDataProcessor.encodeNamespaces(nsArray);
                    }
                    catch (BAMException e) {
                        log.error((Object)("Error fetching namespace for xpath id " + xpathConfig.getId() + ". No namespaces will be available.."), (Throwable)e);
                    }
                }
            }
            catch (BAMException e) {
                log.error((Object)("Error fetching xpath configurations for server id " + serverId));
                throw new BAMException("Filter processing failed at xpath filters..", (Throwable)e);
            }
        }
        return this.getAleauditMessagesForSAP(startTimeSelection, endTimeSelection, server, service, operation, direction, status, messageTypeSelection, messageFormatSelection, applicationStatusSelection, technicalStatusSelection, messageGUID, xpathExpression, value, namespaces, startDataset, endDataset);
    }

    public int getCountofChildrenFailedMessages(int activityKeyID) throws BAMException {
        try {
            StringBuilder result = new StringBuilder();
            int count = this.bamDSClient.getCountofChildrenFailedMessages(activityKeyID);
            if (count > 0) {
                return count;
            }
        }
        catch (Exception e) {
            throw new BAMException("failed to getCountofChildrenFailedMessages ", (Throwable)e);
        }
        return 0;
    }

    public String getCountofChildrenFailedMessagesString(int activityKeyID) throws BAMException {
        StringBuilder result = new StringBuilder();
        try {
            int count = this.bamDSClient.getCountofChildrenFailedMessages(activityKeyID);
            result.append("<FailedMessageCount>");
            result.append(count);
            result.append("</FailedMessageCount>\n");
        }
        catch (Exception e) {
            throw new BAMException("failed to getCountofChildrenFailedMessages ", (Throwable)e);
        }
        return result.toString();
    }
}

