/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.gauges.ui;

import java.rmi.RemoteException;
import java.util.Calendar;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.stub.statquery.Endpoint;
import org.wso2.carbon.bam.stub.statquery.ProxyService;
import org.wso2.carbon.bam.stub.statquery.Sequence;
import org.wso2.carbon.bam.stub.summaryquery.BAMSummaryQueryDSStub;
import org.wso2.carbon.bam.stub.summaryquery.MedSummaryStat;
import org.wso2.carbon.bam.stub.summaryquery.SummaryStat;
import org.wso2.carbon.bam.util.BAMCalendar;

public class BAMSummaryQueryDSClient {
    private static final Log log = LogFactory.getLog(BAMSummaryQueryDSClient.class);
    private BAMSummaryQueryDSStub stub;
    private static final String BAM_SUMMARY_QUERY_DS = "BAMSummaryQueryDS";

    public BAMSummaryQueryDSClient(String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL.startsWith("local:/") ? "local://services/BAMSummaryQueryDS" : backendServerURL + BAM_SUMMARY_QUERY_DS;
        this.stub = new BAMSummaryQueryDSStub(configCtx, serviceURL);
    }

    public BAMSummaryQueryDSClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL.startsWith("local:/") ? "local://servicesBAMSummaryQueryDS" : backendServerURL + BAM_SUMMARY_QUERY_DS;
        this.stub = new BAMSummaryQueryDSStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public SummaryStat[] getServerStatHourlySummaries(int serverId, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getServerStatHourlySummaries(serverId, BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getServerStatDailySummaries(int serverId, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getServerStatDailySummaries(serverId, BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getServerStatMonthlySummaries(int serverId, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getServerStatMonthlySummaries(serverId, BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getServerStatQuarterlySummaries(int serverId, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getServerStatQuarterlySummaries(serverId, BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getServerStatYearlySummaries(int serverId, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getServerStatYearlySummaries(serverId, BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getServiceStatHourlySummaries(int serviceId, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getServiceStatHourlySummaries(serviceId, BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getServiceStatDailySummaries(int serviceId, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getServiceStatDailySummaries(serviceId, BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getServiceStatMonthlySummaries(int serviceId, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getServiceStatMonthlySummaries(serviceId, BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getServiceStatQuarterlySummaries(int serviceId, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getServiceStatQuarterlySummaries(serviceId, BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getServiceStatYearlySummaries(int serviceId, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getServiceStatYearlySummaries(serviceId, BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getOperationStatHourlySummaries(int operationId, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getOperationStatHourlySummaries(operationId, BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getOperationStatDailySummaries(int operationId, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getOperationStatDailySummaries(operationId, BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getOperationStatMonthlySummaries(int operationId, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getOperationStatMonthlySummaries(operationId, BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getOperationStatQuarterlySummaries(int operationId, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getOperationStatQuarterlySummaries(operationId, BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public SummaryStat[] getOperationStatYearlySummaries(int operationId, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getOperationStatYearlySummaries(operationId, BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getEndpointStatHourlySummaries(int serverId, Endpoint endpoint, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getEndpointStatHourlySummaries(serverId, endpoint.getEndpoint(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getEndpointStatDailySummaries(int serverId, Endpoint endpoint, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getEndpointStatDailySummaries(serverId, endpoint.getEndpoint(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getEndpointStatMonthlySummaries(int serverId, Endpoint endpoint, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getEndpointStatMonthlySummaries(serverId, endpoint.getEndpoint(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getEndpointStatQuarterlySummaries(int serverId, Endpoint endpoint, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getEndpointStatQuarterlySummaries(serverId, endpoint.getEndpoint(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getEndpointStatYearlySummaries(int serverId, Endpoint endpoint, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getEndpointStatQuarterlySummaries(serverId, endpoint.getEndpoint(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getSequenceStatHourlySummaries(int serverId, Sequence sequence, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getSequenceStatHourlySummaries(serverId, sequence.getSequence(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getSequenceStatDailySummaries(int serverId, Sequence sequence, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getSequenceStatDailySummaries(serverId, sequence.getSequence(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getSequenceStatMonthlySummaries(int serverId, Sequence sequence, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getSequenceStatMonthlySummaries(serverId, sequence.getSequence(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getSequenceStatQuarterlySummaries(int serverId, Sequence sequence, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getSequenceStatQuarterlySummaries(serverId, sequence.getSequence(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getSequenceStatYearlySummaries(int serverId, Sequence sequence, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getSequenceStatQuarterlySummaries(serverId, sequence.getSequence(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getProxyStatHourlySummaries(int serverId, ProxyService proxy, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getProxyStatHourlySummaries(serverId, proxy.getProxyService(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getProxyStatDailySummaries(int serverId, ProxyService proxy, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getProxyStatDailySummaries(serverId, proxy.getProxyService(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getProxyStatMonthlySummaries(int serverId, ProxyService proxy, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getProxyStatMonthlySummaries(serverId, proxy.getProxyService(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getProxyStatQuarterlySummaries(int serverId, ProxyService proxy, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getProxyStatQuarterlySummaries(serverId, proxy.getProxyService(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }

    public MedSummaryStat[] getProxyStatYearlySummaries(int serverId, ProxyService proxy, Calendar startTime, Calendar endTime) throws RemoteException {
        return this.stub.getProxyStatQuarterlySummaries(serverId, proxy.getProxyService(), "In", BAMCalendar.getInstance((Calendar)startTime).getBAMTimestamp(), BAMCalendar.getInstance((Calendar)endTime).getBAMTimestamp());
    }
}

