/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.gauges.ui;

import java.net.SocketException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.gauges.ui.BAMStatQueryDSClient;
import org.wso2.carbon.bam.stub.statquery.Count;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class ResponseTimesManager {
    private static final Log log = LogFactory.getLog(ResponseTimesManager.class);
    BAMStatQueryDSClient bamDSClient;

    public ResponseTimesManager(ServletConfig config, HttpSession session, HttpServletRequest request) throws AxisFault, SocketException {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        this.bamDSClient = new BAMStatQueryDSClient(cookie, backendServerURL, configContext, request.getLocale());
    }

    public String getAvgResponseTime(int serviceID) {
        String value;
        String range = "1000";
        try {
            value = this.bamDSClient.getAvgResponseTime(serviceID);
            if (value == null) {
                value = "0";
            } else {
                int dVal = (int)Double.parseDouble(value);
                if (dVal < 10) {
                    range = "10";
                } else if (dVal < 100) {
                    range = "100";
                } else if (dVal < 1000) {
                    range = "1000";
                } else if (dVal < 0) {
                    dVal = 0;
                } else {
                    dVal = 1000;
                    range = "1000";
                }
                value = "" + dVal;
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
            value = "0";
        }
        return "&value=" + value + "&range=" + range;
    }

    public String getMinResponseTimeSystem(int serverID) {
        String value = "0";
        try {
            value = "0";
            if (value == null) {
                value = "0";
            } else {
                int dVal = (int)Double.parseDouble(value);
                if (dVal > 1000) {
                    dVal = 1000;
                } else if (dVal < 0) {
                    dVal = 0;
                }
                value = "" + dVal;
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
            value = "0";
        }
        return value;
    }

    public String getMaxResponseTimeSystem(String serverUrl) {
        String value = "0";
        try {
            value = "0";
            if (value == null) {
                value = "0";
            } else {
                int dVal = (int)Double.parseDouble(value);
                if (dVal > 1000) {
                    dVal = 1000;
                } else if (dVal < 0) {
                    dVal = 0;
                }
                value = "" + dVal;
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
            value = "0";
        }
        return value;
    }

    public String getAvgResponseTimeSystem(String serverUrl) {
        String value = "0";
        try {
            value = "0";
            if (value == null) {
                value = "0";
            } else {
                int dVal = (int)Double.parseDouble(value);
                if (dVal > 1000) {
                    dVal = 1000;
                } else if (dVal < 0) {
                    dVal = 0;
                }
                value = "" + dVal;
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
            value = "0";
        }
        return value;
    }

    public String getAvgResponseTimeSystem() {
        String resp = "100";
        return resp;
    }

    public String getMaxResponseTime(int serviceID) {
        String value = "0";
        try {
            value = this.bamDSClient.getMaxResponseTime(serviceID);
            if (value == null) {
                value = "0";
            } else {
                int dVal = (int)Double.parseDouble(value);
                if (dVal > 1000) {
                    dVal = 1000;
                } else if (dVal < 0) {
                    dVal = 0;
                }
                value = "" + dVal;
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
            value = "0";
        }
        return value;
    }

    public String getMinResponseTime(int serviceID) {
        String value = "0";
        try {
            value = this.bamDSClient.getMinResponseTime(serviceID);
            if (value == null) {
                value = "0";
            } else {
                int dVal = (int)Double.parseDouble(value);
                if (dVal > 1000) {
                    dVal = 1000;
                } else if (dVal < 0) {
                    dVal = 0;
                }
                value = "" + dVal;
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
            value = "0";
        }
        return value;
    }

    public String getLastMinuteRequestCount(int serviceID) {
        String resp = "";
        try {
            Count[] response = this.bamDSClient.getLastMinuteRequestCount(serviceID);
            if (response != null) {
                return response[0].getCount();
            }
        }
        catch (Exception e) {
            log.debug((Object)e);
        }
        return "0";
    }

    public String getMinMaxAverageRespTimesService(int serviceID) throws BAMException {
        String minVal = "0";
        String maxVal = "0";
        String avgVal = "0";
        minVal = this.bamDSClient.getMinResponseTime(serviceID);
        maxVal = this.bamDSClient.getMaxResponseTime(serviceID);
        avgVal = this.bamDSClient.getAvgResponseTime(serviceID);
        return minVal + "&" + maxVal + "&" + avgVal;
    }
}

