/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.gauges.ui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.bam.stub.statquery.Activity;
import org.wso2.carbon.bam.stub.statquery.ActivityForServer;
import org.wso2.carbon.bam.stub.statquery.ActivityForTime;
import org.wso2.carbon.bam.stub.statquery.ActivityGroupForTime;
import org.wso2.carbon.bam.stub.statquery.ActivityInfo;
import org.wso2.carbon.bam.stub.statquery.ActivityOperation;
import org.wso2.carbon.bam.stub.statquery.AleauditFailCount;
import org.wso2.carbon.bam.stub.statquery.AllMessagesForActivity;
import org.wso2.carbon.bam.stub.statquery.AverageTime;
import org.wso2.carbon.bam.stub.statquery.BAMStatQueryDSStub;
import org.wso2.carbon.bam.stub.statquery.ClientServiceOperationInfo;
import org.wso2.carbon.bam.stub.statquery.Count;
import org.wso2.carbon.bam.stub.statquery.CountofChildrenFailedMessage;
import org.wso2.carbon.bam.stub.statquery.CumulativeCount;
import org.wso2.carbon.bam.stub.statquery.Data;
import org.wso2.carbon.bam.stub.statquery.DirectionForOperation;
import org.wso2.carbon.bam.stub.statquery.Endpoint;
import org.wso2.carbon.bam.stub.statquery.FaultCount;
import org.wso2.carbon.bam.stub.statquery.FullActivityData;
import org.wso2.carbon.bam.stub.statquery.JmxMetricsInfo;
import org.wso2.carbon.bam.stub.statquery.MaximumTime;
import org.wso2.carbon.bam.stub.statquery.Message;
import org.wso2.carbon.bam.stub.statquery.MessageCount;
import org.wso2.carbon.bam.stub.statquery.MessageData;
import org.wso2.carbon.bam.stub.statquery.MessageForMessageID;
import org.wso2.carbon.bam.stub.statquery.MessageForOperation;
import org.wso2.carbon.bam.stub.statquery.MessageId;
import org.wso2.carbon.bam.stub.statquery.MinimumTime;
import org.wso2.carbon.bam.stub.statquery.Num;
import org.wso2.carbon.bam.stub.statquery.Operation;
import org.wso2.carbon.bam.stub.statquery.OperationForService;
import org.wso2.carbon.bam.stub.statquery.OperationInfo;
import org.wso2.carbon.bam.stub.statquery.OperationList;
import org.wso2.carbon.bam.stub.statquery.OriginalFailCount;
import org.wso2.carbon.bam.stub.statquery.Property;
import org.wso2.carbon.bam.stub.statquery.PropertyBag;
import org.wso2.carbon.bam.stub.statquery.PropertyChildForActivity;
import org.wso2.carbon.bam.stub.statquery.PropertyKeyForActivity;
import org.wso2.carbon.bam.stub.statquery.ProxyService;
import org.wso2.carbon.bam.stub.statquery.ReplayedFailRequestCount;
import org.wso2.carbon.bam.stub.statquery.ReplayedFailResponseCount;
import org.wso2.carbon.bam.stub.statquery.SAPaleaudit;
import org.wso2.carbon.bam.stub.statquery.SAPchild;
import org.wso2.carbon.bam.stub.statquery.SAPcount;
import org.wso2.carbon.bam.stub.statquery.Sequence;
import org.wso2.carbon.bam.stub.statquery.Server;
import org.wso2.carbon.bam.stub.statquery.ServerForActivity;
import org.wso2.carbon.bam.stub.statquery.Service;
import org.wso2.carbon.bam.stub.statquery.ServiceForServer;
import org.wso2.carbon.bam.stub.statquery.Status;
import org.wso2.carbon.bam.stub.statquery.Time;
import org.wso2.carbon.bam.stub.statquery.TimeStampForOperation;
import org.wso2.carbon.bam.util.BAMException;
import org.wso2.carbon.ui.CarbonUIUtil;

public class BAMStatQueryDSClient {
    private static final Log log = LogFactory.getLog(BAMStatQueryDSClient.class);
    BAMStatQueryDSStub stub;

    public BAMStatQueryDSClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "BAMStatQueryDS";
        this.stub = new BAMStatQueryDSStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public BAMStatQueryDSClient(ServletConfig config, HttpSession session, HttpServletRequest request) throws AxisFault {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String serviceURL = backendServerURL + "BAMStatQueryDS";
        this.stub = new BAMStatQueryDSStub(configContext, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public Count[] getLastMinuteRequestCount(int serviceID) throws RemoteException {
        return this.stub.getLastMinuteRequestCount(serviceID);
    }

    public String getAvgResponseTime(int serviceID) throws BAMException {
        try {
            Time[] times = this.stub.getAvgResponseTime(serviceID);
            String avgTime = null;
            if (times != null) {
                avgTime = times[0].getTime();
            }
            return avgTime;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getAvgResponseTime -bam.gauges ", (Throwable)e);
        }
    }

    public String getMinResponseTime(int serviceID) throws BAMException {
        try {
            Time[] times = this.stub.getMinResponseTime(serviceID);
            String minTime = null;
            if (times != null) {
                minTime = times[0].getTime();
            }
            return minTime;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getMinResponseTime -bam.gauges ", (Throwable)e);
        }
    }

    public String getMaxResponseTime(int serviceID) throws BAMException {
        try {
            String maxTime = null;
            Time[] times = this.stub.getMaxResponseTime(serviceID);
            if (times != null) {
                maxTime = times[0].getTime();
            }
            return maxTime;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getMaxResponseTime -bam.gauges ", (Throwable)e);
        }
    }

    public String getValueRangePair(String value) {
        int iValue = (int)Double.parseDouble(value);
        int range = (iValue / 10 + 1) * 10;
        return "&value=" + value + "&range=" + range + "&";
    }

    public String getLatestAverageResponseTimeForServer(int serverID) throws BAMException {
        String value = "0";
        try {
            Time[] times = this.stub.getLatestAverageResponseTimeForServer(serverID);
            if (times != null) {
                value = times[0].getTime();
            }
            return this.getValueRangePair(value);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestAverageResponseTimeForServer -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestMaximumResponseTimeForServer(int serverID) throws BAMException {
        String value = "0";
        try {
            Time[] times = this.stub.getLatestMaximumResponseTimeForServer(serverID);
            if (times != null) {
                value = times[0].getTime();
            }
            return this.getValueRangePair(value);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestMaximumResponseTimeForServer -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestMinimumResponseTimeForServer(int serverID) throws BAMException {
        String value = "0";
        try {
            Time[] times = this.stub.getLatestMinimumResponseTimeForServer(serverID);
            if (times != null) {
                value = times[0].getTime();
            }
            return this.getValueRangePair(value);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestMinimumResponseTimeForServer -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestRequestCountForServer(int serverID) throws BAMException {
        try {
            String count = null;
            Count[] counts = this.stub.getLatestRequestCountForServer(serverID);
            if (counts != null) {
                count = counts[0].getCount();
            }
            return count;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestRequestCountForServer -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestResponseCountForServer(int serverID) throws BAMException {
        try {
            String count = null;
            Count[] counts = this.stub.getLatestResponseCountForServer(serverID);
            if (counts != null) {
                count = counts[0].getCount();
            }
            return count;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestResponseCountForServer -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestFaultCountForServer(int serverID) throws BAMException {
        try {
            String count = null;
            Count[] counts = this.stub.getLatestFaultCountForServer(serverID);
            if (counts != null) {
                count = counts[0].getCount();
            }
            return count;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestFaultCountForServer -bam.gauges ", (Throwable)e);
        }
    }

    public Data getLatestDataForServer(int serverID) throws BAMException {
        try {
            Data data = null;
            Data[] datas = this.stub.getLatestDataForServer(serverID);
            if (datas != null) {
                data = datas[0];
            }
            return data;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestDataForServer -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestAverageResponseTimeForService(int serviceID) throws BAMException {
        String value = "0";
        try {
            Time[] times = this.stub.getLatestAverageResponseTimeForService(serviceID);
            if (times != null) {
                value = times[0].getTime();
            }
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestAverageResponseTimeForService -bam.gauges ", (Throwable)e);
        }
        return this.getValueRangePair(value);
    }

    public String getLatestMaximumResponseTimeForService(int serviceID) throws BAMException {
        String value = "0";
        try {
            Time[] times = this.stub.getLatestMaximumResponseTimeForService(serviceID);
            if (times != null) {
                value = times[0].getTime();
            }
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestMaximumResponseTimeForService -bam.gauges ", (Throwable)e);
        }
        return this.getValueRangePair(value);
    }

    public String getLatestMinimumResponseTimeForService(int serviceID) throws BAMException {
        String value = "0";
        try {
            Time[] times = this.stub.getLatestMinimumResponseTimeForService(serviceID);
            if (times != null) {
                value = times[0].getTime();
            }
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestMinimumResponseTimeForService -bam.gauges ", (Throwable)e);
        }
        return this.getValueRangePair(value);
    }

    public String getLatestRequestCountForService(int serviceID) throws BAMException {
        try {
            String count = null;
            Count[] counts = this.stub.getLatestRequestCountForService(serviceID);
            if (counts != null) {
                count = counts[0].getCount();
            }
            return count;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestRequestCountForService -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestResponseCountForService(int serviceID) throws BAMException {
        try {
            String count = null;
            Count[] counts = this.stub.getLatestResponseCountForService(serviceID);
            if (counts != null) {
                count = counts[0].getCount();
            }
            return count;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestResponseCountForService -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestFaultCountForService(int serviceID) throws BAMException {
        try {
            String count = null;
            Count[] counts = this.stub.getLatestFaultCountForService(serviceID);
            if (counts != null) {
                count = counts[0].getCount();
            }
            return count;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestFaultCountForService -bam.gauges ", (Throwable)e);
        }
    }

    public Data getLatestDataForService(int serviceID) throws BAMException {
        try {
            Data[] datas = this.stub.getLatestDataForService(serviceID);
            Data data = null;
            if (datas != null) {
                data = datas[0];
            }
            return data;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestDataForService -bam.gauges ", (Throwable)e);
        }
    }

    public Operation[] getOperations(int serviceID) throws BAMException {
        try {
            return this.stub.getOperations(serviceID);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getOperations -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestAverageResponseTimeForOperation(int operationID) throws BAMException {
        try {
            String time = null;
            Time[] times = this.stub.getLatestAverageResponseTimeForOperation(operationID);
            if (times != null) {
                time = times[0].getTime();
            }
            return time;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestAverageResponseTimeForOperation -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestMaximumResponseTimeForOperation(int operationID) throws BAMException {
        try {
            String time = null;
            Time[] times = this.stub.getLatestMaximumResponseTimeForOperation(operationID);
            if (times != null) {
                time = times[0].getTime();
            }
            return time;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestMaximumResponseTimeForOperation -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestMinimumResponseTimeForOperation(int operationID) throws BAMException {
        try {
            String time = null;
            Time[] times = this.stub.getLatestMinimumResponseTimeForOperation(operationID);
            if (times != null) {
                time = times[0].getTime();
            }
            return time;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestMinimumResponseTimeForOperation -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestRequestCountForOperation(int operationID) throws BAMException {
        try {
            String count = null;
            Count[] counts = this.stub.getLatestRequestCountForOperation(operationID);
            if (counts != null) {
                count = counts[0].getCount();
            }
            return count;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestRequestCountForOperation -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestResponseCountForOperation(int operationID) throws BAMException {
        try {
            String count = null;
            Count[] counts = this.stub.getLatestResponseCountForOperation(operationID);
            if (counts != null) {
                count = counts[0].getCount();
            }
            return count;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestResponseCountForOperation -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestFaultCountForOperation(int operationID) throws BAMException {
        try {
            String count = null;
            Count[] counts = this.stub.getLatestFaultCountForOperation(operationID);
            if (counts != null) {
                count = counts[0].getCount();
            }
            return count;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestFaultCountForOperation -bam.gauges ", (Throwable)e);
        }
    }

    public Data getLatestDataForOperation(int operationID) throws BAMException {
        try {
            Data data = null;
            Data[] datas = this.stub.getLatestDataForOperation(operationID);
            if (datas != null) {
                data = datas[0];
            }
            return data;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestDataForOperation -bam.gauges ", (Throwable)e);
        }
    }

    public Endpoint[] getEndpoints(int serverID) throws RemoteException {
        try {
            return this.stub.getEndpoints(serverID);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public String getLatestInAverageProcessingTimeForEndpoint(int serverID, String endpointName) throws BAMException {
        String value = "0";
        try {
            AverageTime[] averageTime = this.stub.getLatestInAverageProcessingTimeForEndpoint(serverID, endpointName);
            if (averageTime != null) {
                value = averageTime[0].getAverageTime();
            }
            return this.getValueRangePair(value);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInAverageProcessingTimeForEndpoint -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestInMaximumProcessingTimeForEndpoint(int serverID, String endpointName) throws BAMException {
        String value = "0";
        try {
            MaximumTime[] maximumTime = this.stub.getLatestInMaximumProcessingTimeForEndpoint(serverID, endpointName);
            if (maximumTime != null) {
                value = maximumTime[0].getMaximumTime();
            }
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInMaximumProcessingTimeForEndpoint -bam.gauges ", (Throwable)e);
        }
        return this.getValueRangePair(value);
    }

    public String getLatestInMinimumProcessingTimeForEndpoint(int serverID, String endpointName) throws BAMException {
        String value = "0";
        try {
            MinimumTime[] minimumTime = this.stub.getLatestInMinimumProcessingTimeForEndpoint(serverID, endpointName);
            if (minimumTime != null) {
                value = minimumTime[0].getMinimumTime();
            }
            return this.getValueRangePair(value);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInMinimumProcessingTimeForEndpoint -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestInAverageProcessingTimeForEndpointNoWrap(int serverID, String endpointName) throws BAMException {
        String value = "0";
        try {
            AverageTime[] averageTime = this.stub.getLatestInAverageProcessingTimeForEndpoint(serverID, endpointName);
            if (averageTime != null) {
                value = averageTime[0].getAverageTime();
            }
            return value;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInAverageProcessingTimeForEndpoint -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestInMaximumProcessingTimeForEndpointNoWrap(int serverID, String endpointName) throws BAMException {
        String value = "0";
        try {
            MaximumTime[] maximumTime = this.stub.getLatestInMaximumProcessingTimeForEndpoint(serverID, endpointName);
            if (maximumTime != null) {
                value = maximumTime[0].getMaximumTime();
            }
            return value;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInMaximumProcessingTimeForEndpoint -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestInMinimumProcessingTimeForEndpointNoWrap(int serverID, String endpointName) throws BAMException {
        String value = "0";
        try {
            MinimumTime[] minimumTime = this.stub.getLatestInMinimumProcessingTimeForEndpoint(serverID, endpointName);
            if (minimumTime != null) {
                value = minimumTime[0].getMinimumTime();
            }
            return value;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInMinimumProcessingTimeForEndpoint -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestInCumulativeCountForEndpoint(int serverID, String endpointName) throws BAMException {
        try {
            String count = null;
            CumulativeCount[] cumulativeCount = this.stub.getLatestInCumulativeCountForEndpoint(serverID, endpointName);
            if (cumulativeCount != null) {
                count = cumulativeCount[0].getCumulativeCount();
            }
            return count;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInCumulativeCountForEndpoint -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestInFaultCountForEndpoint(int serverID, String endpointName) throws BAMException {
        try {
            String count = null;
            FaultCount[] faultCount = this.stub.getLatestInFaultCountForEndpoint(serverID, endpointName);
            if (faultCount != null) {
                count = faultCount[0].getFaultCount();
            }
            return count;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInFaultCountForEndpoint -bam.gauges ", (Throwable)e);
        }
    }

    public Sequence[] getSequences(int serverID) throws BAMException {
        try {
            return this.stub.getSequences(serverID);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getSequences -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestInAverageProcessingTimeForSequence(int serverID, String sequenceName) throws BAMException {
        String value = "0";
        try {
            AverageTime[] averageTime = this.stub.getLatestInAverageProcessingTimeForSequence(serverID, sequenceName);
            if (averageTime != null) {
                value = averageTime[0].getAverageTime();
            }
            return this.getValueRangePair(value);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInAverageProcessingTimeForSequence -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestInMaximumProcessingTimeForSequence(int serverID, String sequenceName) throws BAMException {
        String value = "0";
        try {
            MaximumTime[] maximumTime = this.stub.getLatestInMaximumProcessingTimeForSequence(serverID, sequenceName);
            if (maximumTime != null) {
                value = maximumTime[0].getMaximumTime();
            }
            return this.getValueRangePair(value);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInMaximumProcessingTimeForSequence -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestInMinimumProcessingTimeForSequence(int serverID, String sequenceName) throws BAMException {
        String value = "0";
        try {
            MinimumTime[] minimumTime = this.stub.getLatestInMinimumProcessingTimeForSequence(serverID, sequenceName);
            if (minimumTime != null) {
                value = minimumTime[0].getMinimumTime();
            }
            return this.getValueRangePair(value);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInMinimumProcessingTimeForSequence -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestInAverageProcessingTimeForSequenceNoWrap(int serverID, String sequenceName) throws BAMException {
        String value = "0";
        try {
            AverageTime[] averageTime = this.stub.getLatestInAverageProcessingTimeForSequence(serverID, sequenceName);
            if (averageTime != null) {
                value = averageTime[0].getAverageTime();
            }
            return value;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInAverageProcessingTimeForSequence -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestInMaximumProcessingTimeForSequenceNoWrap(int serverID, String sequenceName) throws BAMException {
        String value = "0";
        try {
            MaximumTime[] maximumTime = this.stub.getLatestInMaximumProcessingTimeForSequence(serverID, sequenceName);
            if (maximumTime != null) {
                value = maximumTime[0].getMaximumTime();
            }
            return value;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInMaximumProcessingTimeForSequence -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestInMinimumProcessingTimeForSequenceNoWrap(int serverID, String sequenceName) throws BAMException {
        String value = "0";
        try {
            MinimumTime[] minimumTime = this.stub.getLatestInMinimumProcessingTimeForSequence(serverID, sequenceName);
            if (minimumTime != null) {
                value = minimumTime[0].getMinimumTime();
            }
            return value;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInMinimumProcessingTimeForSequence -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestInCumulativeCountForSequence(int serverID, String sequenceName) throws BAMException {
        try {
            String count = null;
            CumulativeCount[] cumulativeCount = this.stub.getLatestInCumulativeCountForSequence(serverID, sequenceName);
            if (cumulativeCount != null) {
                count = cumulativeCount[0].getCumulativeCount();
            }
            return count;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInCumulativeCountForSequence -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestInFaultCountForSequence(int serverID, String sequenceName) throws BAMException {
        try {
            String count = null;
            FaultCount[] faultCounts = this.stub.getLatestInFaultCountForSequence(serverID, sequenceName);
            if (faultCounts != null) {
                count = faultCounts[0].getFaultCount();
            }
            return count;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInFaultCountForSequence -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestOutAverageProcessingTimeForSequence(int serverID, String sequenceName) throws BAMException {
        String value = "0";
        try {
            AverageTime[] averageTime = this.stub.getLatestOutAverageProcessingTimeForSequence(serverID, sequenceName);
            if (averageTime != null) {
                value = averageTime[0].getAverageTime();
            }
            return this.getValueRangePair(value);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestOutAverageProcessingTimeForSequence -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestOutMaximumProcessingTimeForSequence(int serverID, String sequenceName) throws BAMException {
        String value = "0";
        try {
            MaximumTime[] maximumTime = this.stub.getLatestOutMaximumProcessingTimeForSequence(serverID, sequenceName);
            if (maximumTime != null) {
                value = maximumTime[0].getMaximumTime();
            }
            return this.getValueRangePair(value);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestOutMaximumProcessingTimeForSequence -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestOutMinimumProcessingTimeForSequence(int serverID, String sequenceName) throws BAMException {
        String value = "0";
        try {
            MinimumTime[] minimumTime = this.stub.getLatestOutMinimumProcessingTimeForSequence(serverID, sequenceName);
            if (minimumTime != null) {
                value = minimumTime[0].getMinimumTime();
            }
            return this.getValueRangePair(value);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestOutMinimumProcessingTimeForSequence -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestOutCumulativeCountForSequence(int serverID, String sequenceName) throws BAMException {
        try {
            String count = null;
            CumulativeCount[] cumulativeCount = this.stub.getLatestOutCumulativeCountForSequence(serverID, sequenceName);
            if (cumulativeCount != null) {
                count = cumulativeCount[0].getCumulativeCount();
            }
            return count;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestOutCumulativeCountForSequence -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestOutFaultCountForSequence(int serverID, String sequenceName) throws BAMException {
        try {
            String count = null;
            FaultCount[] faultCount = this.stub.getLatestOutFaultCountForSequence(serverID, sequenceName);
            if (faultCount != null) {
                count = faultCount[0].getFaultCount();
            }
            return count;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestOutFaultCountForSequence -bam.gauges ", (Throwable)e);
        }
    }

    public ProxyService[] getProxyServices(int serverID) throws BAMException {
        try {
            return this.stub.getProxyServices(serverID);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getProxyServices -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestInAverageProcessingTimeForProxy(int serverID, String proxyName) throws BAMException {
        String value = "0";
        try {
            AverageTime[] averageTime = this.stub.getLatestInAverageProcessingTimeForProxy(serverID, proxyName);
            if (averageTime != null) {
                value = averageTime[0].getAverageTime();
            }
            return this.getValueRangePair(value);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getProxyServices -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestInMaximumProcessingTimeForProxy(int serverID, String proxyName) throws BAMException {
        String value = "0";
        try {
            MaximumTime[] maximumTime = this.stub.getLatestInMaximumProcessingTimeForProxy(serverID, proxyName);
            if (maximumTime != null) {
                value = maximumTime[0].getMaximumTime();
            }
            return this.getValueRangePair(value);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInMaximumProcessingTimeForProxy -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestInMinimumProcessingTimeForProxy(int serverID, String proxyName) throws BAMException {
        String value = "0";
        try {
            MinimumTime[] minimumTime = this.stub.getLatestInMinimumProcessingTimeForProxy(serverID, proxyName);
            if (minimumTime != null) {
                value = minimumTime[0].getMinimumTime();
            }
            return this.getValueRangePair(value);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInMinimumProcessingTimeForProxy -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestInAverageProcessingTimeForProxyNoWrap(int serverID, String proxyName) throws BAMException {
        String value = "0";
        try {
            AverageTime[] averageTime = this.stub.getLatestInAverageProcessingTimeForProxy(serverID, proxyName);
            if (averageTime != null) {
                value = averageTime[0].getAverageTime();
            }
            return value;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInAverageProcessingTimeForProxy -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestInMaximumProcessingTimeForProxyNoWrap(int serverID, String proxyName) throws BAMException {
        String value = "0";
        try {
            MaximumTime[] maximumTime = this.stub.getLatestInMaximumProcessingTimeForProxy(serverID, proxyName);
            if (maximumTime != null) {
                value = maximumTime[0].getMaximumTime();
            }
            return value;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInMaximumProcessingTimeForProxy -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestInMinimumProcessingTimeForProxyNoWrap(int serverID, String proxyName) throws BAMException {
        String value = "0";
        try {
            MinimumTime[] minimumTime = this.stub.getLatestInMinimumProcessingTimeForProxy(serverID, proxyName);
            if (minimumTime != null) {
                value = minimumTime[0].getMinimumTime();
            }
            return value;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInMinimumProcessingTimeForProxy -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestInCumulativeCountForProxy(int serverID, String proxyName) throws BAMException {
        try {
            String count = null;
            CumulativeCount[] cumulativeCount = this.stub.getLatestInCumulativeCountForProxy(serverID, proxyName);
            if (cumulativeCount != null) {
                count = cumulativeCount[0].getCumulativeCount();
            }
            return count;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInMinimumProcessingTimeForProxy -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestInFaultCountForProxy(int serverID, String proxyName) throws BAMException {
        try {
            String count = null;
            FaultCount[] faultCounts = this.stub.getLatestInFaultCountForProxy(serverID, proxyName);
            if (faultCounts != null) {
                count = faultCounts[0].getFaultCount();
            }
            return count;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInFaultCountForProxy -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestOutAverageProcessingTimeForProxy(int serverID, String proxyName) throws BAMException {
        String value = "0";
        try {
            AverageTime[] averageTime = this.stub.getLatestOutAverageProcessingTimeForProxy(serverID, proxyName);
            if (averageTime != null) {
                value = averageTime[0].getAverageTime();
            }
            return this.getValueRangePair(value);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestInFaultCountForProxy -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestOutMaximumProcessingTimeForProxy(int serverID, String proxyName) throws BAMException {
        String value = "0";
        try {
            MaximumTime[] maximumTime = this.stub.getLatestOutMaximumProcessingTimeForProxy(serverID, proxyName);
            if (maximumTime != null) {
                value = maximumTime[0].getMaximumTime();
            }
            return this.getValueRangePair(value);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestOutMaximumProcessingTimeForProxy -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestOutMinimumProcessingTimeForProxy(int serverID, String proxyName) throws BAMException {
        String value = "0";
        try {
            MinimumTime[] minimumTime = this.stub.getLatestOutMinimumProcessingTimeForProxy(serverID, proxyName);
            if (minimumTime != null) {
                value = minimumTime[0].getMinimumTime();
            }
            return this.getValueRangePair(value);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestOutMinimumProcessingTimeForProxy -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestOutCumulativeCountForProxy(int serverID, String proxyName) throws BAMException {
        try {
            String count = null;
            CumulativeCount[] cumulativeCount = this.stub.getLatestOutCumulativeCountForProxy(serverID, proxyName);
            if (cumulativeCount != null) {
                count = cumulativeCount[0].getCumulativeCount();
            }
            return count;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestOutCumulativeCountForProxy -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestOutFaultCountForProxy(int serverID, String proxyName) throws BAMException {
        try {
            FaultCount[] faultCount = this.stub.getLatestOutFaultCountForProxy(serverID, proxyName);
            String count = null;
            if (faultCount != null) {
                count = faultCount[0].getFaultCount();
            }
            return count;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getLatestOutFaultCountForProxy -bam.gauges ", (Throwable)e);
        }
    }

    public String getLatestMaximumOperationsForAnActivityID(int activityID) throws BAMException {
        try {
            String count = null;
            Num[] nums = this.stub.getMaximumOperationsForAnActivityID(activityID);
            if (nums != null) {
                count = nums[0].getNum();
            }
            return count;
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getMaximumOperationsForAnActivityID -bam.gauges ", (Throwable)e);
        }
    }

    public ActivityOperation[] getOperationsForActivityID(int activityID) throws RemoteException {
        try {
            return this.stub.getOperationForActivityID(activityID);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Message[] getMessagesForOperationIDAndActivityID(int operationID, int activityID) throws BAMException {
        try {
            return this.stub.getMessagesForOperationIDAndActivityID(operationID, activityID);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getMessagesForOperationIDAndActivityID -bam.gauges ", (Throwable)e);
        }
    }

    public ActivityInfo[] getActivityInfoForActivityID(int activityKeyId) throws BAMException {
        try {
            return this.stub.getActivityInfoForActivityID(activityKeyId);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getActivityInfoForActivityID -bam.gauges ", (Throwable)e);
        }
    }

    public OperationInfo[] getOperationInfoForActivityID(int activityKeyId) throws BAMException {
        try {
            return this.stub.getOperationInfoForActivityID(activityKeyId);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getOperationInfoForActivityID -bam.gauges ", (Throwable)e);
        }
    }

    public JmxMetricsInfo[] getJMXMetricsWindow(int serverID) throws BAMException {
        try {
            return this.stub.getJMXMetricsWindow(serverID);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getJMXMetricsWindow -bam.gauges ", (Throwable)e);
        }
    }

    public ClientServiceOperationInfo[] getClientServiceOperation(int serverID) throws BAMException {
        try {
            return this.stub.getClientServiceOperation(serverID);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getClientServiceOperation -bam.gauges ", (Throwable)e);
        }
    }

    public Service[] getServiceForServer(int serverID, String serviceName) throws BAMException {
        try {
            return this.stub.getServiceForServer(serverID, serviceName);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getServiceForServer -bam.gauges ", (Throwable)e);
        }
    }

    public Activity[] getDetailsForActivity(String activityName) throws BAMException {
        try {
            return this.stub.getDetailsForActivity(activityName);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getDetailsForActivity -bam.gauges ", (Throwable)e);
        }
    }

    public ActivityForTime[] getActivityDetailsForTimeRange(String startTime, String endTime, String propertyKey1, String propertyValue1, String propertyKey2, String propertyValue2, String propertyKey3, String propertyValue3) throws BAMException {
        try {
            return this.stub.getActivityDetailsForTimeRange(startTime, endTime, propertyKey1, propertyValue1, propertyKey2, propertyValue2, propertyKey3, propertyValue3);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getDetailsForActivity -bam.gauges ", (Throwable)e);
        }
    }

    public ActivityGroupForTime[] getActivityDetailsForActivity(String startTime, String endTime) throws BAMException {
        try {
            return this.stub.getActivityDetailsForActivity(startTime, endTime);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getDetailsForActivity -bam.gauges ", (Throwable)e);
        }
    }

    public ActivityForServer[] getActivityDetailsForServer(String serverUrl) throws BAMException {
        try {
            return this.stub.getActivityDetailsForServer(serverUrl);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getActivityDetailsForServer -bam.gauges ", (Throwable)e);
        }
    }

    public PropertyBag[] getpropertyBagForActivity(String activityName) throws BAMException {
        try {
            return this.stub.getpropertyBagForActivity(activityName);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getpropertyBagForActivity -bam.gauges ", (Throwable)e);
        }
    }

    public FullActivityData[] getAllActivityDataForTimeRange(String satrtTime, String endTime) throws BAMException {
        try {
            return this.stub.getAllActivityDataForTimeRange(satrtTime, endTime);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getAllActivityDataForTimeRange -bam.gauges ", (Throwable)e);
        }
    }

    public AllMessagesForActivity[] getAllMessagesForTimeRangeAndActivity(String satrtTime, String endTime, int activityId) throws BAMException {
        try {
            return this.stub.getAllMessagesForTimeRangeAndActivity(satrtTime, endTime, activityId);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getAllMessagesForTimeRangeAndActivity -bam.gauges ", (Throwable)e);
        }
    }

    public ServerForActivity[] getServerListForActivity() throws BAMException {
        try {
            return this.stub.getServerListForActivity();
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getServerListForActivity -bam.gauges ", (Throwable)e);
        }
    }

    public Property[] getPropertyList(String key) throws BAMException {
        try {
            return this.stub.getPropertyList(key);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getPropertyList -bam.gauges ", (Throwable)e);
        }
    }

    public OperationList[] getOperationNameList(int serviceID) throws BAMException {
        try {
            return this.stub.getOperationNameList(serviceID);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getPropertyList -bam.gauges ", (Throwable)e);
        }
    }

    public PropertyKeyForActivity[] getPropertyKeyForActivity(String startTime, String endTime) throws BAMException {
        try {
            return this.stub.getPropertyKeyForActivity(startTime, endTime);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getPropertyKeyForActivity -bam.gauges ", (Throwable)e);
        }
    }

    public PropertyChildForActivity[] getPropertyChildrenForActivity(String childParam, int activityId) throws BAMException {
        try {
            return this.stub.getPropertyChildrenForActivity(childParam, activityId);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getPropertyChildrenForActivity -bam.gauges ", (Throwable)e);
        }
    }

    public ServiceForServer[] getServiceListForActivity(int serverID) throws BAMException {
        try {
            return this.stub.getServiceListForActivity(serverID);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getServiceListForActivity -bam.gauges ", (Throwable)e);
        }
    }

    public OperationForService[] getOperationListForActivity(int serviceId) throws BAMException {
        try {
            return this.stub.getOperationListForActivity(serviceId);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getOperationListForActivity -bam.gauges ", (Throwable)e);
        }
    }

    public TimeStampForOperation[] gettimestampForOperation(int operationId) throws BAMException {
        try {
            return this.stub.gettimestampForOperation(operationId);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing gettimestampForOperation -bam.gauges ", (Throwable)e);
        }
    }

    public DirectionForOperation[] getDirectionForOperation(int operationId) throws BAMException {
        try {
            return this.stub.getDirectionForOperation(operationId);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getDirectionForOperation -bam.gauges ", (Throwable)e);
        }
    }

    public MessageForOperation[] getMessagesForOperation(int operationId, String direction, String startTime, String endTime) throws BAMException {
        try {
            return this.stub.getMessagesForOperation(operationId, direction, startTime, endTime);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getMessagesForOperation -bam.gauges ", (Throwable)e);
        }
    }

    public MessageForMessageID[] getMessageForMessageID(int messageId) throws BAMException {
        try {
            return this.stub.getMessageForMessageID(messageId);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getMessageForMessageID -bam.gauges ", (Throwable)e);
        }
    }

    public Status[] getPropertyValueForStatus(String statusKey, String startTime, String endTime) throws BAMException {
        try {
            return this.stub.getPropertyValueForStatus(statusKey, startTime, endTime);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getPropertyValueForStatus -bam.gauges ", (Throwable)e);
        }
    }

    public MessageCount[] getMessageCount() throws BAMException {
        try {
            return this.stub.getMessageCount();
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getMessagesForStatus -bam.gauges ", (Throwable)e);
        }
    }

    public MessageId[] getMessagesForStatus(String startTime, String endTime, String server, String service, String operation, String direction, String status, String activityType, String messageType, String messageFormat, String applicationStatus, String technicalStatus, String arcKey, int startDataset, int endDataset) throws BAMException {
        try {
            return this.stub.getMessagesForStatus(startTime, endTime, server, service, operation, direction, status, activityType, messageType, messageFormat, applicationStatus, technicalStatus, arcKey, startDataset, endDataset);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getMessagesForStatus -bam.gauges ", (Throwable)e);
        }
    }

    public SAPcount[] getMessagesCountForSAP(String startTime, String endTime, String server, String service, String operation, String direction, String status, String activityType, String messageType, String messageFormat, String applicationStatus, String technicalStatus, String arcKey) throws BAMException {
        try {
            return this.stub.getMessagesCountForSAP(startTime, endTime, server, service, operation, direction, status, activityType, messageType, messageFormat, applicationStatus, technicalStatus, arcKey);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getMessagesForStatus -bam.gauges ", (Throwable)e);
        }
    }

    public SAPchild[] getChildrenMessagesForSAP(String startTime, String endTime, String server, String service, String operation, String direction, String status, String activityType, String messageType, String messageFormat, String applicationStatus, String technicalStatus, String arcKey, int activityId, int startDataset, int endDataset) throws BAMException {
        try {
            return this.stub.getChildrenMessagesForSAP(startTime, endTime, server, service, operation, direction, status, activityType, messageType, messageFormat, applicationStatus, technicalStatus, arcKey, activityId, startDataset, endDataset);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getMessagesForStatus -bam.gauges ", (Throwable)e);
        }
    }

    public SAPaleaudit[] getAleauditMessagesForSAP(String startTime, String endTime, String server, String service, String operation, String direction, String status, String messageType, String messageFormat, String applicationStatus, String technicalStatus, String arcKey, int startDataset, int endDataset) throws BAMException {
        try {
            return this.stub.getAleauditMessagesForSAP(startTime, endTime, server, service, operation, direction, status, messageType, messageFormat, applicationStatus, technicalStatus, arcKey, startDataset, endDataset);
        }
        catch (RemoteException e) {
            throw new BAMException("Error occurred executing getMessagesForStatus -bam.gauges ", (Throwable)e);
        }
    }

    public MessageData[] getMessagesWithXPathValue(String xpathExpression, String value) throws BAMException {
        ArrayList<MessageData> list = new ArrayList<MessageData>();
        try {
            AXIOMXPath xpath = new AXIOMXPath(xpathExpression);
            MessageData[] messages = this.stub.getAllMessages();
            if (messages != null && messages.length > 0) {
                block4: for (MessageData message : messages) {
                    List nodes;
                    StAXOMBuilder builder = new StAXOMBuilder((InputStream)new ByteArrayInputStream(message.getMessageBody().getBytes()));
                    OMElement root = builder.getDocumentElement();
                    if (root == null || (nodes = xpath.selectNodes((Object)root)) == null || nodes.size() <= 0) continue;
                    for (OMContainer node : nodes) {
                        if (!node.toString().equals(value)) continue;
                        list.add(message);
                        continue block4;
                    }
                }
            }
        }
        catch (RemoteException e) {
            throw new BAMException("Unable to fetch message list", (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new BAMException("Unable to construct message body", (Throwable)e);
        }
        catch (JaxenException e) {
            throw new BAMException("Unable to construct xpath", (Throwable)e);
        }
        return list.toArray(new MessageData[list.size()]);
    }

    public int getServerIdForServer(String serverName) throws BAMException {
        try {
            Server[] id = this.stub.getServerIdForServer(serverName);
            if (id != null && id.length > 0) {
                return id[0].getServerID().intValue();
            }
        }
        catch (RemoteException e) {
            throw new BAMException("Unable to retrieve server id for server " + serverName);
        }
        return -1;
    }

    public int getCountofChildrenFailedMessages(int activityKeyID) throws BAMException {
        try {
            CountofChildrenFailedMessage[] count = this.stub.getCountofChildrenFailedMessages(activityKeyID);
            if (count != null && count.length > 0) {
                return Integer.parseInt(count[0].getCount());
            }
        }
        catch (RemoteException e) {
            throw new BAMException("Unable to retrieve Count of Children Failed Messages", (Throwable)e);
        }
        return -1;
    }

    public int getOriginalFailCount(int activityKeyID) throws BAMException {
        try {
            OriginalFailCount[] count = this.stub.getOriginalFailCount(activityKeyID);
            if (count != null && count.length > 0) {
                return Integer.parseInt(count[0].getCount());
            }
        }
        catch (RemoteException e) {
            throw new BAMException("Unable to retrieve Count of Children Failed Messages", (Throwable)e);
        }
        return -1;
    }

    public int getReplayedFailReponseCount(int activityKeyID) throws BAMException {
        try {
            ReplayedFailResponseCount[] count = this.stub.getReplayedFailReponseCount(activityKeyID);
            if (count != null && count.length > 0) {
                return Integer.parseInt(count[0].getCount());
            }
        }
        catch (RemoteException e) {
            throw new BAMException("Unable to retrieve Count of Children Failed Messages", (Throwable)e);
        }
        return -1;
    }

    public int getReplayedFailRequestCount(int activityKeyID) throws BAMException {
        try {
            ReplayedFailRequestCount[] count = this.stub.getReplayedFailRequestCount(activityKeyID);
            if (count != null && count.length > 0) {
                return Integer.parseInt(count[0].getCount());
            }
        }
        catch (RemoteException e) {
            throw new BAMException("Unable to retrieve Count of Children Failed Messages", (Throwable)e);
        }
        return -1;
    }

    public int getAleauditFailCount(int activityKeyID) throws BAMException {
        try {
            AleauditFailCount[] count = this.stub.getAleauditFailCount(activityKeyID);
            if (count != null && count.length > 0) {
                return Integer.parseInt(count[0].getCount());
            }
        }
        catch (RemoteException e) {
            throw new BAMException("Unable to retrieve Count of Children Failed Messages", (Throwable)e);
        }
        return -1;
    }

    public void setParentStatus(int activityKeyID) throws BAMException {
        try {
            this.stub.setParentStatus(activityKeyID);
        }
        catch (RemoteException e) {
            throw new BAMException("Unable to set parent status", (Throwable)e);
        }
    }
}

