/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.gadgetgenwizard.service;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.jaxp.OMSource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.gadgetgenwizard.internal.GGWUtils;
import org.wso2.carbon.bam.gadgetgenwizard.service.GadgetGenException;
import org.wso2.carbon.bam.gadgetgenwizard.service.beans.DBConnInfo;
import org.wso2.carbon.bam.gadgetgenwizard.service.beans.WSMap;
import org.wso2.carbon.bam.gadgetgenwizard.service.beans.WSMapElement;
import org.wso2.carbon.bam.gadgetgenwizard.service.beans.WSResultSet;
import org.wso2.carbon.bam.gadgetgenwizard.service.beans.WSRow;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.CarbonDataSource;
import org.wso2.carbon.registry.common.services.RegistryAbstractAdmin;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.utils.CarbonUtils;

public class GadgetGenService
extends RegistryAbstractAdmin {
    public static final String JAGGERY_APP_GENERATOR_XSLT = "jaggery-app-generator.xslt";
    public static final String GADGET_GENERATOR_XSLT = "gadget-generator.xsl";
    private static final String JQPLOT_CSS = "gadgetgen/css/jquery.jqplot.min.css";
    private static final String DATA_TABLES_CSS = "gadgetgen/css/jquery.dataTables.css";
    private static final String JQUERY_JS = "gadgetgen/js/jquery.min.js";
    private static final String JQPLOT_JS = "gadgetgen/js/jquery.jqplot.min.js";
    private static final String EXCANVAS_JS = "gadgetgen/js/excanvas.min.js";
    private static final String BARGRAPH_JS = "gadgetgen/js/plugins/jqplot.barRenderer.js";
    private static final String CATEGORY_AXIS_JS = "gadgetgen/js/plugins/jqplot.categoryAxisRenderer.js";
    private static final String DATA_TABLES_JS = "gadgetgen/js/jquery.dataTables.min.js";
    private static final String BACK_DISABLED_PNG = "gadgetgen/images/back_disabled.png";
    private static final String BACK_ENABLED_PNG = "gadgetgen/images/back_enabled.png";
    private static final String BACK_ENABLED_HOVER_PNG = "gadgetgen/images/back_enabled_hover.png";
    private static final String FORWARD_DISABLED_PNG = "gadgetgen/images/forward_disabled.png";
    private static final String FORWARD_ENABLED_PNG = "gadgetgen/images/forward_enabled.png";
    private static final String FORWARD_ENABLED_HOVER_PNG = "gadgetgen/images/forward_enabled_hover.png";
    private static final String SORT_ASC_PNG = "gadgetgen/images/sort_asc.png";
    private static final String SORT_ASC_DISABLED_PNG = "gadgetgen/images/sort_asc_disabled.png";
    private static final String SORT_BOTH_PNG = "gadgetgen/images/sort_both.png";
    private static final String SORT_DESC_PNG = "gadgetgen/images/sort_desc.png";
    private static final String SORT_DESC__DISABLED_PNG = "gadgetgen/images/sort_desc_disabled.png";
    private static final String[] GADGET_RESOURCES_JS = new String[]{"gadgetgen/js/excanvas.min.js", "gadgetgen/js/jquery.jqplot.min.js", "gadgetgen/js/jquery.min.js", "gadgetgen/js/plugins/jqplot.barRenderer.js", "gadgetgen/js/plugins/jqplot.categoryAxisRenderer.js", "gadgetgen/js/jquery.dataTables.min.js"};
    private static final String[] GADGET_RESOURCES_CSS = new String[]{"gadgetgen/css/jquery.jqplot.min.css", "gadgetgen/css/jquery.dataTables.css"};
    private static final String[] GADGET_RESOURCES_IMAGES = new String[]{"gadgetgen/images/back_disabled.png", "gadgetgen/images/back_enabled.png", "gadgetgen/images/back_enabled_hover.png", "gadgetgen/images/forward_disabled.png", "gadgetgen/images/forward_enabled.png", "gadgetgen/images/forward_enabled_hover.png", "gadgetgen/images/sort_asc.png", "gadgetgen/images/sort_asc_disabled.png", "gadgetgen/images/sort_both.png", "gadgetgen/images/sort_desc.png", "gadgetgen/images/sort_desc_disabled.png"};
    private static final Log log = LogFactory.getLog(GadgetGenService.class);
    private static final String JAGGERY_APP_DIR = CarbonUtils.getCarbonRepository() + "jaggeryapps";
    private static final String GADGET_GEN_APP_DIR = JAGGERY_APP_DIR + File.separator + "gadgetgen";
    private static final String GADGETGEN_COMP_REG_PATH = "repository/components/org.wso2.carbon.bam.gadgetgen/";

    public String createGadget(WSMap map) throws GadgetGenException {
        OMDocument intermediateXML = this.createIntermediateXML(map);
        String gadgetXMLPath = this.applyXSLTForGadgetXML(intermediateXML);
        this.applyXSLTForJaggeryScript(intermediateXML);
        this.copyGadgetResourcesToRegistry(GADGETGEN_COMP_REG_PATH);
        return gadgetXMLPath;
    }

    public String[] getDataSourceNames() throws GadgetGenException {
        try {
            List allDataSources = GGWUtils.getDataSourceService().getAllDataSources();
            ArrayList<String> dataSourceNames = new ArrayList<String>();
            for (CarbonDataSource carbonDataSource : allDataSources) {
                dataSourceNames.add(carbonDataSource.getDSMInfo().getName());
            }
            return dataSourceNames.toArray(new String[dataSourceNames.size()]);
        }
        catch (DataSourceException e) {
            String errorMsg = "Unable to retrieve data sources. " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new GadgetGenException(errorMsg, e);
        }
    }

    public WSResultSet executeQuery(DBConnInfo dbConnInfo, String sqlQuery) throws GadgetGenException {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Class.forName(dbConnInfo.getDriverClass()).newInstance();
            connection = DriverManager.getConnection(dbConnInfo.getJdbcURL(), dbConnInfo.getUsername(), dbConnInfo.getPassword());
            statement = connection.createStatement();
            resultSet = statement.executeQuery(sqlQuery);
            ResultSetMetaData metaData = resultSet.getMetaData();
            WSResultSet wsResultSet = new WSResultSet();
            int columnCount = metaData.getColumnCount();
            wsResultSet.setColumnCount(columnCount);
            ArrayList<String> columnNames = new ArrayList<String>();
            ArrayList<WSRow> rows = new ArrayList<WSRow>();
            for (int i = 0; i < 10 && resultSet.next(); ++i) {
                ArrayList<String> rowList = new ArrayList<String>();
                for (int j = 1; j < columnCount + 1; ++j) {
                    if (i == 1) {
                        String columnName = metaData.getColumnName(j);
                        columnNames.add(columnName);
                    }
                    rowList.add(resultSet.getString(j));
                }
                WSRow wsRow = new WSRow();
                wsRow.setRow(rowList.toArray(new String[rowList.size()]));
                rows.add(wsRow);
            }
            wsResultSet.setRows(rows.toArray(new WSRow[rows.size()]));
            wsResultSet.setColumnNames(columnNames.toArray(new String[columnNames.size()]));
            WSResultSet wSResultSet = wsResultSet;
            return wSResultSet;
        }
        catch (InstantiationException e) {
            String errorMsg = "The class cannot be instantiated. " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new GadgetGenException(errorMsg, e);
        }
        catch (IllegalAccessException e) {
            String errorMsg = "The class does not have public constructor. " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new GadgetGenException(errorMsg, e);
        }
        catch (ClassNotFoundException e) {
            String errorMsg = "The JDBC Driver Class " + dbConnInfo.getDriverClass() + " is not present in class path. " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new GadgetGenException(errorMsg, e);
        }
        catch (SQLException e) {
            String errorMsg = "Cannot establish database connection. " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new GadgetGenException(errorMsg, e);
        }
        finally {
            String errorMsg;
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    errorMsg = "Cannot close connection. " + e.getMessage();
                    log.error((Object)errorMsg, (Throwable)e);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    errorMsg = "Cannot close statement. " + e.getMessage();
                    log.error((Object)errorMsg, (Throwable)e);
                }
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    errorMsg = "Cannot close result set. " + e.getMessage();
                    log.error((Object)errorMsg, (Throwable)e);
                }
            }
        }
    }

    public boolean validateDBConnection(DBConnInfo dbConnInfo) throws GadgetGenException {
        Connection connection = null;
        try {
            Class.forName(dbConnInfo.getDriverClass()).newInstance();
            connection = DriverManager.getConnection(dbConnInfo.getJdbcURL(), dbConnInfo.getUsername(), dbConnInfo.getPassword());
        }
        catch (InstantiationException e) {
            String errorMsg = "The class cannot be instantiated. " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new GadgetGenException(errorMsg, e);
        }
        catch (IllegalAccessException e) {
            String errorMsg = "The class does not have public constructor. " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new GadgetGenException(errorMsg, e);
        }
        catch (ClassNotFoundException e) {
            String errorMsg = "The JDBC Driver Class " + dbConnInfo.getDriverClass() + " is not present in class path. " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new GadgetGenException(errorMsg, e);
        }
        catch (SQLException e) {
            String errorMsg = "Cannot establish database connection. " + e.getMessage();
            log.error((Object)errorMsg, (Throwable)e);
            throw new GadgetGenException(errorMsg, e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    String errorMsg = "Cannot close connection. " + e.getMessage();
                    log.error((Object)errorMsg, (Throwable)e);
                }
            }
        }
        return true;
    }

    private void copyGadgetResourcesToRegistry(String gadgetRegistryPath) throws GadgetGenException {
        ArrayList<String> gadgetResources = new ArrayList<String>();
        gadgetResources.addAll(Arrays.asList(GADGET_RESOURCES_JS));
        gadgetResources.addAll(Arrays.asList(GADGET_RESOURCES_CSS));
        gadgetResources.addAll(Arrays.asList(GADGET_RESOURCES_IMAGES));
        for (String gadgetResource : gadgetResources) {
            Resource resource = this.convertInputStreamToResource(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(gadgetResource));
            String gadgetResourcePath = gadgetRegistryPath + gadgetResource;
            this.copyResourceWithAnonymousPermission(resource, gadgetResourcePath);
        }
    }

    private void copyResourceWithAnonymousPermission(Resource resource, String gadgetResourcePath) throws GadgetGenException {
        try {
            Registry registry = this.getConfigSystemRegistry();
            if (!registry.resourceExists(gadgetResourcePath)) {
                registry.put(gadgetResourcePath, resource);
                AuthorizationManager authorizationManager = ((UserRegistry)this.getRootRegistry()).getUserRealm().getAuthorizationManager();
                authorizationManager.authorizeRole("wso2.anonymous.role", "/_system/config/" + gadgetResourcePath, "http://www.wso2.org/projects/registry/actions/get");
                this.setPermissionUpdateTimestamp();
            }
        }
        catch (RegistryException e) {
            String msg = "Error inserting resource to registry. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new GadgetGenException(msg, e);
        }
        catch (UserStoreException e) {
            String msg = "Cannot get authorization manager. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new GadgetGenException(msg, e);
        }
    }

    private Resource convertInputStreamToResource(InputStream inputStream) throws GadgetGenException {
        try {
            if (inputStream == null) {
                throw new GadgetGenException("input stream cannot be null");
            }
            Resource resource = this.getConfigSystemRegistry().newResource();
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            resource.setContent((Object)bytes);
            return resource;
        }
        catch (IOException e) {
            String msg = "Error converting file to byte array. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new GadgetGenException(msg, e);
        }
        catch (RegistryException e) {
            String msg = "Error creating new resource. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new GadgetGenException(msg, e);
        }
    }

    private void applyXSLTForJaggeryScript(OMDocument intermediateXML) throws GadgetGenException {
        try {
            File gadgetGenAppDir = new File(GADGET_GEN_APP_DIR);
            if (!gadgetGenAppDir.exists()) {
                FileUtils.forceMkdir((File)gadgetGenAppDir);
            }
            String gadgetFileName = this.getGadgetFileName(intermediateXML);
            File gadgetGenFile = new File(GADGET_GEN_APP_DIR + File.separator + gadgetFileName + ".jag");
            if (gadgetGenFile.exists()) {
                FileUtils.forceDelete((File)gadgetGenFile);
            }
            this.applyXSLT(intermediateXML, FileUtils.openOutputStream((File)gadgetGenFile), JAGGERY_APP_GENERATOR_XSLT);
        }
        catch (FileNotFoundException e) {
            String error = "XSLT file not found. This should be in the classpath. " + e.getMessage();
            log.error((Object)error, (Throwable)e);
            throw new GadgetGenException(error, e);
        }
        catch (IOException e) {
            String error = "Error creating directory structure for jaggery app. " + e.getMessage();
            log.error((Object)error, (Throwable)e);
            throw new GadgetGenException(error, e);
        }
    }

    private String getGadgetFileName(OMDocument intermediateXML) throws GadgetGenException {
        OMElement gadgetFileNameEl = intermediateXML.getOMDocumentElement().getFirstChildWithName(new QName("http://wso2.com/bam/gadgetgen", "gadget-filename", "gg"));
        if (gadgetFileNameEl == null) {
            String errorMsg = "No gadget file name in intermediate xml" + intermediateXML.getOMDocumentElement().toString();
            GadgetGenException gadgetGenException = new GadgetGenException(errorMsg);
            log.error((Object)errorMsg, (Throwable)gadgetGenException);
            throw gadgetGenException;
        }
        String gadgetFileName = gadgetFileNameEl.getText();
        if (!gadgetFileName.matches("[_a-zA-Z0-9\\-\\.]+")) {
            String errorMsg = "Invalid file name for gadget : " + gadgetFileName;
            GadgetGenException gadgetGenException = new GadgetGenException(errorMsg);
            log.error((Object)errorMsg, (Throwable)gadgetGenException);
            throw gadgetGenException;
        }
        return gadgetFileName;
    }

    private void applyXSLT(OMDocument intermediateXML, OutputStream outputStream, String xsltFileNameInClassPath) throws GadgetGenException {
        try {
            StreamResult result = new StreamResult(outputStream);
            InputStream xsltStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(xsltFileNameInClassPath);
            StAXOMBuilder stAXOMBuilder = new StAXOMBuilder(xsltStream);
            OMSource xsltSource = new OMSource(stAXOMBuilder.getDocumentElement());
            OMSource xmlSource = new OMSource(intermediateXML.getOMDocumentElement());
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer transformer = transFact.newTransformer((Source)xsltSource);
            transformer.transform((Source)xmlSource, result);
        }
        catch (XMLStreamException e) {
            String error = "XML error reading XSLT file. " + e.getMessage();
            log.error((Object)error, (Throwable)e);
            throw new GadgetGenException(error, e);
        }
        catch (TransformerException e) {
            String error = "XSLT transformation error during Code generation. " + e.getMessage();
            log.error((Object)error, (Throwable)e);
            throw new GadgetGenException(error, e);
        }
    }

    private String applyXSLTForGadgetXML(OMDocument intermediateXML) throws GadgetGenException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.applyXSLT(intermediateXML, byteArrayOutputStream, GADGET_GENERATOR_XSLT);
            Registry configSystemRegistry = this.getConfigSystemRegistry();
            Resource resource = configSystemRegistry.newResource();
            resource.setContent((Object)byteArrayOutputStream.toByteArray());
            String gadgetXMLPath = "repository/components/org.wso2.carbon.bam.gadgetgen/gadgetgen/" + this.getGadgetFileName(intermediateXML) + ".xml";
            String completeGadgetPath = "/_system/config/" + gadgetXMLPath;
            if (configSystemRegistry.resourceExists(gadgetXMLPath)) {
                throw new GadgetGenException("Choose a different gadget name. Gadget already exists at " + completeGadgetPath);
            }
            this.copyResourceWithAnonymousPermission(resource, gadgetXMLPath);
            return completeGadgetPath;
        }
        catch (RegistryException e) {
            String error = "Error creating resource. " + e.getMessage();
            log.error((Object)error, (Throwable)e);
            throw new GadgetGenException(error, e);
        }
    }

    private OMDocument createIntermediateXML(WSMap map) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMDocument omDocument = factory.createOMDocument();
        OMNamespace gadgetgenNamespace = factory.createOMNamespace("http://wso2.com/bam/gadgetgen", "gg");
        OMElement rootElement = factory.createOMElement("gadgetgen", gadgetgenNamespace);
        WSMapElement[] wsMapElements = map.getWsMapElements();
        boolean barChartFound = false;
        boolean tableFound = false;
        OMElement barChart = factory.createOMElement("BarChart", gadgetgenNamespace);
        OMElement table = factory.createOMElement("Table", gadgetgenNamespace);
        for (WSMapElement wsMapElement : wsMapElements) {
            OMElement omElement;
            if (wsMapElement.getKey().startsWith("bar")) {
                barChartFound = true;
                omElement = factory.createOMElement(wsMapElement.getKey(), gadgetgenNamespace);
                omElement.setText(wsMapElement.getValue());
                barChart.addChild((OMNode)omElement);
            } else if (wsMapElement.getKey().startsWith("table")) {
                tableFound = true;
                omElement = factory.createOMElement(wsMapElement.getKey(), gadgetgenNamespace);
                omElement.setText(wsMapElement.getValue());
                table.addChild((OMNode)omElement);
            }
            omElement = factory.createOMElement(wsMapElement.getKey(), gadgetgenNamespace);
            omElement.setText(wsMapElement.getValue());
            rootElement.addChild((OMNode)omElement);
        }
        if (barChartFound) {
            rootElement.addChild((OMNode)barChart);
        }
        if (tableFound) {
            rootElement.addChild((OMNode)table);
        }
        omDocument.addChild((OMNode)rootElement);
        return omDocument;
    }
}

