/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.gadgetgenwizard.ui;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.json.JSONObject;
import org.wso2.carbon.bam.gadgetgenwizard.stub.GadgetGenAdminServiceGadgetGenException;
import org.wso2.carbon.bam.gadgetgenwizard.stub.GadgetGenAdminServiceStub;
import org.wso2.carbon.bam.gadgetgenwizard.stub.beans.DBConnInfo;
import org.wso2.carbon.bam.gadgetgenwizard.stub.beans.WSMap;
import org.wso2.carbon.bam.gadgetgenwizard.ui.GGWUIUtils;

public class GadgetGenAdminClient {
    private GadgetGenAdminServiceStub stub;

    public GadgetGenAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "GadgetGenAdminService";
        this.stub = new GadgetGenAdminServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public String generateGraph(WSMap map) throws Exception {
        try {
            return this.stub.createGadget(map);
        }
        catch (GadgetGenAdminServiceGadgetGenException e) {
            throw new Exception(e.getFaultMessage().getGadgetGenException().getMessage(), e);
        }
    }

    public boolean validateDBConn(DBConnInfo dbConnInfo) throws Exception {
        try {
            return this.stub.validateDBConnection(dbConnInfo);
        }
        catch (GadgetGenAdminServiceGadgetGenException e) {
            throw new Exception(e.getFaultMessage().getGadgetGenException().getMessage(), e);
        }
    }

    public JSONObject executeQuery(DBConnInfo dbConnInfo, String sql) throws Exception {
        try {
            return GGWUIUtils.convertToJSONObj(this.stub.executeQuery(dbConnInfo, sql));
        }
        catch (GadgetGenAdminServiceGadgetGenException e) {
            throw new Exception(e.getFaultMessage().getGadgetGenException().getMessage(), e);
        }
    }
}

