/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.gadgetgenwizard.ui;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.carbon.bam.gadgetgenwizard.stub.beans.DBConnInfo;
import org.wso2.carbon.bam.gadgetgenwizard.stub.beans.WSMap;
import org.wso2.carbon.bam.gadgetgenwizard.stub.beans.WSMapElement;
import org.wso2.carbon.bam.gadgetgenwizard.stub.beans.WSResultSet;
import org.wso2.carbon.bam.gadgetgenwizard.stub.beans.WSRow;

public class GGWUIUtils {
    public static JSONObject convertToJSONObj(WSResultSet wsResultSet) throws JSONException {
        WSRow[] wsRows;
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonCols = new JSONArray((Object)wsResultSet.getColumnNames());
        jsonObject.put("ColumnNames", (Object)jsonCols);
        JSONArray allRows = new JSONArray();
        for (WSRow wsRow : wsRows = wsResultSet.getRows()) {
            JSONArray row = new JSONArray((Object)wsRow.getRow());
            allRows.put((Object)row);
        }
        jsonObject.put("Rows", (Object)allRows);
        return jsonObject;
    }

    public static String getSQL(HttpSession session) {
        return session.getAttribute("sql") != null ? ((String[])session.getAttribute("sql"))[0] : null;
    }

    public static DBConnInfo constructDBConnInfo(HttpSession session) {
        String jdbcurl = session.getAttribute("jdbcurl") != null ? ((String[])session.getAttribute("jdbcurl"))[0] : "";
        String driver = session.getAttribute("driver") != null ? ((String[])session.getAttribute("driver"))[0] : "";
        String username = session.getAttribute("username") != null ? ((String[])session.getAttribute("username"))[0] : "";
        String password = session.getAttribute("password") != null ? ((String[])session.getAttribute("password"))[0] : "";
        DBConnInfo dbConnInfo = new DBConnInfo();
        dbConnInfo.setJdbcURL(jdbcurl);
        dbConnInfo.setDriverClass(driver);
        dbConnInfo.setUsername(username);
        dbConnInfo.setPassword(password);
        return dbConnInfo;
    }

    public static WSMap constructWSMap(HttpSession session, List<String> sessionAttrKey) {
        ArrayList<WSMapElement> sessionValues = new ArrayList<WSMapElement>();
        for (String key : sessionAttrKey) {
            WSMapElement wsMapElement = new WSMapElement();
            wsMapElement.setKey(key);
            wsMapElement.setValue(((String[])session.getAttribute(key))[0]);
            sessionValues.add(wsMapElement);
        }
        WSMap wsMap = new WSMap();
        wsMap.setWsMapElements(sessionValues.toArray(new WSMapElement[sessionValues.size()]));
        return wsMap;
    }
}

