/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.servicestats.ui;

import java.rmi.RemoteException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.data.publisher.servicestats.stub.ServiceStatPublisherAdminStub;
import org.wso2.carbon.bam.data.publisher.servicestats.stub.config.EventingConfigData;

public class ServiceStatPublisherAdminClient {
    private static final Log log = LogFactory.getLog(ServiceStatPublisherAdminClient.class);
    private static final String BUNDLE = "org.wso2.carbon.bam.data.publisher.servicestats.ui.i18n.Resources";
    private ServiceStatPublisherAdminStub stub;
    private ResourceBundle bundle;

    public ServiceStatPublisherAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "ServiceStatPublisherAdmin";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.stub = new ServiceStatPublisherAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public EventingConfigData getEventingConfigData() throws RemoteException {
        try {
            return this.stub.getEventingConfigData();
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.eventing.config"), e);
            return null;
        }
    }

    public void setEventingConfigData(EventingConfigData eventingConfigData) throws RemoteException {
        try {
            this.stub.configureEventing(eventingConfigData);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("cannot.set.eventing.config"), e);
        }
    }

    private void handleException(String msg, Exception e) throws RemoteException {
        log.error((Object)msg, (Throwable)e);
        throw new RemoteException(msg, e);
    }
}

