/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.servicestats.modules;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.data.publisher.servicestats.PublisherUtils;
import org.wso2.carbon.bam.data.publisher.servicestats.config.EventingConfigData;
import org.wso2.carbon.bam.data.publisher.servicestats.data.OperationStatisticData;
import org.wso2.carbon.bam.data.publisher.servicestats.data.ServiceStatisticData;
import org.wso2.carbon.bam.data.publisher.servicestats.data.StatisticData;
import org.wso2.carbon.bam.data.publisher.servicestats.internal.StatisticsServiceComponent;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.statistics.services.SystemStatisticsUtil;
import org.wso2.carbon.statistics.services.util.OperationStatistics;
import org.wso2.carbon.statistics.services.util.ServiceStatistics;
import org.wso2.carbon.statistics.services.util.SystemStatistics;

public class StatisticsHandler
extends AbstractHandler {
    private static Log log = LogFactory.getLog(StatisticsHandler.class);

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        try {
            SystemStatisticsUtil systemStatisticsUtil = StatisticsServiceComponent.getSystemStatisticsUtil();
            EventingConfigData eventingConfigData = StatisticsServiceComponent.getServiceStatisticsPublisherAdmin().getEventingConfigData();
            if (eventingConfigData != null && eventingConfigData.eventingEnabled() && eventingConfigData.getSystemRequestCountThreshold() > 0) {
                int currentCount;
                AxisConfiguration axisConfiguration = msgContext.getConfigurationContext().getAxisConfiguration();
                SystemStatistics systemStatistics = systemStatisticsUtil.getSystemStatistics(axisConfiguration);
                if (msgContext.getAxisOperation() != null) {
                    OperationStatistics operationStatistics = systemStatisticsUtil.getOperationStatistics(msgContext.getAxisOperation());
                    if (operationStatistics.getTotalRequestCount() == 0) {
                        return Handler.InvocationResponse.CONTINUE;
                    }
                } else {
                    return Handler.InvocationResponse.CONTINUE;
                }
                Collection<ServiceStatisticData> latestServiceStats = this.updateAndGetLatestServiceStatistics(systemStatisticsUtil, msgContext);
                Collection<OperationStatisticData> latestOperationStats = this.updateAndGetLatestOperationStatistics(systemStatisticsUtil, msgContext);
                Parameter lastCountParameter = axisConfiguration.getParameter("lastCount");
                int lastCount = 0;
                if (lastCountParameter != null) {
                    lastCount = (Integer)lastCountParameter.getValue();
                }
                if ((currentCount = systemStatistics.getTotalRequestCount()) - lastCount > eventingConfigData.getSystemRequestCountThreshold()) {
                    lastCountParameter = new Parameter();
                    lastCountParameter.setName("lastCount");
                    lastCountParameter.setValue((Object)currentCount);
                    axisConfiguration.addParameter(lastCountParameter);
                    this.getStatisticAndPublish(msgContext, systemStatistics, latestServiceStats, latestOperationStats);
                }
            }
        }
        catch (Throwable ignore) {
            log.error((Object)("Error at SystemStatisticsHandler. But continuing message processing for message id: " + msgContext.getMessageID()), ignore);
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void getStatisticAndPublish(MessageContext msgContext, SystemStatistics systemStatistics, Collection<ServiceStatisticData> latestServiceStats, Collection<OperationStatisticData> latestOperationStats) {
        StatisticData statisticData = new StatisticData();
        statisticData.setMsgCtxOfStatData(msgContext);
        statisticData.setSystemStatistics(systemStatistics);
        statisticData.setOperationStatisticsList(latestOperationStats);
        statisticData.setServiceStatisticsList(latestServiceStats);
        Date currentDate = new Date();
        Timestamp timestamp = new Timestamp(currentDate.getTime());
        statisticData.setTimestamp(timestamp);
        try {
            PublisherUtils.publishEvent(statisticData);
        }
        catch (Exception e) {
            log.error((Object)("StatisticsHandler - Unable to send event for message message id: " + msgContext.getMessageID()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ServiceStatisticData> updateAndGetLatestServiceStatistics(SystemStatisticsUtil systemStatisticsUtil, MessageContext msgContext) throws AxisFault {
        AxisConfiguration axisConfig = msgContext.getConfigurationContext().getAxisConfiguration();
        int tenantID = SuperTenantCarbonContext.getCurrentContext((AxisConfiguration)axisConfig).getTenantId();
        String serviceName = msgContext.getAxisService().getName();
        ServiceStatistics serviceStatistics = systemStatisticsUtil.getServiceStatistics(msgContext.getAxisService());
        ServiceStatisticData serviceStatisticData = new ServiceStatisticData();
        serviceStatisticData.setServiceStatistics(serviceStatistics);
        serviceStatisticData.setServiceName(serviceName);
        serviceStatisticData.setTenantId(tenantID);
        serviceStatisticData.setUpdateFlag(true);
        ArrayList<ServiceStatisticData> newCollection = new ArrayList<ServiceStatisticData>();
        Map<String, ServiceStatisticData> serviceStats = new HashMap();
        Parameter serviceStatsParameter = axisConfig.getParameter("serviceName");
        if (serviceStatsParameter == null) {
            StatisticsHandler statisticsHandler = this;
            synchronized (statisticsHandler) {
                if (serviceStatsParameter == null) {
                    serviceStats.put(serviceName, serviceStatisticData);
                    serviceStatsParameter = new Parameter();
                    serviceStatsParameter.setName("serviceName");
                    serviceStatsParameter.setValue(serviceStats);
                    axisConfig.addParameter(serviceStatsParameter);
                } else {
                    serviceStats = (Map)serviceStatsParameter.getValue();
                    serviceStats.put(serviceName, serviceStatisticData);
                }
            }
        } else {
            serviceStats = (Map)serviceStatsParameter.getValue();
            serviceStats.put(serviceName, serviceStatisticData);
        }
        newCollection.addAll(serviceStats.values());
        return newCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<OperationStatisticData> updateAndGetLatestOperationStatistics(SystemStatisticsUtil systemStatisticsUtil, MessageContext msgContext) throws AxisFault {
        AxisConfiguration axisConfig = msgContext.getConfigurationContext().getAxisConfiguration();
        int tenantID = SuperTenantCarbonContext.getCurrentContext((AxisConfiguration)axisConfig).getTenantId();
        String operationName = msgContext.getAxisService().getName() + "-" + msgContext.getAxisOperation().getName().getLocalPart();
        OperationStatistics operationStatistics = systemStatisticsUtil.getOperationStatistics(msgContext.getAxisOperation());
        OperationStatisticData operationStatisticData = new OperationStatisticData();
        operationStatisticData.setOperationStatistics(operationStatistics);
        operationStatisticData.setTenantId(tenantID);
        operationStatisticData.setServiceName(msgContext.getAxisService().getName());
        operationStatisticData.setOperationName(msgContext.getAxisOperation().getName().getLocalPart());
        operationStatisticData.setUpdateFlag(true);
        ArrayList<OperationStatisticData> newCollection = new ArrayList<OperationStatisticData>();
        Map<String, OperationStatisticData> operationStats = new HashMap();
        Parameter operationStatsParameter = axisConfig.getParameter("operationName");
        if (operationStatsParameter == null) {
            StatisticsHandler statisticsHandler = this;
            synchronized (statisticsHandler) {
                if (operationStatsParameter == null) {
                    operationStats.put(operationName, operationStatisticData);
                    operationStatsParameter = new Parameter();
                    operationStatsParameter.setName("operationName");
                    operationStatsParameter.setValue(operationStats);
                    axisConfig.addParameter(operationStatsParameter);
                } else {
                    operationStats = (Map)operationStatsParameter.getValue();
                    operationStats.put(operationName, operationStatisticData);
                }
            }
        } else {
            operationStats = (Map)operationStatsParameter.getValue();
            operationStats.put(operationName, operationStatisticData);
        }
        newCollection.addAll(operationStats.values());
        return newCollection;
    }
}

