/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.servicestats.internal;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.bam.data.publisher.servicestats.EventPublisher;
import org.wso2.carbon.bam.data.publisher.servicestats.PublisherUtils;
import org.wso2.carbon.bam.data.publisher.servicestats.ServiceHolder;
import org.wso2.carbon.bam.data.publisher.servicestats.ServiceStatisticsQueue;
import org.wso2.carbon.bam.data.publisher.servicestats.config.RegistryPersistenceManager;
import org.wso2.carbon.bam.data.publisher.servicestats.internal.ServiceStatisticsAxis2ConfigurationContextObserver;
import org.wso2.carbon.bam.data.publisher.servicestats.services.ServiceStatisticsPublisherAdmin;
import org.wso2.carbon.bam.lwevent.core.LightWeightEventBrokerInterface;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.event.core.subscription.Subscription;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.statistics.services.SystemStatisticsUtil;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

public class StatisticsServiceComponent {
    private static Log log = LogFactory.getLog(StatisticsServiceComponent.class);
    private static SystemStatisticsUtil systemStatisticsUtil = null;
    private static ServiceStatisticsPublisherAdmin serviceStatisticsPublisherAdmin = null;
    private static ConfigurationContext configurationContext;
    private static LightWeightEventBrokerInterface lightWeightEventBroker;
    private static ServerConfiguration serverConfiguration;
    private static ServiceStatisticsQueue serviceStatisticsQueue;
    private static RealmService realmService;
    private static RegistryService registryService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext context) {
        block7: {
            try {
                String serverURL;
                configurationContext.getAxisConfiguration().engageModule("wso2bampubsvcstat");
                BundleContext bundleContext = context.getBundleContext();
                bundleContext.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new ServiceStatisticsAxis2ConfigurationContextObserver(), null);
                serviceStatisticsPublisherAdmin = new ServiceStatisticsPublisherAdmin();
                EventPublisher serviceStatsProcessor = new EventPublisher();
                serviceStatisticsQueue = new ServiceStatisticsQueue(serviceStatsProcessor);
                PublisherUtils.setServiceStatisticQueue(serviceStatisticsQueue);
                if (SuperTenantCarbonContext.getCurrentContext((AxisConfiguration)configurationContext.getAxisConfiguration()).getTenantDomain() == null && (serverURL = serverConfiguration.getFirstProperty("BamServerURL")) != null) {
                    Subscription subscription = new Subscription();
                    subscription.setEventSinkURL(serverURL + "BAMServiceStatisticsSubscriberService");
                    subscription.setTopicName("/carbon/bam/data/publishers/service_stats");
                    subscription.setOwner("wso2.system.user");
                    subscription.setEventDispatcherName("wsEventDispatcher");
                    try {
                        SuperTenantCarbonContext.startTenantFlow();
                        int tenantId = SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)StatisticsServiceComponent.getConfigurationContext()).getTenantId();
                        SuperTenantCarbonContext.getCurrentContext().setTenantId(tenantId);
                        SuperTenantCarbonContext.getCurrentContext().getTenantDomain(true);
                        SuperTenantCarbonContext.getCurrentContext().setUsername("wso2.system.user");
                        SuperTenantCarbonContext.getCurrentContext().setUserRealm((UserRealm)realmService.getBootstrapRealm());
                        ServiceHolder.getLWEventBroker().subscribe(subscription);
                    }
                    finally {
                        SuperTenantCarbonContext.endTenantFlow();
                    }
                }
                log.info((Object)"BAM service statistics data publisher bundle is activated");
            }
            catch (Throwable e) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"Failed to activate BAM service statistics data publisher bundle", e);
            }
        }
    }

    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"BAM service statistics data publisher bundle is deactivated");
        }
        serviceStatisticsQueue.cleanup();
    }

    protected void setLWEventBroker(LightWeightEventBrokerInterface lightWeightEventBroker) {
        ServiceHolder.setLWEventBroker(lightWeightEventBroker);
    }

    protected void unsetLWEventBroker(LightWeightEventBrokerInterface lightWeightEventBroker) {
        ServiceHolder.unsetLWEventBroker(lightWeightEventBroker);
    }

    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        configurationContext = configurationContextService.getServerConfigContext();
        ServiceHolder.setConfigurationContextService(configurationContextService.getServerConfigContext());
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        configurationContext = null;
        ServiceHolder.unsetConfigurationContextService(configurationContextService.getServerConfigContext());
    }

    public static ConfigurationContext getConfigurationContext() {
        return configurationContext;
    }

    public static ServerConfiguration getServerConfiguration() {
        return serverConfiguration;
    }

    protected void setServerConfiguration(ServerConfiguration serverConfiguration) {
        StatisticsServiceComponent.serverConfiguration = serverConfiguration;
    }

    protected void unsetServerConfiguration(ServerConfiguration serverConfiguration) {
        serverConfiguration = null;
    }

    protected void setRegistryService(RegistryService registryService) {
        try {
            StatisticsServiceComponent.registryService = registryService;
            RegistryPersistenceManager.setRegistry((Registry)registryService.getConfigSystemRegistry());
        }
        catch (Exception e) {
            log.error((Object)"Cannot retrieve System Registry", (Throwable)e);
        }
    }

    protected void setRealmService(RealmService realmService) {
        StatisticsServiceComponent.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        StatisticsServiceComponent.realmService = null;
    }

    protected void unsetRegistryService(RegistryService registryService) {
        StatisticsServiceComponent.registryService = null;
        RegistryPersistenceManager.setRegistry(null);
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    protected void setSystemStatisticsUtil(SystemStatisticsUtil systemStatisticsUtil) {
        StatisticsServiceComponent.systemStatisticsUtil = systemStatisticsUtil;
    }

    protected void unsetSystemStatisticsUtil(SystemStatisticsUtil sysStatUtil) {
        systemStatisticsUtil = null;
    }

    public static SystemStatisticsUtil getSystemStatisticsUtil() {
        return systemStatisticsUtil;
    }

    public static ServiceStatisticsPublisherAdmin getServiceStatisticsPublisherAdmin() {
        return serviceStatisticsPublisherAdmin;
    }

    public static LightWeightEventBrokerInterface getLightWeightEventBroker() {
        return lightWeightEventBroker;
    }
}

