/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.servicestats.config;

import org.wso2.carbon.bam.data.publisher.servicestats.config.EventingConfigData;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class RegistryPersistenceManager {
    private static Registry registry;
    private static EventingConfigData eventingConfigData;

    public RegistryPersistenceManager() {
        this.load();
    }

    public static void setRegistry(Registry registryParam) {
        registry = registryParam;
    }

    public String getConfigurationProperty(String propertyName) throws RegistryException {
        String resourcePath = "/repository/bam/data/publishers/service_stats" + propertyName;
        String value = null;
        if (registry.resourceExists(resourcePath)) {
            Resource resource = registry.get(resourcePath);
            value = resource.getProperty(propertyName);
        }
        return value;
    }

    public void updateConfigurationProperty(String propertyName, String value) throws RegistryException {
        String resourcePath = "/repository/bam/data/publishers/service_stats" + propertyName;
        if (!registry.resourceExists(resourcePath)) {
            Resource resource = registry.newResource();
            resource.addProperty(propertyName, value);
            registry.put(resourcePath, resource);
        } else {
            Resource resource = registry.get(resourcePath);
            resource.setProperty(propertyName, value);
            registry.put(resourcePath, resource);
        }
    }

    private void load() {
        eventingConfigData.setEnableEventing("ON");
        eventingConfigData.setSystemRequestCountThreshold(20);
        try {
            String eventingStatus = this.getConfigurationProperty("EnableEventing");
            if (eventingStatus != null) {
                eventingConfigData.setEnableEventing(eventingStatus);
                eventingConfigData.setSystemRequestCountThreshold(Integer.parseInt(this.getConfigurationProperty("SystemRequestCountThreshold")));
            } else {
                this.update(eventingConfigData);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update(EventingConfigData eventingConfigData) throws RegistryException {
        this.updateConfigurationProperty("EnableEventing", eventingConfigData.getEnableEventing());
        this.updateConfigurationProperty("SystemRequestCountThreshold", Integer.toString(eventingConfigData.getSystemRequestCountThreshold()));
        RegistryPersistenceManager.eventingConfigData = eventingConfigData;
    }

    public EventingConfigData getEventingConfigData() {
        return eventingConfigData;
    }

    static {
        eventingConfigData = new EventingConfigData();
    }
}

