/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.servicestats;

import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.data.publisher.servicestats.ServiceStatsProcessor;
import org.wso2.carbon.bam.data.publisher.servicestats.data.StatisticData;

public class ServiceStatisticsQueue {
    private static final Log log = LogFactory.getLog(ServiceStatisticsQueue.class);
    private int previousQueueSize;
    private boolean shutdown = false;
    private Queue<StatisticData> statisticsQueue = new ArrayBlockingQueue<StatisticData>(2000);
    private ExecutorService exec = Executors.newFixedThreadPool(100);
    private ServiceStatsProcessor serviceStatsProcessor;

    public ServiceStatisticsQueue(ServiceStatsProcessor serviceStatisticProcessor) {
        this.serviceStatsProcessor = serviceStatisticProcessor;
    }

    public int getSize() {
        return this.statisticsQueue.size();
    }

    public void enqueue(StatisticData systemStatisticData) {
        if (this.shutdown) {
            log.warn((Object)"BAM service statistics queue is shutting down... Not accepting the new statistics...");
            return;
        }
        boolean queued = this.statisticsQueue.offer(systemStatisticData);
        if (queued) {
            if (this.statisticsQueue.size() > 0) {
                this.exec.submit(new ServiceStatsWorker());
            }
        } else {
            log.warn((Object)"Queue size exceeded. Event rejected.");
        }
    }

    public void cleanup() {
        this.shutdown = true;
        while (this.statisticsQueue.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Waiting for the service statistics queue to become empty");
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.exec.shutdownNow();
        this.serviceStatsProcessor.destroy();
    }

    private void delay(int previousQueueSize, int idleLoopCount) {
        try {
            if (idleLoopCount < 20) {
                if (previousQueueSize > 1000) {
                    Thread.sleep(10L);
                } else if (1000 >= previousQueueSize && previousQueueSize > 500) {
                    Thread.sleep(50L);
                } else if (500 >= previousQueueSize && previousQueueSize > 100) {
                    Thread.sleep(200L);
                } else if (100 >= previousQueueSize && previousQueueSize > 10) {
                    Thread.sleep(300L);
                } else {
                    Thread.sleep(1000L);
                }
            } else {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void clearStatisticDataInQueue(int size) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Number of events in queue : " + size));
        }
        StatisticData[] sts = new StatisticData[size];
        for (int i = 0; i < size; ++i) {
            sts[i] = this.statisticsQueue.poll();
        }
        this.serviceStatsProcessor.process(sts);
    }

    private class ServiceStatsWorker
    implements Runnable {
        private ServiceStatsWorker() {
        }

        @Override
        public void run() {
            ServiceStatisticsQueue.this.clearStatisticDataInQueue(ServiceStatisticsQueue.this.statisticsQueue.size());
        }
    }
}

