/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.servicestats;

import java.net.SocketException;
import java.sql.Timestamp;
import java.util.List;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.data.publisher.servicestats.ServiceStatisticsQueue;
import org.wso2.carbon.bam.data.publisher.servicestats.data.EventData;
import org.wso2.carbon.bam.data.publisher.servicestats.data.OperationStatisticData;
import org.wso2.carbon.bam.data.publisher.servicestats.data.ServiceStatisticData;
import org.wso2.carbon.bam.data.publisher.servicestats.data.StatisticData;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.statistics.services.util.OperationStatistics;
import org.wso2.carbon.statistics.services.util.ServiceStatistics;
import org.wso2.carbon.statistics.services.util.SystemStatistics;
import org.wso2.carbon.utils.NetworkUtils;

public class PublisherUtils {
    private static Log log = LogFactory.getLog(PublisherUtils.class);
    private static String serverName;
    private static ServiceStatisticsQueue queue;

    public static void setServiceStatisticQueue(ServiceStatisticsQueue serviceStatisticQueue) {
        queue = serviceStatisticQueue;
    }

    public static ServiceStatisticsQueue getQueue() {
        return queue;
    }

    private static String getServerName(AxisConfiguration axisConfiguration) throws Exception {
        String hostName;
        String serverName = null;
        try {
            hostName = NetworkUtils.getLocalHostname();
        }
        catch (SocketException e) {
            throw new Exception("Error getting host name for the BAM event payload", e);
        }
        String carbonHttpsPort = System.getProperty("carbon.https.port");
        if (carbonHttpsPort == null) {
            carbonHttpsPort = (String)axisConfiguration.getTransportIn("https").getParameter("port").getValue();
        }
        String baseServerUrl = "https://" + hostName + ":" + carbonHttpsPort;
        String context = ServerConfiguration.getInstance().getFirstProperty("WebContextRoot");
        String tenantDomain = SuperTenantCarbonContext.getCurrentContext((AxisConfiguration)axisConfiguration).getTenantDomain();
        if (tenantDomain != null) {
            serverName = baseServerUrl + context + "t/" + tenantDomain;
        } else if (tenantDomain == null && context.equals("/")) {
            serverName = baseServerUrl + "";
        } else if (tenantDomain == null && !context.equals("/")) {
            serverName = baseServerUrl + context;
        }
        return serverName;
    }

    public static void setServerName(String name) {
        serverName = name;
    }

    public static EventData getSystemEventData(StatisticData statisticData, SystemStatistics statistics) {
        AxisConfiguration axisConfig = statisticData.getMsgCtxOfStatData().getConfigurationContext().getAxisConfiguration();
        int tenantID = SuperTenantCarbonContext.getCurrentContext((AxisConfiguration)axisConfig).getTenantId();
        EventData data = new EventData();
        data.setTenantID(tenantID);
        data.setAvgResponseTime(statistics.getAvgResponseTime());
        data.setMaxResponseTime(statistics.getMaxResponseTime());
        data.setMinResponseTime(statistics.getMinResponseTime());
        data.setRequestCount(statistics.getTotalRequestCount());
        data.setResponseCount(statistics.getTotalResponseCount());
        data.setFaultCount(statistics.getTotalFaultCount());
        data.setTimestamp(statisticData.getTimestamp());
        return data;
    }

    public static EventData getServiceEventData(ServiceStatisticData stats, Timestamp timestamp) {
        EventData data = new EventData();
        data.setTenantID(stats.getTenantId());
        ServiceStatistics statistics = stats.getServiceStatistics();
        data.setAvgResponseTime(statistics.getAvgResponseTime());
        data.setMaxResponseTime(statistics.getMaxResponseTime());
        data.setMinResponseTime(statistics.getMinResponseTime());
        data.setRequestCount(statistics.getTotalRequestCount());
        data.setResponseCount(statistics.getTotalResponseCount());
        data.setFaultCount(statistics.getTotalFaultCount());
        data.setServiceName(stats.getServiceName());
        data.setTimestamp(timestamp);
        stats.setUpdateFlag(false);
        return data;
    }

    public static EventData getOperationEventData(OperationStatisticData stats, Timestamp timestamp) {
        EventData data = new EventData();
        data.setTenantID(stats.getTenantId());
        OperationStatistics statistics = stats.getOperationStatistics();
        data.setAvgResponseTime(statistics.getAvgResponseTime());
        data.setMaxResponseTime(statistics.getMaxResponseTime());
        data.setMinResponseTime(statistics.getMinResponseTime());
        data.setRequestCount(statistics.getTotalRequestCount());
        data.setResponseCount(statistics.getTotalResponseCount());
        data.setFaultCount(statistics.getTotalFaultCount());
        data.setServiceName(stats.getServiceName());
        data.setOperationName(stats.getOperationName());
        data.setTimestamp(timestamp);
        stats.setUpdateFlag(false);
        return data;
    }

    public static OMElement getEventPayload(MessageContext msgCtx, EventData systemData, List<EventData> serviceDataList, List<EventData> operationDataList) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace statNamespace = factory.createOMNamespace("http://wso2.org/ns/2009/09/bam/service/statistics/data", "statdata");
        OMElement eventElement = factory.createOMElement("Event", statNamespace);
        OMElement systemStatisticDataElement = factory.createOMElement("ServiceStatisticsData", statNamespace);
        try {
            PublisherUtils.getCommonPayload(msgCtx, factory, statNamespace, systemData, systemStatisticDataElement);
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while creating system payload", (Throwable)e);
        }
        eventElement.addChild((OMNode)systemStatisticDataElement);
        for (EventData serviceData : serviceDataList) {
            OMElement serviceStatisticDataElement = factory.createOMElement("ServiceStatisticsData", statNamespace);
            try {
                PublisherUtils.getCommonPayload(msgCtx, factory, statNamespace, serviceData, serviceStatisticDataElement);
            }
            catch (Exception e) {
                log.error((Object)"Error occurred while creating service payload", (Throwable)e);
            }
            OMElement serviceNameElement = factory.createOMElement("ServiceName", statNamespace);
            factory.createOMText((OMContainer)serviceNameElement, serviceData.getServiceName());
            serviceStatisticDataElement.addChild((OMNode)serviceNameElement);
            eventElement.addChild((OMNode)serviceStatisticDataElement);
        }
        for (EventData operationData : operationDataList) {
            OMElement operationStatisticDataElement = factory.createOMElement("ServiceStatisticsData", statNamespace);
            try {
                PublisherUtils.getCommonPayload(msgCtx, factory, statNamespace, operationData, operationStatisticDataElement);
            }
            catch (Exception e) {
                log.error((Object)"Error occurred while creating operation payload", (Throwable)e);
            }
            OMElement operationNameElement = factory.createOMElement("OperationName", statNamespace);
            factory.createOMText((OMContainer)operationNameElement, operationData.getOperationName());
            OMElement operationServiceNameElement = factory.createOMElement("ServiceName", statNamespace);
            factory.createOMText((OMContainer)operationServiceNameElement, operationData.getServiceName());
            operationStatisticDataElement.addChild((OMNode)operationNameElement);
            operationStatisticDataElement.addChild((OMNode)operationServiceNameElement);
            eventElement.addChild((OMNode)operationStatisticDataElement);
        }
        return eventElement;
    }

    public static OMElement createServerRestartedEvent() {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace statNamespace = factory.createOMNamespace("http://wso2.org/ns/2009/09/bam/service/statistics/data", "statdata");
        OMElement eventElement = factory.createOMElement("Event", statNamespace);
        OMElement systemStatisticDataElement = factory.createOMElement("ServiceStatisticsData", statNamespace);
        return null;
    }

    public static void publishEvent(StatisticData statisticData) throws Exception {
        queue.enqueue(statisticData);
    }

    private static void getCommonPayload(MessageContext msgCtx, OMFactory factory, OMNamespace statNamespace, EventData data, OMElement serviceInvocationDataElement) throws Exception {
        OMElement tenantElement = factory.createOMElement("TenantID", statNamespace);
        factory.createOMText((OMContainer)tenantElement, Integer.toString(data.getTenantID()));
        serviceInvocationDataElement.addChild((OMNode)tenantElement);
        OMElement serverNameElement = factory.createOMElement("ServerName", statNamespace);
        if (msgCtx == null) {
            factory.createOMText((OMContainer)serverNameElement, serverName);
        } else {
            factory.createOMText((OMContainer)serverNameElement, PublisherUtils.getServerName(msgCtx.getConfigurationContext().getAxisConfiguration()));
        }
        serviceInvocationDataElement.addChild((OMNode)serverNameElement);
        OMElement minResponseTimeElement = factory.createOMElement("MinimumResponseTime", statNamespace);
        factory.createOMText((OMContainer)minResponseTimeElement, Long.toString(data.getMinResponseTime()));
        serviceInvocationDataElement.addChild((OMNode)minResponseTimeElement);
        OMElement maxResponseTimeElement = factory.createOMElement("MaximumResponseTime", statNamespace);
        factory.createOMText((OMContainer)maxResponseTimeElement, Long.toString(data.getMaxResponseTime()));
        serviceInvocationDataElement.addChild((OMNode)maxResponseTimeElement);
        OMElement avgResponseTimeElement = factory.createOMElement("AverageResponseTime", statNamespace);
        factory.createOMText((OMContainer)avgResponseTimeElement, Double.toString(data.getAvgResponseTime()));
        serviceInvocationDataElement.addChild((OMNode)avgResponseTimeElement);
        OMElement requestCountElement = factory.createOMElement("RequestCount", statNamespace);
        factory.createOMText((OMContainer)requestCountElement, Integer.toString(data.getRequestCount()));
        serviceInvocationDataElement.addChild((OMNode)requestCountElement);
        OMElement responseCountElement = factory.createOMElement("ResponseCount", statNamespace);
        factory.createOMText((OMContainer)responseCountElement, Integer.toString(data.getResponseCount()));
        serviceInvocationDataElement.addChild((OMNode)responseCountElement);
        OMElement faultCountElement = factory.createOMElement("FaultCount", statNamespace);
        factory.createOMText((OMContainer)faultCountElement, Integer.toString(data.getFaultCount()));
        serviceInvocationDataElement.addChild((OMNode)faultCountElement);
        OMElement timestampElement = factory.createOMElement("Timestamp", statNamespace);
        factory.createOMText((OMContainer)timestampElement, data.getTimestamp().toString());
        serviceInvocationDataElement.addChild((OMNode)timestampElement);
    }
}

