/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.servicestats;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.data.publisher.servicestats.PublisherUtils;
import org.wso2.carbon.bam.data.publisher.servicestats.ServiceHolder;
import org.wso2.carbon.bam.data.publisher.servicestats.ServiceStatsProcessor;
import org.wso2.carbon.bam.data.publisher.servicestats.data.EventData;
import org.wso2.carbon.bam.data.publisher.servicestats.data.OperationStatisticData;
import org.wso2.carbon.bam.data.publisher.servicestats.data.ServiceStatisticData;
import org.wso2.carbon.bam.data.publisher.servicestats.data.StatisticData;
import org.wso2.carbon.bam.data.publisher.servicestats.internal.StatisticsServiceComponent;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.statistics.services.util.SystemStatistics;

public class EventPublisher
implements ServiceStatsProcessor {
    private static Log log = LogFactory.getLog(EventPublisher.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(StatisticData[] statisticData) {
        OMElement eventPayLoad = null;
        for (StatisticData statistic : statisticData) {
            eventPayLoad = this.constructEventPayLoad(statistic);
            try {
                SuperTenantCarbonContext.startTenantFlow();
                int tenantId = SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)StatisticsServiceComponent.getConfigurationContext()).getTenantId();
                SuperTenantCarbonContext.getCurrentContext().setTenantId(tenantId);
                SuperTenantCarbonContext.getCurrentContext().getTenantDomain(true);
                ServiceHolder.getLWEventBroker().publish("/carbon/bam/data/publishers/service_stats", eventPayLoad);
            }
            catch (Exception e) {
                log.error((Object)"Can not publish the message ", (Throwable)e);
            }
            finally {
                SuperTenantCarbonContext.endTenantFlow();
            }
        }
    }

    private OMElement constructEventPayLoad(StatisticData statData) {
        SystemStatistics systemStatistics = statData.getSystemStatistics();
        Collection<OperationStatisticData> operationStatisticsList = statData.getOperationStatisticsList();
        Collection<ServiceStatisticData> serviceStatisticsList = statData.getServiceStatisticsList();
        Timestamp timestamp = statData.getTimestamp();
        ArrayList<EventData> opData = new ArrayList<EventData>();
        ArrayList<EventData> serviceData = new ArrayList<EventData>();
        for (OperationStatisticData operationStats : operationStatisticsList) {
            if (!operationStats.isUpdateFlag()) continue;
            opData.add(PublisherUtils.getOperationEventData(operationStats, timestamp));
        }
        for (ServiceStatisticData serviceStats : serviceStatisticsList) {
            if (!serviceStats.isUpdateFlag()) continue;
            serviceData.add(PublisherUtils.getServiceEventData(serviceStats, timestamp));
        }
        MessageContext msgContext = statData.getMsgCtxOfStatData();
        EventData systemData = PublisherUtils.getSystemEventData(statData, systemStatistics);
        OMElement payLoad = PublisherUtils.getEventPayload(msgContext, systemData, serviceData, opData);
        return payLoad;
    }

    @Override
    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Terminating BAM EventPublisher");
        }
    }
}

