/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.activity.service.ui;

import java.rmi.RemoteException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.data.publisher.activity.service.stub.ActivityPublisherAdminStub;
import org.wso2.carbon.bam.data.publisher.activity.service.stub.types.carbon.EventingConfigData;
import org.wso2.carbon.bam.data.publisher.activity.service.stub.types.carbon.XPathConfigData;

public class ActivityPublisherAdminClient {
    private static final Log log = LogFactory.getLog(ActivityPublisherAdminClient.class);
    private static final String BUNDLE = "org.wso2.carbon.bam.data.publisher.activity.service.ui.i18n.Resources";
    private ActivityPublisherAdminStub stub;
    private ResourceBundle bundle;

    public ActivityPublisherAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "ActivityPublisherAdmin";
        this.bundle = ResourceBundle.getBundle(BUNDLE, locale);
        this.stub = new ActivityPublisherAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public EventingConfigData getEventingConfigData() throws RemoteException {
        try {
            return this.stub.getEventingConfigData();
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.eventing.config"), e);
            return null;
        }
    }

    public void setEventingConfigData(EventingConfigData eventingConfigData) throws RemoteException {
        try {
            this.stub.configureEventing(eventingConfigData);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("cannot.set.eventing.config"), e);
        }
    }

    public void setXPathConfigData(XPathConfigData xpathConfigData) throws RemoteException {
        try {
            this.stub.configureXPathData(xpathConfigData);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("cannot.set.xpath.config") + " " + e.getMessage(), e);
        }
    }

    public XPathConfigData[] getXPathConfigData() throws RemoteException {
        try {
            return this.stub.getXPathData();
        }
        catch (RemoteException e) {
            this.handleException(this.bundle.getString("cannot.get.xpath.config"), e);
        }
        catch (Exception e) {
            this.handleException(this.bundle.getString("cannot.get.xpath.config"), e);
        }
        return new XPathConfigData[0];
    }

    private void handleException(String msg, Exception e) throws RemoteException {
        log.error((Object)msg, (Throwable)e);
        throw new RemoteException(msg, e);
    }
}

