/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.activity.service.modules;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.bam.data.publisher.activity.service.Counter;
import org.wso2.carbon.bam.data.publisher.activity.service.PublisherUtils;
import org.wso2.carbon.bam.data.publisher.activity.service.XPathStore;
import org.wso2.carbon.bam.data.publisher.activity.service.config.EventingConfigData;
import org.wso2.carbon.bam.data.publisher.activity.service.config.XPathConfigData;
import org.wso2.carbon.bam.data.publisher.activity.service.data.MessageData;

public class XPathLookupHandler
extends AbstractHandler {
    private static Log log = LogFactory.getLog(XPathLookupHandler.class);
    private static Map<Integer, String> xpathValues = new HashMap<Integer, String>();
    private static MessageData messageData = new MessageData();

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        String activityID = "";
        String activityName = "";
        String activityDescription = "";
        String xmlStream = messageContext.getEnvelope().getBody().toString();
        List listOfNodes = null;
        int flow = messageContext.getFLOW();
        if (messageContext.getAxisService() != null) {
            EventingConfigData eventingConfigData;
            AxisService service = messageContext.getAxisService();
            Parameter param_admin = service.getParameter("adminService");
            Parameter param_hidden = service.getParameter("hiddenService");
            if (param_admin == null && param_hidden == null && (eventingConfigData = PublisherUtils.getActivityPublisherAdmin().getEventingConfigData()) != null && eventingConfigData.eventingEnabled() && eventingConfigData.messageLookupEnabled()) {
                Object value = messageContext.getConfigurationContext().getProperty("BAMXPathCount");
                if (value != null) {
                    if (value instanceof Counter) {
                        ((Counter)value).increment();
                    }
                } else {
                    Counter xpathCounter = new Counter();
                    xpathCounter.increment();
                    messageContext.getConfigurationContext().setProperty("BAMXPathCount", (Object)xpathCounter);
                }
                XPathConfigData[] xpathExps = null;
                try {
                    xpathExps = PublisherUtils.getActivityPublisherAdmin().getXPathData();
                }
                catch (Exception e) {
                    log.error((Object)"Error while fetching xpath properties from registry..", (Throwable)e);
                }
                if (xpathExps != null && xpathExps.length > 0) {
                    UUID uuid = UUID.randomUUID();
                    String messageID = messageContext.getMessageID();
                    if (messageID == null) {
                        messageID = uuid.toString();
                        messageContext.setMessageID(messageID);
                    }
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xmlStream.getBytes());
                    try {
                        ConcurrentMap<String, String> activity;
                        if (flow == 1) {
                            activity = this.processInMessageContext(messageContext);
                            if (activity != null) {
                                activityID = (String)activity.get("ActivityID");
                            }
                        } else {
                            MessageContext inMessagecontext = messageContext.getOperationContext().getMessageContext("In");
                            activity = this.processInMessageContext(inMessagecontext);
                            if (activity != null) {
                                activityID = (String)activity.get("ActivityID");
                            }
                        }
                        StAXOMBuilder builder = new StAXOMBuilder((InputStream)byteArrayInputStream);
                        OMElement root = builder.getDocumentElement();
                        HashMap<XPathConfigData, String> xpathEvaluations = new HashMap<XPathConfigData, String>();
                        for (XPathConfigData xpathExp : xpathExps) {
                            AXIOMXPath xpath = new AXIOMXPath(xpathExp.getXpath());
                            String[] namespaces = xpathExp.getNameSpaces();
                            if (namespaces != null && namespaces.length > 0) {
                                for (String ns : namespaces) {
                                    String[] tokens = ns.split("@");
                                    if (tokens == null || tokens.length < 2) continue;
                                    xpath.addNamespace(tokens[0], tokens[1]);
                                }
                            }
                            if ((listOfNodes = xpath.selectNodes((Object)root)) != null && listOfNodes.size() > 0) {
                                for (int i = 0; i < listOfNodes.size(); ++i) {
                                    OMContainer omContainer = (OMContainer)listOfNodes.get(i);
                                    if (omContainer instanceof OMDocument) {
                                        omContainer = ((OMDocument)omContainer).getOMDocumentElement();
                                    }
                                    String xpathValue = omContainer.toString();
                                    xpathValues.put(i + 1, xpathValue);
                                }
                                messageData.addValuesForXPath(xpathExp.getKey(), xpathValues);
                                XPathStore.storeMessageXPathData(messageID, messageData);
                            }
                            if (XPathStore.getMessageXPathData(messageID) == null) continue;
                            MessageData msgData = XPathStore.getMessageXPathData(messageID);
                            Map<Integer, String> xpathDet = msgData.getValuesForXPath(xpathExp.getKey());
                            String xpathEvaluation = "";
                            for (int i = 0; i < xpathDet.size(); ++i) {
                                xpathEvaluation = xpathEvaluation + xpathDet.get(i + 1);
                            }
                            xpathEvaluations.put(xpathExp, xpathEvaluation);
                        }
                        AxisConfiguration axisConfig = messageContext.getConfigurationContext().getAxisConfiguration();
                        PublisherUtils.getMessageLookupEventPayload(messageContext, axisConfig, messageContext.getAxisService().getName(), messageContext.getAxisOperation().getName().getLocalPart(), activityID, messageID, xpathEvaluations, activityName, activityDescription);
                    }
                    catch (JaxenException e) {
                        log.error((Object)"Error in creating XPath", (Throwable)e);
                    }
                    catch (XMLStreamException e) {
                        log.error((Object)"Could not create OMBuilder", (Throwable)e);
                    }
                    catch (Exception e) {
                        log.error((Object)"XPathe handler error", (Throwable)e);
                    }
                }
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private ConcurrentMap<String, String> processInMessageContext(MessageContext inMsgContext) {
        ConcurrentHashMap<String, String> activity = new ConcurrentHashMap<String, String>();
        String activityID = "";
        String activityProperty = "";
        String activityPropertyValue = "";
        Iterator itr = inMsgContext.getEnvelope().getHeader().getChildrenWithName(new QName("http://wso2.org/ns/2010/10/bam", "BAMEvent"));
        if (itr.hasNext()) {
            OMElement element = (OMElement)itr.next();
            activityID = element.getAttributeValue(new QName("activityID"));
            Iterator childItr = element.getChildElements();
            if (childItr.hasNext()) {
                OMElement childElement = (OMElement)childItr.next();
                activityProperty = childElement.getAttributeValue(new QName("name"));
                activityPropertyValue = childElement.getAttributeValue(new QName("value"));
            }
        }
        activity.put("ActivityID", activityID);
        activity.put("ActivityProperty", activityProperty);
        activity.put("ActivityPropertyValue", activityPropertyValue);
        return activity;
    }
}

