/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.activity.service.modules;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.data.publisher.activity.service.BAMCalendar;
import org.wso2.carbon.bam.data.publisher.activity.service.Counter;
import org.wso2.carbon.bam.data.publisher.activity.service.PublisherUtils;
import org.wso2.carbon.bam.data.publisher.activity.service.config.EventingConfigData;

public class ActivityOutHandler
extends AbstractHandler {
    private static Log log = LogFactory.getLog(ActivityOutHandler.class);

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        MessageContext inMessagecontext;
        ConcurrentMap<String, String> activity;
        String activityID = "";
        String activityName = "";
        String activityDescription = "";
        String userAgent = "";
        String remoteIPAddress = "";
        String activityProperty = "";
        String activityPropertyValue = "";
        String outMessageID = "";
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            outMessageID = messageContext.getMessageID();
        }
        catch (Exception e) {
            log.warn((Object)"Could not find messageID for the outgoing message.", (Throwable)e);
        }
        UUID uuid = UUID.randomUUID();
        if (outMessageID == null) {
            outMessageID = uuid.toString();
            messageContext.setMessageID(outMessageID);
        }
        if (messageContext.getProperty("REMOTE_ADDR") != null) {
            remoteIPAddress = (String)messageContext.getProperty("REMOTE_ADDR");
        }
        if ((activity = this.processInMessageContext(inMessagecontext = messageContext.getOperationContext().getMessageContext("In"))) != null) {
            activityID = (String)activity.get("ActivityID");
            activityProperty = (String)activity.get("ActivityProperty");
            activityPropertyValue = (String)activity.get("ActivityPropertyValue");
        }
        if (activityProperty != null && activityPropertyValue != null && !activityProperty.equals("") && !activityPropertyValue.equals("")) {
            properties.put(activityProperty, activityPropertyValue);
        }
        this.genericEvent(messageContext, outMessageID, activityID, activityName, activityDescription, userAgent, remoteIPAddress, properties);
        this.engageSOAPHeaders(messageContext, activityID, activityProperty, activityPropertyValue);
        return Handler.InvocationResponse.CONTINUE;
    }

    private synchronized void genericEvent(MessageContext messageContext, String outMessageID, String activityID, String activityName, String activityDescription, String userAgent, String remoteIPAddress, Map<String, String> properties) {
        if (messageContext.getAxisService() != null) {
            EventingConfigData eventingConfigData;
            AxisService service = messageContext.getAxisService();
            Parameter param_admin = service.getParameter("adminService");
            Parameter param_hidden = service.getParameter("hiddenService");
            if (param_admin == null && param_hidden == null && (eventingConfigData = PublisherUtils.getActivityPublisherAdmin().getEventingConfigData()) != null && eventingConfigData.eventingEnabled()) {
                if (eventingConfigData.messageDumpingEnabled()) {
                    this.messageDataEvent(messageContext, outMessageID, activityID, remoteIPAddress, activityName, activityDescription, properties);
                } else {
                    Object value = messageContext.getConfigurationContext().getProperty("BAMMessageCount");
                    if (value != null) {
                        if (value instanceof Counter) {
                            ((Counter)value).increment();
                        }
                    } else {
                        Counter messageCounter = new Counter();
                        messageCounter.increment();
                        messageContext.getConfigurationContext().setProperty("BAMMessageCount", (Object)messageCounter);
                    }
                    PublisherUtils.getEventPayload(messageContext, messageContext.getConfigurationContext().getAxisConfiguration(), outMessageID, activityID, messageContext.getAxisService().getName(), messageContext.getAxisOperation().getName().getLocalPart(), activityName, activityDescription, remoteIPAddress, userAgent, BAMCalendar.getInstance(Calendar.getInstance()).getBAMTimestamp(), properties, "Response");
                }
            }
        }
    }

    private synchronized void messageDataEvent(MessageContext messageContext, String outMessageID, String activityID, String remoteIPAddress, String activityName, String activityDescription, Map<String, String> properties) {
        Object value = messageContext.getConfigurationContext().getProperty("BAMMessageDataCount");
        if (value != null) {
            if (value instanceof Counter) {
                ((Counter)value).increment();
            }
        } else {
            Counter messageCounter = new Counter();
            messageCounter.increment();
            messageContext.getConfigurationContext().setProperty("BAMMessageDataCount", (Object)messageCounter);
        }
        PublisherUtils.getMessageDataEventPayload(messageContext, messageContext.getConfigurationContext().getAxisConfiguration(), messageContext.getAxisService().getName(), messageContext.getAxisOperation().getName().getLocalPart(), outMessageID, activityID, BAMCalendar.getInstance(Calendar.getInstance()).getBAMTimestamp(), "Response", messageContext.getEnvelope().getBody().toString(), remoteIPAddress, activityName, activityDescription, properties);
    }

    private synchronized void engageSOAPHeaders(MessageContext messageContext, String actID, String property, String propertyValue) {
        Iterator itr;
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://wso2.org/ns/2010/10/bam", "ns");
        SOAPEnvelope soapEnvelope = messageContext.getEnvelope();
        String soapNamespaceURI = soapEnvelope.getNamespace().getNamespaceURI();
        SOAPFactory soapFactory = null;
        SOAPHeaderBlock soapHeaderBlock = null;
        if (soapNamespaceURI.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            soapFactory = OMAbstractFactory.getSOAP11Factory();
        } else if (soapNamespaceURI.equals("http://www.w3.org/2003/05/soap-envelope")) {
            soapFactory = OMAbstractFactory.getSOAP12Factory();
        } else {
            log.error((Object)"Not a standard soap message");
        }
        OMElement bampropertyElement = fac.createOMElement(new QName("http://wso2.org/ns/2010/10/bam", "Property", "ns"), null);
        bampropertyElement.addAttribute("name", property, null);
        bampropertyElement.addAttribute("value", propertyValue, null);
        if (soapEnvelope.getHeader() != null && !(itr = soapEnvelope.getHeader().getChildrenWithName(new QName("http://wso2.org/ns/2010/10/bam", "BAMEvent"))).hasNext()) {
            soapHeaderBlock = soapEnvelope.getHeader().addHeaderBlock("BAMEvent", omNs);
            soapHeaderBlock.addAttribute("activityID", actID, null);
            soapHeaderBlock.addChild((OMNode)bampropertyElement);
        }
        if (soapEnvelope.getHeader() == null) {
            if (soapFactory != null) {
                soapFactory.createSOAPHeader(soapEnvelope);
            }
            if (soapEnvelope.getHeader() != null) {
                soapHeaderBlock = soapEnvelope.getHeader().addHeaderBlock("BAMEvent", omNs);
                soapHeaderBlock.addAttribute("activityID", actID, null);
                soapHeaderBlock.addChild((OMNode)bampropertyElement);
            }
        }
    }

    private ConcurrentMap<String, String> processInMessageContext(MessageContext inMsgContext) {
        ConcurrentHashMap<String, String> activity = new ConcurrentHashMap<String, String>();
        String activityID = "";
        String activityProperty = "";
        String activityPropertyValue = "";
        Iterator itr = inMsgContext.getEnvelope().getHeader().getChildrenWithName(new QName("http://wso2.org/ns/2010/10/bam", "BAMEvent"));
        if (itr.hasNext()) {
            OMElement element = (OMElement)itr.next();
            activityID = element.getAttributeValue(new QName("activityID"));
            Iterator childItr = element.getChildElements();
            if (childItr.hasNext()) {
                OMElement childElement = (OMElement)childItr.next();
                activityProperty = childElement.getAttributeValue(new QName("name"));
                activityPropertyValue = childElement.getAttributeValue(new QName("value"));
            }
        }
        activity.put("ActivityID", activityID);
        activity.put("ActivityProperty", activityProperty);
        activity.put("ActivityPropertyValue", activityPropertyValue);
        return activity;
    }
}

