/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.activity.service.modules;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.data.publisher.activity.service.BAMCalendar;
import org.wso2.carbon.bam.data.publisher.activity.service.Counter;
import org.wso2.carbon.bam.data.publisher.activity.service.PublisherUtils;
import org.wso2.carbon.bam.data.publisher.activity.service.config.EventingConfigData;

public class ActivityInHandler
extends AbstractHandler {
    private static Log log = LogFactory.getLog(ActivityInHandler.class);

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        OMElement element;
        Iterator itr;
        String messageID = "";
        String activityID = "";
        String activityName = "";
        String activityDescription = "";
        String userAgent = "";
        String remoteIPAddress = "";
        String activityProperty = "";
        String activityPropertyValue = "";
        HashMap<String, String> properties = new HashMap<String, String>();
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace("http://wso2.org/ns/2010/10/bam", "ns");
        SOAPEnvelope soapEnvelope = messageContext.getEnvelope();
        String soapNamespaceURI = soapEnvelope.getNamespace().getNamespaceURI();
        SOAPFactory soapFactory = null;
        SOAPHeaderBlock soapHeaderBlock = null;
        UUID uuid_random = UUID.randomUUID();
        String uuid = uuid_random.toString();
        if (soapNamespaceURI.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            soapFactory = OMAbstractFactory.getSOAP11Factory();
        } else if (soapNamespaceURI.equals("http://www.w3.org/2003/05/soap-envelope")) {
            soapFactory = OMAbstractFactory.getSOAP12Factory();
        } else {
            log.error((Object)"Not a standard soap message");
        }
        if (soapEnvelope.getHeader() != null) {
            itr = soapEnvelope.getHeader().getChildrenWithName(new QName("http://wso2.org/ns/2010/10/bam", "BAMEvent"));
            if (!itr.hasNext()) {
                soapHeaderBlock = soapEnvelope.getHeader().addHeaderBlock("BAMEvent", omNs);
                soapHeaderBlock.addAttribute("activityID", uuid, null);
            } else {
                element = (OMElement)itr.next();
                String aid = element.getAttributeValue(new QName("activityID"));
                if (aid != null) {
                    if (aid.equals("")) {
                        element.addAttribute("activityID", uuid, null);
                    }
                } else {
                    element.addAttribute("activityID", uuid, null);
                }
            }
        }
        if (soapEnvelope.getHeader() == null) {
            if (soapFactory != null) {
                soapFactory.createSOAPHeader(soapEnvelope);
            }
            if (soapEnvelope.getHeader() != null) {
                soapHeaderBlock = soapEnvelope.getHeader().addHeaderBlock("BAMEvent", omNs);
                soapHeaderBlock.addAttribute("activityID", uuid, null);
            }
        }
        if (messageContext.getProperty("REMOTE_ADDR") != null) {
            remoteIPAddress = (String)messageContext.getProperty("REMOTE_ADDR");
        }
        try {
            messageID = messageContext.getMessageID();
        }
        catch (Exception e) {
            log.warn((Object)"Could not find messageID for the incoming message.", (Throwable)e);
        }
        if (messageID == null) {
            messageID = uuid.toString();
            messageContext.setMessageID(messageID);
        }
        if ((itr = messageContext.getEnvelope().getHeader().getChildrenWithName(new QName("http://wso2.org/ns/2010/10/bam", "BAMEvent"))).hasNext()) {
            element = (OMElement)itr.next();
            activityID = element.getAttributeValue(new QName("activityID"));
            Iterator childItr = element.getChildElements();
            if (childItr.hasNext()) {
                OMElement childElement = (OMElement)childItr.next();
                activityProperty = childElement.getAttributeValue(new QName("name"));
                activityPropertyValue = childElement.getAttributeValue(new QName("value"));
            }
        }
        if (activityProperty != null && activityPropertyValue != null && !activityProperty.equals("") && !activityPropertyValue.equals("")) {
            properties.put(activityProperty, activityPropertyValue);
        }
        this.genericEvent(messageContext, messageID, activityID, activityName, activityDescription, userAgent, remoteIPAddress, properties);
        return Handler.InvocationResponse.CONTINUE;
    }

    private synchronized void genericEvent(MessageContext messageContext, String messageID, String activityID, String activityName, String activityDescription, String userAgent, String remoteIPAddress, Map<String, String> properties) {
        if (messageContext.getAxisService() != null) {
            EventingConfigData eventingConfigData;
            AxisService service = messageContext.getAxisService();
            Parameter param_admin = service.getParameter("adminService");
            Parameter param_hidden = service.getParameter("hiddenService");
            if (param_admin == null && param_hidden == null && (eventingConfigData = PublisherUtils.getActivityPublisherAdmin().getEventingConfigData()) != null && eventingConfigData.eventingEnabled()) {
                if (eventingConfigData.messageDumpingEnabled()) {
                    this.messageDataEvent(messageContext, messageID, activityID, remoteIPAddress, activityName, activityDescription, properties);
                } else {
                    Object value = messageContext.getConfigurationContext().getProperty("BAMMessageCount");
                    if (value != null) {
                        if (value instanceof Counter) {
                            ((Counter)value).increment();
                        }
                    } else {
                        Counter messageCounter = new Counter();
                        messageCounter.increment();
                        messageContext.getConfigurationContext().setProperty("BAMMessageCount", (Object)messageCounter);
                    }
                    PublisherUtils.getEventPayload(messageContext, messageContext.getConfigurationContext().getAxisConfiguration(), messageID, activityID, messageContext.getAxisService().getName(), messageContext.getAxisOperation().getName().getLocalPart(), activityName, activityDescription, remoteIPAddress, userAgent, BAMCalendar.getInstance(Calendar.getInstance()).getBAMTimestamp(), properties, "Request");
                }
            }
        }
    }

    private synchronized void messageDataEvent(MessageContext messageContext, String messageID, String activityID, String remoteIPAddress, String activityName, String activityDescription, Map<String, String> properties) {
        Object value = messageContext.getConfigurationContext().getProperty("BAMMessageDataCount");
        if (value != null) {
            if (value instanceof Counter) {
                ((Counter)value).increment();
            }
        } else {
            Counter messageCounter = new Counter();
            messageCounter.increment();
            messageContext.getConfigurationContext().setProperty("BAMMessageDataCount", (Object)messageCounter);
        }
        PublisherUtils.getMessageDataEventPayload(messageContext, messageContext.getConfigurationContext().getAxisConfiguration(), messageContext.getAxisService().getName(), messageContext.getAxisOperation().getName().getLocalPart(), messageID, activityID, BAMCalendar.getInstance(Calendar.getInstance()).getBAMTimestamp(), "Request", messageContext.getEnvelope().getBody().toString(), remoteIPAddress, activityName, activityDescription, properties);
    }
}

