/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.activity.service.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.bam.data.publisher.activity.service.PublisherUtils;
import org.wso2.carbon.bam.data.publisher.activity.service.config.RegistryPersistanceManager;
import org.wso2.carbon.bam.data.publisher.activity.service.services.ActivityPublisherAdmin;
import org.wso2.carbon.bam.lwevent.core.LightWeightEventBrokerInterface;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class ActivityServiceComponent {
    private static Log log = LogFactory.getLog(ActivityServiceComponent.class);
    private static LightWeightEventBrokerInterface lightWeightEventBroker;

    protected void activate(ComponentContext ctxt) {
        try {
            PublisherUtils.getConfigurationContext().getAxisConfiguration().engageModule("wso2bamactivitypublisher");
            ActivityPublisherAdmin admin = new ActivityPublisherAdmin();
            PublisherUtils.setActivityPublisherAdmin(admin);
            if (log.isDebugEnabled()) {
                log.debug((Object)"BAM Activity publisher bundle is activated");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate BAM Activity publisher bundle", e);
        }
    }

    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"BAM Activity publisher bundle is deactivated");
        }
    }

    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"The Configuration Context Service is set");
        PublisherUtils.setConfigurationContext(configurationContextService.getServerConfigContext());
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        PublisherUtils.setConfigurationContext(null);
    }

    public ServerConfiguration getServerConfiguration() {
        return PublisherUtils.getServerConfiguration();
    }

    protected void setServerConfiguration(ServerConfiguration serverConfiguration) {
        PublisherUtils.setServerConfiguration(serverConfiguration);
    }

    protected void unsetServerConfiguration(ServerConfiguration serverConfiguration) {
        PublisherUtils.setServerConfiguration(null);
    }

    protected void setRegistryService(RegistryService registryService) {
        try {
            RegistryPersistanceManager.setRegistry((Registry)registryService.getConfigSystemRegistry());
        }
        catch (Exception e) {
            log.error((Object)"Cannot retrieve System Registry", (Throwable)e);
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        RegistryPersistanceManager.setRegistry(null);
    }

    protected void setLWEventBroker(LightWeightEventBrokerInterface lightWeightEventBroker) {
        ActivityServiceComponent.lightWeightEventBroker = lightWeightEventBroker;
    }

    protected void unsetLWEventBroker(LightWeightEventBrokerInterface lightWeightEventBroker) {
        ActivityServiceComponent.lightWeightEventBroker = null;
    }
}

