/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.activity.service.config;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.data.publisher.activity.service.config.EventingConfigData;
import org.wso2.carbon.bam.data.publisher.activity.service.config.XPathConfigData;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class RegistryPersistanceManager {
    private static Registry registry;
    private static final String SEPERATOR = "/";
    private static EventingConfigData eventingConfigData;
    private Log log = LogFactory.getLog(RegistryPersistanceManager.class);

    public RegistryPersistanceManager() {
        this.load();
    }

    public static void setRegistry(Registry registryParam) {
        registry = registryParam;
    }

    public String getConfigurationProperty(String propertyName) throws RegistryException {
        String resourcePath = "/repository/bam/data/publishers/activity/" + propertyName;
        String value = null;
        if (registry.resourceExists(resourcePath)) {
            Resource resource = registry.get(resourcePath);
            value = resource.getProperty(propertyName);
        }
        return value;
    }

    public String[] getMultiValuedConfigurationProperty(String propertyName) throws RegistryException {
        String resourcePath = "/repository/bam/data/publishers/activity/" + propertyName;
        ArrayList<String> values = new ArrayList<String>();
        if (registry.resourceExists(resourcePath)) {
            Resource resource = registry.get(resourcePath);
            int counter = 0;
            String propertyValue = resource.getProperty(propertyName + counter);
            while (propertyValue != null) {
                values.add(propertyValue);
                propertyValue = resource.getProperty(propertyName + ++counter);
            }
        }
        return values.toArray(new String[0]);
    }

    public void updateConfigurationProperty(String propertyName, String value) throws RegistryException {
        String resourcePath = "/repository/bam/data/publishers/activity/" + propertyName;
        if (registry != null) {
            if (!registry.resourceExists(resourcePath)) {
                Resource resource = registry.newResource();
                resource.addProperty(propertyName, value);
                registry.put(resourcePath, resource);
            } else {
                Resource resource = registry.get(resourcePath);
                resource.setProperty(propertyName, value);
                registry.put(resourcePath, resource);
            }
        }
    }

    public void updateMultivaluedConfigurationProperty(String propertyName, String[] values) throws RegistryException {
        String resourcePath = "/repository/bam/data/publishers/activity/" + propertyName;
        if (registry != null) {
            Resource resource;
            if (!registry.resourceExists(resourcePath)) {
                resource = registry.newResource();
                for (int i = 0; i < values.length; ++i) {
                    String property = propertyName + i;
                    resource.addProperty(property, values[i]);
                }
            } else {
                resource = registry.get(resourcePath);
                this.clearProperties(resource, propertyName);
                for (int i = 0; i < values.length; ++i) {
                    String property = propertyName + i;
                    resource.setProperty(property, values[i]);
                }
            }
            registry.put(resourcePath, resource);
        }
    }

    private void clearProperties(Resource resource, String propertyName) {
        int counter = 0;
        String value = resource.getProperty(propertyName + counter);
        while (value != null) {
            resource.removeProperty(propertyName + counter);
            value = resource.getProperty(propertyName + ++counter);
        }
    }

    private void clearXpathProperties(Resource resource) {
        resource.removeProperty("XPath");
        int counter = 0;
        String value = resource.getProperty("ns" + counter);
        while (value != null) {
            resource.removeProperty("ns" + counter);
            value = resource.getProperty("ns" + ++counter);
        }
    }

    private void load() {
        eventingConfigData.setEnableEventing("ON");
        eventingConfigData.setMessageThreshold(2);
        eventingConfigData.setEnableMessageLookup("OFF");
        eventingConfigData.setXPathExpressions(new String[]{""});
        eventingConfigData.setEnableMessageDumping("OFF");
        try {
            String eventingStatus = this.getConfigurationProperty("EnableEventing");
            String messageLookupStatus = this.getConfigurationProperty("EnableMessageLookup");
            String messageDumpingStatus = this.getConfigurationProperty("EnableMessageDumping");
            if (eventingStatus != null) {
                eventingConfigData.setEnableEventing(eventingStatus);
                eventingConfigData.setMessageThreshold(Integer.parseInt(this.getConfigurationProperty("MessageThreshold")));
            }
            if (messageLookupStatus != null) {
                eventingConfigData.setEnableMessageLookup(messageLookupStatus);
                eventingConfigData.setXPathExpressions(this.getMultiValuedConfigurationProperty(""));
            }
            if (messageDumpingStatus != null) {
                eventingConfigData.setEnableMessageDumping(messageDumpingStatus);
            }
            this.update(eventingConfigData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update(EventingConfigData eventingConfigData) throws RegistryException {
        this.updateConfigurationProperty("EnableEventing", eventingConfigData.getEnableEventing());
        this.updateConfigurationProperty("MessageThreshold", Integer.toString(eventingConfigData.getMessageThreshold()));
        this.updateConfigurationProperty("EnableMessageLookup", eventingConfigData.getEnableMessageLookup());
        this.updateConfigurationProperty("EnableMessageDumping", eventingConfigData.getEnableMessageDumping());
        RegistryPersistanceManager.eventingConfigData = eventingConfigData;
    }

    public void update(XPathConfigData xpathConfigData) throws RegistryException {
        String resourcePath = "/repository/bam/data/publishers/activity/xpaths/" + xpathConfigData.getKey();
        if (registry != null) {
            Resource resource;
            if (!registry.resourceExists(resourcePath)) {
                resource = registry.newResource();
                resource.addProperty("XPath", xpathConfigData.getXpath());
                String[] nameSpaces = xpathConfigData.getNameSpaces();
                if (nameSpaces != null) {
                    for (int i = 0; i < xpathConfigData.getNameSpaces().length; ++i) {
                        String property = "ns" + i;
                        resource.addProperty(property, nameSpaces[i]);
                    }
                }
            } else if (xpathConfigData.isEditing()) {
                resource = registry.get(resourcePath);
                this.clearXpathProperties(resource);
                resource.addProperty("XPath", xpathConfigData.getXpath());
                String[] nameSpaces = xpathConfigData.getNameSpaces();
                if (nameSpaces != null) {
                    for (int i = 0; i < xpathConfigData.getNameSpaces().length; ++i) {
                        String property = "ns" + i;
                        resource.addProperty(property, nameSpaces[i]);
                    }
                }
            } else {
                throw new RegistryException("XPath Expression Key should be unique..");
            }
            registry.put(resourcePath, resource);
        }
    }

    public void rollback(XPathConfigData xpathConfigData) throws RegistryException {
        String resourcePath = "/repository/bam/data/publishers/activity/xpaths/" + xpathConfigData.getKey();
        if (registry != null) {
            try {
                if (registry.resourceExists(resourcePath)) {
                    registry.delete(resourcePath);
                }
            }
            catch (RegistryException e) {
                this.log.error((Object)"Error while performing roll back..", (Throwable)e);
                throw e;
            }
        }
    }

    public EventingConfigData getEventingConfigData() {
        return eventingConfigData;
    }

    public XPathConfigData[] getXPathConfigData() throws RegistryException {
        String resourcePath = "/repository/bam/data/publishers/activity/xpaths";
        ArrayList<XPathConfigData> xpathConfigs = new ArrayList<XPathConfigData>();
        if (registry != null && registry.resourceExists(resourcePath)) {
            Resource resource = registry.get(resourcePath);
            if (!(resource instanceof Collection)) {
                return new XPathConfigData[0];
            }
            Collection collection = (Collection)resource;
            String[] children = collection.getChildren();
            if (children != null) {
                for (String child : children) {
                    Resource xpath = registry.get(child);
                    XPathConfigData data = new XPathConfigData();
                    data.setEditing(false);
                    data.setKey(RegistryUtils.getResourceName((String)child));
                    data.setXpath(xpath.getProperty("XPath"));
                    int counter = 0;
                    String property = "ns" + counter;
                    String nameSpace = xpath.getProperty(property);
                    ArrayList<String> nameSpaces = new ArrayList<String>();
                    while (nameSpace != null) {
                        nameSpaces.add(nameSpace);
                        property = "ns" + ++counter;
                        nameSpace = xpath.getProperty(property);
                    }
                    data.setNameSpaces(nameSpaces.toArray(new String[nameSpaces.size()]));
                    xpathConfigs.add(data);
                }
            }
        }
        return xpathConfigs.toArray(new XPathConfigData[xpathConfigs.size()]);
    }

    static {
        eventingConfigData = new EventingConfigData();
    }
}

