/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.activity.service;

import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.threadpool.ThreadFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.data.publisher.activity.service.Counter;
import org.wso2.carbon.bam.data.publisher.activity.service.EventGenarator;
import org.wso2.carbon.bam.data.publisher.activity.service.ServiceHolder;
import org.wso2.carbon.bam.data.publisher.activity.service.config.EventingConfigData;
import org.wso2.carbon.bam.data.publisher.activity.service.config.XPathConfigData;
import org.wso2.carbon.bam.data.publisher.activity.service.services.ActivityPublisherAdmin;
import org.wso2.carbon.bam.lwevent.core.LightWeightEventBroker;
import org.wso2.carbon.bam.lwevent.core.LightWeightEventBrokerInterface;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.utils.NetworkUtils;

public class PublisherUtils {
    private static Log log = LogFactory.getLog(PublisherUtils.class);
    private static ConfigurationContext configurationContext;
    private static LightWeightEventBrokerInterface lightWeightEventBroker;
    private static ServerConfiguration serverConfiguration;
    private static ActivityPublisherAdmin activityPublisherAdmin;
    private static String serverName;
    private static final String TRANSPORT = "https";
    private static ConcurrentMap<String, Map<String, OMElement>> messageMap;
    private static ConcurrentMap<String, Map<String, OMElement>> messageDataMap;
    private static ConcurrentMap<String, Map<String, OMElement>> xpathMap;

    public static synchronized ConcurrentMap<String, Map<String, OMElement>> getMessageMap() {
        return messageMap;
    }

    public static synchronized void setMessageMap(ConcurrentMap<String, Map<String, OMElement>> map) {
        messageMap = map;
    }

    public static synchronized ConcurrentMap<String, Map<String, OMElement>> getMessageDataMap() {
        return messageDataMap;
    }

    public static synchronized void setMessageDataMap(ConcurrentMap<String, Map<String, OMElement>> map) {
        messageDataMap = map;
    }

    public static synchronized ConcurrentMap<String, Map<String, OMElement>> getXpathMap() {
        return xpathMap;
    }

    public static synchronized void setXpathMap(ConcurrentMap<String, Map<String, OMElement>> map) {
        xpathMap = map;
    }

    public static void setServerName(String name) {
        serverName = name;
    }

    public static String getServerName() {
        return serverName;
    }

    public static String updateServerName(AxisConfiguration axisConfiguration) {
        if (serverName == null) {
            try {
                String context;
                String carbonHttpsPort = System.getProperty("carbon.https.port");
                if (carbonHttpsPort == null) {
                    carbonHttpsPort = (String)axisConfiguration.getTransportIn(TRANSPORT).getParameter("port").getValue();
                }
                if ((context = ServerConfiguration.getInstance().getFirstProperty("WebContextRoot")).equals("/")) {
                    context = "";
                }
                serverName = "https://" + NetworkUtils.getLocalHostname() + ":" + carbonHttpsPort + context;
            }
            catch (SocketException ignored) {
                serverName = "https://localhost:9943";
            }
        }
        return serverName;
    }

    public static void publishXPathConfigurations(XPathConfigData data) throws Exception {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace activityNamespace = factory.createOMNamespace("http://wso2.org/ns/2009/09/bam/service/activity/data", "activitydata");
        OMElement propertyFilterElement = factory.createOMElement("PropertyFilter", activityNamespace);
        OMElement eventElement = factory.createOMElement("Event", activityNamespace);
        eventElement.addChild((OMNode)propertyFilterElement);
        OMElement serverNameElement = factory.createOMElement("ServerName", activityNamespace);
        factory.createOMText((OMContainer)serverNameElement, PublisherUtils.updateServerName(PublisherUtils.getConfigurationContext().getAxisConfiguration()));
        OMElement xpathExpressionsElement = factory.createOMElement("XPathExpressions", activityNamespace);
        OMElement xpathExpressionElement = factory.createOMElement("XPathExpression", activityNamespace);
        OMElement expressionKeyElement = factory.createOMElement("ExpressionKey", activityNamespace);
        factory.createOMText((OMContainer)expressionKeyElement, data.getKey());
        OMElement aliasElement = factory.createOMElement("Alias", activityNamespace);
        factory.createOMText((OMContainer)aliasElement, data.getAlias());
        OMElement namespacesElement = factory.createOMElement("Namespaces", activityNamespace);
        if (data.getNameSpaces() != null) {
            for (String ns : data.getNameSpaces()) {
                OMElement namespaceElement = factory.createOMElement("Namespace", activityNamespace);
                factory.createOMText((OMContainer)namespaceElement, ns);
                namespacesElement.addChild((OMNode)namespaceElement);
            }
        }
        OMElement expressionElement = factory.createOMElement("Expression", activityNamespace);
        factory.createOMText((OMContainer)expressionElement, data.getXpath());
        xpathExpressionElement.addChild((OMNode)expressionKeyElement);
        xpathExpressionElement.addChild((OMNode)aliasElement);
        xpathExpressionElement.addChild((OMNode)expressionElement);
        xpathExpressionElement.addChild((OMNode)namespacesElement);
        xpathExpressionsElement.addChild((OMNode)xpathExpressionElement);
        propertyFilterElement.addChild((OMNode)serverNameElement);
        propertyFilterElement.addChild((OMNode)xpathExpressionsElement);
        PublisherUtils.publishSynchronously(eventElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void publishSynchronously(OMElement eventBody) throws Exception {
        if (eventBody != null) {
            LightWeightEventBrokerInterface eb = ServiceHolder.getLWEventBroker();
            try {
                SuperTenantCarbonContext.startTenantFlow();
                int tenantId = SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)PublisherUtils.getConfigurationContext()).getTenantId();
                SuperTenantCarbonContext.getCurrentContext().setTenantId(tenantId);
                SuperTenantCarbonContext.getCurrentContext().getTenantDomain(true);
                eb.publish("/carbon/bam/data/publishers/activity", eventBody);
            }
            finally {
                SuperTenantCarbonContext.endTenantFlow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getEventPayload(MessageContext messageContext, AxisConfiguration axisConfiguration, String messageID, String activityID, String serviceName, String operationName, String activityName, String description, String ipAddress, String userAgent, String timeStamp, Map<String, String> properties, String messageDirection) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace activityDataNamespace = factory.createOMNamespace("http://wso2.org/ns/2009/09/bam/service/activity/data", "activitydata");
        OMElement serverNameElement = factory.createOMElement("ServerName", activityDataNamespace);
        factory.createOMText((OMContainer)serverNameElement, PublisherUtils.updateServerName(axisConfiguration));
        OMElement serviceNameElement = factory.createOMElement("ServiceName", activityDataNamespace);
        factory.createOMText((OMContainer)serviceNameElement, serviceName);
        OMElement operationNameElement = factory.createOMElement("OperationName", activityDataNamespace);
        factory.createOMText((OMContainer)operationNameElement, operationName);
        OMElement activityNameElement = factory.createOMElement("ActivityName", activityDataNamespace);
        factory.createOMText((OMContainer)activityNameElement, activityName);
        OMElement activityDescriptionElement = factory.createOMElement("ActivityDescription", activityDataNamespace);
        factory.createOMText((OMContainer)activityDescriptionElement, description);
        OMElement actiivtyIdElement = factory.createOMElement("ActivityID", activityDataNamespace);
        factory.createOMText((OMContainer)actiivtyIdElement, activityID);
        OMElement messageIDElement = factory.createOMElement("MessageID", activityDataNamespace);
        factory.createOMText((OMContainer)messageIDElement, messageID);
        OMElement messageDirectionElement = factory.createOMElement("MessageDirection", activityDataNamespace);
        factory.createOMText((OMContainer)messageDirectionElement, messageDirection);
        OMElement remoteIPElement = factory.createOMElement("RemoteIPAddress", activityDataNamespace);
        factory.createOMText((OMContainer)remoteIPElement, ipAddress);
        OMElement userAgentElement = factory.createOMElement("UserAgent", activityDataNamespace);
        factory.createOMText((OMContainer)userAgentElement, userAgent);
        OMElement timeStampElement = factory.createOMElement("TimeStamp", activityDataNamespace);
        factory.createOMText((OMContainer)timeStampElement, timeStamp);
        OMElement propertiesElement = factory.createOMElement("ActivityProperties", activityDataNamespace);
        for (String property : properties.keySet()) {
            OMElement propertyElement = factory.createOMElement("ActivityProperty", activityDataNamespace);
            OMElement propertyChildElement = factory.createOMElement("ActivityPropertyChild", activityDataNamespace);
            factory.createOMText((OMContainer)propertyChildElement, property);
            OMElement propertyValue = factory.createOMElement("PropertyValue", activityDataNamespace);
            factory.createOMText((OMContainer)propertyValue, properties.get(property));
            propertyElement.addChild((OMNode)propertyChildElement);
            propertyElement.addChild((OMNode)propertyValue);
            propertiesElement.addChild((OMNode)propertyElement);
        }
        Object value = messageContext.getConfigurationContext().getProperty("BAMMessageCount");
        if (value != null && value instanceof Counter) {
            PublisherUtils.storeValues(messageID, serverNameElement, serviceNameElement, operationNameElement, activityNameElement, activityDescriptionElement, actiivtyIdElement, messageIDElement, remoteIPElement, userAgentElement, timeStampElement, propertiesElement, messageDirectionElement);
        }
        OMNamespace activityNamespace = factory.createOMNamespace("http://wso2.org/ns/2009/09/bam/service/activity/data", "activitydata");
        OMElement eventElement = factory.createOMElement("Event", activityNamespace);
        EventingConfigData eventingConfigData = PublisherUtils.getActivityPublisherAdmin().getEventingConfigData();
        if (((Counter)value).getCount() > eventingConfigData.getMessageThreshold()) {
            EventingConfigData eventingConfigData2 = eventingConfigData;
            synchronized (eventingConfigData2) {
                ConfigurationContext configContxt = new ConfigurationContext(axisConfiguration);
                ThreadFactory threadFactory = configContxt.getThreadPool();
                EventGenarator thread = new EventGenarator(messageContext, null, eventingConfigData.getMessageThreshold(), eventElement, true, false, false, PublisherUtils.getMessageMap(), null, null);
                threadFactory.execute((Runnable)thread);
                PublisherUtils.setMessageMap(new ConcurrentHashMap<String, Map<String, OMElement>>());
                Counter messageCounter = new Counter();
                messageCounter.resetMessageCount(messageContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getMessageLookupEventPayload(MessageContext messageContext, AxisConfiguration axisConfiguration, String serviceName, String operationName, String activityID, String messageID, Map<XPathConfigData, String> xpathEvaluations, String activityName, String activityDescription) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace activityNamespace = factory.createOMNamespace("http://wso2.org/ns/2009/09/bam/service/activity/data", "activitydata");
        OMElement eventElement = factory.createOMElement("Event", activityNamespace);
        OMElement serverNameElement = factory.createOMElement("ServerName", activityNamespace);
        factory.createOMText((OMContainer)serverNameElement, PublisherUtils.updateServerName(axisConfiguration));
        OMElement serviceNameElement = factory.createOMElement("ServiceName", activityNamespace);
        factory.createOMText((OMContainer)serviceNameElement, serviceName);
        OMElement operationNameElement = factory.createOMElement("OperationName", activityNamespace);
        factory.createOMText((OMContainer)operationNameElement, operationName);
        OMElement activityIdElement = factory.createOMElement("ActivityID", activityNamespace);
        factory.createOMText((OMContainer)activityIdElement, activityID);
        OMElement messageIDElement = factory.createOMElement("MessageID", activityNamespace);
        factory.createOMText((OMContainer)messageIDElement, messageID);
        OMElement xpathExpressionsElement = factory.createOMElement("XPathExpressions", activityNamespace);
        for (XPathConfigData xpathConfig : xpathEvaluations.keySet()) {
            OMElement xpathExpressionElement = factory.createOMElement("XPathExpression", activityNamespace);
            OMElement keyElement = factory.createOMElement("ExpressionKey", activityNamespace);
            factory.createOMText((OMContainer)keyElement, xpathConfig.getKey());
            OMElement expressionElement = factory.createOMElement("Expression", activityNamespace);
            factory.createOMText((OMContainer)expressionElement, xpathConfig.getXpath());
            OMElement xpathValue = factory.createOMElement("XPathValue", activityNamespace);
            factory.createOMText((OMContainer)xpathValue, xpathEvaluations.get(xpathConfig));
            OMElement aliasElement = factory.createOMElement("Alias", activityNamespace);
            factory.createOMText((OMContainer)aliasElement, xpathConfig.getAlias());
            OMElement namespacesElement = factory.createOMElement("Namespaces", activityNamespace);
            if (xpathConfig.getNameSpaces() != null) {
                for (String ns : xpathConfig.getNameSpaces()) {
                    OMElement namespaceElement = factory.createOMElement("Namespace", activityNamespace);
                    factory.createOMText((OMContainer)namespaceElement, ns);
                    namespacesElement.addChild((OMNode)namespaceElement);
                }
            }
            xpathExpressionElement.addChild((OMNode)keyElement);
            xpathExpressionElement.addChild((OMNode)expressionElement);
            xpathExpressionElement.addChild((OMNode)aliasElement);
            xpathExpressionElement.addChild((OMNode)namespacesElement);
            xpathExpressionElement.addChild((OMNode)xpathValue);
            xpathExpressionsElement.addChild((OMNode)xpathExpressionElement);
        }
        OMElement activityNameElement = factory.createOMElement("ActivityName", activityNamespace);
        factory.createOMText((OMContainer)activityNameElement, activityName);
        OMElement activityDescriptionElement = factory.createOMElement("ActivityDescription", activityNamespace);
        factory.createOMText((OMContainer)activityDescriptionElement, activityDescription);
        Object value = messageContext.getConfigurationContext().getProperty("BAMXPathCount");
        if (value != null && value instanceof Counter) {
            PublisherUtils.storeXPathValues(messageID, serverNameElement, serviceNameElement, operationNameElement, activityIdElement, messageIDElement, xpathExpressionsElement, activityNameElement, activityDescriptionElement);
            EventingConfigData eventingConfigData = PublisherUtils.getActivityPublisherAdmin().getEventingConfigData();
            if (((Counter)value).getCount() > eventingConfigData.getMessageThreshold()) {
                EventingConfigData eventingConfigData2 = eventingConfigData;
                synchronized (eventingConfigData2) {
                    ConfigurationContext configContxt = new ConfigurationContext(axisConfiguration);
                    ThreadFactory threadFactory = configContxt.getThreadPool();
                    EventGenarator thread = new EventGenarator(messageContext, null, eventingConfigData.getMessageThreshold(), eventElement, false, false, true, null, null, PublisherUtils.getXpathMap());
                    threadFactory.execute((Runnable)thread);
                    PublisherUtils.setXpathMap(new ConcurrentHashMap<String, Map<String, OMElement>>());
                    Counter messageCounter = new Counter();
                    messageCounter.resetXPathCount(messageContext);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getMessageDataEventPayload(MessageContext messageContext, AxisConfiguration axisConfiguration, String serviceName, String operationName, String messageID, String activityID, String timeStamp, String messageDirection, String messageBody, String ipAddress, String activityName, String activityDescription, Map<String, String> properties) {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMNamespace activityNamespace = factory.createOMNamespace("http://wso2.org/ns/2009/09/bam/service/activity/data", "activitydata");
        OMElement serverNameElement = factory.createOMElement("ServerName", activityNamespace);
        factory.createOMText((OMContainer)serverNameElement, PublisherUtils.updateServerName(axisConfiguration));
        OMElement serviceNameElement = factory.createOMElement("ServiceName", activityNamespace);
        factory.createOMText((OMContainer)serviceNameElement, serviceName);
        OMElement operationNameElement = factory.createOMElement("OperationName", activityNamespace);
        factory.createOMText((OMContainer)operationNameElement, operationName);
        OMElement actiivtyIdElement = factory.createOMElement("ActivityID", activityNamespace);
        factory.createOMText((OMContainer)actiivtyIdElement, activityID);
        OMElement messageIDElement = factory.createOMElement("MessageID", activityNamespace);
        factory.createOMText((OMContainer)messageIDElement, messageID);
        OMElement messageBodyElement = factory.createOMElement("MessageBody", activityNamespace);
        factory.createOMText((OMContainer)messageBodyElement, messageBody);
        OMElement messageDirectionElement = factory.createOMElement("MessageDirection", activityNamespace);
        factory.createOMText((OMContainer)messageDirectionElement, messageDirection);
        OMElement timeStampElement = factory.createOMElement("TimeStamp", activityNamespace);
        factory.createOMText((OMContainer)timeStampElement, timeStamp);
        OMElement propertiesElement = factory.createOMElement("ActivityProperties", activityNamespace);
        for (String property : properties.keySet()) {
            OMElement propertyElement = factory.createOMElement("ActivityProperty", activityNamespace);
            OMElement propertyChildElement = factory.createOMElement("ActivityPropertyChild", activityNamespace);
            factory.createOMText((OMContainer)propertyChildElement, property);
            OMElement propertyValue = factory.createOMElement("PropertyValue", activityNamespace);
            factory.createOMText((OMContainer)propertyValue, properties.get(property));
            propertyElement.addChild((OMNode)propertyChildElement);
            propertyElement.addChild((OMNode)propertyValue);
            propertiesElement.addChild((OMNode)propertyElement);
        }
        OMElement remoteIPElement = factory.createOMElement("RemoteIPAddress", activityNamespace);
        factory.createOMText((OMContainer)remoteIPElement, ipAddress);
        OMElement activityNameElement = factory.createOMElement("ActivityName", activityNamespace);
        factory.createOMText((OMContainer)activityNameElement, activityName);
        OMElement activityDescriptionElement = factory.createOMElement("ActivityDescription", activityNamespace);
        factory.createOMText((OMContainer)activityDescriptionElement, activityDescription);
        Object value = messageContext.getConfigurationContext().getProperty("BAMMessageDataCount");
        if (value != null && value instanceof Counter) {
            PublisherUtils.storeMessageDataValues(messageID, serverNameElement, serviceNameElement, operationNameElement, activityNameElement, activityDescriptionElement, actiivtyIdElement, messageIDElement, remoteIPElement, timeStampElement, messageDirectionElement, messageBodyElement, propertiesElement);
            OMNamespace actNamespace = factory.createOMNamespace("http://wso2.org/ns/2009/09/bam/service/activity/data", "activitydata");
            OMElement eventElement = factory.createOMElement("Event", actNamespace);
            EventingConfigData eventingConfigData = PublisherUtils.getActivityPublisherAdmin().getEventingConfigData();
            if (((Counter)value).getCount() > eventingConfigData.getMessageThreshold()) {
                EventingConfigData eventingConfigData2 = eventingConfigData;
                synchronized (eventingConfigData2) {
                    ConfigurationContext configContxt = new ConfigurationContext(axisConfiguration);
                    ThreadFactory threadFactory = configContxt.getThreadPool();
                    EventGenarator thread = new EventGenarator(messageContext, null, eventingConfigData.getMessageThreshold(), eventElement, false, true, false, null, PublisherUtils.getMessageDataMap(), null);
                    threadFactory.execute((Runnable)thread);
                    PublisherUtils.setMessageDataMap(new ConcurrentHashMap<String, Map<String, OMElement>>());
                    Counter messageCounter = new Counter();
                    messageCounter.resetMessageDataCount(messageContext);
                }
            }
        }
    }

    private static void storeValues(String key, OMElement serverNameElement, OMElement serviceNameElement, OMElement operationNameElement, OMElement activityNameElement, OMElement activityDescriptionElement, OMElement actiivtyIdElement, OMElement messageIDElement, OMElement remoteIPElement, OMElement userAgentElement, OMElement timeStampElement, OMElement propertiesElement, OMElement messageDirectionElement) {
        ConcurrentHashMap<String, OMElement> map = new ConcurrentHashMap<String, OMElement>();
        map.put("ServerElement", serverNameElement);
        map.put("ServiceElement", serviceNameElement);
        map.put("OperationElement", operationNameElement);
        map.put("ActivityNameElement", activityNameElement);
        map.put("ActivityDescriptionElement", activityDescriptionElement);
        map.put("ActivityIdElement", actiivtyIdElement);
        map.put("MessageIdElement", messageIDElement);
        map.put("RemoteIpElement", remoteIPElement);
        map.put("UserAgentElement", userAgentElement);
        map.put("TimeStampElement", timeStampElement);
        map.put("PropertiesElement", propertiesElement);
        map.put("MessageDirElement", messageDirectionElement);
        PublisherUtils.storeMessage(key, map);
    }

    private static void storeMessage(String key, ConcurrentMap<String, OMElement> actMap) {
        if (!messageMap.containsKey(key)) {
            messageMap.put(key, new ConcurrentHashMap());
        }
        ((Map)messageMap.get(key)).putAll(actMap);
    }

    private static void storeMessageDataValues(String key, OMElement serverNameElement, OMElement serviceNameElement, OMElement operationNameElement, OMElement activityNameElement, OMElement activityDescriptionElement, OMElement actiivtyIdElement, OMElement messageIDElement, OMElement remoteIPElement, OMElement timeStampElement, OMElement messageDirectionElement, OMElement messageBodyElement, OMElement propertiesElement) {
        ConcurrentHashMap<String, OMElement> map = new ConcurrentHashMap<String, OMElement>();
        map.put("ServerElement", serverNameElement);
        map.put("ServiceElement", serviceNameElement);
        map.put("OperationElement", operationNameElement);
        map.put("ActivityNameElement", activityNameElement);
        map.put("ActivityDescriptionElement", activityDescriptionElement);
        map.put("ActivityIdElement", actiivtyIdElement);
        map.put("MessageIdElement", messageIDElement);
        map.put("RemoteIpElement", remoteIPElement);
        map.put("TimeStampElement", timeStampElement);
        map.put("PropertiesElement", propertiesElement);
        map.put("MessageDirElement", messageDirectionElement);
        map.put("MessageBodyElement", messageBodyElement);
        PublisherUtils.storeMessageData(key, map);
    }

    private static void storeMessageData(String key, Map<String, OMElement> actMap) {
        if (!messageDataMap.containsKey(key)) {
            messageDataMap.put(key, new HashMap());
        }
        ((Map)messageDataMap.get(key)).putAll(actMap);
    }

    private static void storeXPathValues(String key, OMElement serverNameElement, OMElement serviceNameElement, OMElement operationNameElement, OMElement activityIdElement, OMElement messageIDElement, OMElement xpathExpressionsElement, OMElement activityNameElement, OMElement activityDescriptionElement) {
        ConcurrentHashMap<String, OMElement> map = new ConcurrentHashMap<String, OMElement>();
        map.put("ServerElement", serverNameElement);
        map.put("ServiceElement", serviceNameElement);
        map.put("OperationElement", operationNameElement);
        map.put("ActivityNameElement", activityNameElement);
        map.put("ActivityDescriptionElement", activityDescriptionElement);
        map.put("ActivityIdElement", activityIdElement);
        map.put("MessageIdElement", messageIDElement);
        map.put("XPathExpElement", xpathExpressionsElement);
        PublisherUtils.storeXPathData(key, map);
    }

    private static void storeXPathData(String key, Map<String, OMElement> actMap) {
        if (!xpathMap.containsKey(key)) {
            xpathMap.put(key, new HashMap());
        }
        ((Map)xpathMap.get(key)).putAll(actMap);
    }

    public static LightWeightEventBrokerInterface getEventBroker() {
        return lightWeightEventBroker;
    }

    public static void setLWEventBroker(LightWeightEventBroker eventBroker) {
        lightWeightEventBroker = eventBroker;
    }

    public static ConfigurationContext getConfigurationContext() {
        return configurationContext;
    }

    public static void setConfigurationContext(ConfigurationContext configurationContext) {
        PublisherUtils.configurationContext = configurationContext;
    }

    public static ServerConfiguration getServerConfiguration() {
        return serverConfiguration;
    }

    public static void setServerConfiguration(ServerConfiguration serverConfiguration) {
        PublisherUtils.serverConfiguration = serverConfiguration;
    }

    public static ActivityPublisherAdmin getActivityPublisherAdmin() {
        return activityPublisherAdmin;
    }

    public static void setActivityPublisherAdmin(ActivityPublisherAdmin activityPublisherAdmin) {
        PublisherUtils.activityPublisherAdmin = activityPublisherAdmin;
    }

    static {
        activityPublisherAdmin = null;
        messageMap = new ConcurrentHashMap<String, Map<String, OMElement>>();
        messageDataMap = new ConcurrentHashMap<String, Map<String, OMElement>>();
        xpathMap = new ConcurrentHashMap<String, Map<String, OMElement>>();
    }
}

