/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.activity.service;

import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.data.publisher.activity.service.PublisherUtils;
import org.wso2.carbon.bam.data.publisher.activity.service.ServiceHolder;
import org.wso2.carbon.bam.lwevent.core.LightWeightEventBrokerInterface;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.event.core.Message;

class EventGenarator
implements Runnable {
    private Log log = LogFactory.getLog(EventGenarator.class);
    OMFactory factory = OMAbstractFactory.getOMFactory();
    int threshold;
    MessageContext messageContext;
    OMElement eventElement;
    boolean genericEvent = false;
    boolean messageDumpEvent = false;
    boolean xpathEvent = false;
    AxisConfiguration axisConf;
    OMNamespace activityNamespace = this.factory.createOMNamespace("http://wso2.org/ns/2009/09/bam/service/activity/data", "activitydata");
    ConcurrentMap<String, Map<String, OMElement>> messageMap = null;
    ConcurrentMap<String, Map<String, OMElement>> messageDataMap = null;
    ConcurrentMap<String, Map<String, OMElement>> xpathMap = null;

    EventGenarator(MessageContext messageContext, AxisConfiguration axisConf, int threshold, OMElement eventElement, boolean genericEvent, boolean messageDumpEvent, boolean xpathEvent, ConcurrentMap<String, Map<String, OMElement>> messageMap, ConcurrentMap<String, Map<String, OMElement>> messageDataMap, ConcurrentMap<String, Map<String, OMElement>> xpathMap) {
        this.messageContext = messageContext;
        this.threshold = threshold;
        this.eventElement = eventElement;
        this.genericEvent = genericEvent;
        this.messageDumpEvent = messageDumpEvent;
        this.xpathEvent = xpathEvent;
        this.messageMap = messageMap;
        this.messageDataMap = messageDataMap;
        this.xpathMap = xpathMap;
        this.axisConf = axisConf;
    }

    @Override
    public void run() {
        if (this.genericEvent) {
            this.genericEvent();
        }
        if (this.messageDumpEvent) {
            this.messageDumpEvent();
        }
        if (this.xpathEvent) {
            this.xpathEvent();
        }
    }

    private void genericEvent() {
        for (String key : this.messageMap.keySet()) {
            Map map = (Map)this.messageMap.get(key);
            OMElement serviceInvocationDataElement = this.factory.createOMElement("ActivityData", this.activityNamespace);
            if (map == null || serviceInvocationDataElement == null) continue;
            serviceInvocationDataElement.addChild((OMNode)map.get("ServerElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("ServiceElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("OperationElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("ActivityNameElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("ActivityDescriptionElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("ActivityIdElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("MessageIdElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("MessageDirElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("RemoteIpElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("UserAgentElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("TimeStampElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("PropertiesElement"));
            this.eventElement.addChild((OMNode)serviceInvocationDataElement);
        }
        this.generateEvent(this.eventElement);
    }

    private void messageDumpEvent() {
        for (String key : this.messageDataMap.keySet()) {
            Map map = (Map)this.messageDataMap.get(key);
            OMElement serviceInvocationDataElement = this.factory.createOMElement("ActivityData", this.activityNamespace);
            if (map == null || serviceInvocationDataElement == null) continue;
            serviceInvocationDataElement.addChild((OMNode)map.get("ServerElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("ServiceElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("OperationElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("ActivityNameElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("ActivityDescriptionElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("ActivityIdElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("MessageIdElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("RemoteIpElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("TimeStampElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("PropertiesElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("MessageDirElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("MessageBodyElement"));
            this.eventElement.addChild((OMNode)serviceInvocationDataElement);
        }
        this.generateEvent(this.eventElement);
    }

    private void xpathEvent() {
        for (String key : this.xpathMap.keySet()) {
            Map map = (Map)this.xpathMap.get(key);
            OMElement serviceInvocationDataElement = this.factory.createOMElement("ActivityData", this.activityNamespace);
            if (map == null || serviceInvocationDataElement == null) continue;
            serviceInvocationDataElement.addChild((OMNode)map.get("ServerElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("ServiceElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("OperationElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("ActivityIdElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("MessageIdElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("XPathExpElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("ActivityNameElement"));
            serviceInvocationDataElement.addChild((OMNode)map.get("ActivityDescriptionElement"));
            this.eventElement.addChild((OMNode)serviceInvocationDataElement);
        }
        this.generateEvent(this.eventElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateEvent(OMElement statMessage) {
        if (statMessage != null) {
            Message message = new Message();
            message.setMessage(statMessage);
            try {
                LightWeightEventBrokerInterface broker = ServiceHolder.getLWEventBroker();
                SuperTenantCarbonContext.startTenantFlow();
                int tenantId = SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)PublisherUtils.getConfigurationContext()).getTenantId();
                SuperTenantCarbonContext.getCurrentContext().setTenantId(tenantId);
                SuperTenantCarbonContext.getCurrentContext().getTenantDomain(true);
                broker.publish("/carbon/bam/data/publishers/activity", statMessage);
            }
            catch (Exception e) {
                this.log.error((Object)"Can not publish the message ", (Throwable)e);
            }
            finally {
                SuperTenantCarbonContext.endTenantFlow();
            }
        }
    }
}

