/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.activity.mediation.jdbc;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.data.publisher.activity.mediation.ActivityProcessor;
import org.wso2.carbon.bam.data.publisher.activity.mediation.MessageActivity;
import org.wso2.carbon.bam.data.publisher.activity.mediation.jdbc.ActivityPersistenceManager;

public class JDBCActivityProcessor
implements ActivityProcessor {
    private static final Log log = LogFactory.getLog(JDBCActivityProcessor.class);
    private ExecutorService exec;
    private ActivityPersistenceManager pm;

    public JDBCActivityProcessor() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initializing the JDBC based activity processor for BAM");
        }
        this.pm = new ActivityPersistenceManager();
        this.exec = Executors.newCachedThreadPool();
    }

    @Override
    public void destroy() {
        this.exec.shutdown();
    }

    @Override
    public void process(MessageActivity[] activities) {
        this.exec.submit(new JDBCWorker(activities));
    }

    private class JDBCWorker
    implements Runnable {
        private MessageActivity[] activities;

        private JDBCWorker(MessageActivity[] activities) {
            this.activities = activities;
        }

        @Override
        public void run() {
            for (MessageActivity act : this.activities) {
                JDBCActivityProcessor.this.pm.persistActivity(act);
            }
        }
    }
}

