/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.activity.mediation.jdbc;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.data.publisher.activity.mediation.ActivityPublisherUtils;
import org.wso2.carbon.bam.data.publisher.activity.mediation.MessageActivity;
import org.wso2.carbon.bam.data.publisher.activity.mediation.config.EventingConfigData;
import org.wso2.carbon.bam.data.publisher.activity.mediation.config.XPathConfigData;
import org.wso2.carbon.bam.data.publisher.activity.mediation.jdbc.SimpleLRUCache;
import org.wso2.carbon.utils.CarbonUtils;

public class ActivityPersistenceManager {
    private static final Log log = LogFactory.getLog(ActivityPersistenceManager.class);
    private DataSource dataSource;
    private int serverId = -1;
    private Map<String, Integer> services = new ConcurrentHashMap<String, Integer>();
    private Map<String, Integer> operations = new ConcurrentHashMap<String, Integer>();
    private SimpleLRUCache<String, Integer> activities = new SimpleLRUCache(200);
    private volatile Object serviceTable = new Object();
    private volatile Object operationTable = new Object();
    private volatile Object activityTable = new Object();
    private volatile Object messageTable = new Object();
    private volatile Object messageDataTable = new Object();
    private volatile Object propertiesTable = new Object();

    public ActivityPersistenceManager() {
        this.dataSource = this.initDataSource();
    }

    public void persistActivity(MessageActivity activity) {
        block9: {
            if (this.serverId == -1) {
                this.serverId = this.getServerId();
                if (this.serverId == -1) {
                    log.error((Object)"Unable to find the server ID of the monitored server - Activities will not be saved");
                    return;
                }
            }
            try {
                int serviceId = this.getServiceId(activity.getService());
                int operationId = this.getOperationId(activity.getOperation(), serviceId);
                int activityId = this.getActivityId(activity.getActivityId(), activity.getActivityName());
                int messageId = this.saveMessage(activity, operationId, activityId);
                this.saveMessageProperties(messageId, activityId, activity);
                EventingConfigData data = ActivityPublisherUtils.getActivityPublisherAdmin().getEventingConfigData();
                if (data != null && data.getEnableMessageDumping().equals("ON")) {
                    this.saveMessageData(messageId, activityId, activity);
                }
                if (data == null || !data.messageLookupEnabled()) break block9;
                XPathConfigData[] xpathConfigs = null;
                try {
                    xpathConfigs = ActivityPublisherUtils.getActivityPublisherAdmin().getXPathData();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                if (xpathConfigs != null) {
                    for (XPathConfigData xpathConfig : xpathConfigs) {
                        this.saveXpathConfigData(xpathConfig);
                    }
                }
                this.saveXPathProperties(messageId, activityId, activity);
            }
            catch (SQLException e) {
                log.error((Object)"Error while saving the activity to the database", (Throwable)e);
            }
        }
    }

    private int getServiceId(String serviceName) throws SQLException {
        if (this.services.containsKey(serviceName)) {
            return this.services.get(serviceName);
        }
        String select = "SELECT BAM_ID FROM BAM_SERVICE WHERE BAM_SERVICE_NAME='" + serviceName + "' AND BAM_SERVER_ID=" + this.serverId;
        String insert = "INSERT INTO BAM_SERVICE (BAM_SERVER_ID, BAM_SERVICE_NAME) VALUES (" + this.serverId + ", '" + serviceName + "')";
        return this.getIdFromDatabase(select, insert, this.serviceTable, serviceName, this.services);
    }

    private int getOperationId(String operationName, int serviceId) throws SQLException {
        String key = serviceId + "-" + operationName;
        if (this.operations.containsKey(key)) {
            return this.operations.get(key);
        }
        String select = "SELECT BAM_ID FROM BAM_OPERATION WHERE BAM_OP_NAME='" + operationName + "' AND BAM_SERVICE_ID=" + serviceId;
        String insert = "INSERT INTO BAM_OPERATION (BAM_SERVICE_ID, BAM_OP_NAME) VALUES (" + serviceId + ", '" + operationName + "')";
        return this.getIdFromDatabase(select, insert, this.operationTable, key, this.operations);
    }

    private int getActivityId(String activityKey, String activityName) throws SQLException {
        Integer activityId = (Integer)this.activities.get(activityKey);
        if (activityId != null) {
            return (Integer)this.activities.get(activityKey);
        }
        String select = "SELECT BAM_ID FROM BAM_ACTIVITY WHERE BAM_USER_DEFINED_ID='" + activityKey + "'";
        String insert = "INSERT INTO BAM_ACTIVITY (BAM_NAME, BAM_USER_DEFINED_ID) VALUES ('" + (activityName != null ? activityName : "") + "', '" + activityKey + "')";
        return this.getIdFromDatabase(select, insert, this.activityTable, activityKey, this.activities);
    }

    private XPathConfigData getXpathConfigData(String xpathKey, int serverId) throws SQLException {
        String select = "SELECT BAM_ID,BAM_ALIAS,BAM_XPATH FROM BAM_XPATH WHERE BAM_NAME ='" + xpathKey + "' AND BAM_SERVER_ID =" + "'" + serverId + "'";
        Connection conn = this.dataSource.getConnection();
        Statement stmt = conn.createStatement();
        ResultSet selectResults = stmt.executeQuery(select);
        int id = -1;
        if (selectResults.next()) {
            id = selectResults.getInt(1);
        }
        if (id != -1) {
            XPathConfigData data = new XPathConfigData();
            data.setKey(xpathKey);
            data.setXpath(selectResults.getString(3));
            data.setAlias(selectResults.getString(2));
            data.setId(id);
            selectResults.close();
            select = "SELECT BAM_ID, BAM_PREFIX, BAM_URI FROM BAM_NAMESPACE WHERE BAM_XPATH_ID ='" + id + "'";
            selectResults = stmt.executeQuery(select);
            ArrayList<String> namespaces = new ArrayList<String>();
            while (selectResults.next()) {
                namespaces.add(selectResults.getString(2) + "@" + selectResults.getString(3));
            }
            if (namespaces.size() > 0) {
                data.setNameSpaces(namespaces.toArray(new String[namespaces.size()]));
            }
            return data;
        }
        selectResults.close();
        stmt.close();
        conn.close();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int saveMessage(MessageActivity act, int operationId, int activityId) throws SQLException {
        Connection conn = this.dataSource.getConnection();
        Statement stmt = conn.createStatement();
        String sql = "INSERT INTO BAM_MESSAGE (BAM_MSG_ID, BAM_OP_ID, BAM_ACTIVITY_ID, BAM_TIMESTAMP, BAM_IP_ADDRESS, BAM_TARGET_IP_ADDRESS) VALUES ('" + act.getMessageId() + "', " + operationId + ", " + activityId + ", '" + act.getTimestamp().getBAMTimestamp() + "', '" + (act.getSenderHost() != null ? act.getSenderHost() : "") + "', " + "'" + (act.getReceiverHost() != null ? act.getReceiverHost() : "") + "')";
        Object object = this.messageTable;
        synchronized (object) {
            stmt.executeUpdate(sql, 1);
        }
        ResultSet rs = stmt.getGeneratedKeys();
        int id = -1;
        while (rs.next()) {
            id = rs.getInt(1);
        }
        rs.close();
        stmt.close();
        conn.close();
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMessageData(int messageId, int activityId, MessageActivity act) throws SQLException {
        String direction = act.getDirection() == 1 ? "Request" : "Response";
        String appFailure = act.getProperty("application_failure");
        String techFailure = act.getProperty("technical_failure");
        String status = appFailure != null && !"".equals(appFailure) || techFailure != null && !"".equals(techFailure) ? "Fail" : "Success";
        Connection conn = this.dataSource.getConnection();
        PreparedStatement stmt = conn.prepareStatement("INSERT INTO BAM_MESSAGE_DATA (BAM_MESSAGE_ID, BAM_ACTIVITY_ID, BAM_TIMESTAMP, BAM_DIRECTION, BAM_MESSAGE, BAM_STATUS) VALUES (?,?,?,?,?,?)");
        stmt.setInt(1, messageId);
        stmt.setInt(2, activityId);
        stmt.setString(3, act.getTimestamp().getBAMTimestamp());
        stmt.setString(4, direction);
        stmt.setString(5, act.getPayload());
        stmt.setString(6, status);
        Object object = this.messageDataTable;
        synchronized (object) {
            stmt.execute();
        }
        stmt.close();
        conn.close();
    }

    private void saveXpathConfigData(XPathConfigData xpathConfig) throws SQLException {
        XPathConfigData data = this.getXpathConfigData(xpathConfig.getKey(), this.serverId);
        if (data != null && xpathConfig.equals(data)) {
            return;
        }
        Connection conn = this.dataSource.getConnection();
        Statement stmt = conn.createStatement();
        if (data == null) {
            String insertXpath = "INSERT INTO BAM_XPATH(BAM_ALIAS,BAM_NAME,BAM_XPATH,BAM_SERVER_ID) VALUES ('" + xpathConfig.getAlias() + "','" + xpathConfig.getKey() + "','" + xpathConfig.getXpath() + "','" + this.serverId + "')";
            stmt.executeUpdate(insertXpath, 1);
            int id = -1;
            ResultSet insertResults = stmt.getGeneratedKeys();
            if (insertResults.next()) {
                id = insertResults.getInt(1);
            }
            insertResults.close();
            this.saveNamespaceData(xpathConfig, id);
        } else if (!xpathConfig.equals(data)) {
            String updateXpath = "UPDATE BAM_XPATH SET BAM_ALIAS = '" + xpathConfig.getAlias() + "', BAM_NAME = '" + xpathConfig.getKey() + "', " + "BAM_XPATH = '" + xpathConfig.getXpath() + "'," + " BAM_SERVER_ID = '" + this.serverId + "' WHERE BAM_ID = '" + data.getId() + "'";
            stmt.executeUpdate(updateXpath, 1);
            int id = -1;
            ResultSet updateResults = stmt.getGeneratedKeys();
            if (updateResults.next()) {
                id = updateResults.getInt(1);
            }
            updateResults.close();
            String deleteNS = "DELETE FROM BAM_NAMESPACE WHERE BAM_XPATH_ID ='" + id + "'";
            stmt.executeUpdate(deleteNS);
            this.saveNamespaceData(xpathConfig, id);
        }
        stmt.close();
        conn.close();
    }

    private void saveNamespaceData(XPathConfigData xpathConfig, int xpathId) throws SQLException {
        Connection conn = this.dataSource.getConnection();
        Statement stmt = conn.createStatement();
        if (xpathConfig.getNameSpaces() != null) {
            for (String ns : xpathConfig.getNameSpaces()) {
                String[] tokens = ns.split("@");
                if (tokens == null || tokens.length != 2) continue;
                String prefix = tokens[0];
                String namespace = tokens[1];
                String insertNS = "INSERT INTO BAM_NAMESPACE(BAM_XPATH_ID,BAM_PREFIX, BAM_URI) VALUES('" + xpathId + "','" + prefix + "','" + namespace + "')";
                stmt.executeUpdate(insertNS);
            }
        }
        stmt.close();
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMessageProperties(int messageId, int activityId, MessageActivity act) throws SQLException {
        String sql = "INSERT INTO BAM_MESSAGE_PROPERTIES (BAM_MESSAGE_ID, BAM_ACTIVITY_ID, BAM_KEY, BAM_VALUE) VALUES (?,?,?,?)";
        Set<String> keys = act.getPropertyKeys();
        Connection conn = this.dataSource.getConnection();
        PreparedStatement stmt = conn.prepareStatement(sql);
        for (String k : keys) {
            stmt.setInt(1, messageId);
            stmt.setInt(2, activityId);
            stmt.setString(3, k);
            stmt.setString(4, act.getProperty(k));
            stmt.addBatch();
        }
        Object object = this.propertiesTable;
        synchronized (object) {
            stmt.executeBatch();
        }
        stmt.close();
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveXPathProperties(int messageId, int activityId, MessageActivity activity) throws SQLException {
        String sql = "INSERT INTO BAM_MESSAGE_PROPERTIES (BAM_MESSAGE_ID, BAM_ACTIVITY_ID, BAM_KEY, BAM_VALUE) VALUES (?,?,?,?)";
        Set<XPathConfigData> xpathConfigs = activity.getXpathKeys();
        Connection conn = this.dataSource.getConnection();
        PreparedStatement stmt = conn.prepareStatement(sql);
        for (XPathConfigData xpathConfig : xpathConfigs) {
            stmt.setInt(1, messageId);
            stmt.setInt(2, activityId);
            stmt.setString(3, xpathConfig.getKey());
            stmt.setString(4, activity.getXpath(xpathConfig));
            stmt.addBatch();
        }
        Object object = this.propertiesTable;
        synchronized (object) {
            stmt.executeBatch();
        }
        stmt.close();
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIdFromDatabase(String selectQuery, String insertQuery, Object tableLock, String cacheKey, Map<String, Integer> cache) throws SQLException {
        Object object = tableLock;
        synchronized (object) {
            if (cache.containsKey(cacheKey)) {
                return cache.get(cacheKey);
            }
            Connection conn = this.dataSource.getConnection();
            Statement stmt = conn.createStatement();
            ResultSet selectResults = stmt.executeQuery(selectQuery);
            int id = -1;
            while (selectResults.next()) {
                id = selectResults.getInt(1);
            }
            selectResults.close();
            if (id == -1) {
                stmt.executeUpdate(insertQuery, 1);
                ResultSet insertResults = stmt.getGeneratedKeys();
                if (insertResults.next()) {
                    id = insertResults.getInt(1);
                    cache.put(cacheKey, id);
                }
                insertResults.close();
            }
            stmt.close();
            conn.close();
            return id;
        }
    }

    private int getServerId() {
        int serverId = -1;
        String url = System.getProperty("bam.server.url");
        if (url == null) {
            url = ActivityPublisherUtils.getServerName();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Determining the server ID for the URL: " + url));
        }
        try {
            Connection conn = this.dataSource.getConnection();
            Statement stmt = conn.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT BAM_SERVER_ID FROM BAM_SERVER WHERE BAM_URL='" + url + "'");
            if (rs.next()) {
                serverId = rs.getInt("BAM_SERVER_ID");
            }
            rs.close();
            stmt.close();
            conn.close();
        }
        catch (SQLException e) {
            log.error((Object)"Error while retreiving the server ID from BAM database", (Throwable)e);
        }
        return serverId;
    }

    private DataSource initDataSource() {
        String path = CarbonUtils.getCarbonConfigDirPath() + File.separator + "bam-publisher.properties";
        Properties props = new Properties();
        try {
            String maxIdle;
            String initialSize;
            String maxActive;
            props.load(new FileInputStream(path));
            BasicDataSource dataSource = new BasicDataSource();
            dataSource.setDriverClassName(props.getProperty("driver"));
            dataSource.setUrl(props.getProperty("url"));
            dataSource.setUsername(props.getProperty("username"));
            dataSource.setPassword(props.getProperty("password"));
            String validationQuery = props.getProperty("validationQuery");
            if (validationQuery != null) {
                dataSource.setValidationQuery(validationQuery);
            }
            if ((maxActive = props.getProperty("maxActive")) != null) {
                dataSource.setMaxActive(Integer.parseInt(maxActive));
            }
            if ((initialSize = props.getProperty("initialSize")) != null) {
                dataSource.setInitialSize(Integer.parseInt(initialSize));
            }
            if ((maxIdle = props.getProperty("maxIdle")) != null) {
                dataSource.setMaxIdle(Integer.parseInt(maxIdle));
            }
            log.info((Object)("Created new data source to: " + dataSource.getUrl()));
            return dataSource;
        }
        catch (IOException e) {
            log.error((Object)("Error while loading publisher DB configuration from: " + path), (Throwable)e);
            return null;
        }
    }
}

