/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.activity.mediation.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.bam.data.publisher.activity.mediation.ActivityProcessor;
import org.wso2.carbon.bam.data.publisher.activity.mediation.ActivityPublisherUtils;
import org.wso2.carbon.bam.data.publisher.activity.mediation.ActivityQueue;
import org.wso2.carbon.bam.data.publisher.activity.mediation.config.RegistryPersistanceManager;
import org.wso2.carbon.bam.data.publisher.activity.mediation.eventing.EventGenerator;
import org.wso2.carbon.bam.data.publisher.activity.mediation.services.ActivityPublisherAdmin;
import org.wso2.carbon.bam.lwevent.core.LightWeightEventBroker;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.mediation.statistics.services.MediationStatisticsService;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class ActivityMediatorServiceComponent {
    private static Log log = LogFactory.getLog(ActivityMediatorServiceComponent.class);
    private MediationStatisticsService statService;
    private ActivityQueue activityQueue;

    protected void activate(ComponentContext ctxt) {
        if (this.statService != null) {
            // empty if block
        }
        ActivityProcessor activityProcessor = null;
        String processor = System.getProperty("bam.activity.processor");
        if (processor != null) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(processor);
                activityProcessor = (ActivityProcessor)clazz.newInstance();
            }
            catch (Exception e) {
                log.error((Object)("Error while initializing the activity processor: " + processor), (Throwable)e);
            }
        }
        if (activityProcessor == null) {
            activityProcessor = new EventGenerator();
        }
        this.activityQueue = new ActivityQueue(activityProcessor);
        String thresholdProperty = System.getProperty("bam.activity.threshold");
        if (thresholdProperty != null) {
            this.activityQueue.setThreshold(Integer.parseInt(thresholdProperty));
        } else {
            this.activityQueue.setThreshold(1);
        }
        ActivityPublisherUtils.setActivityQueue(this.activityQueue);
        ActivityPublisherAdmin admin = new ActivityPublisherAdmin();
        ActivityPublisherUtils.setActivityPublisherAdmin(admin);
        log.info((Object)"BAM activity mediator bundle is activated");
    }

    protected void deactivate(ComponentContext context) {
        this.activityQueue.cleanup();
        if (log.isDebugEnabled()) {
            log.debug((Object)"BAM activity Mediator bundle is deactivated");
        }
    }

    protected void setServerConfiguration(ServerConfiguration serverConfiguration) {
        ActivityPublisherUtils.setServerConfiguration(serverConfiguration);
    }

    protected void unsetServerConfiguration(ServerConfiguration serverConfiguration) {
        ActivityPublisherUtils.setServerConfiguration(null);
    }

    protected void setMediationStatisticsService(MediationStatisticsService statService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Mediation statistics service bound to the BAM mediation statistics component");
        }
        this.statService = statService;
    }

    protected void unsetMediationStatisticsService(MediationStatisticsService statService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Mediation statistics service unbound from the BAM mediation statistics component");
        }
        this.statService = null;
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        ActivityPublisherUtils.setConfigurationContextService(contextService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        ActivityPublisherUtils.setConfigurationContextService(null);
    }

    protected void setRegistryService(RegistryService registryService) {
        try {
            RegistryPersistanceManager.setRegistry((Registry)registryService.getConfigSystemRegistry());
        }
        catch (Exception e) {
            log.error((Object)"Cannot retrieve System Registry", (Throwable)e);
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        RegistryPersistanceManager.setRegistry(null);
    }

    protected void setLWEventBroker(LightWeightEventBroker lightWeightEventBroker) {
        ActivityPublisherUtils.setEventBroker(lightWeightEventBroker);
    }

    protected void unsetLWEventBroker(LightWeightEventBroker lightWeightEventBroker) {
        ActivityPublisherUtils.setEventBroker(null);
    }
}

