/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.activity.mediation.eventing;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.data.publisher.activity.mediation.ActivityProcessor;
import org.wso2.carbon.bam.data.publisher.activity.mediation.ActivityPublisherUtils;
import org.wso2.carbon.bam.data.publisher.activity.mediation.MessageActivity;
import org.wso2.carbon.bam.lwevent.core.LightWeightEventBroker;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;

public class EventGenerator
implements ActivityProcessor {
    private static final Log log = LogFactory.getLog(EventGenerator.class);
    private OMFactory fac = OMAbstractFactory.getOMFactory();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(MessageActivity[] activities) {
        if (activities == null || activities.length == 0) {
            return;
        }
        OMNamespace actNamespace = this.fac.createOMNamespace("http://wso2.org/ns/2009/09/bam/service/activity/data", "bam");
        OMElement eventElement = this.fac.createOMElement("Event", actNamespace);
        for (MessageActivity activity : activities) {
            eventElement.addChild((OMNode)ActivityPublisherUtils.serialize(activity));
        }
        try {
            ActivityPublisherUtils.getEventBroker();
            LightWeightEventBroker eb = LightWeightEventBroker.getInstance();
            SuperTenantCarbonContext.startTenantFlow();
            int tenantId = SuperTenantCarbonContext.getCurrentContext((ConfigurationContext)ActivityPublisherUtils.getConfigurationContextService().getServerConfigContext()).getTenantId();
            SuperTenantCarbonContext.getCurrentContext().setTenantId(tenantId);
            SuperTenantCarbonContext.getCurrentContext().getTenantDomain(true);
            eb.publish("/carbon/bam/data/publishers/activity", eventElement);
        }
        catch (Exception e) {
            log.error((Object)"Can not publish the message ", (Throwable)e);
        }
        finally {
            SuperTenantCarbonContext.endTenantFlow();
        }
    }

    @Override
    public void destroy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Terminating BAM EventGenerator");
        }
    }
}

