/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.activity.mediation;

import java.util.Iterator;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.wso2.carbon.bam.data.publisher.activity.mediation.ActivityPublisherConstants;
import org.wso2.carbon.bam.data.publisher.activity.mediation.ActivityPublisherUtils;

public class MessageActivityMediator
extends AbstractMediator {
    private String status = "";
    private static Log log = LogFactory.getLog(MessageActivityMediator.class);

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean mediate(org.apache.synapse.MessageContext synCtx) {
        this.setMessageProperties(synCtx);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing new message through the BAM activity mediator - Message ID=" + synCtx.getMessageID()));
        }
        Object appFailure = synCtx.getProperty("application_failure");
        Object techFailure = synCtx.getProperty("technical_failure");
        if (JavaUtils.isTrueExplicitly((Object)appFailure) || JavaUtils.isTrueExplicitly((Object)techFailure)) {
            String messageId = UUID.randomUUID().toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting the new message ID: " + messageId + " on the failure message"));
            }
            synCtx.setMessageID(messageId);
        }
        if (!synCtx.isResponse() && !synCtx.isFaultResponse()) {
            ActivityPublisherUtils.publishEvent(synCtx, true);
        } else {
            Object activityProperty = synCtx.getProperty("activity_property");
            if (activityProperty != null) {
                this.setActivityIdHeader(synCtx, activityProperty.toString());
            }
            ActivityPublisherUtils.publishEvent(synCtx, false);
        }
        SOAPHeader header = synCtx.getEnvelope().getHeader();
        OMElement bamEvent = header.getFirstChildWithName(ActivityPublisherConstants.BAM_EVENT_QNAME);
        if (bamEvent != null) {
            Iterator iter = bamEvent.getChildElements();
            while (iter.hasNext()) {
                OMAttribute valueAttr;
                OMElement childElement = (OMElement)iter.next();
                OMAttribute nameAttr = childElement.getAttribute(new QName("name"));
                if (nameAttr != null) {
                    nameAttr.setAttributeValue("Child");
                }
                if ((valueAttr = childElement.getAttribute(new QName("value"))) == null) continue;
                valueAttr.setAttributeValue("true");
            }
        }
        return true;
    }

    private void setMessageProperties(org.apache.synapse.MessageContext synapseContext) {
        try {
            Iterator itr;
            UUID uuid = UUID.randomUUID();
            String uuid_string = uuid.toString();
            Axis2MessageContext axis2smc = (Axis2MessageContext)synapseContext;
            MessageContext axis2MessageContext = axis2smc.getAxis2MessageContext();
            String propName = "";
            String propValue = "";
            if (synapseContext.getProperty("application_failure") != null && synapseContext.getProperty("application_failure").equals("true")) {
                propName = "";
                propValue = "";
            } else if (synapseContext.getProperty("technical_failure") != null && synapseContext.getProperty("technical_failure").equals("true")) {
                propName = "";
                propValue = "";
            } else {
                propName = this.status;
                propValue = this.status + "_" + uuid_string + "_" + synapseContext.getMessageID();
            }
            OMFactory fac = OMAbstractFactory.getOMFactory();
            OMNamespace omNs = fac.createOMNamespace("http://wso2.org/ns/2010/10/bam", "ns");
            SOAPEnvelope soapEnvelope = axis2MessageContext.getEnvelope();
            String soapNamespaceURI = soapEnvelope.getNamespace().getNamespaceURI();
            SOAPFactory soapFactory = null;
            SOAPHeaderBlock soapHeaderBlock = null;
            OMElement bampropertyElement = fac.createOMElement(new QName("http://wso2.org/ns/2010/10/bam", "Property", "ns"), null);
            if (soapNamespaceURI.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
                soapFactory = OMAbstractFactory.getSOAP11Factory();
            } else if (soapNamespaceURI.equals("http://www.w3.org/2003/05/soap-envelope")) {
                soapFactory = OMAbstractFactory.getSOAP12Factory();
            } else {
                log.error((Object)"Not a standard soap message");
            }
            if (soapEnvelope.getHeader() != null) {
                itr = soapEnvelope.getHeader().getChildrenWithName(new QName("http://wso2.org/ns/2010/10/bam", "BAMEvent"));
                if (!itr.hasNext()) {
                    soapHeaderBlock = soapEnvelope.getHeader().addHeaderBlock("BAMEvent", omNs);
                    if (synapseContext.getProperty("bam_activity_id") == null) {
                        soapHeaderBlock.addAttribute("activityID", uuid_string, null);
                        synapseContext.setProperty("bam_activity_id", (Object)uuid_string);
                    } else {
                        soapHeaderBlock.addAttribute("activityID", (String)synapseContext.getProperty("bam_activity_id"), null);
                    }
                    bampropertyElement.addAttribute("name", propName, null);
                    bampropertyElement.addAttribute("value", propValue, null);
                    soapHeaderBlock.addChild((OMNode)bampropertyElement);
                } else {
                    OMElement bamHeader = (OMElement)itr.next();
                    OMAttribute activityIdAttr = bamHeader.getAttribute(new QName("activityID"));
                    if (activityIdAttr != null) {
                        String activityId = activityIdAttr.getAttributeValue();
                        synapseContext.setProperty("bam_activity_id", (Object)activityId);
                    } else {
                        bamHeader.addAttribute("activityID", uuid_string, null);
                        synapseContext.setProperty("bam_activity_id", (Object)uuid_string);
                    }
                }
            }
            if (soapEnvelope.getHeader() == null) {
                if (soapFactory != null) {
                    soapFactory.createSOAPHeader(soapEnvelope);
                }
                if (soapEnvelope.getHeader() != null) {
                    soapHeaderBlock = soapEnvelope.getHeader().addHeaderBlock("BAMEvent", omNs);
                    if (synapseContext.getProperty("bam_activity_id") == null) {
                        soapHeaderBlock.addAttribute("activityID", uuid_string, null);
                        synapseContext.setProperty("bam_activity_id", (Object)uuid_string);
                    } else {
                        soapHeaderBlock.addAttribute("activityID", (String)synapseContext.getProperty("bam_activity_id"), null);
                    }
                    bampropertyElement.addAttribute("name", propName, null);
                    bampropertyElement.addAttribute("value", propValue, null);
                    soapHeaderBlock.addChild((OMNode)bampropertyElement);
                }
            }
            synapseContext.setProperty("activity_property", (Object)propName);
            synapseContext.setProperty("activity_property_value", (Object)propValue);
            itr = synapseContext.getEnvelope().getHeader().getChildrenWithName(new QName("http://wso2.org/ns/2010/10/bam", "BAMEvent"));
            if (itr.hasNext()) {
                OMElement childElement;
                OMElement element = (OMElement)itr.next();
                String activityID = element.getAttributeValue(new QName("activityID"));
                Iterator childItr = element.getChildElements();
                if (activityID != null && !activityID.equals("") && ("".equals((childElement = (OMElement)childItr.next()).getAttributeValue(new QName("name"))) || "".equals(childElement.getAttributeValue(new QName("value"))))) {
                    childElement.getAttribute(new QName("name")).setAttributeValue(propName);
                    childElement.getAttribute(new QName("value")).setAttributeValue(propValue);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while processing MessageHeaderMediator...", (Throwable)e);
        }
    }

    private void setActivityIdHeader(org.apache.synapse.MessageContext synCtx, String activityId) {
        OMElement bamEventElement;
        OMElement bamEventElement2;
        SOAPEnvelope soapEnvelope = synCtx.getEnvelope();
        SOAPHeader soapHeader = soapEnvelope.getHeader();
        if (soapHeader != null && (bamEventElement2 = soapHeader.getFirstChildWithName(ActivityPublisherConstants.BAM_EVENT_QNAME)) != null) {
            return;
        }
        String soapNamespaceURI = soapEnvelope.getNamespace().getNamespaceURI();
        SOAPFactory soapFactory = "http://schemas.xmlsoap.org/soap/envelope/".equals(soapNamespaceURI) ? OMAbstractFactory.getSOAP11Factory() : OMAbstractFactory.getSOAP12Factory();
        if (soapEnvelope.getHeader() == null) {
            soapFactory.createSOAPHeader(soapEnvelope);
        }
        if ((bamEventElement = soapEnvelope.getHeader().getFirstChildWithName(ActivityPublisherConstants.BAM_EVENT_QNAME)) == null) {
            OMNamespace omNs = soapFactory.createOMNamespace("http://wso2.org/ns/2010/10/bam", "ns");
            SOAPHeaderBlock soapHeaderBlock = soapEnvelope.getHeader().addHeaderBlock("BAMEvent", omNs);
            soapHeaderBlock.addAttribute("activityID", activityId, null);
        }
    }
}

