/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.activity.mediation;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.data.publisher.activity.mediation.ActivityProcessor;
import org.wso2.carbon.bam.data.publisher.activity.mediation.MessageActivity;

public class ActivityQueue {
    private static final Log log = LogFactory.getLog(ActivityQueue.class);
    private volatile int threshold = 1;
    private boolean shutdown = false;
    private Queue<MessageActivity> activities = new ConcurrentLinkedQueue<MessageActivity>();
    private ExecutorService exec = Executors.newSingleThreadExecutor();
    private ActivityProcessor activityProcessor;

    public ActivityQueue(ActivityProcessor activityProcessor) {
        this.activityProcessor = activityProcessor;
        this.exec.submit(new ActivityWorker());
    }

    public void cleanup() {
        this.shutdown = true;
        while (this.activities.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Waiting for the activity queue to become empty");
            }
            this.delay();
        }
        this.exec.shutdownNow();
        this.activityProcessor.destroy();
    }

    public void setThreshold(int threshold) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initializing the activity queue with the threshold value: " + threshold));
        }
        this.threshold = threshold;
    }

    public void enqueue(MessageActivity activity) {
        if (this.shutdown) {
            log.warn((Object)"BAM activity queue is shutting down... Not accepting the new activity...");
            return;
        }
        this.activities.offer(activity);
    }

    private void clearActivities(int size) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing " + size + " activities from the activity queue..."));
        }
        MessageActivity[] activitySet = new MessageActivity[size];
        for (int i = 0; i < size; ++i) {
            activitySet[i] = this.activities.poll();
        }
        this.activityProcessor.process(activitySet);
    }

    private void delay() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class ActivityWorker
    implements Runnable {
        private ActivityWorker() {
        }

        @Override
        public void run() {
            if (log.isDebugEnabled()) {
                log.info((Object)"Initializing the activity processor thread...");
            }
            while (true) {
                try {
                    while (true) {
                        int size;
                        if ((size = ActivityQueue.this.activities.size()) >= ActivityQueue.this.threshold || ActivityQueue.this.shutdown) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Activity threshold (" + ActivityQueue.this.threshold + ") exceeds " + "current activity queue length (" + size + ")"));
                            }
                            ActivityQueue.this.clearActivities(size);
                            continue;
                        }
                        ActivityQueue.this.delay();
                    }
                }
                catch (Throwable t) {
                    log.error((Object)"Unexpected runtime error in the activity processor", t);
                    continue;
                }
                break;
            }
        }
    }
}

