/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.data.publisher.activity.mediation;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.SocketException;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.jaxen.JaxenException;
import org.wso2.carbon.bam.data.publisher.activity.mediation.ActivityPublisherConstants;
import org.wso2.carbon.bam.data.publisher.activity.mediation.ActivityQueue;
import org.wso2.carbon.bam.data.publisher.activity.mediation.BAMCalendar;
import org.wso2.carbon.bam.data.publisher.activity.mediation.MessageActivity;
import org.wso2.carbon.bam.data.publisher.activity.mediation.config.EventingConfigData;
import org.wso2.carbon.bam.data.publisher.activity.mediation.config.XPathConfigData;
import org.wso2.carbon.bam.data.publisher.activity.mediation.services.ActivityPublisherAdmin;
import org.wso2.carbon.bam.lwevent.core.LightWeightEventBroker;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.mediation.statistics.MessageTraceLog;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.NetworkUtils;

public class ActivityPublisherUtils {
    private static final Log log = LogFactory.getLog(ActivityPublisherUtils.class);
    private static LightWeightEventBroker lightWeightEventBroker;
    private static ConfigurationContextService cfgCtxService;
    private static ServerConfiguration serverConfiguration;
    private static ActivityQueue activityQueue;
    private static ActivityPublisherAdmin activityPublisherAdmin;
    private static OMFactory fac;

    public static void setEventBroker(LightWeightEventBroker eventBroker) {
        lightWeightEventBroker = eventBroker;
    }

    public static LightWeightEventBroker getEventBroker() {
        return lightWeightEventBroker;
    }

    public static ActivityQueue getActivityQueue() {
        return activityQueue;
    }

    public static void setConfigurationContextService(ConfigurationContextService cfgCtxService) {
        ActivityPublisherUtils.cfgCtxService = cfgCtxService;
    }

    public static ConfigurationContextService getConfigurationContextService() {
        return cfgCtxService;
    }

    public static void setServerConfiguration(ServerConfiguration serverConfiguration) {
        ActivityPublisherUtils.serverConfiguration = serverConfiguration;
    }

    public static void setActivityQueue(ActivityQueue activityQueue) {
        ActivityPublisherUtils.activityQueue = activityQueue;
    }

    public static void publishEvent(org.apache.synapse.MessageContext synCtx, boolean request) {
        MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        AxisService service = msgCtx.getAxisService();
        if (service == null || service.getParameter("adminService") != null || service.getParameter("hiddenService") != null) {
            return;
        }
        MessageActivity activity = ActivityPublisherUtils.newActivity(synCtx, request);
        activityQueue.enqueue(activity);
    }

    public static void publishEvent(MessageTraceLog traceLog) {
        MessageActivity activity = ActivityPublisherUtils.newActivity(traceLog);
        activityQueue.enqueue(activity);
    }

    public static MessageActivity newActivity(org.apache.synapse.MessageContext synCtx, boolean request) {
        Object techFailure;
        Object appFailure;
        Object arrivalTime;
        MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        MessageActivity activity = new MessageActivity();
        activity.setDirection(request ? 1 : 2);
        activity.setService(msgCtx.getAxisService().getName());
        activity.setOperation(msgCtx.getAxisOperation().getName().getLocalPart());
        EventingConfigData data = activityPublisherAdmin.getEventingConfigData();
        if (data != null && data.messageDumpingEnabled()) {
            activity.setPayload(msgCtx.getEnvelope().getBody().toString());
        }
        if (data != null && data.messageLookupEnabled()) {
            XPathConfigData[] xpathConfigs = null;
            try {
                xpathConfigs = ActivityPublisherUtils.getActivityPublisherAdmin().getXPathData();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                String messageBody = msgCtx.getEnvelope().getBody().toString();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(messageBody.getBytes());
                StAXOMBuilder builder = new StAXOMBuilder((InputStream)byteArrayInputStream);
                OMElement root = builder.getDocumentElement();
                if (xpathConfigs != null) {
                    for (XPathConfigData xpathConfig : xpathConfigs) {
                        AXIOMXPath xpath = new AXIOMXPath(xpathConfig.getXpath());
                        String[] namespaces = xpathConfig.getNameSpaces();
                        if (namespaces != null && namespaces.length > 0) {
                            for (String ns : namespaces) {
                                String[] tokens = ns.split("@");
                                if (tokens == null || tokens.length < 2) continue;
                                xpath.addNamespace(tokens[0], tokens[1]);
                            }
                        }
                        List listOfNodes = xpath.selectNodes((Object)root);
                        StringBuffer value = new StringBuffer();
                        if (listOfNodes != null && listOfNodes.size() > 0) {
                            for (int i = 0; i < listOfNodes.size(); ++i) {
                                OMContainer omContainer = (OMContainer)listOfNodes.get(i);
                                if (omContainer instanceof OMDocument) {
                                    omContainer = ((OMDocument)omContainer).getOMDocumentElement();
                                }
                                String xpathValue = omContainer.toString();
                                value.append(xpathValue);
                            }
                        }
                        activity.setXpath(xpathConfig, value.toString());
                    }
                }
            }
            catch (XMLStreamException e) {
                log.error((Object)"Error building the xpath..", (Throwable)e);
            }
            catch (JaxenException e) {
                log.error((Object)"Error building the xpath..", (Throwable)e);
            }
        }
        if ((arrivalTime = synCtx.getProperty("BAM_MESSAGE_ARRIVAL_TIME")) != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(Long.parseLong(arrivalTime.toString()));
            activity.setTimestamp(BAMCalendar.getInstance(cal));
        } else {
            activity.setTimestamp(BAMCalendar.getInstance());
        }
        if (msgCtx.getMessageID() != null) {
            activity.setMessageId(msgCtx.getMessageID());
        } else {
            String messageId = UUID.randomUUID().toString();
            msgCtx.setMessageID(messageId);
            activity.setMessageId(messageId);
        }
        Object senderHost = synCtx.getProperty("REMOTE_ADDR");
        if (senderHost != null) {
            activity.setSenderHost(senderHost.toString());
        } else {
            activity.setSenderHost((String)msgCtx.getProperty("REMOTE_ADDR"));
        }
        Object receiverHost = msgCtx.getProperty("RECEIVER_ADDR");
        if (receiverHost != null) {
            activity.setReceiverHost(receiverHost.toString());
        } else {
            activity.setReceiverHost((String)msgCtx.getProperty("RECEIVER_ADDR"));
        }
        SOAPHeader header = msgCtx.getEnvelope().getHeader();
        OMElement bamEvent = header.getFirstChildWithName(ActivityPublisherConstants.BAM_EVENT_QNAME);
        if (bamEvent != null) {
            OMElement propertyElement;
            String activityId = bamEvent.getAttributeValue(ActivityPublisherConstants.ACTIVITY_ID_QNAME);
            if (activityId != null) {
                activity.setActivityId(activityId);
            }
            if ((propertyElement = bamEvent.getFirstElement()) != null) {
                String name = propertyElement.getAttributeValue(new QName("name"));
                String value = propertyElement.getAttributeValue(new QName("value"));
                activity.setProperty(name, value);
            }
        } else {
            log.warn((Object)"BAMEvent header not found on the message");
        }
        Object arcKey = synCtx.getProperty("arc_key");
        if (arcKey != null) {
            activity.setProperty("arc_key", arcKey.toString());
        }
        if (JavaUtils.isTrueExplicitly((Object)(appFailure = synCtx.getProperty("application_failure")))) {
            Object errorDetail = synCtx.getProperty("application_failure_detail");
            if (errorDetail != null) {
                activity.setProperty("application_failure", errorDetail.toString());
            } else {
                activity.setProperty("application_failure", synCtx.getEnvelope().getBody().getFirstOMChild().toString());
            }
        }
        if (JavaUtils.isTrueExplicitly((Object)(techFailure = synCtx.getProperty("technical_failure")))) {
            Object errorDetail = synCtx.getProperty("technical_failure_detail");
            if (errorDetail != null) {
                activity.setProperty("technical_failure", errorDetail.toString());
            } else {
                activity.setProperty("technical_failure", synCtx.getEnvelope().getBody().getFirstOMChild().toString());
            }
        }
        ActivityPublisherUtils.setActivityProperty(synCtx, activity, "activity_type");
        ActivityPublisherUtils.setActivityProperty(synCtx, activity, "message_type");
        ActivityPublisherUtils.setActivityProperty(synCtx, activity, "message_format");
        ActivityPublisherUtils.setActivityProperty(synCtx, activity, "arc_status");
        ActivityPublisherUtils.setActivityProperty(synCtx, activity, "arc_detail");
        ActivityPublisherUtils.setActivityProperty(synCtx, activity, "if_fail_uuid");
        ActivityPublisherUtils.setActivityProperty(synCtx, activity, "if_fail_replay_operation");
        return activity;
    }

    public static OMElement serialize(MessageActivity activity) {
        OMNamespace activityNamespace = fac.createOMNamespace("http://wso2.org/ns/2009/09/bam/service/activity/data", "bam");
        OMElement activityDataElement = fac.createOMElement("ActivityData", activityNamespace);
        OMElement serverNameElement = fac.createOMElement("ServerName", activityNamespace);
        serverNameElement.setText(ActivityPublisherUtils.getServerName());
        activityDataElement.addChild((OMNode)serverNameElement);
        OMElement serviceNameElement = fac.createOMElement("ServiceName", activityNamespace);
        serviceNameElement.setText(activity.getService());
        activityDataElement.addChild((OMNode)serviceNameElement);
        OMElement operationNameElement = fac.createOMElement("OperationName", activityNamespace);
        operationNameElement.setText(activity.getOperation());
        activityDataElement.addChild((OMNode)operationNameElement);
        OMElement activtyIdElement = fac.createOMElement("ActivityID", activityNamespace);
        activtyIdElement.setText(activity.getActivityId());
        activityDataElement.addChild((OMNode)activtyIdElement);
        OMElement messageIDElement = fac.createOMElement("MessageID", activityNamespace);
        messageIDElement.setText(activity.getMessageId());
        activityDataElement.addChild((OMNode)messageIDElement);
        int direction = activity.getDirection();
        if (direction != 0) {
            OMElement messageDirectionElement = fac.createOMElement("MessageDirection", activityNamespace);
            if (direction == 1) {
                messageDirectionElement.setText("Request");
            } else {
                messageDirectionElement.setText("Response");
            }
            activityDataElement.addChild((OMNode)messageDirectionElement);
        }
        OMElement timeStampElement = fac.createOMElement("TimeStamp", activityNamespace);
        timeStampElement.setText(activity.getTimestamp().getBAMTimestamp());
        activityDataElement.addChild((OMNode)timeStampElement);
        if (activity.getSenderHost() != null) {
            OMElement remoteIPElement = fac.createOMElement("RemoteIPAddress", activityNamespace);
            remoteIPElement.setText(activity.getSenderHost());
            activityDataElement.addChild((OMNode)remoteIPElement);
        }
        if (activity.getUserAgent() != null) {
            OMElement userAgentElement = fac.createOMElement("UserAgent", activityNamespace);
            userAgentElement.setText(activity.getUserAgent());
            activityDataElement.addChild((OMNode)userAgentElement);
        }
        if (activity.getActivityName() != null) {
            OMElement activityNameElement = fac.createOMElement("ActivityName", activityNamespace);
            activityNameElement.setText(activity.getActivityName());
            activityDataElement.addChild((OMNode)activityNameElement);
        }
        if (activity.getDescription() != null) {
            OMElement activityDescriptionElement = fac.createOMElement("ActivityDescription", activityNamespace);
            activityDescriptionElement.setText(activity.getDescription());
            activityDataElement.addChild((OMNode)activityDescriptionElement);
        }
        if (activity.getPayload() != null) {
            OMElement messageBodyElement = fac.createOMElement("MessageBody", activityNamespace);
            messageBodyElement.setText(activity.getPayload());
            activityDataElement.addChild((OMNode)messageBodyElement);
        }
        if (activity.getRequestStatus() != -1) {
            OMElement requestStatusElement = fac.createOMElement("RequestMessageStatus", activityNamespace);
            requestStatusElement.setText(String.valueOf(activity.getRequestStatus()));
            activityDataElement.addChild((OMNode)requestStatusElement);
        }
        if (activity.getResponseStatus() != -1) {
            OMElement responseStatusElement = fac.createOMElement("ResponseMessageStatus", activityNamespace);
            responseStatusElement.setText(String.valueOf(activity.getResponseStatus()));
            activityDataElement.addChild((OMNode)responseStatusElement);
        }
        OMElement propertiesElement = fac.createOMElement("ActivityProperties", activityNamespace);
        for (String key : activity.getPropertyKeys()) {
            OMElement propertyElement = fac.createOMElement("ActivityProperty", activityNamespace);
            OMElement propertyChildElement = fac.createOMElement("ActivityPropertyChild", activityNamespace);
            propertyChildElement.setText(key);
            OMElement propertyValue = fac.createOMElement("PropertyValue", activityNamespace);
            propertyValue.setText(activity.getProperty(key));
            propertyElement.addChild((OMNode)propertyChildElement);
            propertyElement.addChild((OMNode)propertyValue);
            propertiesElement.addChild((OMNode)propertyElement);
        }
        activityDataElement.addChild((OMNode)propertiesElement);
        OMElement xpathExpressionsElement = fac.createOMElement("XPathExpressions", activityNamespace);
        for (XPathConfigData data : activity.getXpathKeys()) {
            OMElement xpathExpressionElement = fac.createOMElement("XPathExpression", activityNamespace);
            OMElement keyElement = fac.createOMElement("ExpressionKey", activityNamespace);
            fac.createOMText((OMContainer)keyElement, data.getKey());
            OMElement expressionElement = fac.createOMElement("Expression", activityNamespace);
            fac.createOMText((OMContainer)expressionElement, data.getXpath());
            OMElement xpathValue = fac.createOMElement("XPathValue", activityNamespace);
            fac.createOMText((OMContainer)xpathValue, activity.getXpath(data));
            OMElement aliasElement = fac.createOMElement("Alias", activityNamespace);
            fac.createOMText((OMContainer)aliasElement, data.getAlias());
            OMElement namespacesElement = fac.createOMElement("Namespaces", activityNamespace);
            if (data.getNameSpaces() != null) {
                for (String ns : data.getNameSpaces()) {
                    OMElement namespaceElement = fac.createOMElement("Namespace", activityNamespace);
                    fac.createOMText((OMContainer)namespaceElement, ns);
                    namespacesElement.addChild((OMNode)namespaceElement);
                }
            }
            xpathExpressionElement.addChild((OMNode)keyElement);
            xpathExpressionElement.addChild((OMNode)expressionElement);
            xpathExpressionElement.addChild((OMNode)aliasElement);
            xpathExpressionElement.addChild((OMNode)namespacesElement);
            xpathExpressionElement.addChild((OMNode)xpathValue);
            xpathExpressionsElement.addChild((OMNode)xpathExpressionElement);
        }
        activityDataElement.addChild((OMNode)xpathExpressionsElement);
        return activityDataElement;
    }

    public static MessageActivity newActivity(MessageTraceLog traceLog) {
        Object errorDetail;
        Object techFailure;
        Object errorDetail2;
        Object appFailure;
        Object arcKey;
        Map properties = traceLog.getProperties();
        MessageActivity activity = new MessageActivity();
        activity.setService(traceLog.getType().toString());
        activity.setOperation(traceLog.getResourceId());
        activity.setActivityId(properties.get("bam_activity_id").toString());
        activity.setMessageId(traceLog.getMessageId());
        activity.setRequestStatus(traceLog.getRequestFaultStatus());
        activity.setResponseStatus(traceLog.getResponseFaultStatus());
        Object arrivalTime = properties.get("BAM_MESSAGE_ARRIVAL_TIME");
        if (arrivalTime != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(Long.parseLong(arrivalTime.toString()));
            activity.setTimestamp(BAMCalendar.getInstance(cal));
        } else {
            activity.setTimestamp(BAMCalendar.getInstance());
        }
        if (properties.containsKey("bam_message_body")) {
            activity.setPayload(properties.get("bam_message_body").toString());
        }
        if ((arcKey = properties.get("arc_key")) != null) {
            activity.setProperty("arc_key", arcKey.toString());
        }
        if (JavaUtils.isTrueExplicitly(appFailure = properties.get("application_failure")) && (errorDetail2 = properties.get("application_failure_detail")) != null) {
            activity.setProperty("application_failure", errorDetail2.toString());
        }
        if (JavaUtils.isTrueExplicitly(techFailure = properties.get("technical_failure")) && (errorDetail = properties.get("technical_failure_detail")) != null) {
            activity.setProperty("technical_failure", errorDetail.toString());
        }
        ActivityPublisherUtils.setActivityProperty(traceLog, activity, "activity_type");
        ActivityPublisherUtils.setActivityProperty(traceLog, activity, "message_type");
        ActivityPublisherUtils.setActivityProperty(traceLog, activity, "message_format");
        ActivityPublisherUtils.setActivityProperty(traceLog, activity, "arc_status");
        ActivityPublisherUtils.setActivityProperty(traceLog, activity, "arc_detail");
        ActivityPublisherUtils.setActivityProperty(traceLog, activity, "if_fail_uuid");
        ActivityPublisherUtils.setActivityProperty(traceLog, activity, "if_fail_replay_operation");
        return activity;
    }

    private static void setActivityProperty(org.apache.synapse.MessageContext synCtx, MessageActivity activity, String key) {
        Object obj = synCtx.getProperty(key);
        if (obj != null && !"".equals(obj)) {
            activity.setProperty(key, obj.toString());
        }
    }

    private static void setActivityProperty(MessageTraceLog traceLog, MessageActivity activity, String key) {
        Object obj = traceLog.getProperties().get(key);
        if (obj != null && !"".equals(obj)) {
            activity.setProperty(key, obj.toString());
        }
    }

    public static ActivityPublisherAdmin getActivityPublisherAdmin() {
        return activityPublisherAdmin;
    }

    public static void setActivityPublisherAdmin(ActivityPublisherAdmin activityPublisherAdmin) {
        ActivityPublisherUtils.activityPublisherAdmin = activityPublisherAdmin;
    }

    public static String getServerName() {
        String serverName;
        String TRANSPORT = "https";
        try {
            String context;
            String carbonHttpsPort = System.getProperty("carbon." + TRANSPORT + ".port");
            if (carbonHttpsPort == null) {
                AxisConfiguration axisConfig = cfgCtxService.getServerConfigContext().getAxisConfiguration();
                carbonHttpsPort = (String)axisConfig.getTransportIn(TRANSPORT).getParameter("port").getValue();
            }
            if ((context = serverConfiguration.getFirstProperty("WebContextRoot")) == null || context.equals("/")) {
                context = "";
            }
            serverName = TRANSPORT + "://" + NetworkUtils.getLocalHostname() + ":" + carbonHttpsPort + context;
        }
        catch (SocketException ignored) {
            serverName = "https://localhost:9443";
        }
        return serverName;
    }

    static {
        fac = OMAbstractFactory.getOMFactory();
    }
}

