/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.activity.mediation.data.publisher.util;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPVersion;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.wso2.carbon.bam.activity.mediation.data.publisher.data.MessageActivity;
import org.wso2.carbon.bam.activity.mediation.data.publisher.queue.ActivityQueue;
import org.wso2.carbon.bam.data.publisher.util.PublisherConfiguration;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.multitenancy.SuperTenantCarbonContext;
import org.wso2.carbon.mediation.statistics.MessageTraceLog;
import org.wso2.carbon.utils.ConfigurationContextService;

public class ActivityPublisherUtils {
    private static final Log log = LogFactory.getLog(ActivityPublisherUtils.class);
    private static ActivityQueue activityQueue;
    private static ServerConfiguration serverConfiguration;
    private static ConfigurationContextService configContextService;
    private static PublisherConfiguration publisherConfiguration;

    public static void setActivityQueue(ActivityQueue activityQueue) {
        ActivityPublisherUtils.activityQueue = activityQueue;
    }

    public static void setServerConfiguration(ServerConfiguration serverConfiguration) {
        ActivityPublisherUtils.serverConfiguration = serverConfiguration;
    }

    public static void setConfigurationContextService(ConfigurationContextService cfgCtxService) {
        configContextService = cfgCtxService;
    }

    public static void publishEvent(MessageTraceLog traceLog) {
        MessageActivity activity = ActivityPublisherUtils.newActivity(traceLog);
        activityQueue.enqueue(activity);
    }

    public static void publishEvent(org.apache.synapse.MessageContext synCtx, long currentTime, boolean extractSoapBody, boolean request) {
        MessageActivity activity = ActivityPublisherUtils.newActivity(synCtx, currentTime, extractSoapBody, request);
        if (activity != null) {
            activityQueue.enqueue(activity);
        }
    }

    public static MessageActivity newActivity(org.apache.synapse.MessageContext synCtx, long currentTime, boolean extractSoapBody, boolean request) {
        MessageActivity activity = null;
        MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        AxisConfiguration axisConfiguration = msgCtx.getConfigurationContext().getAxisConfiguration();
        int tenantID = SuperTenantCarbonContext.getCurrentContext((AxisConfiguration)axisConfiguration).getTenantId();
        activity = new MessageActivity();
        activity.setTenantId(tenantID);
        activity.setDirection(request ? "IN" : "OUT");
        activity.setService(msgCtx.getAxisService().getName());
        activity.setOperation(msgCtx.getAxisOperation().getName().getLocalPart());
        Map hashMap = ((Axis2MessageContext)synCtx).getProperties();
        for (Map.Entry entry : hashMap.entrySet()) {
            Object value = entry.getValue();
            if (!(value instanceof String) || !entry.getKey().toString().startsWith("bam_")) continue;
            activity.setProperty(entry.getKey().toString(), value.toString());
        }
        if (extractSoapBody) {
            SOAPEnvelope soapEnvelope = msgCtx.getEnvelope();
            SOAPVersion soapVersion = soapEnvelope.getVersion();
            activity.setSoapEnvelopNamespaceURI(soapVersion.getEnvelopeURI());
            activity.setPayload(soapEnvelope.getBody().toString());
        }
        Timestamp timestamp = new Timestamp(currentTime);
        activity.setTimestamp(timestamp);
        if (msgCtx.getMessageID() != null) {
            activity.setMessageId(msgCtx.getMessageID());
        } else {
            String messageId = UUID.randomUUID().toString();
            msgCtx.setMessageID(messageId);
            activity.setMessageId(messageId);
        }
        SOAPHeader header = msgCtx.getEnvelope().getHeader();
        QName bamEventQName = new QName("http://wso2.org/ns/2010/10/bam", "BAMEvent");
        OMElement bamEvent = header.getFirstChildWithName(bamEventQName);
        if (bamEvent != null) {
            QName activityIdQName = new QName("activityID");
            String activityId = bamEvent.getAttributeValue(activityIdQName);
            if (activityId != null) {
                activity.setActivityId(activityId);
            }
        } else {
            log.warn((Object)"BAMEvent header not found on the message");
        }
        return activity;
    }

    private static MessageActivity newActivity(MessageTraceLog traceLog) {
        Map properties = traceLog.getProperties();
        MessageActivity activity = new MessageActivity();
        activity.setService(traceLog.getType().toString());
        activity.setOperation(traceLog.getResourceId());
        activity.setActivityId(properties.get("bam_activity_id").toString());
        activity.setMessageId(traceLog.getMessageId());
        activity.setRequestStatus(traceLog.getRequestFaultStatus());
        activity.setResponseStatus(traceLog.getResponseFaultStatus());
        Object arrivalTime = properties.get("BAM_MESSAGE_ARRIVAL_TIME");
        if (arrivalTime != null) {
            Timestamp timestamp = new Timestamp(Long.parseLong(arrivalTime.toString()));
            activity.setTimestamp(timestamp);
        } else {
            Date currentDate = new Date();
            Timestamp timestamp = new Timestamp(currentDate.getTime());
            activity.setTimestamp(timestamp);
        }
        if (properties.containsKey("bam_message_body")) {
            activity.setPayload(properties.get("bam_message_body").toString());
        }
        return activity;
    }

    public static void setPublisherConfiguration(PublisherConfiguration configuration) {
        publisherConfiguration = configuration;
    }

    public static PublisherConfiguration getPublisherConfiguration() {
        return publisherConfiguration;
    }
}

