/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.activity.mediation.data.publisher.queue;

import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.bam.activity.mediation.data.publisher.data.MessageActivity;
import org.wso2.carbon.bam.activity.mediation.data.publisher.process.ActivityWorker;
import org.wso2.carbon.bam.activity.mediation.data.publisher.publish.ActivityProcessor;
import org.wso2.carbon.bam.data.publisher.util.PublisherConfiguration;

public class ActivityQueue {
    private static final Log log = LogFactory.getLog(ActivityQueue.class);
    private ActivityProcessor activityProcessor;
    private ThreadPoolExecutor threadPool = null;
    private BlockingQueue<Runnable> runnableQueue;
    private Queue<MessageActivity> activityQueue;
    private boolean shutdown = false;
    long keepAliveTime = 20L;

    public ActivityQueue(ActivityProcessor activityProcessor, PublisherConfiguration configuration) {
        this.activityProcessor = activityProcessor;
        this.runnableQueue = new ArrayBlockingQueue<Runnable>(configuration.getTaskQueueSize());
        this.activityQueue = new ArrayBlockingQueue<MessageActivity>(configuration.getEventQueueSize());
        this.threadPool = new ThreadPoolExecutor(configuration.getCorePoolSize(), configuration.getMaxPoolSize(), this.keepAliveTime, TimeUnit.SECONDS, this.runnableQueue);
        this.threadPool.allowCoreThreadTimeOut(false);
    }

    public void enqueue(MessageActivity activity) {
        if (this.shutdown) {
            log.warn((Object)"BAM activity queue is shutting down... Not accepting the new activity...");
            return;
        }
        boolean queued = this.activityQueue.offer(activity);
        if (queued) {
            if (this.activityQueue.size() > 0) {
                try {
                    this.threadPool.execute(new ActivityWorker(this.activityQueue, this.activityProcessor));
                }
                catch (RejectedExecutionException rejectedExecutionException) {}
            }
        } else {
            log.warn((Object)"Queue size exceeded. Event rejected.");
        }
    }
}

