/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.bam.activity.mediation.data.publisher.publish;

import org.apache.thrift.TException;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.wso2.carbon.bam.activity.mediation.data.publisher.conf.ActivityConfigData;
import org.wso2.carbon.bam.service.AuthenticationException;
import org.wso2.carbon.bam.service.AuthenticatorService;
import org.wso2.carbon.utils.CarbonUtils;

public class ThriftUtil {
    private static volatile String sessionId = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getSessionId(ActivityConfigData activityConfigData) {
        THttpClient client = null;
        try {
            if (sessionId != null) return sessionId;
            Class<ThriftUtil> clazz = ThriftUtil.class;
            synchronized (ThriftUtil.class) {
                if (sessionId != null) return sessionId;
                client = ThriftUtil.getClient(activityConfigData);
                TCompactProtocol protocol = new TCompactProtocol((TTransport)client);
                AuthenticatorService.Client authClient = new AuthenticatorService.Client((TProtocol)protocol);
                client.open();
                sessionId = authClient.authenticate(activityConfigData.getUserName(), activityConfigData.getPassword());
                client.close();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return sessionId;
            }
        }
        catch (TTransportException e) {
            e.printStackTrace();
            return sessionId;
        }
        catch (TException e) {
            e.printStackTrace();
            return sessionId;
        }
        catch (AuthenticationException e) {
            e.printStackTrace();
        }
        return sessionId;
    }

    public static THttpClient getClient(ActivityConfigData activityConfigData) {
        THttpClient client = null;
        try {
            String trustStore = CarbonUtils.getCarbonHome() + "/repository/resources/security";
            System.setProperty("javax.net.ssl.trustStore", trustStore + "/client-truststore.jks");
            System.setProperty("javax.net.ssl.trustStorePassword", "wso2carbon");
            client = new THttpClient(activityConfigData.getUrl() + "thriftAuthenticator");
        }
        catch (TTransportException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return client;
    }

    public static void setSessionId(String sessionID) {
        sessionId = sessionID;
    }
}

